	title   cvt_datetime - convert binary date/time to ascii string
	page    ,96
	subttl  Program Documentation
;
;       cvt_datetime - convert binary date/time to ascii string
;
;       cvt_datetime: version 1 revision 3 of 5/26/84
;
;       Copyright (c) 1984 by   David A. Wallace
;                               146 Westford St.
;                               Chelmsford,  Ma.
;                                       01824
;
;       Released with PRINTL Version 4.04
;
;       This function uses two words of data, a binary coded date and a binary
;       coded time, formatted as they appear in a directory entry and creates
;       a date/time string of the form "mm-dd-yy hh:mm:ss" from them.
;
	subttl  Definitions
	.xlist
	include b:defascii.asm
	include b:defms.asm
	.list
	subttl  Code
	page
prog    segment byte public 'PROG'
	assume  cs:prog,ds:prog,es:prog,ss:prog
	public  cvt_datetime
;       CVT_DATETIME -- CONVERT DATE AND TIME FROM BINARY TO ASCII
;
;       Entry:  SI -> DATE and TIME words
;               DI -> DATE/TIME string area
;       Exit:   none
;       Uses:   none
;
CVT_DATETIME:
	PUSH    AX
	PUSH    BX
	PUSH    CX
	PUSH    DX
	PUSH    SI
	PUSH    DI
;
;       First convert the date field.
;
	LODSB
	AND     AL,11100000B
	MOV     AH,AL
	LODSB
	AND     AL,00000001B
	XCHG    AH,AL
	SHL     AX,1
	SHL     AX,1
	SHL     AX,1
	MOV     DL,AH
	CALL    BINDEC8
	XCHG    AH,AL
	STOSB
	XCHG    AH,AL
	STOSB
	MOV     AL,'-'
	STOSB
	DEC     SI
	DEC     SI
	LODSB
	AND     AL,00011111B
	MOV     DL,AL
	CALL    BINDEC8
	XCHG    AH,AL
	STOSB
	XCHG    AH,AL
	STOSB
	MOV     AL,'-'
	STOSB
	LODSB
	AND     AL,11111110B
	SHR     AL,1
	ADD     AL,80
	CMP     AL,100
	JB      CDT1
	SUB     AL,100
CDT1:
	MOV     DL,AL
	CALL    BINDEC8
	XCHG    AH,AL
	STOSB
	XCHG    AH,AL
	STOSB
	MOV     AL,' '
	STOSB
;
;       Now convert the time field.
;
	INC     SI
	LODSB
	AND     AL,11111000B
	SHR     AL,1
	SHR     AL,1
	SHR     AL,1
	MOV     DL,AL
	CALL    BINDEC8
	XCHG    AH,AL
	STOSB
	XCHG    AH,AL
	STOSB
	MOV     AL,':'
	STOSB
	DEC     SI
	LODSB
	AND     AL,00000111B
	MOV     AH,AL
	DEC     SI
	DEC     SI
	LODSB
	AND     AL,11100000B
	SHL     AX,1
	SHL     AX,1
	SHL     AX,1
	MOV     DL,AH
	CALL    BINDEC8
	XCHG    AH,AL
	STOSB
	XCHG    AH,AL
	STOSB
	MOV     AL,':'
	STOSB
	DEC     SI
	LODSB
	AND     AL,00011111B
	SHL     AL,1
	MOV     DL,AL
	CALL    BINDEC8
	XCHG    AH,AL
	STOSB
	XCHG    AH,AL
	STOSB
	POP     DI
	POP     SI
	POP     DX
	POP     CX
	POP     BX
	POP     AX
	RET
	PAGE
;       BINDEC8 -- Convert an 8-bit binary number in (DL) to three ASCII-coded
;                  decimal digits in DH, AH and AL
;
;       Entry:  DL = value
;       Exit:   DH = high-order digit
;               AH = middle digit
;               AL = low-order digit
;       Uses:   AX,DX
;
	public  bindec8
BINDEC8:
	MOV     AX,'00'
	MOV     DH,'0'
BINDEC8A:
	CMP     DL,100
	JB      BINDEC8B
	SUB     DL,100
	INC     DH
	JMP     BINDEC8A


BINDEC8B:
	CMP     DL,10
	JL      BINDEC8C
	SUB     DL,10
	INC     AH
	JMP     BINDEC8B


BINDEC8C:
	ADD     AL,DL
	RET


prog    ends
	end     cvt_datetime
RET


prog    ends
	end     cvt_datetim