      CHARACTER*1 MODE, ESC, ETX, FF
      ESC=CHAR(27)
      WRITE (*,1) ESC
    1 FORMAT (1X,A1,'x5')
      WRITE (*,2) ESC
    2 FORMAT (1X,A1,'E')
      WRITE (*,10)
   10 FORMAT (6X,'CARDCAT is a program which permits'
     X' you to use your computer to'/1X,'keep track of information in'
     X' a manner similar to a library''s card catalogue.'/1X,'The info'
     X'rmation may consist of books, magazine articles, musical'/1X,
     X'selections, etc.  For each "card" in the catalogue, which is'
     X' actually stored'/1X,'as a line on a disk file, you may enter'
     X' its title, up to three authors, up to'/1X,'two subjects, and'
     X' a "location," a reference to where the item may be found'/
     X1X,'such as shelf or file folder numbers, or its Dewey Decimal'
     X' System number,'/1X,'etc.'/
     X6X,'The program allows you to enter the "card" entries'
     X' to be stored on disk,'/1X,'and subsequently examine indivi'
     X'dual entries and edit them if necessary.  The'/1X,'group of'
     X' entries, located on a single disk or many disks, may then be'
     X/1X,'searched in terms of locating all entries with a common'
     X' title, author,'/1X,'subject, or location.  The output'
     X' list may be displayed on the screen,'/1X,'sent to the'
     X' printer, or saved on disk.')
      WRITE (*,20)
   20 FORMAT (6X,'Each disk has a capacity of 2,700'
     X' entries.  These are arranged as 27'/1X,'disk files, named'
     X' "A" through "Z" plus "@", each file having 100 entries.'/1X,
     X'There is no limit to the number of disks onto which data'
     X' can be entered.'/1X,'However, each disk must be created, edit'
     X'ed and searched individually and'/1X,'sequentially.  In addi'
     X'tion, the number of lines of output is limited to 300.')
      WRITE (*,3)
    3 FORMAT (/)
      PAUSE
      WRITE (*,2) ESC
      WRITE (*,30)
   30 FORMAT (6X,'CARDCAT is written in FORTRAN, and is supplied'
     X' on disk as an ".EXE" file,'/1X,'thus you do not need a FORTRAN'
     X' compiler to run the program.  CARDCAT'/1X,'should work with'
     X' any computer running MS-DOS and having one disk drive and'/1X,
     X'128K of memory.  However, greater ease in operation will be'
     X' afforded by'/1X,'two disk drives, and 192K of memory will'
     X' permit full utilization of its'/1X,'searching and sorting'
     X' routines, (i.e., up to the maximum 300 lines of output.')
      WRITE (*,40)
   40 FORMAT (6X,'If you have two disk drives, place the disk'
     X' containing CARDCAT'/1X,'in Drive B, and your file disk,'
     X' which is initially a blank, formatted disk,'/1X,'in Drive'
     X' A.  With Drive A as the default drive, then type "B:CARDCAT"'
     X' to'/1X,'load the program.  Since the entire program fits in'
     X' memory, no subsequent'/1X,'communication with Drive B will'
     X' be necessary while running CARDCAT.'/6X,'If you have only'
     X' one disk drive, insert the disk with CARDCAT and type'/1X,
     X'"CARDCAT".  When the program has loaded,'
     X' remove the program disk and insert'/1X,'the file disk.  No'
     X' further disk swapping will be necessary.')
      WRITE (*,3)
      PAUSE
      WRITE (*,2) ESC
      WRITE (*,50)
   50 FORMAT (6X,'CARDCAT is'
     X' designed to run on MS-DOS version 2.0 using disks formatted'
     X/1X,'with 9 sectors.  If you must run CARDCAT using MS-DOS'
     X' version 1.0, copy the'/1X,'program named "CARDCAT.ONE" onto'
     X' another disk and name it "CARDCAT.EXE".  This'/1X,'program'
     X' uses file disks formatted with 8 sectors, and each file'
     X' disk has'/1X,'a capacity of 2,400 entries, arranged as 24 disk'
     X' files named "A" through'/1X,'"X", each having 100 entries.')
      WRITE (*,60)
   60 FORMAT (6X,'Further information about specific CARDCAT opera'
     X'tions may be obtained'/1X,'by hitting a carriage return and'
     X' responding to the resulting menu.')
      WRITE (*,3)
      PAUSE
   70 WRITE (*,80) ESC
   80 FORMAT (1X,A1,'E'10X,'For information to:'///15X
     X'<1>  Initialize a blank, formatted'
     X' disk'//15X,'<2>  Enter data to be stored on disk'//15X,'<3>  '
     X'Edit data stored on disk'//15X,'<4>  Display the contents of'
     X' a file'//15X,'<5>  Search disk and sort'
     X' data'//15X,'<6>  End CARDCAT'//15X,'<7>  Error messages'
     X' and caution'//15X,'<8>  Print a copy of these instructions'//
     X15X,'<9>  END help session'///10X,'Enter the number followed'
     X' by a carriage return.  '\)
      READ (*,90) MODE
   90 FORMAT (A1)
      IF (MODE .EQ. '1') GOTO 100
      IF (MODE .EQ. '2') GOTO 200
      IF (MODE .EQ. '3') GOTO 300
      IF (MODE .EQ. '4') GOTO 400
      IF (MODE .EQ. '5') GOTO 500
      IF (MODE .EQ. '6') GOTO 600
      IF (MODE .EQ. '7') GOTO 700
      IF (MODE .EQ. '8') GOTO 800
      IF (MODE .EQ. '9') GOTO 900
      GOTO 70
  100 WRITE (*,2) ESC
      WRITE (*,110)
  110 FORMAT (30X,'DISK INITIALIZATION'//6X,'Before a'
     X' disk can be written upon by CARDCAT, it must be initialized.'
     X/1X,'This process makes use of the MS-DOS utility FORMAT, as'
     X' well as an internal'/1X,'CARDCAT routine.'/6X,'First,'
     X' FORMAT a disk according to the instructions in the opera'
     X'ting'/1X,'system manual.  If you are using MS-DOS version'
     X' 2.0, FORMAT the disk'/1X,'using the "9" switch so that the'
     X' maximum number of entries can be placed'/1X,'on the disk.'
     X'  Do not place the operating system'
     X' on the disk.  Furthermore,'/1X,'no other files, other than'
     X' those written by CARDCAT, may be placed on'/1X,'the disk.'
     X' Second, with this disk in the default drive, load CARD'
     X'CAT and'/1X,'respond to the initial menu by entering'
     X' a "1" followed by a carriage return.'/6X,'Striking another car'
     X'riage return completes the initialization process,'/1X,'and you'
     X' will be returned to the CARDCAT menu.'/6X,'All disks must be'
     X' initialized in this manner before they can be'/1X,'written'
     X' upon by CARDCAT.'//)
      PAUSE
      GOTO 70
  200 WRITE (*,2) ESC
      WRITE (*,210)
  210 FORMAT (35X,'DATA ENTRY'//6X,'To enter data in the'
     X' form of card catalogue entries, enter a "2" followed'/1X,'by'
     X' a carriage return from the CARDCAT menu.  You will then be'
     X' prompted to'/1X,'enter the title, authors, subjects, and'
     X' location.  The title is limited to 40'/1X,'characters, the'
     X' authors and subjects to 15 characters each, and the'
     X' location'/1X,'to 7 characters.'/6X,'When making these entries,'
     X' keep in mind that CARDCAT considers upper'/1X,'and lower'
     X' case letters to be different, it considers punctuation'
     X' marks to be'/1X,'significant, and it considers blanks'
     X' within a name, (but not trailing blanks),'/1X,'to be'
     X' significant.  These rules become very important'
     X' when subsequent'/1X,'searches of the files are conducted.'
     X/6X,'For example, the following author entries would each'
     X' be treated as'/1X,'a different name:'//15X,'F. Flintstone'/
     X15X,'F Flintstone'/15X,'Flintstone, Fred'/15X,'Flintstone, F')
      WRITE (*,3)
      PAUSE
      WRITE (*,2) ESC
      WRITE (*,220)
  220 FORMAT (6X,'The way you choose to enter the data'
     X' is up to you, but it is most'/1X,'important to be consistent'
     X' so that when searches are conducted, data entries'/1X,'will'
     X' not be missed.'/6X,'How the various entries under the three'
     X' possible authors and two'/1X,'possible subjects may be'
     X' utilized is also up to you.  For example, for'/1X,'a musical'
     X' selection, the three author entries may be used for the'/1X,
     X'performing artist(s) as well as for the songwriter(s) and/or'
     X' composer(s).'/1X,'The location may, for example, be'
     X' encoded "S3R83C4" to represent the'/1X,'4th cut on the'
     X' 83rd record on the 3rd shelf.  A few examples of'/
     X1X,'possible methods of organizing data entries follow.')
      WRITE (*,3)
      PAUSE
      WRITE (*,2) ESC
      WRITE (*,230)
  230 FORMAT (6X,'Some examples of book entries:'///10X,
     X'Title:  All the President''s Men'/10X,'First Author:  '
     X'Bernstein C'/10X,'Second Author:  Woodward B'/10X,'Third'
     X' Author:'/10X,'Subject #1:  Politicians'/,10X,'Subject #2:  '
     X'Crooks'/,10X,'Location:  2359G'//10X,'Title:  Principles of'
     X' Biochemistry, 6th ed.'/10X,'First Author:  White A'/10X,
     X'Second Author:  Handler P'/10X,'Third Author:  Smith EL'/10X,
     X'Subject #1:  Biochemistry'/10X,'Subject #2:  Textbooks'/10X,
     X'Location:  S22B107')
      WRITE (*,3)
      PAUSE
      WRITE (*,2) ESC
      WRITE (*,240)
  240 FORMAT (10X,'Title:  Rabbit is Rich'/10X,
     X'First Author:  Updike J'/10X,'Second Author:'/10X,
     X'Third Author:'/10X,'Subject #1:  Rabbits'/10X,'Subject #2:  '
     X'Toyota Dealers'/10X,'Location:  81-1287'//10X,'Title:  '
     X'2001:  A Space Odyssey'/10X,'First Author:  Clarke AC'/10X,
     X'Second Author:'/10X,'Third Author:'/10X,'Subject #1:  '
     X'Travel'/10X,'Subject #2:  Fiction'/10X,'Location:  Closet')
      WRITE (*,3)
      PAUSE
      WRITE (*,2) ESC
      WRITE (*,250)
  250 FORMAT (6X,'Some examples of musical selection'
     X' entries:'///10X,'Title:  I Want to Hold Your Hand'/10X,
     X'First Author:  The Beatles'/10X,'Second Author:  Lennon J'/10X,
     X'Third Author:  McCartney P'/10X,'Subject #1:  Love Songs'/10X,
     X'Subject #2:  Rock and Roll'/10X,'Location:  S5R29C8'//10X,
     X'Title:  Symphony No. 5'/10X,'First Author:  Beethoven L'/10X,
     X'Second Author:  Boston Symphony'/10X,'Third Author:  Ozawa'
     X' S'/10X,'Subject #1:  German'/10X,'Subject #2:  Classical'/
     X10X,'Location:  Drawer')
      WRITE (*,3)
      PAUSE
      WRITE (*,2) ESC
      WRITE (*,260)
  260 FORMAT (10X,'Title:  My Way'/10X,'First Author:  '
     X'Presley E'/10X,'Second Author:  Anka P'/10X,'Third Author:'/
     X10X,'Subject #1:  Dead Singers'/10X,'Subject #2:  Ballads'
     X/10X,'Location:  735.32'//10X,'Title:  MacArthur'
     X' Park'/10X,'First Author:  Harris R'/10X,'Second Author:  '
     X'Webb J'/10X,'Third Author:'/10X,'Subject #1:  1965-1969'/
     X10X,'Subject #2:  Very Long Songs'/10X,'Location:  GFV43z')
      WRITE (*,3)
      PAUSE
      WRITE (*,2) ESC
      WRITE (*,270)
  270 FORMAT (6X,'When the data entry mode is selected,'
     X' CARDCAT searches the disk to find'/1X,'the last entry.  '
     X'Subsequent entries are positioned immediately following'
     X' this'/1X,'last entry.  Prior to the prompt for the title,'
     X' the current file name ("A" to'/1X,'"@") and the current'
     X' file line ("1" to "100") will be displayed.'/6X,
     X'To terminate data entry, enter a single asterisk followed'
     X' by a carriage'/1X,'return when prompted for the TITLE'
     X' following the LOCATION of the LAST'/1X,'entry.')
      WRITE (*,3)
      PAUSE
      GOTO 70
  300 WRITE (*,2) ESC
      WRITE (*,310) 
  310 FORMAT (34X,'DATA EDITING'//6X,'If a single entry,'
     X' or group of entries, need to be altered, this can be'/1X,
     X'accomplished easily with the editing feature of CARDCAT.'
     X'  From the CARDCAT'/1X,'menu, enter a "3" followed by a'
     X' carriage return.  You will then be prompted'/1X,'for the'
     X' name of the file.  Enter the letter name ("A" through "@"),'
     X' making'/1X,'sure you use an upper case letter only, followed'
     X' by a carriage return.'/6X,'You will then be prompted for'
     X' the line to be edited.  Enter this'/1X,'number (1-100)'
     X' followed by a carriage return.  The title will be'
     X' displayed,'/1X,'and you will be prompted for the new title.'
     X' Subsequently, the three'/1X,'authors, two subjects, and'
     X' location will each be displayed, and you'/1X,'will be'
     X' prompted to enter new responses.  Entering a carriage return'
     X/1X,'in place of a new entry keeps the existing entry'
     X' unchanged.')
      WRITE (*,3)
      PAUSE
      WRITE (*,2) ESC
      WRITE (*,320)
  320 FORMAT (6X,'Since editing cannot be performed on file lines'
     X' not yet written, if you'/1X,'enter the name of a nonexistent'
     X' file, or a nonexistent line number, you will'/1X,'be informed,'
     X' and prompted to reenter the file name or line number.  After'
     X/1X,'completing the editing of a file line, you will be'
     X' prompted for'/1X,'another line to edit in the same file.  If'
     X' no further lines in that file'/1X,'require editing, then'
     X' enter a "0" followed by a carriage return.  You'/1X,'will'
     X' then be prompted for the next file to edit.  If no further'
     X' editing'/1X,'is required at this time, enter an asterisk,'
     X' otherwise enter the name of'/1X,'the next file to be edited.')
      WRITE (*,330)
  330 FORMAT (6X,'At this time it should be'
     X' mentioned that the disk files should not be'/1X,'edited'
     X' with the MS-DOS text editor EDLIN.  Although the files are'
     X' ASCII'/1X,'files, since their formatting is crucial to'
     X' accurate reading, the insertion'/1X,'or deletion of a'
     X' single letter may render the file unreadable.')
      WRITE (*,3)
      PAUSE
      GOTO 70
  400 WRITE (*,2) ESC
      WRITE (*,410)
  410 FORMAT (32X,'DISPLAYING A FILE'//6X,'To view the contents of'
     X' a particular file, enter a "4" from the CARDCAT'/1X,'menu'
     X' followed by a carriage return.  You will be prompted to'
     X' enter the name'/1X,'of the file ("A" through "@") to be'
     X' displayed, and will be informed if this'/1X,'file does not'
     X' exist on the disk.  You will then be asked if the'
     X' file should be'/1X,'displayed on the screen.  If you answer'
     X' "Y", the file will be displayed, five'/1X,'lines at a time.  '
     X' Note that because the lines are wider than the screen, each'
     X/1X,'will appear over two screen lines.'/6X,'You will then'
     X' be asked if the file should be sent to the printer.  If'/1X,
     X'you answer "Y", you will then be asked how many lines you'
     X' would like to'/1X,'print between pauses to change paper.'
     X'  Printing will begin immediately after'/1X,'responding to'
     X' this question.  The output is formatted to a column'
     X' width of 132,'/1X,'thus your printer should be capable of'
     X' printing 132 characters per line.')
      WRITE (*,3)
      PAUSE
      GOTO 70
  500 WRITE (*,2) ESC
      WRITE (*,510)
  510 FORMAT (26X,'DATA SEARCHING AND SORTING'//6X,'The'
     X' primary utility of CARDCAT is to permit the files to be'
     X' searched'/1X,'for a specific title, author, etc., and then'
     X' output all entries with the'/1X,'matching title, author, etc.'
     X' to the screen, printer, or disk.'/6X,'To enter this mode,'
     X' enter a "5" from the CARDCAT menu followed by a'/1X,'carriage'
     X' return.  You will then be prompted to enter a number corres'
     X'ponding'/1X,'to the type for which you wish to search.  For'
     X' example, to search the files'/1X,'for all entries containing'
     X' a specific Third Author, enter a "4".  You will'/1X,'then be'
     X' prompted for the number of characters in the name which must'
     X' be'/1X,'identical to a file entry for CARDCAT to consider'
     X' them equivalent.'/1X,'You will then be asked to enter the'
     X' name for which you wish to search.')
      WRITE (*,3)
      PAUSE
      WRITE (*,2) ESC
      WRITE (*,520)
  520 FORMAT (6X,'For example, assume that a disk includes the'
     X' following entries'/1X,'for title:'//15X,
     X'The Longest Yard'/15X,'The Long and Winding Road'/
     X15X,'The Last Detail'/15X,'The Longest Day'/15X,'The Last Pict'
     X'ure Show'//1X'If you entered "8" for the number of characters'
     X' and "The Long" for the'/1X,'title, the search would turn'
     X' up the first, second, and fourth of the above'/1X,'entries.'
     X'  However, if you entered "5" for the number of charac'
     X'ters and'/1X,'"The L" for the title, the search would turn'
     X' up all of the above entries.  The'/1X,'ability to search'
     X' for just a fragment of a name is very useful when the exact'
     X/1X,'spelling of the entry is not known.')
      WRITE (*,3)
      PAUSE
      WRITE (*,2) ESC
      WRITE (*,530)
  530 FORMAT (6X,'Once the name is'
     X' entered, CARDCAT searches the disk for all entries with'/1X,
     X'the same name, and makes an internal list containing all'
     X' those entries which'/1X,'match.  You will be informed if'
     X' there are no matching entries on the disk, or'/1X,'if the'
     X' number of matching entries exceeds 300.  In the latter case'
     X' the output'/1X,'list will contain the FIRST 300 entries'
     X' which match.  If you have more'/1X,'than one disk to search,'
     X' you will be prompted to insert subsequent disks.'/1X,'There is'
     X' no limit to the number of disks which can be searched,'
     X' however,'/1X,'a single output list can contain no more than'
     X' 300 lines.')
      WRITE (*,540)
  540 FORMAT (6X,'When CARDCAT has completed creating its'
     X' internal list of matching entries,'/1X,'you will be prompted'
     X' to enter the type of name (e.g. Title, First Author,'/1X,
     X'Subject #2, etc.) under which the list will be alphabetized.'
     X'  You will then be'/1X,'asked if the output list should be'
     X' displayed on the screen.  If you answer'/1X,'"Y", the list'
     X' will be displayed, five lines at a time.  Note that'
     X' because the'/1X,'output lines are wider than the screen,'
     X' each will appear over two screen lines.'/
     X6X,'You will then be asked if the output'
     X' list should be sent to the printer.'/1X,'If you answer "Y",'
     X' you will then be asked how many lines you would like to'/1X,
     X'print between pauses to change paper.  Printing will begin'
     X' immediately after'/1X,'responding to this question.  The'
     X' output is formatted to a column width of'/1X,'132,'
     X' thus your printer should be capable of printing 132 charac'
     X'ters per line.')
      WRITE (*,3)
      PAUSE
      WRITE (*,2) ESC
      WRITE (*,550)
  550 FORMAT (6X,'After printing is completed, if you selected that'
     X' option, you will be'/1X,'asked if you want to store the output'
     X' list on disk.  If you answer "Y", you'/1X,'will then be told'
     X' to insert the disk to receive the file in Drive A.  This'/1X
     X'disk should be a different disk than was searched to'
     X' create the output list,'/1X,'so that duplicate entries will'
     X' not end up on the same disk.  The output'/1X,'list will be'
     X' written following any existing entries on this disk, and will'
     X' be'/1X,'arranged identically to those files described'
     X' under DATA ENTRY.')
      WRITE (*,560)
  560 FORMAT (6X,'The major utility of saving the output list on disk'
     X' is that it will'/1X,'permit subsequent searching of the output'
     X' list for matches in another'/1X,'category.  For example, if'
     X' all entries on a disk containing BOTH a'/1X,'particular'
     X' Subject #1 and a Subject #2 are desired, the disk is first'/1X,
     X'searched for the Subject #1, and the output list is saved on'
     X' a different'/1X,'disk.  This second disk is then searched for'
     X' the Subject #2.  The resulting'/1X,'output list contains'
     X' only those entries on the original disk with both'/1X,
     X'subjects.  When writing the output list to disk is completed,'
     X' you will be'/1X,'returned to the CARDCAT menu.')
      WRITE (*,3)
      PAUSE
      GOTO 70
  600 WRITE (*,2) ESC
      WRITE (*,610)
  610 FORMAT (33X,'ENDING CARDCAT'//6X,'When you wish to'
     X' terminate CARDCAT, enter a "6" followed by a carriage'/1X,
     X'return from the CARDCAT menu.  You will be transferred back'
     X' to the operating'/1X,'system, and will see the "A:" prompt.'
     X' Since the operating system is retained'/1X,'in memory during'
     X' CARDCAT, you do not need to reinsert a disk containing'/1X,
     X'the operating system prior to ending CARDCAT.')
      WRITE (*,3)
      PAUSE
      GOTO 70
  700 WRITE (*,2) ESC
      WRITE (*,710)
  710 FORMAT (27X,'ERROR MESSAGES AND CAUTION'//6X,'There'
     X' are various errors that can occur during CARDCAT which will'/
     X1X,'result in aborting program execution.  If such a situation'
     X' occurs, a FORTRAN'/1X,'error message will be displayed on'
     X' the screen.  Some of the possible'/1X,'error numbers, and'
     X' their likely causes, are as follows:'//6X,'1003 - An attempt'
     X' was made by CARDCAT to write a file to disk,'/7X,'or'4X,'but'
     X' there was no room.  There are files on the disk other'/6X,
     X'1008'3X,'than those written by CARDCAT, and these files need'
     X' to'/13X,'be removed.'//6X,'1004 - CARDCAT searched for a file'
     X' that should have existed,'/7X,'or'4X,'but could not find it.  '
     X'Either the disk was not initialized,'/6X,'1298'3X,'or some'
     X' error in the organization of files on the disk'/13X,'has'
     X' occurred, making the disk unreadable.'/)
      WRITE (*,3)
      PAUSE
      WRITE (*,2) ESC
      WRITE (*,720)
  720 FORMAT (1X,'In addition, there are a few areas of'
     X' caution which need emphasis:'//6X,'1.  Prior to any CARDCAT'
     X' operation on a file disk, make sure you have a'/10X,'backup'
     X' copy of the file disk.  You never know what might'
     X' happen.'//6X,'2.  Do not use EDLIN to examine or edit disk'
     X' files, but use the CARDCAT'/10X,'routines.  A single character'
     X' inserted or deleted accidentally'/10X,'during EDLIN may make a'
     X' file disk unreadable.'//6X,'3.  Remember that upper and lower'
     X' case letters are not equivalent and thus'/10X,'it is very'
     X' important to maintain consistency in your files so that'/10X,
     X'errors and missed entries do not occur during searching.'//
     X6X,'4.  All disks that will be read by or written'
     X' to by CARDCAT must have'/10X,'been initialized by CARDCAT.'//
     X6X,'5.  Please be patient.  It can take a few minutes to read'
     X' or search a'/10X,'completely filled disk, and up to a minute'
     X' to alphabetize'/10X,'300 output lines.'//)
      PAUSE
      GOTO 70
  800 WRITE (*,2) ESC
      WRITE (*,810)
  810 FORMAT (22X,'PRINTING A COPY OF THE INSTRUCTIONS'//
     X6X,'This routine will permit you to print a hard copy of these'
     X' instructions.'/1X,'The line width is 80 characters, so the'
     X' printer should be set for 12'/1X,'characters per inch, if'
     X' possible.  The page length is set at 11 inches,'/1X,'and'
     X' printing will pause and wait for a carriage return at the'
     X' top of each page.'/6X,'Enter a carriage return to begin'
     X' printing.'//)
      PAUSE
      ETX=CHAR(03)
      FF=CHAR(12)
      OPEN (2,FILE='PRN')
      WRITE (2,820)
  820 FORMAT (36X,'CARDCAT'//26X,'By Mark Dershwitz, M.D., Ph.D.'//)
      WRITE (2,10)
      WRITE (2,20)
      WRITE (2,30)
      WRITE (2,40)
      WRITE (2,50)
      WRITE (2,4) ETX, FF
    4 FORMAT (1X,2A1)
      PAUSE
      WRITE (2,110)
      WRITE (2,210)
      WRITE (2,5)
    5 FORMAT ('')
      WRITE (2,220)
      WRITE (2,4) ETX, FF
      PAUSE
      WRITE (2,230)
      WRITE (2,5)
      WRITE (2,240)
      WRITE (2,3)
      WRITE (2,250)
      WRITE (2,4) ETX, FF
      PAUSE
      WRITE (2,260)
      WRITE (2,3)
      WRITE (2,270)
      WRITE (2,3)
      WRITE (2,310)
      WRITE (2,320)
      WRITE (2,3)
      WRITE (2,4) ETX, FF
      PAUSE
      WRITE (2,410)
      WRITE (2,3)
      WRITE (2,510)
      WRITE (2,520)
      WRITE (2,530)
      WRITE (2,4) ETX, FF
      PAUSE
      WRITE (2,540)
      WRITE (2,550)
      WRITE (2,560)
      WRITE (2,3)
      WRITE (2,610)
      WRITE (2,3)
      WRITE (2,710)
      WRITE (2,4) ETX, FF
      PAUSE
      WRITE (2,720)
      WRITE (2,4) ETX, FF
      GOTO 70
  900 WRITE (*,910) ESC, ESC
  910 FORMAT (1X,A1,'E',A1,'y5')
      END
