      PROGRAM CARDCAT
      DIMENSION N(100)
      CHARACTER*40 T
      CHARACTER*15 AS
      CHARACTER*7 L
      CHARACTER*1 AST, ESC, FNAM
      COMMON T(100), AS(100,5), L(100), NFIL, NLIN
      AST=CHAR(42)
      ESC=CHAR(27)
      WRITE (*,1000) ESC
 1000 FORMAT (1X,A1,'E')
      WRITE (*,1010) ESC, ESC
 1010 FORMAT (1X,A1,'v',A1,'x4'/5X,'WELCOME TO CARDCAT!'/5X,'By Mark'
     X' Dershwitz, M.D., Ph.D.'/)
 1020 WRITE (*,1030)
 1030 FORMAT (/5X,'Enter the number corresponding to the operation'
     X' you wish to perform:'///10X,'<1>  Initialize a blank,'
     X' formatted disk'//10X,'<2>  Enter data to be stored on'
     X' disk'//10X,'<3>  Edit data stored on disk'//10X,'<4>  Display'
     X' the contents of a file'//10X,'<5>  Search'
     X' disk and sort data'//10X,'<6>  End CARDCAT'///5X,'Enter'
     X' the operation number followed by a carriage return.  '\)
      READ (*,1040,ERR=1045) MODE
 1040 FORMAT (I1)
C Branch to selected subroutine
      IF (MODE .EQ. 1) GOTO 2000
      IF ((MODE .GT. 1) .AND. (MODE .LT. 6)) GOTO 1050
      IF (MODE .EQ. 6) GOTO 3000
 1045 WRITE (*,1000) ESC
      GOTO 1020
C Determine the number of files, and the number of records in the
C   last file, on the disk, and pass these values to subroutines
C   MAKEFILE, EDFILE, SEEFILE, and SORTFILE
 1050 WRITE (*,1060) ESC
 1060 FORMAT (1X,A1,'E'///5X,'Reading file disk. . .')
      OPEN (2,FILE='DIR')
C NFIL represents the file name with  1=A, 2=B, etc.
C NLIN represents the record number in the last file
      READ (2,1070) NFIL, NLIN
 1070 FORMAT (I2,I3)
      CLOSE (2)
C Read contents of last file on the disk
      FNAM=CHAR(NFIL+64)
      IF (NFIL .EQ. 27) FNAM=CHAR(64)
      OPEN (3,FILE=FNAM)
      DO 1090 I=1,NLIN
      READ (3,1080) N(I), T(I), (AS(I,K),K=1,5), L(I)
 1080 FORMAT (I3,A40,5A15,A7)
 1090 CONTINUE
 1100 WRITE (*,1000) ESC
C Branch to selected subroutine
      IF (MODE .EQ. 2) CALL MAKEFILE
      IF (MODE .EQ. 3) CALL EDFILE
      IF (MODE .EQ. 4) CALL SEEFILE
      IF (MODE .EQ. 5) CALL SORTFILE
      WRITE (*,1000) ESC
      GOTO 1020
C Initialize disk by writing in a file named DIR the values 1 and 0
C   for NFIL and NLIN, and in a file named A an asterisk as the title
C   in the first record
 2000 OPEN (2,FILE='DIR',STATUS='NEW')
      WRITE (*,2010) ESC
 2010 FORMAT (1X,A1,'E'//1X,'Please insert a formatted disk in'
     X' the default drive'/1X,'and strike a carriage return.'///)
      PAUSE
      NFIL=1
      NLIN=0
      WRITE (2,1070) NFIL, NLIN
      CLOSE (2)
      OPEN (3,FILE='A',STATUS='NEW')
      I=1
      WRITE (3,2020) I,AST
 2020 FORMAT (I3,A1)
      CLOSE (3)
      WRITE (*,1000) ESC
      GOTO 1020
C Terminate program
 3000 WRITE (*,3010) ESC, ESC
 3010 FORMAT (1X,A1,'E',A1,'y4')
      END
C Subroutine to accept data from keyboard and write new files to disk
      SUBROUTINE MAKEFILE
      DIMENSION N(100)
      CHARACTER*40 T
      CHARACTER*15 AS
      CHARACTER*7 L
      CHARACTER*1 AST, ESC, FNAME(27)
      COMMON T(100), AS(100,5), L(100), NFIL, NLIN
      AST=CHAR(42)
      ESC=CHAR(27)
C Branch if file disk is filled to capacity
      IF ((NFIL .EQ. 27) .AND. (NLIN .EQ. 100)) GOTO 4190
C Increment file if present file is full
      IF (NLIN .EQ. 100) THEN
      NLIN=0
      NFIL=NFIL+1
      ENDIF
      DO 4170 J=NFIL,27
C Files named A through @
      FNAME(J)=CHAR(J+64)
      IF (J .EQ. 27) FNAME(J)=CHAR(64)
      DO 4130 I=NLIN+1,100
C Accept data from keyboard
      WRITE (*,4000)
 4000 FORMAT (/5X,'Enter the title, up to three authors, up to'
     X' two subjects, and a'/10X,'location, each followed by a'
     X' carriage return.'//5X,'Enter an asterisk for the title'
     X' to terminate data entry.')
      WRITE (*,4010) FNAME(J),I
 4010 FORMAT (//5X,'The current filename is ',A1,'.   The current'
     X' file line is',I4,'.')
      WRITE (*,4020)
 4020 FORMAT (/10X,'Enter the title (40 char).  '\)
      READ (*,4030) T(I)
 4030 FORMAT (A40)
C NLINW is the number of records in the file to be written to disk
      NLINW=I
C Branch if asterisk entered for TITLE indicating no further entries
      IF (T(I) .EQ. AST) GOTO 4140
      WRITE (*,4040)
 4040 FORMAT (/10X,'Enter the first author (15 char).  '\)
      READ (*,4050) AS(I,1)
 4050 FORMAT (A15)
      WRITE (*,4060)
 4060 FORMAT (/10X,'Enter the second author (15 char).  '\)
      READ (*,4050) AS(I,2)
      WRITE (*,4070)
 4070 FORMAT (/10X,'Enter the third author (15 char).  '\)
      READ (*,4050) AS(I,3)
      WRITE (*,4080)
 4080 FORMAT (/10X,'Enter subject #1 (15 char).  '\)
      READ (*,4050) AS(I,4)
      WRITE (*,4090)
 4090 FORMAT (/10X,'Enter subject #2 (15 char).  '\)
      READ (*,4050) AS(I,5)
      WRITE (*,4100)
 4100 FORMAT (/10X,'Enter the location (7 char).  '\)
      READ (*,4110) L(I)
 4110 FORMAT (A7)
      WRITE (*,4120) ESC
 4120 FORMAT (1X,A1,'E')
 4130 CONTINUE
      NLIN=0
C Write data to disk
 4140 OPEN (3,FILE=FNAME(J),STATUS='NEW')
      REWIND 3
      DO 4160 I=1,NLINW
      WRITE (3,4150) I, T(I), (AS(I,K),K=1,5), L(I)
 4150 FORMAT (I3,A40,5A15,A7)
 4160 CONTINUE
      CLOSE (3)
C Branch to main program menu if data entry terminated
      NFIL=J
      IF (T(NLINW) .EQ. AST) GOTO 4210
 4170 CONTINUE
C Write the directory
      OPEN (2,FILE='DIR')
      WRITE (2,4180) 27,100
 4180 FORMAT (I2,I3)
      CLOSE (2)
C Inform user that disk is filled to capacity
 4190 WRITE (*,4200) ESC
 4200 FORMAT (1X,A1,'E'///1X,'This disk is now full.'//1X,'Please'
     X' insert a new formatted disk in the default drive'/1X,'and'
     X' strike a carriage return.'///)
      PAUSE
      GOTO 4230
 4210 NLIN=NLINW-1
      OPEN (2,FILE='DIR')
      WRITE (2,4220) NFIL, NLIN
 4220 FORMAT (I2,I3)
      CLOSE (2)
 4230 END
C Subroutine to observe and edit individual file records
      SUBROUTINE EDFILE
      DIMENSION N(100)
      CHARACTER*40 T, ENTRY
      CHARACTER*15 AS
      CHARACTER*7 L
      CHARACTER*1 AST, ESC, FNAM, SHENTRY, SPA
      COMMON T(100), AS(100,5), L(100), NFIL, NLIN
      AST=CHAR(42)
      ESC=CHAR(27)
      SPA=CHAR(32)
 5000 WRITE (*,5010)
 5010 FORMAT (///5X,'Enter the name of the file to be edited.'
     X1X,//5X,'Enter an asterisk to terminate editing.  '\)
      READ (*,5020) FNAM
 5020 FORMAT (A1)
C NFILED represents the file number (1-27) corresponding to the
C   specific file name (A through @) being edited
      NFILED=ICHAR(FNAM)-64
      IF (FNAM .EQ. '@') NFILED=27
C Branch if editing is terminated
      IF (FNAM .EQ. AST) THEN
      WRITE (*,5030) ESC
 5030 FORMAT (1X,A1,'E')
      GOTO 5330
      ENDIF
C Determine that file selected to be edited exists on this disk
      IF ((NFILED .LT. 1) .OR. (NFILED .GT. 27)) GOTO 5035
      IF (NFILED .LE. NFIL) GOTO 5050
 5035 WRITE (*,5040)
 5040 FORMAT (5X,'This file does not exist on this disk.')
      GOTO 5000
C Read contents of selected file into memory
 5050 OPEN (3,FILE=FNAM)
      DO 5070 I=1,100
      READ (3,5060,ERR=5035) N(I), T(I), (AS(I,K),K=1,5), L(I)
 5060 FORMAT (I3,A40,5A15,A7)
C NLIN represents the number of records in this file
      NLIN=I
      IF (T(I) .EQ. AST) GOTO 5080
 5070 CONTINUE
C Select file record to be edited
 5080 WRITE (*,5090)
 5090 FORMAT (/5X,'Enter the file line to be edited.  Enter a zero'
     X' to exit this file.  '\)
      READ (*,5100,ERR=5110) NLINED
 5100 FORMAT (BN,I3)
      IF (NLINED .EQ. 0) GOTO 5310
      IF ((NLINED .EQ. NLIN) .AND. (T(NLINED) .EQ. AST)) GOTO 5110
      IF (NLINED .LE. NLIN) GOTO 5130
 5110 WRITE (*,5120)
 5120 FORMAT (5X,'This file line does not exist in this file.'/)
      GOTO 5080
C Display the contents of the record and accept changes
 5130 WRITE (*,5140) ESC, T(NLINED)
 5140 FORMAT (1X,A1,'E',/5X,'The title is:  ',A40)
      WRITE (*,5150)
 5150 FORMAT (5X,'Enter the new title.  '\)
      READ (*,5160) ENTRY
 5160 FORMAT (A40)
      SHENTRY=ENTRY
      IF (SHENTRY .NE. SPA) T(NLINED)=ENTRY
      WRITE (*,5170) AS(NLINED,1)
 5170 FORMAT (/5X,'The first author is:   ',A15)
      WRITE (*,5180)
 5180 FORMAT (5X,'Enter the new first author.  '\)
      READ (*,5190) ENTRY
 5190 FORMAT (A15)
      SHENTRY=ENTRY
      IF (SHENTRY .NE. SPA) AS(NLINED,1)=ENTRY
      WRITE (*,5200) AS(NLINED,2)
 5200 FORMAT (/5X,'The second author is:  ',A15)
      WRITE (*,5210)
 5210 FORMAT (5X,'Enter the new second author.  '\)
      READ (*,5190) ENTRY
      SHENTRY=ENTRY
      IF (SHENTRY .NE. SPA) AS(NLINED,2)=ENTRY
      WRITE (*,5220) AS(NLINED,3)
 5220 FORMAT (/5X,'The third author is:  ',A15)
      WRITE (*,5230)
 5230 FORMAT (5X,'Enter the new third author.  '\)
      READ (*,5190) ENTRY
      SHENTRY=ENTRY
      IF (SHENTRY .NE. SPA) AS(NLINED,3)=ENTRY
      WRITE (*,5240) AS(NLINED,4)
 5240 FORMAT (/5X,'Subject #1 is:  ',A15)
      WRITE (*,5250)
 5250 FORMAT (5X,'Enter the new subject #1.  '\)
      READ (*,5190) ENTRY
      SHENTRY=ENTRY
      IF (SHENTRY .NE. SPA) AS(NLINED,4)=ENTRY
      WRITE (*,5260) AS(NLINED,5)
 5260 FORMAT (/5X,'Subject #2 is:  ',A15)
      WRITE (*,5270)
 5270 FORMAT (5X,'Enter the new subject #2.  '\)
      READ (*,5190) ENTRY
      SHENTRY=ENTRY
      IF (SHENTRY .NE. SPA) AS(NLINED,5)=ENTRY
      WRITE (*,5280) L(NLINED)
 5280 FORMAT (/5X,'The location is:  ',A7)
      WRITE (*,5290)
 5290 FORMAT (5X,'Enter the new location.  '\)
      READ (*,5300) ENTRY
 5300 FORMAT (A7)
      SHENTRY=ENTRY
      IF (SHENTRY .NE. SPA) L(NLINED)=ENTRY
      GOTO 5080
C Write the edited file on the disk
 5310 REWIND 3
      DO 5320 I=1,NLIN
      WRITE (3,5060) N(I), T(I), (AS(I,K),K=1,5), L(I)
 5320 CONTINUE
      CLOSE (3)
      WRITE (*,5030) ESC
      GOTO 5000
 5330 RETURN
      END
C Subroutine to search the files for all records containing a
C   specific name, alphabetize these entries, display the list
C   on the screen, print the list on the printer, and save the 
C   list on disk
      SUBROUTINE SORTFILE
      DIMENSION N(100)
      CHARACTER*40 T, MT(301), TEMP, NSRCH, NTYPE
      CHARACTER*15 AS, MAS(300,5)
      CHARACTER*10 SHORT0
      CHARACTER*9 SHORT9
      CHARACTER*8 SHORT8
      CHARACTER*7 L, ML(300), SHORT7
      CHARACTER*6 SHORT6
      CHARACTER*5 SHORT5
      CHARACTER*4 SHORT4
      CHARACTER*3 SHORT3
      CHARACTER*2 SHORT2
      CHARACTER*1 AST, ESC, ETX, FF, SPA
      CHARACTER*1 FNAM, FNAME(27), SHORT1, Q
      COMMON T(100), AS(100,5), L(100), NFIL, NLIN
      AST=CHAR(42)
      ESC=CHAR(27)
      ETX=CHAR(03)
      FF=CHAR(12)
      SPA=CHAR(32)
 6000 WRITE (*,6010) ESC
 6010 FORMAT (1X,A1,'E')
      M=0
 6030 WRITE (*,6040)
 6040 FORMAT (//5X,'Enter the number corresponding to the type of'
     X' name for which you'/10X,'wish to search.'///15X,'<1>'
     X'  Title'//15X,'<2>  First Author'//15X,'<3>  Second Author'//
     X15X,'<4>  Third Author'//15X,'<5>  Subject #1'//15X,'<6>'
     X'  Subject #2'//15X,'<7>  Location'///5X,'Enter this number'
     X' followed by a carriage return.  '\)
      READ (*,6050,ERR=6000) MODE
 6050 FORMAT (I1)
      IF ((MODE .LT. 1) .OR. (MODE .GT. 7)) GOTO 6000
C NSRCH is the name for which the files will be searched
C NCHAR is the number of characters in the name that must be equivalent
C   for a match to occur
 6060 WRITE (*,6070) ESC
 6070 FORMAT (1X,A1,'E'///5X,'Enter the number of characters that must'
     X' match  (1-10).'/5X,'Enter 0 for an exact match.  '\)
      READ (*,6080,ERR=6060) NCHAR
 6080 FORMAT (BN,I2)
      IF ((NCHAR .LT. 0) .OR. (NCHAR .GT. 10)) GOTO 6060
      IF (NCHAR .EQ. 0) NCHAR=11
      IF (MODE .EQ. 1) THEN
      WRITE (*,6090) ESC
 6090 FORMAT (1X,A1,'E'//5X,'Enter the title for which you wish to'
     X' search.')
      ELSEIF (MODE .EQ. 2) THEN
      WRITE (*,6100) ESC
 6100 FORMAT (1X,A1,'E'//5X,'Enter the first author for which you'
     X' wish to search.')
      ELSEIF (MODE .EQ. 3) THEN
      WRITE (*,6110) ESC
 6110 FORMAT (1X,A1,'E'//5X,'Enter the second author for which you'
     X' wish to search.')
      ELSEIF (MODE .EQ. 4) THEN
      WRITE (*,6120) ESC
 6120 FORMAT (1X,A1,'E'//5X,'Enter the third author for which you'
     X' wish to search.')
      ELSEIF (MODE .EQ. 5) THEN
      WRITE (*,6130) ESC
 6130 FORMAT (1X,A1,'E'//5X,'Enter the subject #1 for which you'
     X' wish to search.')
      ELSEIF (MODE .EQ. 6) THEN
      WRITE (*,6140) ESC
 6140 FORMAT (1X,A1,'E'//5X,'Enter the subject #2 for which you'
     X' wish to search.')
      ELSEIF (MODE .EQ. 7) THEN
      WRITE (*,6150) ESC
 6150 FORMAT (1X,A1,'E'//5X,'Enter the location for which you'
     X' wish to search.')
      ELSE
      GOTO 6000
      ENDIF
      WRITE (*,6160)
 6160 FORMAT (/5X\)
      READ (*,6170) NSRCH
 6170 FORMAT (A40)
      SHORT1=NSRCH
C Don't search for a blank entry
      IF (SHORT1 .EQ. SPA) GOTO 6000
 6180 WRITE (*,6190) ESC
 6190 FORMAT (1X,A1,'E'////5X,'Searching file disk. . .')
C Search the disk for all entries containing NSRCH
      DO 6360 J=1,27
      FNAME(J)=CHAR(J+64)
      IF (J .EQ. 27) FNAME(J)=CHAR(64)
      OPEN (3,FILE=FNAME(J))
      DO 6350 I=1,100
      READ (3,6200) N(I), T(I), (AS(I,K),K=1,5), L(I)
 6200 FORMAT (I3,A40,5A15,A7)
C Terminate search when asterisk encountered for TITLE
      IF (T(I) .EQ. AST) GOTO 6390
C NTYPE represents the type of name being searched for, determined by
C   the value entered for MODE
      IF (MODE .EQ. 1) THEN
      NTYPE=T(I)
      GOTO 6210
      ELSEIF (MODE .EQ. 2) THEN
      NTYPE=AS(I,1)
      GOTO 6210
      ELSEIF (MODE .EQ. 3) THEN
      NTYPE=AS(I,2)
      GOTO 6210
      ELSEIF (MODE .EQ. 4) THEN
      NTYPE=AS(I,3)
      GOTO 6210
      ELSEIF (MODE .EQ. 5) THEN
      NTYPE=AS(I,4)
      GOTO 6210
      ELSEIF (MODE .EQ. 6) THEN
      NTYPE=AS(I,5)
      GOTO 6210
      ELSEIF (MODE .EQ. 7) THEN
      NTYPE=L(I)
      GOTO 6210
      ELSE
      GOTO 6000
      ENDIF
C Mask off trailing letters not desired in search
 6210 GOTO (6220, 6230, 6240, 6250, 6260, 6270, 6280, 6290, 6300, 
     X6310, 6320), NCHAR
 6220 SHORT1=NTYPE
      NTYPE=SHORT1
      SHORT1=NSRCH
      NSRCH=SHORT1
      GOTO 6320
 6230 SHORT2=NTYPE
      NTYPE=SHORT2
      SHORT2=NSRCH
      NSRCH=SHORT2
      GOTO 6320
 6240 SHORT3=NTYPE
      NTYPE=SHORT3
      SHORT3=NSRCH
      NSRCH=SHORT3
      GOTO 6320
 6250 SHORT4=NTYPE
      NTYPE=SHORT4
      SHORT4=NSRCH
      NSRCH=SHORT4
      GOTO 6320
 6260 SHORT5=NTYPE
      NTYPE=SHORT5
      SHORT5=NSRCH
      NSRCH=SHORT5
      GOTO 6320
 6270 SHORT6=NTYPE
      NTYPE=SHORT6
      SHORT6=NSRCH
      NSRCH=SHORT6
      GOTO 6320
 6280 SHORT7=NTYPE
      NTYPE=SHORT7
      SHORT7=NSRCH
      NSRCH=SHORT7
      GOTO 6320
 6290 SHORT8=NTYPE
      NTYPE=SHORT8
      SHORT8=NSRCH
      NSRCH=SHORT8
      GOTO 6320
 6300 SHORT9=NTYPE
      NTYPE=SHORT9
      SHORT9=NSRCH
      NSRCH=SHORT9
      GOTO 6320
 6310 SHORT0=NTYPE
      NTYPE=SHORT0
      SHORT0=NSRCH
      NSRCH=SHORT0
C When NTYPE=NSRCH, a match has occurred
 6320 IF (NSRCH .EQ. NTYPE) THEN
C M represents the cumulative number of matched entries
      M=M+1
C No more than 300 matches can be accommodated by program
      IF (M .GT. 300) THEN
      M=M-1
      WRITE (*,6330) ESC
 6330 FORMAT (1X,A1,'E'//1X,'The maximum number of output lines,'
     X' 300, has been reached.'//1X,'There are remaining files on'
     X' this disk which match the'/1X,'name for which you are'
     X' searching.  These file lines'/5X,'will not be included in'
     X' the output.'///)
      PAUSE
      GOTO 6410
      ENDIF
C MT, MAS, and ML represent values of T, AS, and L from a record
C   which contains a match for NSRCH
      MT(M)=T(I)
      DO 6340 K=1,5
      MAS(M,K)=AS(I,K)
 6340 CONTINUE
      ML(M)=L(I)
      ELSE
      CONTINUE
      ENDIF
 6350 CONTINUE
      CLOSE (3)
 6360 CONTINUE
      WRITE (*,6370) ESC
 6370 FORMAT (1X,A1,'E'//5X,'Would you like to search another'
     X' disk?  <Y or N>  '\)
      READ (*,6380) Q
 6380 FORMAT (A1)
      IF ((Q .EQ. 'Y') .OR. (Q .EQ. 'y')) GOTO 6180
 6390 WRITE (*,6010) ESC
      IF (M .EQ. 0) THEN
      WRITE (*,6400)
 6400 FORMAT (//1X,'No matching entries were found.'//)
      PAUSE
      GOTO 6840
      ENDIF
C Select alphabetization format
 6410 WRITE (*,6420) ESC
 6420 FORMAT (1X,A1,'E'//5X,'Under which of the following would you'
     X' like the output alphabetized?'///15X,'<1>  Title'//15X,
     X'<2>  First Author'//15X,'<3>  Second Author'//15X,'<4>'
     X'  Third Author'//15X,'<5>  Subject #1'//15X,'<6>  Subject'
     X' #2'//15X,'<7>  Location'///5X,'Enter the number followed'
     X' by a carriage return.  '\)
      READ (*,6425,ERR=6410) MODE
 6425 FORMAT (I1)
      IF ((MODE .LT. 1) .OR. (MODE .GT. 7)) GOTO 6410
      WRITE (*,6430) ESC
 6430 FORMAT (1X,A1,'E'////5X,'Alphabetizing the output. . .')
      DO 6540 I=1,M-1
      DO 6530 J=I+1,M
      IF (MODE .EQ. 1) GOTO 6435
      IF (MODE .EQ. 2) GOTO 6440
      IF (MODE .EQ. 3) GOTO 6450
      IF (MODE .EQ. 4) GOTO 6460
      IF (MODE .EQ. 5) GOTO 6470
      IF (MODE .EQ. 6) GOTO 6480
      IF (MODE .EQ. 7) GOTO 6490
      GOTO 6410
C Alphabetize the records
 6435 IF (MT(I) .LE. MT(J)) GOTO 6520
      GOTO 6500
 6440 IF (MAS(I,1) .LE. MAS(J,1)) GOTO 6520
      GOTO 6500
 6450 IF (MAS(I,2) .LE. MAS(J,2)) GOTO 6520
      GOTO 6500
 6460 IF (MAS(I,3) .LE. MAS(J,3)) GOTO 6520
      GOTO 6500
 6470 IF (MAS(I,4) .LE. MAS(J,4)) GOTO 6520
      GOTO 6500
 6480 IF (MAS(I,5) .LE. MAS(J,5)) GOTO 6520
      GOTO 6500
 6490 IF (ML(I) .LE. ML(J)) GOTO 6520
 6500 TEMP=MT(I)
      MT(I)=MT(J)
      MT(J)=TEMP
      DO 6510 K=1,5
      TEMP=MAS(I,K)
      MAS(I,K)=MAS(J,K)
      MAS(J,K)=TEMP
 6510 CONTINUE
      TEMP=ML(I)
      ML(I)=ML(J)
      ML(J)=TEMP
 6520 CONTINUE
 6530 CONTINUE
 6540 CONTINUE
C Write the output list on the screen
      WRITE (*,6550) ESC
 6550 FORMAT (1X,A1,'E'//5X,'Do you want the output list displayed'
     X' on the screen?  <Y or N>  '\)
      READ (*,6380) Q
      IF ((Q .NE. 'Y') .AND. (Q .NE. 'y')) GOTO 6600
      WRITE (*,6560) ESC
 6560 FORMAT (1X,A1,'E'/3X,'#',1X,'TITLE',36X,'FIRST AUTHOR',4X,
     X'SECOND AUTHOR'/,3X,'THIRD AUTHOR',4X,'SUBJECT #1',6X,
     X'SUBJECT #2',6X,'LOCATION'/)
      DO 6590 I=1,M
C Pause after each five records displayed on screen
      NREM=MOD(I,5)
      WRITE (*,6570) I, MT(I), (MAS(I,K),K=1,5), ML(I)
 6570 FORMAT (I4,A41,A16,A16/,2X,3A16,A8/)
      IF (NREM .EQ. 0) THEN
      WRITE (*,6580)
 6580 FORMAT (//)
      PAUSE
      WRITE (*,6010) ESC
      WRITE (*,6580)
      ENDIF
 6590 CONTINUE
      PAUSE
C Write the output list on the printer
 6600 WRITE (*,6610) ESC
 6610 FORMAT (1X,A1,'E'//5X,'Do you want the output list sent to'
     X' the printer?  <Y or N>  '\)
      READ (*,6380) Q
      IF (Q .EQ. '&') GOTO 6680
      IF ((Q .NE. 'Y') .AND. (Q .NE. 'y')) THEN
      WRITE (*,6010) ESC
      GOTO 6700
      ENDIF
 6615 WRITE (*,6620)
 6620 FORMAT (//5X,'Pause after how many printed lines?  <1-300>  '\)
      READ (*,6630,ERR=6615) NLINP
 6630 FORMAT (BN,I3)
      IF ((NLINP .LT. 1) .OR. (NLINP .GT. 300)) GOTO 6615
      OPEN (4,FILE='PRN',STATUS='NEW')
      WRITE (4,6640)
 6640 FORMAT (2X,'#',2X,'TITLE',36X,'FIRST AUTHOR',4X,'SECOND AUTHOR'
     X3X,'THIRD AUTHOR',4X,'SUBJECT #1',6X,'SUBJECT #2',6X,
     X'LOCATION'/)
      DO 6670 I=1,M
      NREM=MOD(I,NLINP)
      WRITE (4,6650) I, MT(I), (MAS(I,K),K=1,5), ML(I)
 6650 FORMAT (I4,A41,5A16,A8)
      IF (NREM .EQ. 0) THEN
      WRITE (4,6660) FF
 6660 FORMAT (1X,A1)
      PAUSE
      ENDIF
 6670 CONTINUE
      WRITE (4,6660) ETX
      WRITE (4,6660) FF
      CLOSE (4)
      WRITE (*,6010) ESC
      GOTO 6700
C Sneaky way of author hiding his name in program
 6680 WRITE (*,6690) ESC
 6690 FORMAT (1X,A1,'E'////37X,'CARDCAT'///20X,'A Program by Mark'
     X' Dershwitz, M.D., Ph.D.'/////)
      PAUSE
      GOTO 6600
C Write the output list to disk
 6700 WRITE (*,6710)
 6710 FORMAT (/5X,'Do you want the output list saved on'
     X' disk?  <Y or N>  '\)
      READ (*,6380) Q
      IF ((Q .NE. 'Y') .AND. (Q .NE. 'y')) GOTO 6840
C Write an asterisk for the title after the last record
      MT(M+1)=AST
      M=1
      WRITE (*,6010) ESC
 6720 WRITE (*,6730)
 6730 FORMAT (/1X,'Please insert the disk in the default drive on'
     X' which you want to'/1X,'save the output list.  Then strike a'
     X' carriage return.'///)
      PAUSE
C Determine the number of files, and the number of records in the
C   last file, on the disk
      WRITE (*,6740) ESC
 6740 FORMAT (1X,A1,'E'////5X,'Reading file disk. . .')
      OPEN (2,FILE='DIR')
      READ (2,6750) NFIL, NLIN
 6750 FORMAT (I2,I3)
      CLOSE (2)
C Inform user if disk capacity has been reached
      IF ((NFIL .EQ. 27) .AND. (NLIN .EQ. 100)) GOTO 6810
C Read contents of last file into memory
      FNAM=CHAR(NFIL+64)
      IF (NFIL .EQ. 27) FNAM=CHAR(64)
      OPEN (3,FILE=FNAM)
      DO 6760 I=1,NLIN
      READ (3,6200) N(I), T(I), (AS(I,K),K=1,5), L(I)
 6760 CONTINUE
      CLOSE (3)
C Write alphabetized output list to disk, immediately following
C   last existing entry; write an asterisk for the title after
C   the last record
      WRITE (*,6770)
 6770 FORMAT (///5X,'Writing file disk. . .')
      DO 6800 J=NFIL,27
      NFIL=J
      FNAME(J)=CHAR(J+64)
      IF (J .EQ. 27) FNAME(J)=CHAR(64)
      OPEN (3,FILE=FNAME(J),STATUS='NEW')
C First rewrite the records existing in this file
      DO 6780 I=1,NLIN
      WRITE (3,6200) I, T(I), (AS(I,K),K=1,5), L(I)
 6780 CONTINUE
C Now write the alphabetized output list
      DO 6790 I=NLIN+1,100
      WRITE (3,6200) I, MT(M), (MAS(M,K),K=1,5), ML(M)
C Branch after last record written
      IF (MT(M) .EQ. AST) THEN
      NLIN=I-1
      GOTO 6830
      ENDIF
      M=M+1
 6790 CONTINUE
      NLIN=0
      CLOSE (3)
 6800 CONTINUE
      NLIN=100
 6810 WRITE (*,6820) ESC
 6820 FORMAT (1X,A1,'E'//1X,'This disk is now full.')
C Now rewrite the directory
      OPEN (6,FILE='DIR')
      WRITE (6,6750) NFIL, NLIN
      CLOSE (6)
      GOTO 6720
C Now rewrite the directory
 6830 CLOSE (3)
      OPEN (6,FILE='DIR')
      WRITE (6,6750) NFIL, NLIN
      CLOSE (6)
 6840 WRITE (*,6010) ESC
      RETURN
      END
C Subroutine to display an entire file
      SUBROUTINE SEEFILE
      DIMENSION N(100)
      CHARACTER*40 T
      CHARACTER*15 AS
      CHARACTER*7 L
      CHARACTER*1 AST, ESC, ETX, FF, FNAM, Q
      COMMON T(100), AS(100,5), L(100), NFIL, NLIN
      AST=CHAR(42)
      ESC=CHAR(27)
      ETX=CHAR(03)
      FF=CHAR(12)
 7000 WRITE (*,7010)
 7010 FORMAT (//5X,'Enter the name of the file to be displayed.  '/5X,
     X'Enter an asterisk to return to the main menu.  '\)
      READ (*,7020) FNAM
 7020 FORMAT (A1)
      IF (FNAM .EQ. AST) GOTO 7220
C NFILD represents the file number (1-27) corresponding to the
C   specific file name (A through @) to be displayed
      NFILD=ICHAR(FNAM)-64
      IF (FNAM .EQ. '@') NFILD=27
      IF ((NFILD .LT. 1) .OR. (NFILD .GT. 27)) GOTO 7025
C Determine that file selected to be edited exists on this disk
      IF (NFILD .LE. NFIL) GOTO 7040
 7025 WRITE (*,7030)
 7030 FORMAT (5X,'This file does not exist on this disk.')
      GOTO 7000
C Read contents of selected file into memory
 7040 OPEN (3,FILE=FNAM)
      DO 7060 I=1,100
      READ (3,7050,ERR=7025) N(I), T(I), (AS(I,K),K=1,5), L(I)
 7050 FORMAT (I3,A40,5A15,A7)
C NLIN represents the number of records in this file
      IF (T(I) .EQ. AST) GOTO 7070
      NLIN=I
 7060 CONTINUE
      CLOSE (3)
C Display the file on the screen
 7070 WRITE (*,7080) ESC
 7080 FORMAT (1X,A1,'E'///5X,'Do you want the file displayed'
     X' on the screen?  <Y or N>  '\)
      READ (*,7020) Q
      IF ((Q .NE. 'Y') .AND. (Q .NE. 'y')) GOTO 7140
      WRITE (*,7090) ESC
 7090 FORMAT (1X,A1,'E',/3X,'#',1X,'TITLE',36X,'FIRST AUTHOR',4X,
     X'SECOND AUTHOR'/,3X,'THIRD AUTHOR',4X,'SUBJECT #1',6X,
     X'SUBJECT #2',6X,'LOCATION'/)
      DO 7130 I=1,NLIN
C Pause after each five records displayed on screen
      NREM=MOD(I,5)
      WRITE (*,7100) I, T(I), (AS(I,K),K=1,5), L(I)
 7100 FORMAT (I4,A41,A16,A16/,2X,3A16,A8/)
      IF (NREM .EQ. 0) THEN
      WRITE (*,7110)
 7110 FORMAT (//)
      PAUSE
      WRITE (*,7120) ESC
 7120 FORMAT (1X,A1,'E')
      WRITE (*,7110)
      ENDIF
 7130 CONTINUE
      PAUSE
C Send the file to the printer
 7140 WRITE (*,7150) ESC
 7150 FORMAT (1X,A1,'E'///5X,'Do you want the file sent to'
     X' the printer?  <Y or N>  '\)
      READ (*,7020) Q
      IF ((Q .NE. 'Y') .AND. (Q .NE. 'y')) THEN
      WRITE (*,7120) ESC
      GOTO 7000
      ENDIF
 7155 WRITE (*,7160)
 7160 FORMAT (//5X,'Pause after how many printed lines?  <1-100>  '\)
      READ (*,7170,ERR=7155) NLINP
 7170 FORMAT (BN,I3)
      IF ((NLINP .LT. 1) .OR. (NLINP .GT. 100)) GOTO 7155
      OPEN (4,FILE='PRN',STATUS='NEW')
      WRITE (4,7180)
 7180 FORMAT (2X,'#',2X,'TITLE',36X,'FIRST AUTHOR',4X,'SECOND AUTHOR'
     X3X,'THIRD AUTHOR',4X,'SUBJECT #1',6X,'SUBJECT #2',6X,
     X'LOCATION'/)
      DO 7210 I=1,NLIN
      NREM=MOD(I,NLINP)
      WRITE (4,7190) I, T(I), (AS(I,K),K=1,5), L(I)
 7190 FORMAT (I4,A41,5A16,A8)
      IF (NREM .EQ. 0) THEN
      WRITE (4,7200) FF
 7200 FORMAT (1X,A1)
      PAUSE
      ENDIF
 7210 CONTINUE
      WRITE (4,7200) ETX
      WRITE (4,7200) FF
      CLOSE (4)
 7220 WRITE (*,7120) ESC
      RETURN
      END
