	TITLE	Z-100 Console Setup Utility
	SUBTTL	Data Definitions
	PAGE	,132
;
;	Z-100/Z-150 Console Setup Utility
;
;	Author: R. A. Metz		Date: 6/16/83
;	MODIFIED BY P. SWAYNE, HUG  04-JAN-85  21-JAN-85
;		WRAP SETTINGS ADDED
;		CURSOR AND WRAP TYPE DISPLAYS ADDED
;		EXIT COMMAND ADDED
;		Z-150 SECTION ADDED
;	
	PAGE
SETCON	SEGMENT
	ASSUME	DS:SETCON,CS:SETCON,SS:SETCON,ES:SETCON
	ORG	100H
INCLUDE MACROS.ASM
START:
	JMP	BEGIN
;
HICODE	EQU	0FH			; Z-150 HIGHLIGHT CODE
					; USE 70H FOR REV. VIDEO
ESC	EQU	01BH
;
MAXADR	DW	0
CURTBL	DW	0
TTYPE	DB	0			; TERMINAL TYPE
DISTYPE	DB	3			; DISPLAY TYPE
SCTYPE	DB	0			; SCROLL TYPE
CURTYPE	DW	607H			; CURSOR TYPE
;
IDMSG	DB	ESC,'Z',13,'  ',13,'$'
;
MENU_HDR	DB	ESC,'E'		; Clear screen
	DB	ESC,'x1'		; Enable 25th line
	ADDR	25,1
	DB	80 DUP (' ')		; Clear 25th line
	DB	ESC,'y?'		; Disable kbd expansion
	DB	ESC,'x5'		; Cursor off
	ADDR	1,23
	DB	ESC,'q'			; Normal video
	DB	ESC,'F'			; Graphic mode
	DB	'f'
	DB	33 DUP ('a')
	DB	'c'
	ADDR	2,23
	DB	'`',ESC,'G'
	DB	'      Z-1'
MTYPE	DB	'00 Console Utility      '
	DB	ESC,'F`'
	ADDR	3,23
	DB	'`',ESC,'G'
	DB	10 DUP (' ')
	DB	'Version 1.1.0'
	DB	10 DUP (' ')
	DB	ESC,'F`'
	ADDR	4,23
	DB	'e'
	DB	33 DUP ('a')
	DB	'd'
	ADDR	18,14
	DB	'f'
	DB	12 DUP ('a')
	DB	's'
	DB	12 DUP ('a')
	DB	's'
	DB	12 DUP ('a')
	DB	's'
	DB	12 DUP ('a')
	DB	'c'
	ADDR	19,14
	DB	'`',ESC,'G'
	DB	'  Key ==>   '
	DB	ESC,'F`',ESC,'G'
	DB	'    '
HTYPE	DB	'Help    '
	DB	ESC,'F`',ESC,'G'
	DB	'  Up/Down   '
	DB	ESC,'F`',ESC,'G'
	DB	'   Enter    '
	DB	ESC,'F`'
	ADDR	20,14
	DB	'`',ESC,'G'
	DB	12 DUP (' ')
	DB	ESC,'F`',ESC,'G'
	DB	'            '
	DB	ESC,'F`',ESC,'G'
	DB	'   Arrows   '
	DB	ESC,'F`',ESC,'G'
	DB	12 DUP (' ')
	DB	ESC,'F`'
	ADDR	21,14
	DB	'v'
	DB	12 DUP ('a')
	DB	'b'
	DB	12 DUP ('a')
	DB	'b'
	DB	12 DUP ('a')
	DB	'b'
	DB	12 DUP ('a')
	DB	't'
	ADDR	22,14
	DB	'`',ESC,'G'
	DB	' Action ==> '
	DB	ESC,'F`',ESC,'G'
	DB	'  Display   '
	DB	ESC,'F`',ESC,'G'
	DB	'    Move    '
	DB	ESC,'F`',ESC,'G'
	DB	'    Make    '
	DB	ESC,'F`'
	ADDR	23,14
	DB	'`',ESC,'G'
	DB	12 DUP (' ')
	DB	ESC,'F`',ESC,'G'
	DB	' Information'
	DB	ESC,'F`',ESC,'G'
	DB	'  Indicator '
	DB	ESC,'F`',ESC,'G'
	DB	' Selection  '
	DB	ESC,'F`'
	ADDR	24,14
	DB	'e'
	DB	12 DUP ('a')
	DB	'u'
	DB	12 DUP ('a')
	DB	'u'
	DB	12 DUP ('a')
	DB	'u'
	DB	12 DUP ('a')
	DB	'd'
	DB	ESC,'G$'

MRKDEF:	ADDR	6,18
	DB	'*'			; MARK DEFAULT ITEMS
	ADDR	16,18
	DB	'*'
	ADDR	6,48
	DB	'*'
	ADDR	10,48
	DB	'*$'
MRKDEF1:ADDR	10,18
	DB	'*'
	ADDR	7,48
	DB	'*'
	ADDR	10,48
	DB	'*$'

F1HLP	DB	' F1 '
;
HELPMSG	DB	ESC,'E',ESC,'x5',13,'$'
HELP1	LABEL	NEAR
 DB 9,'                  Z-100 Console Utility Program',13,10,10
 DB 9,'This  program allows you to alter certain features of the  screen',13,10
 DB 9,'and keyboard on H/Z-100 series computers.  The features which may',13,10
 DB 9,'be altered are the cursor type,  screen wrap, key click, and auto',13,10
 DB 9,'repeat.   To  alter a feature,  use the arrow keys on  the  small',13,10
 DB 9,'keypad  to  move  the highlighted display to the  item  you  have',13,10
 DB 9,'selected and press the ENTER key.  To exit this program, move the',13,10
 DB 9,'highlighted  display to the Exit selection and press ENTER.   You',13,10
 DB 9,'can also press the E key on the main keyboard to exit.',13,10,10
 DB 9,'The  current screen wrap setting (off or on) and the cursor  type',13,10
 DB 9,'are shown on the screen.   When screen wrap is on,  the  computer',13,10
 DB 9,'will  display a line of more than 80 characters as more than  one',13,10
 DB 9,'line on the screen.  When it is off, only 80 characters of a long',13,10
 DB 9,'line are displayed, and the rest are discarded.',13,10,10
 DB 9,'You  can  test for auto repeat and key click by using  the  arrow',13,10
 DB 9,'keys after making a selection.',13,10,10
 DB 9,'Items in the menu with asterisks (*) beside them are the  default',13,10
 DB 9,'settings, in effect when you first turn on the computer.',13,10,10
 DB 9,'Press any key to return to the menu.$'
HELP2	LABEL	NEAR
 DB 9,'                  Z-150 Console Utility Program',13,10,10
 DB 9,'This  program allows you to alter certain features of the  screen',13,10
 DB 9,'on  H/Z-150 series computers.   The features which may be altered',13,10
 DB 9,'are the video mode, the scroll mode, and the shape of the cursor.',13,10
 DB 9,'To  alter a feature,  use the arrow keys on the small  keypad  to',13,10
 DB 9,'move  the  highlighted display to the item you have selected  and',13,10
 DB 9,'press  the ENTER key.   Except for cursor shape,  your  selection',13,10
 DB 9,'will  not take effect until you exit this program,  but  will  be',13,10
 DB 9,'indicated on the screen.   To exit,  move the highlighted display',13,10
 DB 9,'to the Exit selection and press ENTER.   You can also press the E',13,10
 DB 9,'key on the main keyboard to exit.',13,10,10
 DB 9,'Not all video modes are compatible with all scroll modes.  If you',13,10
 DB 9,'try  to  select  an invalid combination,  you will hear  a  beep.',13,10
 DB 9,'Video mode 7 requires a monochrome adapter card,  and should  not',13,10
 DB 9,'be selected unless you have one installed in your computer.',13,10,10
 DB 9,'Settings  you make are not permanent,  and may be altered by  any',13,10
 DB 9,'program  that you run.   Items in the menu marked with  asterisks',13,10
 DB 9,'(*) are the default settings in effect when you first turn on the',13,10
 DB 9,'computer.',13,10,10
 DB 9,'Press any key to return to the menu.$'
;
REV_VID	DB	ESC,'p$'
NRM_VID	DB	ESC,'q$'
;
CURON	LABEL	NEAR
	ADDR	1,1
	DB	'Screen Wrap:'
	ADDR	2,1
	DB	'OFF'
	ADDR	1,80
	DB	' ON '
CURON1:	ADDR	16,50
	DB	'Cursor Type: '
	DB	ESC,'y5$'
CUROFF	DB	ESC,'x5$'

VMODE:	ADDR	16,20
	DB	'Video Mode: $'
SMODE:	ADDR	16,37
	DB	'Scroll: $'
;
TABLE_BUF	LABEL	BYTE
	ORG	0*80+OFFSET TABLE_BUF
	ADDR	6,20
	DB	'Blinking Underline Cursor$'
	ORG	0*80+40+OFFSET TABLE_BUF
	CALL	TYPTX
	DB	ESC,'y4',ESC,'y',';'+80H
	RET
;
	ORG	1*80+OFFSET TABLE_BUF
	ADDR	8,20
	DB	'Stable Underline Cursor$'
	ORG	1*80+40+OFFSET TABLE_BUF
	CALL	TYPTX
	DB	ESC,'y4',esc,'x',';'+80H
	RET
;
	ORG	2*80+OFFSET TABLE_BUF
	ADDR	10,20
	DB	'Blinking Block Cursor$'
	ORG	2*80+40+OFFSET TABLE_BUF
	CALL	TYPTX
	DB	ESC,'x4',ESC,'y',';'+80H
	RET
;
	ORG	3*80+OFFSET TABLE_BUF
	ADDR	12,20
	DB	'Stable Block Cursor$'
	ORG	3*80+40+OFFSET TABLE_BUF
	CALL	TYPTX
	DB	ESC,'x4',ESC,'x',';'+80H
	RET
;
	ORG	4*80+OFFSET TABLE_BUF
	ADDR	14,20
	DB	'Screen Wrap ON$'
	ORG	4*80+40+OFFSET TABLE_BUF
	CALL	TYPTX
	DB	ESC,'v'+80H
	RET
;
	ORG	5*80+OFFSET TABLE_BUF
	ADDR	16,20
	DB	'Screen Wrap OFF$'
	ORG	5*80+40+OFFSET TABLE_BUF
	CALL	TYPTX
	DB	ESC,'w'+80H
	RET
;
	ORG	6*80+OFFSET TABLE_BUF
	ADDR	6,50
	DB	'Key Click ON$'
	ORG	6*80+40+OFFSET TABLE_BUF
	CALL	TYPTX
	DB	ESC,'y','2'+80H
	RET
;
	ORG	7*80+OFFSET TABLE_BUF
	ADDR	8,50
	DB	'Key Click OFF$'
	ORG	7*80+40+OFFSET TABLE_BUF
	CALL	TYPTX
	DB	ESC,'x','2'+80H
	RET
;
	ORG	8*80+OFFSET TABLE_BUF
	ADDR	10,50
	DB	'Auto-Repeat ON$'
	ORG	8*80+40+OFFSET TABLE_BUF
	CALL	TYPTX
	DB	ESC,'y','<'+80H
	RET
;
	ORG	9*80+OFFSET TABLE_BUF
	ADDR	12,50
	DB	'Auto-Repeat OFF$'
	ORG	9*80+40+OFFSET TABLE_BUF
	CALL	TYPTX
	DB	ESC,'x','<'+80H
	RET
;
	ORG	10*80+OFFSET TABLE_BUF
	ADDR	14,50
	DB	'Exit Console Utility$'
	ORG	10*80+40+OFFSET TABLE_BUF
ZEXIT:	CALL	TYPTX
EXITMSG	DB	ESC,'y5'		; Cursor on
	DB	ESC,'x?'		; Kbd expansion on
	DB	ESC,'G'			; Graphics off
	DB	ESC,'q'			; Normal video
	DB	ESC,'E'+80H		; Clear
	INT	20H
;
	ORG	11*80+OFFSET TABLE_BUF
	DB	'99'			; End of table

TABLE_BUF1	LABEL	BYTE
	ORG	0*80+OFFSET TABLE_BUF1
	ADDR	7,20
	DB	'Video Mode 0: 40 B/W$'
	ORG	0*80+40+OFFSET TABLE_BUF1
	CMP	SCTYPE,0		; SCROLL MODE 0?
	JNZ	NM1
	MOV	DISTYPE,0
	RET
NM1:	MOV	AL,7
	JMP	SCOUT			; BEEP
;
	ORG	1*80+OFFSET TABLE_BUF1
	ADDR	8,20
	DB	'Video Mode 1: 40 Color$'
	ORG	1*80+40+OFFSET TABLE_BUF1
	CMP	SCTYPE,0
	JNZ	NM2
	MOV	DISTYPE,1
	RET
NM2:	MOV	AL,7
	JMP	SCOUT
;
	ORG	2*80+OFFSET TABLE_BUF1
	ADDR	9,20
	DB	'Video Mode 2: 80 B/W$'
	ORG	2*80+40+OFFSET TABLE_BUF1
	CMP	SCTYPE,2		; SMOOTH SCROLL?
	JZ	NM3			; NOT ALLOWED HERE
	MOV	DISTYPE,2
	RET
NM3:	MOV	AL,7
	JMP	SCOUT
;
	ORG	3*80+OFFSET TABLE_BUF1
	ADDR	10,20
	DB	'Video Mode 3: 80 Color$'
	ORG	3*80+40+OFFSET TABLE_BUF1
	CMP	SCTYPE,2
	JZ	NM4
	MOV	DISTYPE,3
	RET
NM4:	MOV	AL,7
	JMP	SCOUT
;
	ORG	4*80+OFFSET TABLE_BUF1
	ADDR	11,20
	DB	'Video Mode 4: 320 Color$'
	ORG	4*80+40+OFFSET TABLE_BUF1
	MOV	DISTYPE,4
	RET
;
	ORG	5*80+OFFSET TABLE_BUF1
	ADDR	12,20
	DB	'Video Mode 5: 320 B/W$'
	ORG	5*80+40+OFFSET TABLE_BUF1
	MOV	DISTYPE,5
	RET
;
	ORG	6*80+OFFSET TABLE_BUF1
	ADDR	13,20
	DB	'Video Mode 6: 640 B/W$'
	ORG	6*80+40+OFFSET TABLE_BUF1
	MOV	DISTYPE,6
	RET
;
	ORG	7*80+OFFSET TABLE_BUF1
	ADDR	14,20
	DB	'Video Mode 7: Monochrome$'
	ORG	7*80+40+OFFSET TABLE_BUF1
	CMP	SCTYPE,0
	JNZ	NM5			; ONLY SOFTWARE SCROLL ALLOWED
	MOV	DISTYPE,7
	RET
NM5:	MOV	AL,7
	JMP	SCOUT
;
	ORG	8*80+OFFSET TABLE_BUF1
	ADDR	7,50
	DB	'Software Scroll$'
	ORG	8*80+40+OFFSET TABLE_BUF1
	MOV	SCTYPE,0
	RET
;
	ORG	9*80+OFFSET TABLE_BUF1
	ADDR	8,50
	DB	'Hardware Scroll$'
	ORG	9*80+40+OFFSET TABLE_BUF1
	CMP	DISTYPE,2		; OK TO HARDWARE SCROLL?
	JC	NSC1			; NO
	CMP	DISTYPE,7
	JZ	NSC1			; MONOCHROME NOT ALLOWED
	MOV	SCTYPE,1
	RET
NSC1:	MOV	AL,7
	JMP	SCOUT			; BEEP, ILLEGAL FUNCTION
;
	ORG	10*80+OFFSET TABLE_BUF1
	ADDR	9,50
	DB	'Smooth Scroll$'
	ORG	10*80+40+OFFSET TABLE_BUF1
	CMP	DISTYPE,4		; OK TO SMOOTH SCROLL?
	JC	NSC2
	CMP	DISTYPE,7
	JZ	NSC2
	MOV	SCTYPE,2
	RET
NSC2:	MOV	AL,7
	JMP	SCOUT
;
	ORG	11*80+OFFSET TABLE_BUF1
	ADDR	10,50
	DB	'Standard Cursor$'
	ORG	11*80+40+OFFSET TABLE_BUF1
	CMP	DISTYPE,7		; MONOCHROME MODE?
	MOV	CX,0B0CH		; ASSUME YES
	JZ	SETC1
	MOV	CX,0607H		; ELSE, USE COLOR VALUES
SETC1:	MOV	CURTYPE,CX		; SAVE CURSOR TYPE
	MOV	AH,1
	INT	10H
	RET
;
	ORG	12*80+OFFSET TABLE_BUF1
	ADDR	11,50
	DB	'One Line Cursor$'
	ORG	12*80+40+OFFSET TABLE_BUF1
	CMP	DISTYPE,7
	MOV	CX,0C0CH
	JZ	SETC2
	MOV	CX,0707H
SETC2:	MOV	CURTYPE,CX
	MOV	AH,1
	INT	10H
	RET
;
	ORG	13*80+OFFSET TABLE_BUF1
	ADDR	12,50
	DB	'Block Cursor$'
	ORG	13*80+40+OFFSET TABLE_BUF1
	CMP	DISTYPE,7
	MOV	CX,0CH
	JZ	SETC3
	MOV	CX,07H
SETC3:	MOV	CURTYPE,CX
	MOV	AH,1
	INT	10H
	RET
;
	ORG	14*80+OFFSET TABLE_BUF1
	ADDR	14,50
	DB	'Exit Console Utility$'
	ORG	14*80+40+OFFSET TABLE_BUF1
IEXIT:	CALL	DOCLR
	MOV	AH,0
	MOV	AL,DISTYPE
	INT	10H			; SET VIDEO MODE
	MOV	AH,100
	MOV	AL,SCTYPE
	INT	10H			; SET SCROLL MODE
	CALL	TCURON			; SET CURSOR TYPE
	INT	20H			; EXIT

	ORG	15*80+OFFSET TABLE_BUF1
	DB	'99'
;
	SUBTTL	CODE SECTION
	PAGE
BEGIN:
	DISPLAY	IDMSG			; ASK TERMINAL TYPE
	MOV	CX,50			; SET A COUNTER
WFCHR:	MOV	AH,0BH
	INT	21H			; TEST FOR REPLY
	OR	AL,AL
	JNZ	GOTCHR			; GOT REPLY
	LOOP	WFCHR			; ELSE, TRY AGAIN
	PUSH	CX
	MOV	MTYPE,'5'		; SHOW COMPUTER AS Z-150
	MOV	AX,WORD PTR F1HLP
	MOV	WORD PTR HTYPE,AX
	MOV	AX,WORD PTR F1HLP+2
	MOV	WORD PTR HTYPE+2,AX	; CHANGE HELP KEY TO F1
	MOV	BYTE PTR UPCHR-1,48H	; FIX CHAR CHECKS
	MOV	BYTE PTR DNCHR-1,50H
	MOV	BYTE PTR HPCHR-1,3BH
	MOV	AX,100*256
	INT	10H			; SET NORMAL SCROLL
	MOV	AX,500H
	INT	10H			; SET PAGE 0
	MOV	AH,3
	INT	10H			; GET CURSOR TYPE
	MOV	CURTYPE,CX		; SAVE IT
	MOV	AH,15
	INT	10H			; READ DISPLAY TYPE
	MOV	DISTYPE,AL		; SAVE DISPLAY TYPE
	CMP	AL,7			; MONOCHROME CARD?
	JZ	MONCRD			; YES
	MOV	AX,3			; ELSE, FORCE MODE 3 FOR NOW
	INT	10H
MONCRD:	POP	CX
GOTCHR:	MOV	TTYPE,CL		; SAVE TERMINAL TYPE (0 = Z-150)
	MOV	AX,0C00H
	INT	21H			; FLUSH TYPE-AHEAD
REST:	MOV	DX,OFFSET MENU_HDR	; Display menu template
	CALL	DSPMSG
	MOV	DX,OFFSET MRKDEF
	CMP	TTYPE,0
	JNZ	MRKDFS
	MOV	DX,OFFSET MRKDEF1
MRKDFS:	CALL	DSPMSG			; MARK DEFAULT SETTINGS
	MOV	BX,OFFSET TABLE_BUF
	CMP	TTYPE,0			; Z-150?
	JNZ	SAVBF			; NO
	MOV	BX,OFFSET TABLE_BUF1	; ELSE, USE 2ND TABLE
SAVBF:	PUSH	BX
LINLP:					; Display menu items
	CMP	WORD PTR [BX],'99'
	JE	TABLE_FIN		; '99' is end of table
	CALL	NORMAL			; Display line item
	ADD	BX,80
	JMP	LINLP
;
TABLE_FIN:
	SUB	BX,80
	MOV	MAXADR,BX		; BX to last entry
	POP	BX			; GET BUFFER ADDRESS
	MOV	CURTBL,BX		; SAVE CURRENT TABLE ADDRESS
INLUP:
	CALL	REVERSE			; Reverse current entry
	MOV	DX,OFFSET CURON
	CMP	TTYPE,0			; Z-150
	JNZ	INLUP0
	MOV	DX,OFFSET VMODE
	CALL	DSPMSG			; SHOW VIDEO MODE MSG.
	MOV	AL,DISTYPE
	ADD	AL,'0'
	CALL	SCOUT			; SHOW VIDEO MODE
	MOV	DX,OFFSET SMODE
	CALL	DSPMSG			; SHOW SCROLL MODE MESSAGE
	MOV	AL,SCTYPE
	ADD	AL,'0'
	CALL	SCOUT			; SHOW SCROLL MODE
	MOV	DX,OFFSET CURON1	; DONT'T SHOW WRAP STATUS
INLUP0:	CALL	DSPMSG			; SHOW CURSOR
INLUP1:
	SVC	7  			; Read keyboard entry
	CMP	AL,0			; NULL?
	JNZ	INLUP2			; NO
	SVC	7			; GET NEXT KEY
INLUP2:	CMP	AL,0A5H			; Cursor up?
UPCHR:	JNE	DWNCHK
	CALL	NORMAL			; Yes - nrml vid current line
	SUB	BX,80			;  Previous line
	CMP	BX,CURTBL
	JGE	INLUP
	MOV	BX,MAXADR		;   (Wrap)
	JMP	INLUP
DWNCHK:
	CMP	AL,0A6H			; Cursor down?
DNCHR:	JNE	HELPCHK
	CALL	NORMAL			;  Yes
	ADD	BX,80			;  Next line
	CMP	BX,MAXADR
	JLE	INLUP
	MOV	BX,CURTBL		;   (Wrap)
	JMP	INLUP
HELPCHK:
	CMP	AL,095H			; Help?
HPCHR:	JNE	ENTRCHK
	MOV	DX,OFFSET HELPMSG	; Display help message
	CALL	DSPMSG
	CMP	TTYPE,0			; Z-150?
	MOV	DX,OFFSET HELP2		; ASSUME IT IS
	JZ	HELPCH1			; IT IS
	MOV	DX,OFFSET HELP1
HELPCH1:CALL	DSPMSG
	SVC	7   			;  Wait for kbd entry
	JMP	REST
ENTRCHK:
	CMP	AL,0DH			; CR?
	JE	DOCR
	CMP	AL,8DH			; ENTER?
	JNE	EXITCHK
	JMP	SHORT DOCR
EXITCHK:
	AND	AL,5FH			; CAPITALIZE
	CMP	AL,'E'			; EXIT?
	JZ	DOEXIT			; YES, EXIT
	JMP	INLUP			; ELSE, GET ANOTHER KEY
DOEXIT:	CMP	TTYPE,0			; Z-150
	JNZ	EXITZ			; NO
	JMP	IEXIT			; ELSE USE Z-150 EXIT
EXITZ:	JMP	ZEXIT
DOCR:
	ADD	BX,40			; Command addr
	CALL	BX			; INSTALL CHANGE
	SUB	BX,40			; FIX POINTER
	JMP	INLUP			; GET ANOTHER COMMAND
;
;	Change video characteristics of menu line item
;	in response to movement by a cursor up/down key
;
REVERSE	PROC	NEAR
	MOV	DX,OFFSET REV_VID	; Set to reverse video
	CALL	DSPMSG
NORMAL:
	MOV	DX,OFFSET CUROFF
	CALL	DSPMSG			; TURN CURSOR OFF
	MOV	DX,BX
	CALL	DSPMSG  		; Display line item
	MOV	DX,OFFSET NRM_VID
	CALL	DSPMSG
	RET
REVERSE	ENDP
;
;	SCOUT - SINGLE CHARACTER OUTPUT

SCOUT:	PUSH	AX
	PUSH	CX
	PUSH	BX
	PUSH	DX
	CMP	Byte Ptr TTYPE,0	; H150?
	JNZ	SCOUT1
	CALL	IBMOUT
	JMP	SCOUT2
SCOUT1:	MOV	DL,AL
	MOV	AH,6
	INT	21H
SCOUT2:	POP	DX
	POP	BX
	POP	CX
	POP	AX
	RET

;	DISPLAY MESSAGE ON SCREEN

DSPMSG:	PUSH	SI
	CLD
	MOV	SI,DX			; SI POINTS TO MSG
DSPMLP:	LODSB				; GET A CHARACTER
	CMP	AL,'$'			; END?
	JZ	DSPMX			; YES
	CALL	SCOUT			; ELSE, DISPLAY CHARACTER
	JMP	DSPMLP
DSPMX:	POP	SI
	RET

;	TYPTX - TYPE TEXT FOLLOWING CALL

TYPTX:	MOV	BP,SP			;GET ADDRESS OF TEXT
	XCHG	BX,[BP]
TYPTX1:	MOV	AL,[BX]
	AND	AL,7FH
	CALL	SCOUT
	CMP	AL,[BX]
	PUSHF
	INC	BX
	POPF
	JZ	TYPTX1
	MOV	BP,SP
	XCHG	BX,[BP]
	RET

;	Z19 CODE TO IBM TRANSLATOR -- WITH THANKS TO BOB METZ

IBMOUT:	JMP	WORD PTR IBMJMP
IBMOUT1:AND	AL,7FH
	CMP	AL,1BH			;ESCAPE?
	JNZ	CRT_OUT			;NO, NORMAL CHAR
	MOV	WORD PTR IBMJMP,OFFSET FIND_CODE	;ELSE, FIND CODE NEXT
IBMRET:	RET				;AND IGNORE ESC

CRT_OUT:OR	AL,AL			;NUL?
	JZ	IBMRET			;IF SO, RETURN
	CMP	AL,9			;TAB?
	JNZ	CRTOT1
	JMP	TAB			;IF SO, PROCESS IT HERE
CRTOT1:	CMP	AL,' '			;LET WRT TTY DO CONTROL
	JB	WRT_TTY
	CMP	BYTE PTR GRAFLG,0	;GRAPHICS MODE?
	JE	SCREEN_OUT		; NO - NORMAL
	CMP	AL,5EH			; YES - GRAPHICS CHR?
	JB	SCREEN_OUT
	CMP	AL,7EH		
	JA	SCREEN_OUT
	SUB	AL,5EH
	MOV	BX,OFFSET IBMGRPH
	XLAT
SCREEN_OUT:
	MOV	AH,9
	MOV	BL,ATTRI
	MOV	BH,0			;WRITE CHR W/ ATTRIIBUTE
	MOV	CX,1
	INT	10H
	JMP	CURRT			;MOVE CURSOR OVER
WRT_TTY:CMP	AL,10			;LF?
	JNE	WRT_TTY1
	MOV	AH,3			; YES, GET CURSOR POSITION
	MOV	BH,0
	INT	10H
	MOV	AL,10
	CMP	DH,23			;IF LINE <24 THEN NORMAL LF
	JL	WRT_TTY1
	JE	SCROL_24		;IF LINE = 24 THEN SCROLL 1-24
	RET				;IF LINE = 25 THEN IGNORE LF
SCROL_24:
	MOV	AX,601H
	MOV	CX,0
	MOV	DH,23
	MOV	DL,79
	MOV	BH,ATTRI
	INT	10H
	RET
WRT_TTY1:MOV	AH,14			; WRITE TTY TO SCREEN
	MOV	BL,ATTRI 
	MOV	BH,0
	INT	10H
	RET
;
FIND_CODE:
	MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	MOV	BX,OFFSET CODETABLE
FIND_LP:CMP	BYTE PTR [BX],0		;END OF TABLE?
	JNE	CHKIT			; NO
	RET				; YES - IGNORE ESC SEQUENCE
CHKIT:	CMP	AL,[BX]	
	JE	PROCESSIT
	ADD	BX,3			;NOT THIS ENTRY - CHECK NXT
	JMP	FIND_LP
PROCESSIT:
	JMP	WORD PTR 1[BX]		;ENTER ESC SEQ PROCESSOR

;	ESCAPE SEQUENCE PROCESSORS

;	RESET SCREEN

IBMRST:	MOV	BYTE PTR ATTRI,7	;RESET ATTRIBUTE
	MOV	BYTE PTR GRAFLG,0	;GRAPHIC MODE OFF
	MOV	AH,5
	MOV	AL,0			;ACTIVE PAGE IS 0
	INT	10H
	MOV	AX,600H
	MOV	BH,ATTRI		;GET ATTRIBUTE
	MOV	CX,0
	MOV	DH,24			;CLEAR SCREEN
	MOV	DL,79
	INT	10H
	JMP	HOME

GRAFON:	MOV	BYTE PTR GRAFLG,1	;GRAPHIC MODE ON
	RET
GRAFOF:	MOV	BYTE PTR GRAFLG,0	;GRAPHIC MODE OFF
	RET

REVIND:	MOV	AH,3			;REVERSE INDEX
	MOV	BH,0
	INT	10H			;GET CURSOR LOCATION
	CMP	DH,0			;LINE 1?
	JNZ	CURUP			;NO
	MOV	AX,701H			;ELSE, SCROLL DOWN
	MOV	CX,0
	MOV	DH,23
	MOV	DL,79
	MOV	BH,ATTRI
	INT	10H
	RET

;	CURSOR ADDRESSING

DOADR:	MOV	WORD PTR IBMJMP,OFFSET GETROW	;NEXT CHAR IS ROW
	RET
GETROW:	MOV	SAV_ROW,AL			;SAVE ROW
	MOV	WORD PTR IBMJMP,OFFSET GETCOL	;NEXT CHAR IS COLUMN
	RET
GETCOL:	MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	MOV	DH,SAV_ROW
	MOV	DL,AL				;AL = COLUMN
	SUB	DX,'  '			;CONVERT TO 0 BASE
SETCURS:MOV	AH,2
	MOV	BH,0
	INT	10H			;SET CURSOR POSITION CALL
	RET
;
CURUP:	MOV	AH,3			;CURSOR UP
	MOV	BH,0
	INT	10H			;GET CURRENT POS
CURUP1:	DEC	DH
	CMP	DH,0
	JAE	SETCURS
	INC	DH			;DON'T ALLOW TO GO OFF SCREEN
	JMP SHORT SETCURS
;
CURDWN:	MOV	AH,3			;CURSOR DOWN
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
CURDWN1:CMP	DH,24			;AT BOTTOM LINE?
	JZ	CURDWN2			;IF SO, NO SCROLL
	INC	DH
	CMP	DH,23
	JLE	SETCURS
CURDWN2:RET
;
TAB:	MOV	AH,3			;PROCESS TABS
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	ADD	DL,8
	AND	DL,0F8H			;MOV TO NEXT TAB STOP
	JMP SHORT CURRT1
;
CURRT:	MOV	AH,3			;CURSOR RIGHT
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	INC	DL
CURRT1:	CMP	DL,79
	JBE	SETCURS
	RET				;CURSOR IN LAST COLUMN
;
CURLFT:	MOV	AH,3			;CURSOR LEFT
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	DEC	DL
	CMP	DL,0
	JAE	SETCURS
	RET				;CURSOR IN FIRST COLUMN

HOME:	MOV	DX,0			;HOME CURSOR
	JMP	SETCURS
;
DOCLR:	MOV	AX,600H			;CLEAR SCREEN
	MOV	BH,ATTRI
	MOV	CX,0			;ERASE LINES 1-24,COLS 1-80
	MOV	DH,23
	MOV	DL,79
	INT	10H
	JMP SHORT HOME
;
ERSEOL:	MOV	AH,3			;ERASE TO END OF LINE
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	MOV	AX,600H
	MOV	BH,ATTRI
	MOV	CX,DX
	MOV	DL,79
	INT	10H
	RET
;
ERSEOS:	MOV	AH,3			;ERASE TO END OF SCREEN
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	MOV	AX,600H
	MOV	BH,ATTRI		;ERSEOL FIRST
	MOV	CX,DX
	MOV	DL,79
	PUSH	CX			;SAVE CURSOR POSITION
	INT	10H
	POP	CX
	MOV	DH,23
	MOV	DL,79
	CMP	CH,23
	JE 	ERS_RET
	INC	CH
	MOV	AX,600H
	MOV	BH,ATTRI
	INT	10H
ERS_RET:RET

ERSLIN:	MOV	AH,3			;ERASE LINE
	MOV	BH,0
	INT	10H			;GET CURRENT LOCATION
	MOV	CX,DX
	MOV	CL,0
	MOV	DL,79
	MOV	AX,0600H		;SCROLL REGION (SINGLE LINE) CLEAR
	MOV	BH,ATTRI
	INT	10H
	RET
;
SAVCRS:	MOV	AH,3			;SAVE CURSOR POSITION
	MOV	BH,0
	INT	10H
	MOV	CURSAV,DX
	RET
;
RSTCRS:	MOV	DX,CURSAV		;RESTORE CURSOR POSITION
	JMP	SETCURS
;
DOREV:	MOV	BYTE PTR ATTRI,HICODE 	;REV. VIDEO
	RET
;
DONRM:	MOV	BYTE PTR ATTRI,7	;NOR. VIDEO
	RET

RESMOD:	MOV	WORD PTR IBMJMP,OFFSET RESMOD1	; GET NEXT CHAR
	RET
RESMOD1:MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	; RESET JUMP
	CMP	AL,'5'			; RESTORE CURSOR?
	JZ	TCURON			; YES
	RET				; ELSE, IGNORE
TCURON:	MOV	AH,1
	MOV	CX,CURTYPE		; GET CURSOR TYPE
	INT	10H			; RESTORE CURSOR
	RET

SETMOD:	MOV	WORD PTR IBMJMP,OFFSET SETMOD1	; GET NEXT CHAR
	RET
SETMOD1:MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	; RESET JUMP
	CMP	AL,'5'			; KILL CURSOR?
	JZ	TCUROFF
	RET
TCUROFF:MOV	AH,1
	MOV	CX,2020H
	INT	10H			; TURN OFF CURSOR
	RET

IBMJMP	DW	IBMOUT1			;JUMP INTO CODE
GRAFLG	DB	0			;GRAPHICS MODE FLAG
ATTRI	DB	7  			;DEFAULT ATTRIBUTE (WHITE ON BLACK)
SAV_ROW	DB	0			;SAVED ROW POSITION
CURSAV	DW	0			;SAVED CURSOR POSITION
;
CODETABLE:				;ESC SEQUENCE PROCESSOR TABLE
	DB	'Y'
	DW	OFFSET DOADR
	DB	'E'
	DW	OFFSET DOCLR
	DB	'F'
	DW	OFFSET GRAFON
	DB	'G'
	DW	OFFSET GRAFOF
	DB	'J'
	DW	OFFSET ERSEOS
	DB	'K'
	DW	OFFSET ERSEOL
	DB	'A'
	DW	OFFSET CURUP
	DB	'B'
	DW	OFFSET CURDWN
	DB	'C'
	DW	OFFSET CURRT
	DB	'D'
	DW	OFFSET CURLFT
	DB	'H'
	DW	OFFSET HOME
	DB	'I'
	DW	OFFSET REVIND
	DB	'l'
	DW	ERSLIN
	DB	'p'
	DW	OFFSET DOREV
	DB	'q'
	DW	OFFSET DONRM
	DB	'j'
	DW	OFFSET SAVCRS
	DB	'k'
	DW	OFFSET RSTCRS
	DB	'x'
	DW	OFFSET SETMOD
	DB	'y'
	DW	OFFSET RESMOD
	DB	'z'
	DW	OFFSET IBMRST
	DB	0			;END OF TABLE
;
;      Z-100 to IBM PC graphic chr xlat table
;	only locs 5eh to 7eh are present    
;
IBMGRPH	LABEL	BYTE
	db	0f9h	; ^
	db	0dbh	; _
	db	0b3h	; `
	db	0c4h	; a
	db	0c5h	; b
	db	0bfh	; c
	db	0d9h	; d
	db	0c0h	; e
	db	0dah	; f
	db	0f1h	; g
	db	01ah	; h
	db	0b0h	; i
	db	0f6h	; j
	db	019h	; k
	db	0dah	; l
	db	0bfh	; m
	db	0d9h	; n
	db	0c0h	; o
	db	0dfh	; p
	db	0deh	; q
	db	0dbh	; r
	db	0c2h	; s
	db	0b4h	; t
	db	0c1h	; u
	db	0c3h	; v
	db	058h	; w
	db	02fh	; x
	db	05ch	; y
	db	0dfh	; z
	db	0dch	; {
	db	0ddh	; |
	db	0deh	; }
	db	014h	; ~
	db	0dbh	; del

SETCON	ENDS
	END	START
                                                                                    