	Title	Menu Create Program
	Page	,132
;
;	Menu Create Program
;
;	Author: R. A. Metz		Date: 10/10/83
;
;	MODIFIED BY P. SWAYNE, HUG  07-NOV-84  04-FEB-85
;		EASY SCREEN DISPLAY SETUP, USING | AND -
;		DOUBLE COLUNM MENUES SUPPORTED
;		IBM GRAPHIC CHARACTERS USED IN OUTPUT FILE, NOT ZENITH
;		ALLOWS LEADING SPACES AND BLANK LINES IN DEF. FILE
;		COMPUTER TYPE DETERMINATION LEFT UP TO MENU PROGRAM
;		USES MS-DOS 2 FILE I/O COMMANDS
;
;	This program reads a menu definition file and creates a
;	menu display file.  Invocation is as follows:
;
;	A:MNUCREAT <def file> <display file>
;
;	Where: <def file> is the name of the definition file and
;	<display file> is the name of the resulting display file.
;
;	The definition file is created using an ordinary text editor,
;	using the supplied file MENU.RAW as a guide.
;
;	The resulting display file has the following format:
;
;	The first 128 bytes contain header info as follows:
;
;		Byte 0   - RESERVED
;		     1   - Number of menu items (maximum of 21) 
;		   
;	     Up to 21 6-byte fields as follows:
;
;		Byte 0,1  - Offset to display line
;			Format of display line:
;				Byte 0,1 - Line, Col address of display
;				Bytes 2-(n-1) - display info
;				Byte n   -  Null terminator
;		Byte 2,3  -  Offset to command info
;			Format of command info:
;				Byte 0  -  Command type code (0,1,2,3,4,5)
;				Bytes 1-(n-1) - default disk/dir string
;				Byte n  -  Null terminator
;				Bytes (n+1)-(m-1) - command string
;				Byte m - null terminator
;		Byte 4,5  -  Offset to Help info
;			Format of help info:
;				Bytes 0-(n-1) - Help text
;				Byte n  -  Null terminator
;
;	This program will run only under MS-DOS 2.0 or better.
;
	subttl	code section
	page
makmenu	segment
	assume	cs:makmenu,ds:makmenu,ss:makmenu,es:makmenu
include macros.asm
	org	5ch
fcb1 	label	byte
	org	6ch
fcb2	label	byte
	org	80h
inbuf	label	byte
	org	100h

;	MAIN PROGRAM
;	CHECK VERSION NO., USER ENTRY

start:	get_ver
	cmp	al,2
	jae	vers_ok
	display	err17			; improper DOS version
	int	20h
vers_ok:
;	CMP	FCB1,' '		; CHECK FOR FILE NAME
;	JZ	FILERR			; NONE
;	CMP	FCB2,' '
;	JZ	FILERR
	CLD
	MOV	SI,OFFSET INBUF
	LODSB				; GET CHAR COUNT
	MOV	CL,AL
	XOR	CH,CH			; CX = CHAR COUNT
	MOV	DI,SI
	MOV	AL,' '
	REPZ	SCASB			; LOOK FOR NON-SPACE
	JZ	FILERR			; NOT FOUND
	PUSH	DI			; SAVE NAME START
	REPNZ	SCASB			; LOOK FOR NEXT SPACE
	JNZ	FILERR			; NOT FOUND
	MOV	BYTE PTR -1[DI],0	; REPLACE WITH NULL
	REPZ	SCASB			; LOOK FOR NON-SPACE
	JZ	FILERR			; NOT FOUND
	PUSH	CX			; SAVE COUNT HERE
	MOV	SI,DI
	REP	LODSB			; MOVE TO END
	MOV	BYTE PTR [SI],0		; ADD A NULL
	DEC	DI
	MOV	SI,DI
	MOV	DI,OFFSET OUTFN		; SAVE OUTPUT FILE NAME HERE
	POP	CX			; GET COUNT OF CHARS TO MOVE
	INC	CX
	INC	CX			; INCLUDE NULL
	REP	MOVSB			; MOVE IT

;	OPEN INPUT FILE

	POP	DX
	DEC	DX			; DX POINTS TO FILE NAME
	XOR	AL,AL
	SVC	3DH			; OPEN INPUT FILE
	JNC	REDMNU			; NO ERROR
	display	err1
	sys_term 0
filerr:
	display err14
	sys_term 0
;
;	READ AND PROCESS INPUT FILE
;	FIRST, CHECK FOR VALID FILE

redmnu:					; read menu image
	MOV	INHAND,AX		; SAVE INPUT HANDLE NO.
REDMN1:
	call	getlin			; read a line from input file
	CALL	FFC			; GET FIRST CHARACTER
	CMP	AL,0DH			; NULL LINE?
	JZ	REDMN1			; IF SO, SKIP IT
	DEC	SI			; POINT TO IT
	mov	di,offset filflg
	mov	cx,6
	rep	cmpsb			; verify file as menu definition file
	je	goodfil
	display err3       		; file must have proper header
	sys_term 0

;	FILE IS OK, GET MENU DISPLAY

goodfil:mov	di,offset obuf+128
	mov	cx,24			; 24 lines maximum
linlp1:
	push 	cx
	call	getlin
	mov	cx,word ptr buf
	mov	si,offset buf+2
collp1:
	lodsb
	cmp	al,"\"			; "\" terminates image
	jne	cpychr
	mov	al,0
	stosb				; nul terminator
	jmp	short finimg
cpychr: 
	CMP	AL,'*'			; CORNER?
	JNZ	NOTCRN			; NO
	MOV	AL,BYTE PTR CRNCNT	; ELSE, GET CORNER COUNTER
	INC	AL			; ADD ONE
	CMP	AL,5			; ALL CORNERS USED?
	JNZ	NACRN			; NO
	MOV	AL,1			; ELSE, START OVER
NACRN:	MOV	BYTE PTR CRNCNT,AL	; SAVE CORNER COUNT
	DEC	AL			; START WITH 0
	MOV	BX,OFFSET CRNTBL	; GET CORNER TABLE
	XLAT				; TRANSLATE TO PROPER CHARACTER
	JMP	SHORT STOCHR		; AND STORE IT
NOTCRN:	CMP	AL,'|'			; WALL?
	JNZ	NOTWALL			; NO
	CALL	GETWALL			; ELSE, GET WALL CHARACTER
	JMP	SHORT STOCHR		; AND STORE IT
NOTWALL:CMP	AL,'-'			; SHELF?
	JNZ	STOCHR			; NO
	MOV	AL,0C4H			; ELSE, GET SHELF CHARACTER
STOCHR:	stosb				; copy to output buffer
	loop	collp1
	pop	cx
	loop	linlp1			; next line
	display err4       		; should not arrive here
	sys_term 0

;	GET SCREEN MENU ITEMS

finimg:	pop	cx			; fix stack
	mov	si,offset obuf+128	; POINT TO PLACE IN OUTPUT BUFFER
	mov	bx,offset ITABUF	; AND COLUMN ADDRESS BUFFER
	mov	row," "
	mov	col," "-1
scnlp:					; scan image for fields
	mov	al,[si]
	inc	col
	cmp	al,0			; null terminates image
	je	INSADR			; DONE, INSERT ITEM ADDRESSES
	cmp	al,"!"			; "!" is field delimiter
	je  	gotfld
	inc	si
	cmp	al,lf			; inc row on lf
	jne	scnlp
	inc	row
	mov	col," "-1
	MOV	BYTE PTR DCFLG,0	; RESET DOUBLE COLUMN FLAG
	jmp	scnlp
gotfld:
	INC	BYTE PTR DCFLG		; COUNT ENTRY ON LINE
	mov	al," "			; replace "!" w/ space 
	mov	[si],al
	inc	si
	sub	di,offset obuf
	CMP	BYTE PTR DCFLG,1	; IN FIRST COLUMN?
	JNZ	COL2			; NO
	MOV	[BX],DI			; ELSE, PUT ADDRESS HERE
	JMP	SHORT COL1
COL2:	DEC	BX			; REMOVE EXTRA POINTER INCREMENT
	DEC	BX
	MOV	44[BX],DI		; PUT 2ND COL. ADDRESS HERE
COL1:	add	di,offset obuf
	mov	al,row
	stosb
	mov	al,col			; row/col to output
	inc	al			;  (field is 1 byte beyond "!")
	stosb
fldcpy:
	lodsb
	inc	col
	cmp	al,0			; if null  -  error
	jne	ckeof
	display err5
	sys_term 0
ckeof:
	cmp	al,"!"
	je	goteof
	stosb
	jmp	fldcpy
goteof:
	dec	si
	mov	byte ptr [si]," "	; replace "!" w/ space
	inc	si   
	mov	al,0
	stosb				; terminate field
	INC	BX			; INCREMENT ITEM ADDR POINTER
	INC	BX
	inc	byte ptr itemcnt	; increment # of items
	jmp	scnlp

;	INSERT ITEM ADDRESSES INTO HEADER

INSADR:	MOV	SI,OFFSET ITABUF	; POINT TO STORED ADDRESSES
	MOV	BX,OFFSET ITEM		; AND WHERE THEY GO
COL1LP:	LODSW				; GET AN ADDRESS
	OR	AX,AX			; DONE?
	JZ	COL1DN			; YES
	MOV	[BX].DISLIN,AX		; ELSE, INSERT ADDRESS INTO BUFFER
	ADD	BX,SIZE ITEM		; UPDATE POINTER
	JMP	SHORT COL1LP		; GET ANOTHER ADDRESS
COL1DN:	MOV	SI,OFFSET ITABUF2	; POINT TO SECOND COLUMN ITEMS
	MOV	CX,21			; SET A COUNTER
COL2LP:	LODSW				; GET AN ADDRESS
	OR	AX,AX			; NO ENTRY HERE?
	JZ	SKIPIT			; IF SO, SKIP
	MOV	[BX].DISLIN,AX		; ELSE, INSERT ADDRESS
	ADD	BX,SIZE ITEM		; UPDATE POINTER
SKIPIT:	LOOP	COL2LP			; LOOP UNTIL DONE
;
getcmds:
	cmp	byte ptr itemcnt,21	; ensure not too many fields
	jbe	entsok
	display err9
	sys_term 0
entsok:

;	now read command lines

	mov	bx,offset item
	mov	cl,itemcnt
	mov	ch,0			; itemcnt of them
cmdlp:
	push	cx
CMDLP1:	call	getlin
	CALL	FFC			; FIND FIRST CHARACTER
	CMP	AL,0DH			; NULL LINE?
	JZ	CMDLP1
	cmp	al,"0"			; verify type code
	jb	cmderr
	cmp	al,"5"
	ja	cmderr
	sub	di,offset obuf
	mov	[bx].cmdlin,di
	add	di,offset obuf
	stosb
	mov	dl,al			; save code
	INC	SI			; SKIP OVER SPACE
	dec 	cx			; DECREMENT CHAR COUNT
	dec	cx
cpydflt:
	lodsb
	cmp	al,"!"	
	je	enddflt
	stosb
	loop	cpydflt
diserr6:
	mov	dx,offset err6
dis_err:
	svc	9
	sys_term 0
cmderr:
	mov	dx,offset err11
	jmp	dis_err
enddflt:
	mov	al,0
	stosb
	cmp	byte ptr [si],0
	je	cpycmd
	cmp	byte ptr 1[si],':'	; check for drive specifier
	je	tsttyp1
	cmp	dl,'4'			; no drive specified - type 4?
	jne	cpycmd			;  no - ok
	mov	dx,offset err16		;  yes - type 4 must have drive
	jmp	dis_err
tsttyp1:
	cmp	dl,'1'			; drive specified - type 1?
	jne	cpycmd			;  no - ok
	mov	dx,offset err15		;  yes - type 1 cannot have drive
	jmp	dis_err
cpycmd:
	lodsb
	cmp	al,"!"
	je	endcmd
	stosb
	loop	cpycmd
	jmp	diserr6
endcmd:
	mov	al,0dh			; cr at end of cmd
	stosb
	mov	al,0			; null terminates entry
	stosb
	add	bx,size item
	pop	cx
	loop	cmdlp

;	GET HELP INFORMATION

GHELP:	call	getlin	 		; now read nxt line
	CALL	FFC			; GET FIRST CHARACTER
	CMP	AL,0DH			; NULL LINE?
	JZ	GHELP			; YES, SKIP IT
	cmp	AL,"\"			; must begin 1st help info packet
	je	dohelp
	display	err7
	sys_term 0
dohelp:					; read help info
	mov	bx,offset item
	mov	cl,itemcnt
	mov	ch,0			; must be itemcnt packets
hlplp:
	push	cx
	sub 	di,offset obuf
	mov	[bx].hlpinfo,di
	add	di,offset obuf
	mov	lincnt,0
cpyhlplin:
	call	getlin
	CALL	FFC			; GET FIRST CHARACTER
	cmp	AL,"\"
	je	endhlp
	inc	lincnt
	mov	cx,word ptr buf		; use full count
	mov	si,offset buf+2
	rep	movsb
	jmp	cpyhlplin
endhlp:
	cmp	lincnt,22		; verify number of lines
	jbe	hlpok
	display err13
	sys_term 0
hlpok:
	mov	al,0
	stosb				; null terminator
	add	bx,size item
	pop	cx 	
	loop	hlplp

;	now write output file

	MOV	DX,OFFSET OUTFN		; POINT TO OUTPUT FILE NAME
	XOR	CX,CX			; NO ATTRIBUTES
	SVC	3CH			; CREATE OUTPUT FILE
	JNC	OUTFILOP
	display err2			; error
	sys_term 0
OUTFILOP:
	MOV	BX,AX			; BX = OUTPUT HANDLE
	sub	di,offset obuf
	MOV	CX,DI			; CX = BYTES TO WRITE
	MOV	DX,OFFSET OBUF
	SVC	40H			; WRITE OUTPUT FILE
	JNC	wrtok
outfilerr:
	display err8
	sys_term 0
wrtok:
	SVC	3EH			; CLOSE OUTPUT FILE
	JC	outfilerr
	MOV	BX,INHAND
	SVC	3EH			; CLOSE INPUT FILE
	display cmpltmsg
	sys_term 0
;
	subttl	Subroutines
	page
;	GET A LINE FROM THE INPUT FILE

getlin	proc	near			; get a line from input file
	push	si
	push	di
	push	ax			; save all regs
	push	bx
	push	cx
	push	dx
readlin:
	mov	word ptr buf,0		; new line
	mov	di,offset buf+2
	mov	bx,inptr
getbyt:
	cmp	bx,80h
	jne	getnxtbyt
	MOV	BX,INHAND
	MOV	DX,OFFSET INBUF
	MOV	CX,128
	SVC	3FH			; READ FROM INPUT FILE
	JNC	readok
	CMP	AX,0			; DONE?
	JNZ	READOK
RDERR:	display err10
	sys_term 0
readok:
	mov	bx,0   
getnxtbyt:
	mov	al,inbuf[bx]
	inc	bx
	AND	AL,7FH			; STRIP PARITY (ALLOW WORDSTAR)
	stosb    
	inc	word ptr buf
	cmp	al,lf			; lf?
	jne	getbyt
	mov	inptr,bx
	CALL	FFC			; FIND FIRST CHARACTER
	CMP	AL,";"			; COMMENT LINE?
	je	readlin			; read another line if so
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	di
	pop	si 
	ret				; return good line
getlin	endp

;	FIND FIRST PRINTABLE CHARACTER IN BUF
;	RETURNS SI POINTED TO NEXT CHAR, CX = MODIFIED COUNT

FFC	PROC	NEAR
	MOV	SI,OFFSET BUF+2		; POINT TO FIRST CHAR IN BUF
	MOV	CX,WORD PTR BUF		; GET COUNT
FFC1:	LODSB				; GET IT
	CMP	AL,1AH			; EOF?
	JZ	RDERR			; SHOULDN'T SEE ONE
	CMP	AL,0DH			; NULL LINE?
	JZ	GOTLIN			; ALLOW IT
	CMP	AL,' '			; NON PRINTING CHARACTER?
	JG	GOTLIN			; YES, WE HAVE IT
	DEC	CX			; ELSE, BACK UP COUNT
	JMP	SHORT FFC1		; AND TRY AGAIN
GOTLIN:	RET
FFC	ENDP

;	GET WALL CHARACTER

GETWALL	PROC	NEAR
	MOV	AL,BYTE PTR CRNCNT	; GET CORNER COUNTER
	DEC	AL			; TOP SHELF?
	JZ	TPSHF			; YES
	DEC	AL			; MIDDLE SHELF?
	JZ	MDSHF			; YES
	MOV	AL,0C1H			; ELSE, MUST BE BOTTOM SHELF
GETWX:	RET
TPSHF:	MOV	AL,0C2H			; TOP SHELF CHARACTER
	RET
MDSHF:	MOV	AL,0			; GET A ZERO
	CMP	BYTE PTR -2[SI],'-'	; PREVIOUS CHAR SHELF?
	JNZ	NOTPVC			; NO
	OR	AL,10B			; ELSE, MARK SHELF THERE
NOTPVC:	CMP	BYTE PTR [SI],'-'	; NEXT CHAR SHELF?
	JNZ	NOTNXC			; NO
	OR	AL,1			; ELSE, MARK IT
NOTNXC:	MOV	BX,OFFSET WALTBL	; POINT TO WALL CHAR TABLE
	XLAT				; GET PROPER CHARACTER
	RET
GETWALL	ENDP

	subttl Data definitions
	page
inptr	dw	80h			; input file pointer
row	db	0			; current row
col	db	0			; current column
DCFLG	DB	0			; DOUBLE COLUMN FLAG
lincnt	db	0			; line counter - help info
filflg	db	'$$MENU'		; menu file header
CRNCNT	DB	0			; CORNER COUNTER
CRNTBL	DB	0DAH,0BFH,0C0H,0D9H	; TABLE OF CORNER CHARACTERS
WALTBL	DB	0B3H,0C3H,0B4H,0C5H	; TABLE OF WALL WALL CHARACTERS
buf	db	128 dup (0)		; line buffer
;
ent	struc				; item entry structure
dislin	dw	0			; offset of display line
cmdlin	dw	0			; offset of command lin
hlpinfo	dw	0			; offset of help info
ent	ends
;
	subttl	messages
	page
cr	equ	0dh
lf	equ	0ah
IDSTR	DB	27,'Z',13,'  ',13,'$'
err1	db	cr,lf,"Can't open input file.",cr,lf,"$"
err2	db	cr,lf,"No room for output file",cr,lf,"$"
err3	db	cr,lf,"Input file not a menu definition file.",cr,lf,"$"
err4	db	cr,lf,"Too many lines in menu image.",cr,lf,"$"
err5	db	cr,lf,'Unpaired "!" in menu image.',cr,lf,"$"
err6	db	cr,lf,'"!" terminator error on command line',cr,lf,"$"
err7	db	cr,lf,'"\" expected in definition file.',cr,lf,"$"
err8	db	cr,lf,"Output file I/O error.",cr,lf,"$"
err9	db	cr,lf,"Too many fields (21 maximum).",cr,lf,"$"
err10	db	cr,lf,"Past end-of-file on input (file incomplete).",cr,lf,"$"
err11	db	cr,lf,"Invalid command type code.",cr,lf,"$"
err13	db	cr,lf,"Too many lines in help packet (max=22).",cr,lf,"$"
err14	db	cr,lf,"Must specify 2 parameters on entry.",cr,lf,"$"
err15	db	cr,lf,"Command type 1 must not contain drive specifier."
	db	cr,lf,"$"
err16	db	cr,lf,"Command type 4 must contain drive specifier."
	db	cr,lf,"$"
err17	db	cr,lf,"Bad DOS version - must be 2.0 or better.",cr,lf,"$"
cmpltmsg	db	cr,lf
		db	"Menu file creation complete."
		db	cr,lf,"$"
	subttl 	output buffer definition
	page
INHAND	DW	0			; INPUT FILE HANDLE
OUTFN	DB	80 DUP (0)		; OUTPUT FILE NAME
ITABUF	DW	22 DUP (0)		; ITEM ADDRESS BUFFER
ITABUF2	DW	22 DUP (0)		; SECOND COLUMN ADDRESSES
obuf	label	byte
RESBYT	db	"M"			; RESERVED BYTE
itemcnt	db	0			; # menu items
item	ent	<,,>			; define item entry
	db	128 dup (0)		; clear out rest of header
;
makmenu	ends				; buffer continues on past code section
	end	start
                                      