	title	HUG File Manager
	page	,132
;
;	HUG File Manager for MS-DOS 2.0 (formerly FILEMGMT)
;
;			Z-100/Z-150 version
;
;	Author: R. A. Metz		Date: 11/22/83
;
;	MODIFIED BY P. SWAYNE, HUG  19-DEC-84  01-FEB-85
;		WORKS ON Z-150 OR Z-100.
;		N COMMAND DOES NOT PROMPT FOR DIRECTORY NAME IF THERE
;			ARE NO SUB DIRECTORIES.
;		HELP SCREENS RE-WRITTEN.
;		ENTIRE DIRECTORY LOADED AT START OR "N" COMMAND FOR
;			RAPID DISPLAY AFTER COMMANDS THAT CLEAR SCREEN
;		DIRECTORY SORT ADDED (SHELL-METZNER)
;		SORT AND UNSORT COMMANDS ADDED
;		FILE FLAGGING ADDED, FOR MULTIPLE COPY AND DELETE
;		SIZE OF CURRENT FILE, AND FREE DISK SPACE SHOWN
;		DIRECTORY COMMAND ADDED -- ALLOWS MAKING OR REMOVING
;			DIRECTORIES
;		WILDCARD COMMAND ADDED TO SPECIFY FILES DISPLAYED
;		TYPE COMMAND DOES NOT USE COMMAND.COM, PAUSES FOR
;			FULL SCREEN
;		FLAG COMMAND CAN REMOVE OR ADD FLAG
;		CONTROL-C EXIT SET UP FOR CHILD PROCESS
;		SHOWS DISK LABEL AND TOTAL BYTES OF FLAGGED FILES
;		LABEL CHANGE COMMAND ADDED
;
;	NOTE:  GENERALLY, ORIGINAL CODE BY R. METZ IS IN lower case,
;	AND NEW CODE BY P. SWAYNE IS IN UPPER CASE.
;
;	This program operates in a manner similar to the Microsoft
;	Multiplan spreadsheet program in that a command line is
;	displayed at the bottom of the screen.  Operation of that 
;	command line parallels that of Multiplan's command 
;	line.  The main screen area is used for directory
;	display and display of requested file data.
;	Full support exists for MS-DOS 2.0 tree-structured
;	directories.
;
;	This program utilizes the escape sequences as processed
;	by the Z-100 for control of the screen.  In order for this
;	program to operate on an IBM PC or Zenith Z-150, a Z-100
;	emulator such as that provided in IBMZ100.COM must be active.
;
;
;	Commands currently implemented are:
;
;	Copy	Copy selected file.  The user is prompted to
;		enter the name of the destination file/device.
;		COMMAND.COM is used to execute its 'COPY' command.
;	Direct.	Directory Maintenance.  The user is prompted to
;		select Make or Remove, and then is asked for the
;		name of a directory to make or remove.
;	Erase	Erase file.  The user is asked for confirmation
;		before actually erasing the selected file.
;	Flag	Mark file with a flag.  If Copy or Delete are then
;		used, the marked files will be acted upon, instead
;		of the highlighted file.
;	Help	Use of this utility is explained.
;	Listhex	The selected file is displayed in Hex and ASCII.
;		The sub-utility program 'HEXLIST' performs this task.
;	Moredir	If there are more files than fit on the screen, this
;		command will show the next screen.  If used while the
;		last screen of files are showing, the first files are
;		re-displayed.
;	Newdisk	The user is prompted for a disk id to become the
;		new default.  When entered, a list of the sub-directory
;		files in the current directory of that disk is displayed
;		and the user is prompted to enter the name of a sub-
;		directory to become the new current directory.  A
;		carriage return response will cause retention of the
;		current disk/directory.  A new directory display is
;		then presented.
;	Print	The PRINT utility program is invoked to place the
;		selected file on the MS-DOS print spool.
;	Quit	Quit this program.
;	Rename	Rename file.  The user is prompted for a new
;		file name and the selected file is renamed.
;	Sort	The directory is sorted alphabetically and displayed
;		in that form.  This is the normal condition at startup.
;	Type	The selected file is displayed on the screen.
;		COMMAND.COM is used to execute its 'TYPE' command.
;	Unsort	The directory is unsorted and the files are displayed
;		in their natural order.
;	Wildcrd.Wildcard Specification.  The user is prompted for a
;		wildcard specification that determines which files
;		are shown on the screen.
;
;	Note:  For proper operation of Listhex and Print commands, the
;	utility programs 'PRINT.COM' and 'HEXLIST.COM' must be present
;	in the current 'PATH' directory.  Also, COMMAND.COM must be present
;	in the directory indicated in the 'COMSPEC' parameter in the 
;	environment of this program.
;
;
	page
HICODE	EQU	0FH			; HIGHLIGHTING CODE WHEN USED ON
;					; A Z-150.  USE 0FH FOR INTENSE WHITE,
;					; OR 70H FOR REVERSE VIDEO.
include macros.asm
	prog_header filemgmt
	mov	sp,offset BA.stack
	push	ax
	jmp	begin
;
spsave	dw	0
cur_cmd	dw	4
cur_ent	dw	0
max_ent	dw	0
FILECNT	DW	0			; FILE COUNT
PAGECNT	DW	0			; PAGE FILE COUNT
CURTYPE	DW	0			; CURSOR TYPE (Z-150)
DISTYPE	DB	0			; DISPLAY TYPE (Z-150)
TTYPE	DB	1			; TERMINAL TYPE (Z-100 OR Z-150)
MOREFLG	DB	0			; MORE FILES FLAG
VARI	DW	0			; SORT VARIABLES
VARJ	DW	0
VARK	DW	0
VARL	DW	0
VARM	DW	0
SORTFLG	DB	1			; SORT FLAG
FLAGCNT	DB	0			; COUNT OF FILES FLAGGED
FLG2FLG	DB	0			; FILES FLAGGED INDICATOR
TFCNT	DW	0			; TEMP. FILE COUNT
CUR_ADR	DW	0			; CURRENT FILE ADDRESS
FREE_L	DW	0			; DISK FREE SPACE LOW
FREE_H	DW	0			; DISK FREE SPACE HIGH
FLAG_L	DW	0			; FLAGGED FILE BYTES LOW
FLAG_H	DW	0			; FLAGGED FILE BYTES HIGH
LINECNT	DB	0			; LINE COUNT FOR TYPE
LABFLAG	DB	0			; DISK LABEL FLAG
cur_disk	db	'A'
cur_dir	db	64 dup (0)
DLFCB	DB	0FFH,0,0,0,0,0,8	; DISK LABEL FCB
DLFCBDR	DB	0
DLFCBN	DB	'???????????',0,0,0,0
	DB	17 DUP (0)
DLFCBX:
;
cmd_line_tbl	label	word
	dw	offset ccmd
	dw	offset dcmd
	dw 	offset ecmd
	DW	OFFSET FCMD
	dw	offset hcmd
	DW	OFFSET ICMD
	dw	offset lcmd
	DW	OFFSET MCMD
	dw	offset ncmd
	dw	offset pcmd
	DW	OFFSET QCMD
	dw	offset rcmd
	DW	OFFSET SCMD
	dw	offset tcmd
	DW	OFFSET UCMD
	DW	OFFSET WCMD
;
ncmds	equ	16
max_cmd	equ	15
;
ccmd	label	byte
	addr	23,10
    	db	'Copy$'
dcmd	label	byte
	addr	23,15
    	db	'Directory$'
ecmd	label	byte
	addr	23,25
    	db	'Erase$'
FCMD	LABEL	BYTE
	ADDR	23,31
	DB	'Flag$'
hcmd	label	byte
	addr	23,36
	db	'Help$'
ICMD	LABEL	BYTE
	ADDR	23,41
	DB	'ID$'
lcmd	label	byte
	addr	23,44
    	db	'Listhex$'
MCMD	LABEL	BYTE
	ADDR	23,52
	DB	'Morefiles$'
ncmd	label	byte
	addr	23,62
    	db	'Newdisk$'
pcmd	label	byte
	addr	24,10
    	db	'Print$'
QCMD	LABEL	BYTE
	ADDR	24,16
	DB	'Quit$'
rcmd	label	byte
	addr	24,21
    	db	'Rename$'
SCMD	LABEL	BYTE
	ADDR	24,28
	DB	'Sort$'
tcmd	label	byte
	addr	24,33
    	db	'Type$'
UCMD	LABEL	BYTE
	ADDR	24,38
	DB	'Unsort$'
WCMD	LABEL	BYTE
	ADDR	24,45
	DB	'Wildcard$'
;
;	messages
;
cr	equ	0dh
lf	equ	0ah
esc	equ	1bh
;
badversion	db	cr,lf
		db	'Incorrect DOS version.$'
;
IDMSG		DB	27,'Z',13,'  ',13,'$'	; VT-52 IDENTIFY
;
init_msg	db	esc,'E'		; clear screen
		db	esc,'x1'	; enable 25th line
		db	'$'
;
rev_msg	db	esc,'p$'
nrm_msg	db	esc,'q$'
;
FLG_MSG	DB	8,'*$'
;
xit_msg:
	addr	25,1
	db	esc,'K'
	addr	1,1
	db	esc,'E'
CUR_ON:
	db	esc,'y5'
	db	'$'
;
init_prompt	label	byte
		ADDR	24,1
		DB	ESC,'K'
		addr	23,1
		db	esc,'K'
		db	esc,'y5'
		db	'$'
;
init_cmd_line	label	byte
		ADDR	24,1
		DB	ESC,'K'
		addr	23,1
		db	esc,'K'
		db	esc,'x5'
		db	'Command: '
		db	'$'
;
dir_hdr		label	byte
		addr	1,1
		db	ESC,'pHUG File Manager',ESC,'q'
		DB	' Version 1.0'
		addr	3,1
		db	'Contents of Directory $'

LAB_MSG		LABEL	BYTE
		ADDR	1,44
		DB	'Disk label: '
DISKLAB		DB	'           $'
NONE		DB	'(none)     '

FSPC_MSG	LABEL	BYTE
		ADDR	2,44
		DB	'Flagged file bytes:           '
		ADDR	2,64
		DB	'$'

FREE_MSG	LABEL	BYTE
		ADDR	25,59
		DB	'Free space:           '
		ADDR	25,71
		DB	'$'

SIZ_MSG		LABEL	BYTE
		ADDR	25,38
		DB	'File size:        '
		ADDR	25,49
		DB	'$'

MORE_DIR	LABEL	BYTE
		ADDR	21,71
		DB	'MORE'
		ADDR	22,71
		DB	'FILES..$'
;
subdir_hdr	label	byte
		addr	1,1
		db	ESC,'pHUG File Manager',ESC,'q'
		DB	' Version 1.0'
		addr	3,1
		db	'Subdirectories in Directory $'
;
sel_disp	label	byte
		DB	ESC,'x1'
		addr	25,1
		db	'Current selection:             '
		ADDR	25,20
		DB	'$'
;
no_fil_msg	label	byte
		addr	6,1
		db	'No files in directory!!$'
;
no_subfil_msg	label	byte
		db	7,'$'
;
del_err_msg	label	byte
		ADDR	24,1
		DB	ESC,'K'
		addr	23,1
		db	esc,'K'
		db	'Sorry - cannot erase file $'
;
ren_err_msg	label	byte
		ADDR	24,1
		DB	ESC,'K'
		addr	23,1
		db	esc,'K'
		db	'File rename error!$'
;
prog_err_msg	label	byte
		ADDR	24,1
		DB	ESC,'K'
		addr	23,1
		db	esc,'K'
		db	'Program load error!$'
;
dir_err_msg	label	byte
		ADDR	24,1
		DB	ESC,'K'
		addr	23,1
		db	esc,'K'
		db	'Directory file error - directory not changed!$'
;
file_err_msg	label	byte
		ADDR	24,1
		DB	ESC,'K'
		addr	23,1
		db	esc,'K'
		db	'Error - no file selected!$'
;
dest_file_req	label	byte
		db	'Enter destination file pathname: $'
;
confirm_req	label	byte
		db	'OK to erase current file (Y/N)? $'
;
CONFIRM_REQ1	LABEL	BYTE
		DB	'OK to erase flagged file(s) (Y/N)? $'
;
DIR_TYPE_REQ	LABEL	BYTE
		DB	'Do you want to Make or Remove '
		DB	'a directory (M/R)? $'
;
DIR_NAM_REQ	LABEL	BYTE
		DB	'Enter directory name: $'
;
NEW_ID_REQ	LABEL	BYTE
		DB	'Enter new disk label: $'
;
new_name_req	label	byte
		db	'Enter new file name: $'
;
new_disk_req	label	byte
		db	'New default drive: $'
;
new_dir_req	label	byte
		ADDR	24,1
		DB	ESC,'K'
		addr	23,1
		db	'New current directory: $'
;
WILD_CARD_REQ	LABEL	BYTE
		DB	'Enter wildcard specification: $'
;
clr_screen	label byte
		addr	1,1
		db	esc,'E'		; erase all
		addr	25,1
		db	esc,'K'		; ERASE 25TH LINE
		addr	1,1
		db	'$'
;
hlp_vct		dw	chlp
		dw	dhlp
		dw	ehlp
		DW	FHLP
		dw	hhlp
		DW	IHLP
		dw	lhlp
		DW	MHLP
		dw	nhlp
		dw	phlp
		DW	QHLP
		dw	rhlp
		DW	SHLP
		dw	thlp
		DW	UHLP
		DW	WHLP
;
;	help message text
;
CHLP	DB 9,'Copy File',CR,LF,LF
 DB 9,'When you are prompted for a destination file  pathname,  type  in',CR,LF
 DB 9,'a normal MS-DOS destination  (drive designation  and/or directory',CR,LF
 DB 9,'path and/or filename).   The selected file will then be copied to',CR,LF
 DB 9,'the specified destination.  If any files have been Flagged, those',CR,LF
 DB 9,'files  will  be  copied  instead of the currently selected (high-',CR,LF
 DB 9,'lighted) file.$'

DHLP	DB 9,'Directory Maintenance',CR,LF,LF
 DB 9,'After you select this command, you will be asked to type M if you',CR,LF
 DB 9,'want to make a new directory,  or R if you want to remove  an old',CR,LF
 DB 9,'one.   Then  you  will be prompted for the name of the directory,',CR,LF
 DB 9,'and HFM will add it to or remove it from the current directory or',CR,LF
 DB 9,'specified path.$'

EHLP	DB 9,'Erase File',CR,LF,LF
 DB 9,'You will be asked for  confirmation  to erase the selected (high-',CR,LF
 DB 9,'lighted) or Flagged file(s).  If you type Y, the selected file(s)',CR,LF
 DB 9,'will be erased.$'

FHLP	DB 9,'Flag File',CR,LF,LF
 DB 9,'The selected file is marked with a flag.  An asterisk (*) is dis-',CR,LF
 DB 9,'played on the screen before the file name to  indicate  that  the',CR,LF
 DB 9,'file has been flagged.   After you have used this command to mark',CR,LF
 DB 9,'file(s),  the Copy and Erase  commands will operate on the marked',CR,LF
 DB 9,'file(s) instead of the currently selected (highlighted) file.  If',CR,LF
 DB 9,'the selected file already has a flag set when you use  this  com-',CR,LF
 DB 9,'mand,  it will be removed.   The  file sizes of all flagged files',CR,LF
 DB 9,'are added together and displayed at the top of the screen.',CR,LF,LF
 DB 9,'To  remove the flags from all flagged files at once,  use the Un-',CR,LF
 DB 9,'sort command,  followed  by the Sort command if you want the dir-',CR,LF
 DB 9,'ectory sorted.$'

HHLP	DB 9,'HUG File Manager',CR,LF,LF
 DB 9,'The HUG File Manager supports the following operations: copy, re-',CR,LF
 DB 9,'name,  erase,  type (on the screen),  list in hex,  print,  label',CR,LF
 DB 9,'disks,  change  the default disk or directory,  create or  remove',CR,LF
 DB 9,'directories,  sort or unsort the directory display,  and  specify',CR,LF
 DB 9,'the displayed directory via wildcards.   HFM displays the default',CR,LF
 DB 9,'directory  from the default disk on the screen,  with one of  the',CR,LF
 DB 9,'entries  highlighted.  The  indicator (highlighted entry) may  be',CR,LF
 DB 9,'moved using the four arrow keys on the keyboard.   If the indica-',CR,LF
 DB 9,'tor  is at the last entry in a column,  the down arrow  key  will',CR,LF
 DB 9,'move  it to the top of the next column.   If the indicator is  at',CR,LF
 DB 9,'the  last entry on the page,  the down arrow will move it to  the',CR,LF
 DB 9,'first  entry.   The up arrow key works similarly.   The HOME  key',CR,LF
 DB 9,'moves the indicator directly to the first entry.',CR,LF,LF
 DB 9,'Near the bottom of the screen is a command line containing a list',CR,LF
 DB 9,'of  available  commands, with one of them highlighted.  A command',CR,LF
 DB 9,'may selected by typing the first character of the command, or  by',CR,LF
 DB 9,'moving  the highlighted command with the SPACE, TAB, or BACKSPACE',CR,LF
 DB 9,'keys and selecting it with the RETURN or  ENTER  key.    Specific',CR,LF
 DB 9,'information  about  each  command may be obtained by pressing the',CR,LF
 DB 9,'HELP key (Z-100) or F1  key  (Z-150)  with  the  desired  command',CR,LF
 DB 9,'highlighted.$'

IHLP	DB 9,'Change/Create Disk ID',CR,LF,LF
 DB 9,'You  will  be  prompted for a new disk identification label to be',CR,LF
 DB 9,'placed on the currently selected disk.   The label on the disk is',CR,LF
 DB 9,'shown at the top right corner of the screen.$'

LHLP	DB 9,'List File in Hex',CR,LF,LF
 DB 9,'The file you have selected is displayed on  the  screen  in  both',CR,LF
 DB 9,'hexadecimal (hex) and ASCII, with 16 bytes per line.  The listing',CR,LF
 DB 9,'will  pause  every 16 lines (256 bytes).   Type Control-C to exit',CR,LF
 DB 9,'before the end is reached, or any other key to continue.   A sep-',CR,LF
 DB 9,'arate  utility program called HEXLIST is required to execute this',CR,LF
 DB 9,'command.$'

MHLP	DB 9,'More Files',CR,LF,LF
 DB 9,'If  there  are more files in a directory than can be displayed on',CR,LF
 DB 9,'the screen,  the words MORE FILES will appear in the lower  right',CR,LF
 DB 9,'corner.   This command can then be used to display the additional',CR,LF
 DB 9,'files.   If you use this command when the screen shows the end of',CR,LF
 DB 9,'the directory, the beginning will be re-displayed.',CR,LF,LF
 DB 9,'If all the files can be displayed at once,  this  command  is not',CR,LF
 DB 9,'active.$'

NHLP	DB 9,'New Disk/Directory',CR,LF,LF
 DB 9,'You will be prompted to enter a letter (A-P) to designate the new',CR,LF
 DB 9,'default  drive.    You  can specify the current drive by pressing',CR,LF
 DB 9,'RETURN.  After you select a drive, HFM will  search  the  current',CR,LF
 DB 9,'directory  on  that drive for directory names.  If there are any,',CR,LF
 DB 9,'they will be displayed.  You may then enter a directory  pathname',CR,LF
 DB 9,'to become the new current directory.   Enter  a  RETURN  only  in',CR,LF
 DB 9,'response to the prompt to retain the current directory.',CR,LF,LF
 DB 9,'When you select a NEW drive, the root  directory  on  that  drive',CR,LF
 DB 9,'becomes  the  current  directory  that  is searched for directory',CR,LF
 DB 9,'names.  If the drive you designate is the CURRENT drive, the last',CR,LF
 DB 9,'directory  selected is retained as the current directory, and any',CR,LF
 DB 9,'directory names in it will be displayed.  Therefore, by repeated-',CR,LF
 DB 9,'ly  selecting  the  current  drive,  you can work your way into a',CR,LF
 DB 9,'directory tree of several branches.  To work backwards in a tree,',CR,LF
 DB 9,'enter .. as the new directory name.',CR,LF,LF
 DB 9,'If there are no sub directories in  the  current  directory,  you',CR,LF
 DB 9,'will hear a beep, and the current directory will be displayed.',CR,LF,LF
 DB 9,'To change disks in a drive, change the disks first, then use this',CR,LF
 DB 9,'command and select the drive where the change was made.$'

PHLP	DB 9,'Print File',CR,LF,LF
 DB 9,'The currently selected file is placed on the print  queue (stored',CR,LF
 DB 9,'for  printing while the system executes other commands).  The MS-',CR,LF
 DB 9,'DOS PRINT program is required to accomplish this task.$'

QHLP	DB 9,'Quit File Manager',CR,LF,LF
 DB 9,'The HUG File Manager returns control to the operating system.$'

RHLP	DB 9,'Rename File',CR,LF,LF
 DB 9,'You will be prompted for a new name for the selected file.    The',CR,LF
 DB 9,'file will then be renamed.$'

SHLP	DB 9,'Sort Directory',CR,LF,LF
 DB 9,'The directory is sorted alphabetically and displayed in that form',CR,LF
 DB 9,'on the screen.   This is the normal condition when the program is',CR,LF
 DB 9,'started.$'

THLP	DB 9,'Type File',CR,LF,LF
 DB 9,'The contents of the text file you have selected are displayed  on',CR,LF
 DB 9,'the screen.  The display will pause each time 23 lines have  been',CR,LF
 DB 9,'printed.   Type  Control-C  to exit before the file has been com-',CR,LF
 DB 9,'pletely printed, or any other key to continue.$'

UHLP	DB 9,'Unsort/Unflag Directory',CR,LF,LF
 DB 9,'The directory is unsorted and the file names are displayed on the',CR,LF
 DB 9,'screen  in  the  order  in  which  they  are  stored  in the disk',CR,LF
 DB 9,'directory.   Any  flags  that  were placed on files with the Flag',CR,LF
 DB 9,'command are removed.$'

WHLP	DB 9,'Wildcard Specification',CR,LF,LF
 DB 9,'You will be prompted for a wild card specification that will  de-',CR,LF
 DB 9,'termine  which  files from the current directory are shown on the',CR,LF
 DB 9,'screen.   For example,  if  you  want to see only files ending in',CR,LF
 DB 9,'.ASM, you can enter *.ASM as the wildcard specification.  To show',CR,LF
 DB 9,'show all files in the current directory again,  use  this command',CR,LF
 DB 9,'and enter *.* as the specification.  Note:  The wildcard specifi-',CR,LF
 DB 9,'cation  is  cleared to show all files when the Newdisk command is',CR,LF
 DB 9,'used.$'

.list
;
waitkey	label	byte
	addr	25,1
	db	esc,'K'
	db	'Type any character to return to directory menu..$'
WAITKEY1	LABEL	BYTE
	ADDR	25,1
	DB	ESC,'K'
	DB	7,'Type any character..$'
;
wildcard	db	'????????.???',0
;
find_buf	struc
res		db	21 dup (?)
attr		db	?
time		dw	?
date		dw	?
size_l		dw	?
size_h		dw	?
pname		db	13 dup (?)
find_buf	ends
;
prog_blk	label	word
	dw	0
	dw	buf,0
	dw	fcb1,0
	dw	fcb2,0
;
;	Note: these buffers must be contiguous
;
comd_prog	db	64 dup (0)
prnt_prog	db	64 dup (0)
hex_prog	db	64 dup (0)
;
printcom	db	9,'PRINT.COM'
hxlstcom	db	11,'HEXLIST.COM'
comspec		db	8,'COMSPEC='
path		db	5,'PATH='
cswtch		db	9,' /C COPY '
;
dir_ent_addr	label	byte
	addr	5,2
	ADDR	6,2
	ADDR	7,2
	ADDR	8,2
	ADDR	9,2
	ADDR	10,2
	ADDR	11,2
	ADDR	12,2
	ADDR	13,2
	ADDR	14,2
	ADDR	15,2
	ADDR	16,2
	ADDR	17,2
	ADDR	18,2
	ADDR	19,2
	ADDR	20,2
	ADDR	21,2
	addr	5,16
	ADDR	6,16
	ADDR	7,16
	ADDR	8,16
	ADDR	9,16
	ADDR	10,16
	ADDR	11,16
	ADDR	12,16
	ADDR	13,16
	ADDR	14,16
	ADDR	15,16
	ADDR	16,16
	ADDR	17,16
	ADDR	18,16
	ADDR	19,16
	ADDR	20,16
	ADDR	21,16
	addr	5,30
	ADDR	6,30
	ADDR	7,30
	ADDR	8,30
	ADDR	9,30
	ADDR	10,30
	ADDR	11,30
	ADDR	12,30
	ADDR	13,30
	ADDR	14,30
	ADDR	15,30
	ADDR	16,30
	ADDR	17,30
	ADDR	18,30
	ADDR	19,30
	ADDR	20,30
	ADDR	21,30
	addr	5,44
	ADDR	6,44
	ADDR	7,44
	ADDR	8,44
	ADDR	9,44
	ADDR	10,44
	ADDR	11,44
	ADDR	12,44
	ADDR	13,44
	ADDR	14,44
	ADDR	15,44
	ADDR	16,44
	ADDR	17,44
	ADDR	18,44
	ADDR	19,44
	ADDR	20,44
	ADDR	21,44
	addr	5,58
	ADDR	6,58
	ADDR	7,58
	ADDR	8,58
	ADDR	9,58
	ADDR	10,58
	ADDR	11,58
	ADDR	12,58
	ADDR	13,58
	ADDR	14,58
	ADDR	15,58
	ADDR	16,58
	ADDR	17,58
	ADDR	18,58
	ADDR	19,58
	ADDR	20,58
	ADDR	21,58
.list

;	MAIN PROGRAM

;	PERFORM SETUP CHORES

begin:	get_ver				; get DOS version
	cmp	al,2			; ensure MS-DOS 2.x
	jae	ver_ok
	MOV	DX,OFFSET badversion
	CALL	DSPMSG
	int	20h
ver_ok:	DISPLAY	IDMSG			; ASK TERMINAL TYPE
	MOV	CX,50			; SET A COUNTER
WFCHR:	MOV	AH,0BH
	INT	21H			; TEST FOR REPLY
	OR	AL,AL
	JNZ	GOTCHR			; GOT REPLY
	LOOP	WFCHR			; ELSE, TRY AGAIN
	PUSH	CX
	MOV	AX,100*256
	INT	10H			; SET NORMAL SCROLL
	MOV	AX,500H
	INT	10H			; SET PAGE 0
	MOV	AH,3
	INT	10H			; GET CURSOR TYPE
	MOV	CURTYPE,CX		; SAVE IT
	MOV	AH,15
	INT	10H			; READ DISPLAY TYPE
	MOV	DISTYPE,AL		; SAVE DISPLAY TYPE
	CMP	AL,7			; MONOCHROME CARD?
	JZ	MONCRD			; YES
	MOV	AX,3			; ELSE, FORCE MODE 3 FOR NOW
	INT	10H
MONCRD:	POP	CX
GOTCHR:	MOV	TTYPE,CL		; SAVE TERMINAL TYPE (0 = Z-150)
	MOV	AX,0C00H
	INT	21H			; FLUSH TYPE-AHEAD
	mov	si,offset comspec
	mov	bx,offset comd_prog	; get path for COMMAND.COM
	lodsb
	mov	cl,al
	xor	ch,ch
	call	get_env_parm
	mov	si,offset path
	mov	bx,offset prnt_prog	; get current PATH
	lodsb
	mov	cl,al
	xor	ch,ch
	call	get_env_parm
	mov	al,'\'
	cmp	al,-1[di]		; ensure '\' separator
	je	path_parm_ok
	stosb		
path_parm_ok:
	push	di
	mov	cx,64
	mov	si,offset prnt_prog
	mov	di,offset hex_prog
	rep	movsb			; copy to hex_prog too
	pop	di
	push	di
	mov	si,offset printcom
	lodsb				; PRINT.COM behind PATH
	mov	cl,al
	xor	ch,ch
	rep 	movsb
	pop	di
	add	di,64
	mov	si,offset hxlstcom
	lodsb				; HEXLIST.COM behind PATH
	mov	cl,al
	xor	ch,ch
	rep	movsb
;
	current_disk
	mov	dl,al
	add	al,'A'
	mov	cur_disk,al
	inc	dl
	mov	si,offset cur_dir
	svc	47h			; current directory
;
	mov	bx,offset BA.endcod
	mov	cl,4
	shr	bx,cl			; free mem behind me
	inc	bx
	svc	4ah
;
	mov	ax,ds
	mov	prog_blk[4],ax
	mov	prog_blk[8],ax		; segment fixups
	mov	prog_blk[12],ax
;
	MOV	DX,OFFSET init_msg	; initialize the terminal
	CALL	DSPMSG
	CALL	GET_DIRECT		; GET DIRECTORY

;	MAIN COMMAND LOOP

;	REPAINT ENTIRE SCREEN

repaint:MOV	SP,OFFSET BA.STACK		; FIX STACK
	MOV	DX,OFFSET REPAINT
	MOV	AX,2523H
	INT	21H			; SET CONTROL-C ADDRESS
	MOV	DX,OFFSET clr_screen
	CALL	DSPMSG
	call	disp_cmd_line
	call 	directory_display

;	GET SINGLE KEY PRESS, PROCESS IT

get_key:MOV	AH,7
	INT	21H			; GET CHARACTER
	OR	AL,AL			; NULL?
	JZ	GOTNULL			; YES
	CMP	AL,1BH			; ESC?
	JZ	GOTESC			; YES
	mov	bx,offset key_table	; ELSE, USE REGULAR TABLE
	CALL	MUC			; MAKE CHAR UPPER CASE
	JMP	SHORT KEY_CHK
GOTNULL:MOV	BX,OFFSET Z150TBL	; USE Z-150 TABLE
	JMP	SHORT WFKEY		; AND WAIT FOR KEY SEQUENCE
GOTESC:	MOV	BX,OFFSET Z100TBL	; USE Z-100 TABLE
WFKEY:	MOV	CX,50			; SET A COUNTER
WFKEY1:	MOV	AH,6
	MOV	DL,0FFH
	INT	21H			; CHECK FOR KEY SEQUENCE
	OR	AL,AL
	JNZ	KEY_CHK			; GOT SEQUENCE CHAR
	LOOP	WFKEY1			; ELSE, TRY AGAIN
	JMP	GET_KEY			; TIMED OUT, NO KEY SEQUENCE
key_chk:
	cmp	byte ptr [bx],0
	je	get_key			; ignore if not in table
	cmp	al,[bx]
	je	got_key
	add	bx,3
	jmp	key_chk
got_key:
	inc	bx
	jmp	word ptr [bx]
;
key_table:
	db	08h
	dw	offset	dobs
	db	09h
	dw	offset	dotab
	db	0dh
	dw	offset	docr
	db	20h
	dw	offset dospc
	db	'C'
	dw	offset docopy
	db	'D'
	dw	offset DODIR
	db	'E'
	dw	offset DOERA
	DB	'F'
	DW	OFFSET DOFLAG
	db	'H'
	dw	offset dohlp
	DB	'I'
	DW	OFFSET DOID
	db	'L'
	dw	offset dohex
	db	'M'
	DW	OFFSET DOMORE
	db	'N'
	dw	offset donew
	db	'P'
	dw	offset doprt
	DB	'Q'
	DW	OFFSET DOQUIT
	db	'R'
	dw	offset doren
	DB	'S'
	DW	OFFSET DOSORT
	db	'T'
	dw	offset dotyp
	DB	'U'
	DW	OFFSET DOUNSRT
	DB	'W'
	DW	OFFSET DOWILD
	db	0
Z100TBL:
	DB	'~'
	DW	OFFSET DOHELP
	DB	'A'
	DW	OFFSET DOUP
	DB	'B'
	DW	OFFSET DODWN
	DB	'C'
	DW	OFFSET DORT
	DB	'D'
	DW	OFFSET DOLFT
	DB	'H'
	DW	OFFSET DOHOM
	DB	0
Z150TBL:
	DB	';'
	DW	OFFSET DOHELP
	DB	'H'
	DW	OFFSET DOUP
	DB	'P'
	DW	OFFSET DODWN
	DB	'M'
	DW	OFFSET DORT
	DB	'K'
	DW	OFFSET DOLFT
	DB	'G'
	DW	OFFSET DOHOM
	DB	0

;	EXECUTE COMMANDS

;	MOVE COMMAND INDICATOR LEFT

dobs:	call	nrm_curc
	dec	cur_cmd
	cmp	cur_cmd,0
	jge	no_wrp
	mov	cur_cmd,max_cmd
no_wrp:
	call	rev_curc
	jmp	get_key

;	MOVE COMMAND INDICATOR RIGHT

dospc:
dotab:	call	nrm_curc
	inc	cur_cmd
	cmp	cur_cmd,max_cmd
	jbe	no_wrp
	mov	cur_cmd,0
	jmp	no_wrp

;	RETURN PRESSED, EXECUTE SELECTED COMMAND

docr:	mov	si,cur_cmd
	shl	si,1
	jmp	word ptr cmd_jmp_tbl[si]
;
cmd_jmp_tbl	label	word
	dw	offset	docopy
	dw	offset	DODIR
	dw	offset	DOERA
	DW	OFFSET	DOFLAG
	dw	offset  dohlp
	DW	OFFSET	DOID
	dw	offset	dohex
	DW	OFFSET	DOMORE
	dw	offset	donew
	dw	offset	doprt
	DW	OFFSET	DOQUIT
	dw	offset	doren
	DW	OFFSET	DOSORT
	dw	offset	dotyp
	DW	OFFSET	DOUNSRT
	DW	OFFSET	DOWILD

;	MOVE FILE INDICATOR RIGHT

dort:	cmp	FILECNT,0
	JZ	get_keyj
	call	cur_ent_nrm
	add	cur_ent,17
	mov	ax,max_ent
	cmp	ax,cur_ent
	ja 	dort_disp
	sub	cur_ent,17		; no wrap on right
dort_disp:
	call	cur_ent_rev
	MOV	DX,OFFSET sel_disp
	CALL	DSPMSG
	call	cur_ent_dis
	CALL	CUR_ENT_SIZE
get_keyj:
	jmp	get_key

;	MOVE FILE INDICATOR LEFT

dolft:	cmp	FILECNT,0
	JZ	get_keyj
	call	cur_ent_nrm
	sub	cur_ent,17
	cmp	cur_ent,0
	jge	dort_disp
	add	cur_ent,17		; no wrap on left
	jmp	dort_disp

;	MOVE FILE INDICATOR UP

doup:	cmp	FILECNT,0
	JZ	get_keyj
	call	cur_ent_nrm
	dec	cur_ent
	cmp	cur_ent,0
	jge	dort_disp
	mov	ax,max_ent
	dec	ax
	mov	cur_ent,ax
	jmp	dort_disp

;	MOVE FILE INDICATOR DOWN

dodwn:	cmp	FILECNT,0
	JZ	get_keyj
	call	cur_ent_nrm
	inc	cur_ent
	mov	ax,cur_ent
	cmp	ax,max_ent
	jb 	dort_disp
	mov	cur_ent,0
	jmp	dort_disp

;	HOME THE FILE INDICATOR

dohom:	cmp	FILECNT,0
	JZ	get_keyj
	call	cur_ent_nrm
	mov	cur_ent,0
	jmp	dort_disp

;	SHOW HELP ON SELECTED COMMAND

dohlp:	MOV	DX,OFFSET clr_screen
	CALL	DSPMSG
	mov	dx,offset hhlp
	jmp	dohelp_dis

;	SHOW MAIN HELP SCREEN

dohelp:	MOV	DX,OFFSET clr_screen	; clear screen
	CALL	DSPMSG
	mov	si,cur_cmd
	shl	si,1
	mov	dx,hlp_vct[si]
dohelp_dis:
	CALL	DSPMSG
wait_keyin:
	MOV	DX,OFFSET waitkey
	CALL	DSPMSG
	dir_console_in
	jmp	repaint

;	COPY FILE(S)

docopy:	cmp	FILECNT,0
	JNZ 	docopy_ok
	jmp	files_err
docopy_ok:
	MOV	DX,OFFSET init_prompt		
	CALL	DSPMSG
	MOV	DX,OFFSET dest_file_req	; get destination file name
	CALL	DSPMSG
	get_string	7eh,BA.linebuf
	cmp	BA.linebuf+1,0		; no action if null entry
	JNE	DOCOPY1
	JMP	RECMDJ
DOCOPY1:CMP	FLAGCNT,0		; ANY FLAGS?
	JZ	DOCOPY2			; NO
	MOV	AX,FILECNT
	MOV	TFCNT,AX		; ELSE, SET TEMP. COUNT
	MOV	AX,OFFSET BA.DIRPTR
	MOV	CUR_ADR,AX		; SET CURRENT FILE ADDRESS
	MOV	FLG2FLG,1		; AND SET TEMP. FLAG
DOCOPY2:
	MOV	DX,OFFSET CLR_SCREEN
	CALL	DSPMSG			; CLEAR SCREEN
COPYLP:
	mov	si,offset cswtch
	call	set_parm_cmd
	JC	COPYX			; END OF COPYING
	mov	al,' '			; space separator
	stosb
	inc	buf
	mov	si,offset BA.linebuf+2
	mov	cl,BA.linebuf+1
	xor	ch,ch
copy_newname:				; now copy in new name
	movsb
	inc	buf
	loop	copy_newname
	mov	byte ptr [di],CR
	MOV	SI,OFFSET BUF
	LODSB				; GET COUNT OF CHARS IN BUFFER
	ADD	SI,3			; SKIP /C
	SUB	AL,3			; DITTO
	MOV	CL,AL
	XOR	CH,CH
PNAMLP:	LODSB				; GET A CHARACTER
	CALL	SCOUT			; PRINT IT
	LOOP	PNAMLP			; LOOP UNTIL INFO PRINTED
	mov	dx,offset comd_prog
	CALL	load_prog		; COMMAND.COM does COPY
	CMP	FLAGCNT,0		; COPYING FLAGGED FILES?
	JNZ	COPYLP			; IF SO, LOOP
COPYX:	MOV	FLG2FLG,0
	JMP	WAIT_KEYIN
;
files_err:
	mov	dx,offset file_err_msg
err_xit:
	CALL	DSPMSG
	JMP	WAITJ

;	MAKE/REMOVE DIRECTORY

DODIR:	MOV	DX,OFFSET init_prompt
	CALL	DSPMSG
	MOV	DX,OFFSET DIR_TYPE_REQ
	CALL	DSPMSG
	READ_KBD_ECHO
	CALL	MUC
	MOV	BP,AX			; SAVE ANSWER
	CMP	AL,'M'			; CHECK FOR VALID ANSWER
	JZ	DODIR1
	CMP	AL,'R'
	JZ	DODIR1
	JMP	RECMDJ			; BAD ENTRY
DODIR1:	MOV	DX,OFFSET init_prompt
	CALL	DSPMSG
	MOV	DX,OFFSET DIR_NAM_REQ
	CALL	DSPMSG
	GET_STRING	7eh,BA.linebuf
	CMP	BA.linebuf+1,0		; ignore if null entry
	JNE	DODIR2
	JMP	RECMDJ
DODIR2:	mov	bl,BA.linebuf+1
	xor	bh,bh			; BX = CHAR COUNT
	mov	BA.linebuf+2[bx],0	; null string terminator
	mov	DX,offset BA.linebuf+2	; POINT TO NEW NAME
	MOV	AX,BP			; GET USER SELECTION
	MOV	AH,39H			; ASSUME MAKE
	CMP	AL,'R'			; REMOVE?
	JNZ	DODIR3			; NO
	MOV	AH,3AH			; ELSE, USE REMOVE FUNCTION
DODIR3:	INT	21H			; PERFORM FUNCTION
	JC	DODIRER			; ERROR
DODIRX:	CALL	DISP_CMD_LINE		; REPLACE COMMAND LINE
	CALL	GETFREE			; GET FREE SPACE
	CALL	SHOWBOT			; SHOW FREE SPACE
	JMP	GET_KEY
DODIRER:MOV	DX,OFFSET DIR_ERR_MSG
	CALL	DSPMSG
	MOV	DX,OFFSET WAITKEY1
	CALL	DSPMSG
	DIR_CONSOLE_IN			; WAIT FOR KEY
	JMP	DODIRX

;	ERASE FILE(S)

DOERA:	cmp	FILECNT,0
	JNZ	DOERA0
	JMP	FILES_ERR
DOERA0:	MOV	DX,OFFSET init_prompt
	CALL	DSPMSG
	MOV	DX,OFFSET confirm_req	; ask for confirmation
	CMP	FLAGCNT,0		; ANY FLAGS?
	JZ	DOERA1			; NO
	MOV	AX,FILECNT
	MOV	TFCNT,AX		; ELSE, SET TEMP. COUNT
	MOV	AX,OFFSET BA.DIRPTR
	MOV	CUR_ADR,AX		; SET CURRENT ADDRESS
	MOV	FLG2FLG,1		; AND SET TEMP. FLAG
	MOV	DX,OFFSET CONFIRM_REQ1	; USE SPECIAL CONFIRM MSG.
DOERA1:	CALL	DSPMSG
	read_kbd_echo  			; get reply
	CALL	MUC
	cmp	al,"Y"
	je	del_ok			; must be Y or y
RECMDJ:
	MOV	FLG2FLG,0		; CLEAR TEMP. FLAG
	CALL	DISP_CMD_LINE
	jmp	GET_KEY
del_ok:
	call 	get_current
	MOV	SI,DX			; SAVE CUR. ADDRESS
	JC	DELX			; END OF DELETIONS
	svc	41h			; delete file
	jc	del_err
	CMP	FLAGCNT,0		; DOING FLAGS?
	JNZ	DEL_OK			; IF SO, LOOP
DELX:	mov	cur_ent,0
	CALL	GET_DIR0		; RE-GET DIRECTORY
REPAINTJ:
	MOV	FLG2FLG,0
	JMP	REPAINT			; RE-SHOW DIRECTORY
del_err:
	mov	dx,offset del_err_msg
	CALL	DSPMSG
	CLD
PFILE:	LODSB				; GET CHAR
	OR	AL,AL
	JZ	CFFLG
	CALL	SCOUT			; PRINT FILE NAME
	JMP	PFILE
CFFLG:	CMP	FLAGCNT,0		; DOING FLAGS?
	JZ	WAITJ			; IF NOT, EXIT
	MOV	DX,OFFSET WAITKEY1
	CALL	DSPMSG
	DIR_CONSOLE_IN			; WAIT FOR KEY
	JMP	DEL_OK			; AND LOOP
WAITJ:	MOV	FLG2FLG,0
	jmp	wait_keyin

;	FLAG/UNFLAG FILE

DOFLAG:	MOV	SI,CUR_ENT		; GET CURRENT FILE NO.
	PUSH	SI
	SHL	SI,1
	SHL	SI,1			; MPY BY 4
	MOV	CX,4
FLAGLP:
	MOV	AL,DIR_ENT_ADDR[SI]	; address cursor to entry position
	CALL	SCOUT
	INC	SI
	LOOP	FLAGLP
	POP	SI			; GET CURRENT NO. AGAIN
	ADD	SI,PAGECNT		; ADD PAGE COUNT
	SHL	SI,1			; MPY BY 2
	TEST	WORD PTR BA.DIRPTR[SI],8000H	; TEST FOR FLAG BIT
	JNZ	UNFLAG			; SET, SO REMOVE FLAG
	OR	WORD PTR BA.DIRPTR[SI],8000H	; SET FLAG BIT
	INC	FLAGCNT			; COUNT FLAG
	MOV	DX,OFFSET FLG_MSG
	CALL	DSPMSG			; MARK FILE ON SCREEN
	CALL	GET_SIZE		; GET FILE SIZE
	ADD	FLAG_L,BX		; ADD TO TOTAL
	ADC	FLAG_H,AX
	JMP	SHORT FLAGX
UNFLAG:	AND	WORD PTR BA.DIRPTR[SI],7FFFH	; KILL FLAG BIT
	DEC	FLAGCNT			; DECREMENT COUNTER
	MOV	AL,8
	CALL	SCOUT			; REMOVE FLAG FROM DISPLAY
	MOV	AL,' '
	CALL	SCOUT
	CALL	GET_SIZE		; GET FILE SIZE
	SUB	FLAG_L,BX		; SUB FROM TOTAL
	SBB	FLAG_H,AX
FLAGX:	MOV	DX,OFFSET FSPC_MSG
	CALL	DSPMSG
	MOV	BX,FLAG_L		; GET TOTAL BYTES FLAGGED
	MOV	AX,FLAG_H
	CALL	DDECOUT			; SHOW FLAG BYTES
	JMP	GET_KEY

;	CHANGE/CREATE DISK ID

DOID:	CLD
	SET_DTA	BUF			; PREPARE
	MOV	DX,OFFSET init_prompt
	CALL	DSPMSG
	MOV	DX,OFFSET NEW_ID_REQ
	CALL	DSPMSG
	GET_STRING	12,BA.linebuf
	MOV	BL,BA.LINEBUF+1
	XOR	BH,BH			; BX = CHAR COUNT
	CMP	BL,0			; IGNORE IF NULL ENTRY
	JNE	DOID1
	JMP	RECMDJ
DOID1:
	PUSH	BX			; SAVE CHAR COUNT
	CMP	LABFLAG,0		; OLD LABEL PRESENT?
	JNZ	DOID2			; YES
	MOV	SI,OFFSET DLFCB		; ELSE, PREPARE TO MAKE ONE
	MOV	DI,OFFSET BUF
	MOV	CX,(OFFSET DLFCBX)-(OFFSET DLFCB)
	REP	MOVSB
	MOV	SI,OFFSET NONE
	MOV	DI,(OFFSET BUF)+8
	MOV	CX,11
	REP	MOVSB
	MOV	DX,OFFSET BUF
	SVC	16H			; CREATE DUMMY LABEL
	OR	AL,AL
	JNZ	DOIDERR			; COULDN'T DO IT
DOID2:	CALL	GET_LABEL		; GET OLD LABEL
	MOV	DI,(OFFSET BUF)+18H
	MOV	CX,11
	MOV	AL,' '
	REP	STOSB			; FILL NEW NAME WITH SPACES
	POP	CX			; GET ENTERED CHAR COUNT
	mov	SI,offset BA.linebuf+2	; POINT TO NEW LABEL
	MOV	DI,(OFFSET BUF)+18H	; PUT IT HERE
	REP	MOVSB			; MOVE IT IN
	MOV	DX,OFFSET BUF
	SVC	17H			; CHANGE LABEL NAME
	OR	AL,AL
	JNZ	DOIDERR			; COULDN'T DO IT
	CALL	GET_LABEL		; ELSE, GET NEW LABEL
	MOV	DX,OFFSET LAB_MSG
	CALL	DSPMSG			; SHOW IT
	JMP	RECMDJ
DOIDERR:JMP	REN_ERR			; USE RENAME ERR MSG.

;	LIST FILE IN HEX (VIA HEXLIST UTILITY)

dohex:	cmp	FILECNT,0
	JNZ	DOHEX1
	JMP	files_err
DOHEX1:	MOV	DX,OFFSET clr_screen
	CALL	DSPMSG
	call	set_parm		; set parm=cur_ent
	parse	buf+2,fcb1
	mov	dx,offset hex_prog	; prog is hexfile
	CALL	LOAD_PROG
	JMP	WAIT_KEYIN

;	SHOW MORE OF LARGE DIRECTORY

DOMORE:	CMP	BYTE PTR MOREFLG,0	; MORE FILES?
	JNZ	DOMORE1			; YES
	JMP	GET_KEY			; ELSE, IGNORE
DOMORE1:MOV	CUR_ENT,0
	ADD	PAGECNT,85		; SKIP 85 FILES
	MOV	DX,OFFSET clr_screen
	CALL	DSPMSG
	call	disp_cmd_line
	call 	directory_display
	JMP	GET_KEY

;	GET NEW DISK/DIRECTORY

donew:	MOV	DX,OFFSET init_prompt
	CALL	DSPMSG
	MOV	DX,OFFSET new_disk_req	; request new drive ID
	CALL	DSPMSG
	READ_KBD_ECHO
	CALL	MUC
	cmp	al,'A'
	jb 	no_new_disk		; ignore invalid entries
	CMP	AL,'P'+1
	JNC	NO_NEW_DISK
	mov	cur_disk,al
	sub	al,'A'
	select_disk	al		; set new default drive
	xor	dl,dl
	mov	si,offset cur_dir	; new current directory
	svc	47h
	mov	cur_ent,0
no_new_disk:
	call	subdirectory_display
	JC	NO_NEW_DIR		; NO SUB DIRECTORIES
	MOV	DX,OFFSET new_dir_req
	CALL	DSPMSG
	get_string	36,BA.linebuf
	cmp	BA.linebuf+1,0
	je	no_new_dir
	mov	bl,BA.linebuf+1
	xor	bh,bh
	mov	BA.linebuf+2[bx],0	; string terminator
	mov	dx,offset BA.linebuf+2
	svc	3bh			; change current directory
	jc	new_dir_err
	mov	si,offset cur_dir
	mov	dl,0			; save in cur_dir
	svc	47h
	mov	cur_ent,0
no_new_dir:
	CALL	GET_DIRECT		; GET NEW DIRECTORY
	jmp	repaint
new_dir_err:
	mov	dx,offset dir_err_msg
	jmp	err_xit

;	PRINT FILE (VIA PRINT UTILITY)

doprt:	cmp	FILECNT,0
	JNZ	doprt_ok
files_errj:
	jmp	files_err
doprt_ok:
	MOV	DX,OFFSET clr_screen
	CALL	DSPMSG
	MOV	DX,OFFSET CUR_ON
	CALL	DSPMSG
	call	set_parm
	mov	dx,offset prnt_prog
	CALL	load_prog
	JMP	WAIT_KEYIN

;	QUIT -- EXIT TO DOS

DOQUIT:	MOV	DX,OFFSET xit_msg
	CALL	DSPMSG
	CMP	Byte Ptr TTYPE,0	; H150?
	JNZ	EXIT1			; NO
	MOV	AL,DISTYPE		; ELSE, GET OLD DISPLAY TYPE
	XOR	AH,AH
	INT	10H			; SET IT
	MOV	CX,CURTYPE		; GET CURSOR TYPE
	MOV	AH,1
	INT	10H			; SET IT
EXIT1:	sys_term 0

;	RENAME FILE

doren:	cmp	FILECNT,0
	JZ	files_errj
	MOV	DX,OFFSET init_prompt
	CALL	DSPMSG
	MOV	DX,OFFSET new_name_req
	CALL	DSPMSG
	get_string	7eh,BA.linebuf
	cmp	BA.linebuf+1,0		; ignore if null entry
	jne	doren_cont
	jmp	RECMDJ
doren_cont:
	mov	bl,BA.linebuf+1
	xor	bh,bh
	mov	BA.linebuf+2[bx],0	; null string terminator
	call	get_current
	mov	di,offset BA.linebuf+2
	svc	56h			; rename file
	jc	ren_err
	MOV	FILECNT,0
	CALL	GET_DIR1		; GET NEW NAME IN DIRECTORY
	jmp	repaint
ren_err:
	mov	dx,offset ren_err_msg
	CALL	DSPMSG
	MOV	DX,OFFSET WAITKEY1
	CALL	DSPMSG
	DIR_CONSOLE_IN			; WAIT FOR KEY
	CALL	SHOWBOT
	JMP	RECMDJ

;	SORT DIRECTORY

DOSORT:	MOV	SORTFLG,1		; MARK FILES SORTED
	CMP	FILECNT,0		; ANY FILES
	JNZ	SRTFLS			; YES, SORT THEM
	JMP	GET_KEY			; ELSE, EXIT
SRTFLS:	CALL	SORT			; SORT THE DIRECTORY
	JMP	REPAINT			; RE-DISPLAY FILES

;	TYPE FILES ON SCREEN

dotyp:	cmp	FILECNT,0
	JNZ	DOTYP1
	JMP	FILES_ERR
DOTYP1:	MOV	LINECNT,22		; SET LINE COUNT
	MOV	DX,OFFSET clr_screen
	CALL	DSPMSG
	CALL	GET_CURRENT
	MOV	AL,0
	SVC	3DH			; OPEN FILE TO TYPE
	MOV	BX,AX			; HANDLE TO BX
	JNC	TYPLP			; NO ERROR
	JMP	DOTYPR			; ELSE, EXIT
TYPLP:	PUSH	BX			; SAVE HANDLE NO.
	MOV	DX,OFFSET BUF
	MOV	CX,128
	SVC	3FH			; READ FROM FILE
	POP	BX			; RESTORE HANDLE
	JC	DOTYPX			; BAD READ
	CMP	AX,0			; DONE?
	JZ	DOTYPX			; YES
	MOV	CX,AX			; ELSE, COUNT TO CX
	MOV	SI,OFFSET BUF		; POINT TO BUFFER
	CLD
TYPLP1:	LODSB				; GET A CHARACTER
	CMP	AL,1AH			; EOF?
	JZ	DOTYPX			; YES
	PUSH	AX
	CALL	SCOUT			; PRINT TO SCREEN
	POP	AX
	AND	AL,7FH			; STRIP PARITY
	CMP	AL,LF			; LINE FEED?
	JNZ	TYPLP2			; NO
	DEC	LINECNT			; ELSE INCREMENT LINE COUNT
	JNZ	TYPLP2			; NOT ENOUGH LINES
	MOV	LINECNT,22		; RESET LINE COUNT
TWAIT:	DIR_CONSOLE_IN			; GET IT
	CMP	AL,3			; CONTROL-C?
	JNZ	TYPLP2			; NO
DOTYPX:	SVC	3EH			; CLOSE FILE
	JMP	WAIT_KEYIN
TYPLP2: MOV	DL,0FFH
	SVC	6			; CHECK KEYBOARD
	CMP	AL,3			; CONTROL-C?
	JZ	DOTYPX			; IF SO, EXIT
	CMP	AL,'S'-'@'		; CONTROL-S?
	JZ	TWAIT			; IF SO, WAIT
	LOOP	TYPLP1			; FINISH BUFFER
	JMP	TYPLP
DOTYPR:	MOV	DX,OFFSET PROG_ERR_MSG
	CALL	DSPMSG
	JMP	WAIT_KEYIN

;	UNSORT/UNFLAG DIRECTORY

DOUNSRT:XOR	AX,AX
	MOV	FLAG_L,AX		; ZERO FLAG BYTE COUNT
	MOV	FLAG_H,AX
	MOV	SORTFLG,AL		; MARK FILES UNSORTED
	MOV	FLAGCNT,AL		; MARK THEM UNFLAGGED
	CMP	FILECNT,0		; ANY FILES
	JNZ	USFLS			; IF SO, UNSORT THEM
	JMP	GET_KEY			; ELSE, IGNORE
USFLS:	CALL	UNSORT			; UNSORT FILES
	JMP	REPAINT			; RE-DISPLAY THEM

;	ALTER WILDCARD SPECIFICATION

DOWILD:	MOV	DX,OFFSET init_prompt
	CALL	DSPMSG
	MOV	DX,OFFSET WILD_CARD_REQ
	CALL	DSPMSG
	GET_STRING	13,BA.linebuf
	MOV	BL,BA.LINEBUF+1
	XOR	BH,BH			; BX = CHAR COUNT
	CMP	BL,0			; IGNORE IF NULL ENTRY
	JNE	DOWILD1
	JMP	RECMDJ
DOWILD1:
	mov	BA.linebuf+2[bx],0	; null string terminator
	mov	SI,offset BA.linebuf+2	; POINT TO NEW SPEC.
	MOV	DI,OFFSET WILDCARD	; PUT IT HERE
	MOV	CX,BX
	INC	CX			; ALLOW FOR TERMINATOR
	CLD
	REP	MOVSB			; MOVE IT IN
	CALL	GET_DIR0		; GET NEW RESTRICTED DIRECTORY
	jmp	repaint

;	PROCEDURES

;	MAP LOWER TO UPPER CASE

MUC	PROC	NEAR			; CAPITALIZE CHAR IN AL
	CMP	AL,'a'
	JC	MUCX
	CMP	AL,'z'+1
	JNC	MUCX
	AND	AL,5FH			; CAPITALIZE
MUCX:	RET
MUC	ENDP

;	DISPLAY COMMAND LINE

disp_cmd_line	proc	near
	MOV	DX,OFFSET init_cmd_line
	CALL	DSPMSG
	CMP	BYTE PTR TTYPE,0	; Z-150?
	JNZ	NOT150
	MOV	AH,1
	MOV	CX,2020H
	INT	10H			; TURN OFF CURSOR
NOT150:	mov	cx,ncmds
	push	cur_cmd
	mov	cur_cmd,0
dispc_lp:
	call	nrm_curc
	inc	cur_cmd
	loop	dispc_lp
	pop	cur_cmd
	call 	rev_curc
	ret
disp_cmd_line	endp

;	DISPLAY CURRENT COMMAND

rev_curc	proc	near
	MOV	DX,OFFSET rev_msg
	CALL	DSPMSG
nrm_curc:
	mov	si,cur_cmd
	shl	si,1
	mov	dx,cmd_line_tbl[si]
	CALL	DSPMSG
	MOV	DX,OFFSET nrm_msg
	CALL	DSPMSG
	ret
rev_curc	endp

;	DISPLAY DIRECTORY ON SCREEN

directory_display	proc	near
	MOV	DX,OFFSET dir_hdr
	CALL	DSPMSG
	MOV	AL,cur_disk
	CALL	SCOUT
	MOV	AL,':'
	CALL	SCOUT
	MOV	AL,'\'
	CALL	SCOUT
	mov	si,offset cur_dir
disdir:
	lodsb
	cmp	al,0
	je	disents
	CALL	SCOUT
	jmp	disdir
disents:
	MOV	DX,OFFSET LAB_MSG
	CALL	DSPMSG			; SHOW DISK ID
	push	cur_ent			; save current entry pointer
	mov	cur_ent,0		; reset for display
DISENT0:CMP	FILECNT,0		; ANY FILES?
	JNZ	DISPENTS		; YES
DISENT1:MOV	DX,OFFSET no_fil_msg
	CALL	DSPMSG
	pop	cur_ent
	mov	cur_ent,0
	JMP	DIR_FREE		; SHOW DISK FREE SPACE
DISPENTS:
	mov	di,offset BA.dir_ent_buf ; POINT TO DIRECTORY ENTRIES
	MOV	BX,OFFSET BA.DIRPTR	; POINT TO DIRECTORY POINTER
	MOV	AX,PAGECNT		; GET CURRENT COUNT
	CMP	AX,FILECNT		; REACHED FILE COUNT?
	JB	OKCNT			; NO
	MOV	AX,0			; ELSE, START OVER
	MOV	PAGECNT,0
OKCNT:	SHL	AX,1			; DOUBLE COUNT
	ADD	BX,AX			; ADD TO POINTER POS.
	CLD
dis_loop:
	mov	SI,cur_ent
	shl	SI,1
	shl	SI,1
	mov	cx,4
adr_lup:
	MOV	AL,dir_ent_addr[SI]	; address cursor to entry position
	CALL	SCOUT
	inc	SI
	loop	adr_lup
	mov	si,[BX]			; GET FILE NAME ADDRESS
	TEST	SI,8000H		; TEST FOR FLAG
	JZ	NOFLG			; NO FLAG
	AND	SI,7FFFH		; REMOVE FLAG
	MOV	DX,OFFSET FLG_MSG
	CALL	DSPMSG			; SHOW FLAG ON FILE
NOFLG:	mov	cx,12			; NAME SIZE
nam_lup:
	LODSB				; GET CHARACTER
	cmp	al,0
	je	ent_fin
	CALL	SCOUT
	LOOP	nam_lup
ent_fin:
	ADD	BX,2			; MOVE TABLE POINTER
	inc	cur_ent			; COUNT SCREEN FILE
	MOV	AX,PAGECNT
	ADD	AX,CUR_ENT
	CMP	AX,FILECNT		; DONE ALL FILES?
	JZ	ALLIN
	cmp	cur_ent,84
	jbe	dis_loop
	MOV	BYTE PTR MOREFLG,1	; INDICATE MORE AVAILABLE
allin:
	CMP	BYTE PTR MOREFLG,0	; MORE FILES?
	JZ	ALLIN1			; NO
	MOV	DX,OFFSET MORE_DIR
	CALL	DSPMSG			; ELSE, SHOW "MORE.."
ALLIN1:	mov	ax,cur_ent
	mov	max_ent,ax
	pop	cur_ent
	call	cur_ent_rev
	MOV	DX,OFFSET FSPC_MSG
	CALL	DSPMSG			; SAY "FLAG BYTES"
	MOV	BX,FLAG_L		; GET FLAG BYTES
	MOV	AX,FLAG_H
	CALL	DDECOUT			; SHOW THEM
SHOWBOT:
	MOV	DX,OFFSET sel_disp
	CALL	DSPMSG
	call	cur_ent_dis
	CALL	CUR_ENT_SIZE
DIR_FREE:
	MOV	DX,OFFSET FREE_MSG
	CALL	DSPMSG			; SAY "FREE SPACE"
	MOV	BX,FREE_L		; GET FREE SPACE
	MOV	AX,FREE_H
	CALL	DDECOUT			; SHOW IT
	ret
directory_display	endp

;	GET DIRECTORY FILES, STORE IN BUFFER

GET_DIRECT	PROC	NEAR
	MOV	WORD PTR WILDCARD,'.*'
	MOV	WORD PTR WILDCARD+2,'*'	; RESET WILDCARD SPEC.
	CALL	GET_LABEL		; GET DISK LABEL
GET_DIR0:
	XOR	AX,AX
	MOV	FILECNT,AX		; CLEAR FILE COUNT
	MOV	PAGECNT,AX		; AND PAGE COUNT
	MOV	CUR_ENT,AX		; AND CURRENT ENTRY
	MOV	MOREFLG,AL		; AND MORE FLAG
	MOV	FLAGCNT,AL		; AND FLAG COUNT
	MOV	FLAG_L,AX		; AND FLAG BYTES
	MOV	FLAG_H,AX
GET_DIR1:
	SET_DTA	BUF			; SET DTA ADDRESS
	MOV	DI,OFFSET BA.DIR_ENT_BUF ; POINT TO DIR BUFFER
	MOV	DX,OFFSET WILDCARD
	SVC	4EH			; CHECK FOR ENTRY
	JC	GETFREE			; NO FILES, GET FREE SPACE
GOTFILES:
	MOV	SI,OFFSET BUF.PNAME
	MOV	CX,13
	CLD
	REP	MOVSB			; MOVE FILE NAME TO BUFFER
	MOV	SI,OFFSET BUF.SIZE_L
	MOVSW
	MOVSW				; MOVE IN FILE SIZE
	INC	FILECNT			; COUNT THIS FILE
	SVC	4FH			; CHECK FOR ANOTHER FILE
	JNC	GOTFILES		; MOVE IT
	CALL	UNSORT			; SET POINTER TABLE
	CMP	SORTFLG,0		; SORT FILES?
	JZ	GETFREE			; NO
	CALL	SORT			; SORT THE DIRECTORY
GETFREE:MOV	AH,36H
	XOR	DL,DL
	INT	21H			; GET FREE SPACE FROM SYSTEM
	MUL	CX			; COMPUTE BYTES/CLUSTER
	MOV	CX,AX
	MOV	AX,BX			; AX = FREE CLUSTERS
	MUL	CX			; COMPUTE BYTES FREE
	MOV	FREE_L,AX		; SAVE RESULT
	MOV	FREE_H,DX
	RET
GET_DIRECT	ENDP

;	GET DISK LABEL

GET_LABEL	PROC	NEAR
	SET_DTA	BUF
	MOV	DLFCBDR,0
	MOV	DX,OFFSET DLFCB
	SVC	11H			; LOOK FOR DISK LABEL
	OR	AL,AL			; ANY FOUND?
	MOV	SI,OFFSET BUF+8		; ASSUME YES
	MOV	LABFLAG,1
	JZ	MOVLAB			; YES
	MOV	SI,OFFSET NONE		; ELSE USE "NONE"
	MOV	LABFLAG,0
MOVLAB:	MOV	DI,OFFSET DISKLAB	; PUT LABEL HERE
	MOV	CX,11
	CLD
	REP	MOVSB
	RET
GET_LABEL	ENDP

;	UNSORT DIRECTORY (SET POINTERS FOR SORT)

UNSORT	PROC	NEAR
	MOV	AX,OFFSET BA.DIR_ENT_BUF ; POINT TO DIR BUFFER
	MOV	DI,OFFSET BA.DIRPTR	; AND POINTER
	MOV	CX,FILECNT		; GET FILE COUNT
	CLD
UNSLP:	STOSW				; STORE ENTRY ADDRESS
	ADD	AX,17			; MOVE TO NEXT ONE
	LOOP	UNSLP			; CONTINUE TILL DONE
	RET
UNSORT	ENDP

; SHELL-METZNER STRING SORTING ROUTINE
;	ENTRY:  'FILECNT' = NUMBER OF STRINGS TO BE SORTED
;		'DIRPTR'  = START OF POINTER TABLE
;		POINTER TABLE MADE UP OF A SERIES OF 16 BIT ADDRESSES
;		   POINTING TO THE POSITION IN THE DATA TABLE FOR EACH
;		   OF THE ITEMS TO BE SORTED.
;	EXIT:	POINTER TABLE REARRANGED TO POINT TO STRINGS IN
;		ALPHABETICAL ORDER.
;		STRING DATA TABLE IS UNCHANGED.

SORT	PROC	NEAR
	MOV	BX,FILECNT
	CMP	BX,2			;2 OR MORE FILES?
	JNB	SORT1			;YES
	RET				;ELSE NO SORT NEEDED!
SORT1:	MOV	VARM,BX
SETM:	MOV	BX,VARM
	SHR	BX,1
	MOV	VARM,BX			;VARM = VARM / 2 
	CMP	BX,0
	JNZ	NOTEND	
	RET				;IF END OF SORT
NOTEND:	MOV	BX,1
	MOV	VARJ,BX			;VARJ = 1
	MOV	BX,FILECNT
	MOV	DX,VARM
	SUB	BX,DX
	MOV	VARK,BX			;VARK = SCOUNT - VARM
SETI:	MOV	BX,VARJ
	MOV	VARI,BX			;VARI = VARJ
SETL:	MOV	BX,VARI
	MOV	DX,VARM
	ADD	BX,DX
	MOV	VARL,BX			;VARL = VARI + VARM
	CALL	SYMVAL			;BX = START OF DATA POINTED BY VARL
	PUSH	BX
	MOV	BX,VARI
	CALL	SYMVAL
	POP	SI
	MOV	CX,12			;*GET STRING LENGTH
	MOV	DI,BX			;SI AND DI POINT TO START OF STRINGS
	CLD
	REPZ	CMPSB			;COMPARE THE STRINGS
NOMACH:	JNB	SETJ			;IF NO REARRANGEMENT REQUIRED

; SWITCH THE POINTER ADDRESS AT (VARI) WITH THAT AT (VARL)

	MOV	BX,VARI
	CALL	TABADD
	PUSH	BX			;STACK = POINTER DATA FOR (VARI)
	MOV	BX,VARL
	CALL	TABADD			;BX = POINTER DATA FOR (VARL)
	POP	SI
	MOV	AX,[SI]
	MOV	DX,[BX]
	MOV	[SI],DX
	MOV	[BX],AX

; SWITCH COMPLETED

	MOV	BX,VARI
	MOV	DX,VARM
	SUB	BX,DX
	MOV	VARI,BX			;VARI = VARI - VARM
	DEC	BX
	JS	SETJ	
	JMP	SETL			;IF VARI >= 1
SETJ:	MOV	BX,VARJ
	INC	BX
	MOV	VARJ,BX			;VARJ = VARJ + 1
	MOV	DX,VARK
	SUB	DX,BX
	JNB	SETJ0	
	JMP	SETM			;IF VARJ > VARK
SETJ0:	JMP	SETI

; TABADD -- FIND LOCATION OF DATA POINTER IN TABLE
;	ENTRY: BX = INTEGER VALUE ( 1 -> N )
;	EXIT:  BX = ADDR OF TWO BYTE DATA POINTER ( FOR INPUT VALUE )

TABADD:	DEC	BX			;START AT ZERO
	SHL	BX,1			;BX = [(ORIGINAL BX) - 1] * 2
	MOV	DX,OFFSET BA.DIRPTR
	ADD	BX,DX
	RET

; SYMVAL -- FIND DATA RELATED TO INPUT INTEGER VALUE IN ARRAY
;	ENTRY: BX = INTEGER VALUE ( 1 -> N ) POINTING TO DATA ARRAY
;	EXIT:  BX = FWA STRING DATA FOR THAT VALUE

SYMVAL:	CALL	TABADD
	MOV	BX,[BX]
	AND	BX,7FFFH		; REMOVE FLAG BIT
	RET
SORT	ENDP

;	DDECOUT - PRINT 32 BIT NO. IN AX,BX IN DECIMAL
;	AX = HIGH WORD, BX = LOW WORD

DDECOUT	PROC	NEAR
	MOV	SI,0			;CLEAR ZERO SUPPRESS FLAG
	MOV	CX,3B9AH
	MOV	DX,0CA00H		;CX,DX = 1,000,000,000
	CALL	DIVPR			;DIVIDE AND PRINT
	CALL	COMMA			;PRINT A COMMA (IF NO. PRINTED)
	MOV	CX,5F5H
	MOV	DX,0E100H		;CX,DX = 100,000,000
	CALL	DIVPR
	MOV	CX,98H
	MOV	DX,9680H		;CX,DX = 10,000,000
	CALL	DIVPR
	MOV	CX,0FH
	MOV	DX,4240H		;CX,DX = 1,000,000
	CALL	DIVPR
	CALL	COMMA
	MOV	CX,1
	MOV	DX,86A0H		;CX,DX = 100,000
	CALL	DIVPR
	MOV	CX,0
	MOV	DX,10000		;CX,DX = 10000
	CALL	DIVPR
	MOV	CX,0
	MOV	DX,1000			;CX,DX = 1000
	CALL	DIVPR
	CALL	COMMA
	MOV	CX,0
	MOV	DX,100			;CX,DX = 100
	CALL	DIVPR
	MOV	CX,0
	MOV	DX,10			;CX,DX = 10
	CALL	DIVPR
	MOV	AL,BL			;GET ONES DIGIT
	ADD	AL,'0'			;ADD ASCII
	JMP	SCOUT			;PRINT IT AND RETURN
DIVPR:	MOV	DI,-1			;SET A COUNTER
DIVPR1:	INC	DI			;INCREMENT COUNTER
	SUB	BX,DX			;SUBTRACT DIVISOR
	SBB	AX,CX
	JNB	DIVPR1			;REPEAT UNTIL OVERFLOW
	ADD	BX,DX			;ADD DIVISOR BACK IN ONCE
	ADC	AX,CX
	PUSH	AX			;SAVE AX
	MOV	AX,DI			;GET COUNTER (WHICH IS DIGIT)
	ADD	AL,'0'			;ADD ASCII OFFSET
	CMP	SI,0			;CKECK ZERO FLAG
	JNZ	DIVPR2			;PASSED LEADING ZEROS, PRINT NO.
	CMP	AL,'0'			;IS NO. ZERO?
	JZ	DIVPR3			;IF SO, EXIT
	INC	SI			;ELSE, FLAG ZEROS PASSED
DIVPR2:	CALL	SCOUT			;PRINT NO.
DIVPR3:	POP	AX			;RESTORE AX
	RET
COMMA:	CMP	SI,0			;ANY NUMBERS PRINTED?
	JZ	COMMA1			;NO
	PUSH	AX
	MOV	AL,','			;ELSE, PRINT COMMA
	CALL	SCOUT
	POP	AX
COMMA1:	RET
DDECOUT	ENDP

;	SET PARAMETERS FOR PROGRAM LOAD

set_parm	proc	near
	mov	buf,1
	mov	di,offset buf+2
	mov	buf+1,' '		; space separator
	jmp	setprm_getadr
set_parm_cmd:				; special entry for COMMAND.COM parms
	mov	cl,[si]			; requested command first
	mov	buf,cl
	xor	ch,ch
	inc	si
	mov	di,offset buf+1
	CLD
	rep	movsb
setprm_getadr:
	call	get_current
	JNC	SETP1			; GOT CURRENT ADDRESS OK
	RET				; ELSE RETURN
SETP1:	mov	si,dx
setprm_cpy:
	lodsb				; copy in current selection
	cmp	al,0
	je	setprm_cpydon
	stosb
	inc	buf
	jmp	setprm_cpy
setprm_cpydon:
	mov	byte ptr [di],0dh
	OR	AL,AL			; CLEAR CARRY
	ret
set_parm	endp

;	LOAD AND EXECUTE A PROGRAM

load_prog	PROC	NEAR
	PUSH	DX
	MOV	DX,OFFSET LOADX
	MOV	AX,2523H
	INT	21H			; SET CONTROL-C ADDRESS
	POP	DX
	mov	spsave,sp
	mov	bx,offset prog_blk
	mov	al,0
	svc	4bh			; load and execute prog
LOADX:	CLI
	mov	bx,cs
	mov	ds,bx
	mov	es,bx
	mov	ss,bx
	mov	sp,spsave
	STI
	jc	prog_err
	RET
prog_err:
	MOV	DX,OFFSET prog_err_msg
	CALL	DSPMSG
	RET
LOAD_PROG	ENDP

;	DISPLAY CURRENT ENTRY

cur_ent_rev	proc	near
	MOV	DX,OFFSET rev_msg
	CALL	DSPMSG
cur_ent_nrm:
	mov	bx,cur_ent
	shl	bx,1
	shl	bx,1
	mov	cx,4
ent_adr_loop:
	MOV	AL,dir_ent_addr[bx]
	CALL	SCOUT
	inc	bx
	loop	ent_adr_loop
cur_ent_dis:
	mov	BX,cur_ent		; GET CURRENT ENTRY NO.
	ADD	BX,PAGECNT		; ADD PAGE COUNT
	SHL	BX,1			; MPY BY 2
	MOV	BX,WORD PTR BA.DIRPTR[BX] ; GET ENTRY ADDRESS
	AND	BX,7FFFH		; REMOVE FLAG BIT
ent_nam_loop:
	MOV	AL,[BX]
	cmp	al,0
	je	nrm_now
	CALL	SCOUT
	inc	bx
	jmp	ent_nam_loop
nrm_now:
	MOV	DX,OFFSET nrm_msg
	CALL	DSPMSG
	ret
cur_ent_rev	endp
;
;	SHOW SIZE OF CURRENT FILE
;
CUR_ENT_SIZE	PROC	NEAR
	MOV	DX,OFFSET SIZ_MSG
	CALL	DSPMSG			; SAY "FILE SIZE"
	CALL	GET_SIZE		; GET SIZE OF FILE
	CALL	DDECOUT			; PRINT FILE SIZE
CUR_ENT_SIZE	ENDP

GET_SIZE	PROC	NEAR
	mov	SI,cur_ent		; GET CURRENT ENTRY NO.
	ADD	SI,PAGECNT		; ADD PAGE COUNT
	SHL	SI,1			; MPY BY 2
	MOV	SI,WORD PTR BA.DIRPTR[SI] ; GET ENTRY ADDRESS
	AND	SI,7FFFH		; REMOVE FLAG BIT
	MOV	BX,13[SI]		; GET SIZE LOW
	MOV	AX,15[SI]		; GET SIZE HIGH
	RET
GET_SIZE	ENDP

;	return address of current selection

get_current	proc	near
	push	si
	CMP	FLG2FLG,0		; DOING FLAGS?
	JZ	GET1			; NO
	MOV	SI,CUR_ADR		; ELSE, GET FILE ADDRESS PTR.
	PUSH	CX
	MOV	CX,TFCNT		; AND TEMP. COUNT
	OR	CX,CX			; FILES USED UP?
	JZ	GOTEND			; YES
GETLP:	LODSW				; GET ADDRESS
	TEST	AX,8000H		; TEST FOR FLAGGED FILE
	JNZ	GOTFLG			; GOT ONE
	LOOP	GETLP			; LOOP UNTIL END OR ONE FOUND
GOTEND:	POP	CX
	POP	SI
	STC				; NONE FOUND, FLAG END OF FILES
	RET
GOTFLG:	DEC	CX			; COUNT THIS FILE
	MOV	TFCNT,CX		; SAVE COUNT
	POP	CX
	MOV	CUR_ADR,SI		; SAVE FILE PTR ADDRESS
	MOV	DX,AX			; FILE ADDR TO DX
	JMP	SHORT GETX	
GET1:	mov	SI,cur_ent		; GET CURRENT NO.
	ADD	SI,PAGECNT		; ADD PAGE COUNT
	SHL	SI,1			; MPY BY 2
	MOV	DX,WORD PTR BA.DIRPTR[SI]
GETX:	AND	DX,7FFFH		; REMOVE FLAG BIT
	pop	si
	OR	AL,AL			; CLEAR CARRY
	ret
get_current	endp
;
;	get_env_parm - get an environment parameter
;
;		si=addr of string of parm name
;		cx=size of string
;		bx=addr of buffer to contain value
;
;	on return - parm (if found) is in buffer and di
;		    points to nxt chr after it.
;
get_env_parm	proc	near		; get an environment parameter
	push	ds
	push	cx
	push	si
	mov	ds,env_seg		; env addr
	mov	si,0
find_parm:
	pop	di
	pop	cx
	push	cx
	push	di
	cmp	byte ptr [si],0		; end of environment list?
	je	no_parm			;  yes - no parm to copy
	push	si
	rep	cmpsb			; requested identifier?
	je	copy_parm
	pop	si
eos_loop:				;  no - find end of asciz string
	lodsb
	cmp	al,0
	jne	eos_loop
	jmp	find_parm
copy_parm:
	pop	ax			; trash start of parm
	mov	di,bx
copy_parm_loop:
	lodsb
	stosb
	CMP	AL,';'
	JNZ	NOTSEMI
	XOR	AL,AL
NOTSEMI:cmp	al,0
	jne	copy_parm_loop
	dec	di
no_parm:
	pop	si
	pop	cx			; restore regs
	pop	ds
	ret
get_env_parm	endp
;
subdirectory_display	proc	near
	push	cur_ent
	set_dta	buf
	MOV	DX,OFFSET clr_screen
	CALL	DSPMSG
	MOV	DX,OFFSET subdir_hdr
	CALL	DSPMSG
	MOV	AL,cur_disk
	CALL	SCOUT
	MOV	AL,':'
	CALL	SCOUT
	MOV	AL,'\'
	CALL	SCOUT
	mov	si,offset cur_dir
dissubdir:
	lodsb
	cmp	al,0
	je	dissubents
	CALL	SCOUT
	jmp	dissubdir
dissubents:
	mov	cur_ent,0
	MOV	WORD PTR WILDCARD,'.*'
	MOV	WORD PTR WILDCARD+2,'*'	; RESET WILDCARD SPEC.
	mov	dx,offset wildcard
	mov	cx,10h			; search only for directories
	svc	4eh			; get 1st entry
	jnc	dispsubent
nosubs:
	DISPLAY	 no_subfil_msg
	POP	CUR_ENT
	STC				; FLAG NO SUB DIRECTORIES
	RET
subdis_loop:
	svc	4fh			; next entry
	jnc	dispsubent
	cmp	cur_ent,0
	je	nosubs
	jmp	subdir_dis_ret
dispsubent:
	mov	si,offset buf
	test 	[si].attr,10h		; is it a directory?
	jz 	subdis_loop
;
	mov	bx,cur_ent
	shl	bx,1
	shl	bx,1
	mov	cx,4
subadr_lup:
	MOV	AL,dir_ent_addr[bx]
	CALL	SCOUT
	inc	bx
	loop	subadr_lup
subnam_lup:
	mov	al,[si].pname
	cmp	al,0
	je	subent_fin
	CALL	SCOUT
	inc	si
	jmp	subnam_lup
subent_fin:
	inc	cur_ent
	cmp	cur_ent,84
	jbe	subdis_loop
subdir_dis_ret:
	pop	cur_ent
	STC
	CMC				; FLAG SUB DIRECTORIES PRESENT
	ret
subdirectory_display	endp

;	SCOUT - SINGLE CHARACTER OUTPUT

SCOUT:	PUSH	AX
	PUSH	CX
	PUSH	BX
	PUSH	DX
	CMP	Byte Ptr TTYPE,0	; H150?
	JNZ	SCOUT1
	CALL	IBMOUT
	JMP	SCOUT2
SCOUT1:	MOV	DL,AL
	MOV	AH,6
	INT	21H
SCOUT2:	POP	DX
	POP	BX
	POP	CX
	POP	AX
	RET

;	DISPLAY MESSAGE ON SCREEN

DSPMSG:	PUSH	SI
	CLD
	MOV	SI,DX			; SI POINTS TO MSG
DSPMLP:	LODSB				; GET A CHARACTER
	CMP	AL,'$'			; END?
	JZ	DSPMX			; YES
	CALL	SCOUT			; ELSE, DISPLAY CHARACTER
	JMP	DSPMLP
DSPMX:	POP	SI
	RET

;	Z19 CODE TO IBM TRANSLATOR -- WITH THANKS TO BOB METZ

IBMOUT:	JMP	WORD PTR IBMJMP
IBMOUT1:AND	AL,7FH
	CMP	AL,1BH			;ESCAPE?
	JNZ	CRT_OUT			;NO, NORMAL CHAR
	MOV	WORD PTR IBMJMP,OFFSET FIND_CODE	;ELSE, FIND CODE NEXT
IBMRET:	RET				;AND IGNORE ESC

CRT_OUT:OR	AL,AL			;NUL?
	JZ	IBMRET			;IF SO, RETURN
	CMP	AL,9			;TAB?
	JNZ	CRTOT1
	JMP	TAB			;IF SO, PROCESS IT HERE
CRTOT1:	CMP	AL,' '			;LET WRT TTY DO CONTROL
	JB	WRT_TTY
	CMP	BYTE PTR GRAFLG,0	;GRAPHICS MODE?
	JE	SCREEN_OUT		; NO - NORMAL
	CMP	AL,5EH			; YES - GRAPHICS CHR?
	JB	SCREEN_OUT
	CMP	AL,7EH		
	JA	SCREEN_OUT
	SUB	AL,5EH
	MOV	BX,OFFSET IBMGRPH
	XLAT
SCREEN_OUT:
	MOV	AH,9
	MOV	BL,ATTRI
	MOV	BH,0			;WRITE CHR W/ ATTRIIBUTE
	MOV	CX,1
	INT	10H
	JMP	CURRT			;MOVE CURSOR OVER
WRT_TTY:CMP	AL,10			;LF?
	JNE	WRT_TTY1
	MOV	AH,3			; YES, GET CURSOR POSITION
	MOV	BH,0
	INT	10H
	MOV	AL,10
	CMP	DH,23			;IF LINE <24 THEN NORMAL LF
	JL	WRT_TTY1
	JE	SCROL_24		;IF LINE = 24 THEN SCROLL 1-24
	RET				;IF LINE = 25 THEN IGNORE LF
SCROL_24:
	MOV	AX,601H
	MOV	CX,0
	MOV	DH,23
	MOV	DL,79
	MOV	BH,ATTRI
	INT	10H
	RET
WRT_TTY1:MOV	AH,14			; WRITE TTY TO SCREEN
	MOV	BL,ATTRI 
	MOV	BH,0
	INT	10H
	RET
;
FIND_CODE:
	MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	MOV	BX,OFFSET CODETABLE
FIND_LP:CMP	BYTE PTR [BX],0		;END OF TABLE?
	JNE	CHKIT			; NO
	RET				; YES - IGNORE ESC SEQUENCE
CHKIT:	CMP	AL,[BX]	
	JE	PROCESSIT
	ADD	BX,3			;NOT THIS ENTRY - CHECK NXT
	JMP	FIND_LP
PROCESSIT:
	JMP	WORD PTR 1[BX]		;ENTER ESC SEQ PROCESSOR

;	ESCAPE SEQUENCE PROCESSORS

;	RESET SCREEN

IBMRST:	MOV	BYTE PTR ATTRI,7	;RESET ATTRIBUTE
	MOV	BYTE PTR GRAFLG,0	;GRAPHIC MODE OFF
	MOV	AH,5
	MOV	AL,0			;ACTIVE PAGE IS 0
	INT	10H
	MOV	AX,600H
	MOV	BH,ATTRI		;GET ATTRIBUTE
	MOV	CX,0
	MOV	DH,24			;CLEAR SCREEN
	MOV	DL,79
	INT	10H
	JMP	HOME

GRAFON:	MOV	BYTE PTR GRAFLG,1	;GRAPHIC MODE ON
	RET
GRAFOF:	MOV	BYTE PTR GRAFLG,0	;GRAPHIC MODE OFF
	RET

REVIND:	MOV	AH,3			;REVERSE INDEX
	MOV	BH,0
	INT	10H			;GET CURSOR LOCATION
	CMP	DH,0			;LINE 1?
	JNZ	CURUP			;NO
	MOV	AX,701H			;ELSE, SCROLL DOWN
	MOV	CX,0
	MOV	DH,23
	MOV	DL,79
	MOV	BH,ATTRI
	INT	10H
	RET

;	CURSOR ADDRESSING

DOADR:	MOV	WORD PTR IBMJMP,OFFSET GETROW	;NEXT CHAR IS ROW
	RET
GETROW:	MOV	SAV_ROW,AL			;SAVE ROW
	MOV	WORD PTR IBMJMP,OFFSET GETCOL	;NEXT CHAR IS COLUMN
	RET
GETCOL:	MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	MOV	DH,SAV_ROW
	MOV	DL,AL				;AL = COLUMN
	SUB	DX,'  '			;CONVERT TO 0 BASE
SETCURS:MOV	AH,2
	MOV	BH,0
	INT	10H			;SET CURSOR POSITION CALL
	RET
;
CURUP:	MOV	AH,3			;CURSOR UP
	MOV	BH,0
	INT	10H			;GET CURRENT POS
CURUP1:	DEC	DH
	CMP	DH,0
	JAE	SETCURS
	INC	DH			;DON'T ALLOW TO GO OFF SCREEN
	JMP SHORT SETCURS
;
CURDWN:	MOV	AH,3			;CURSOR DOWN
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
CURDWN1:CMP	DH,24			;AT BOTTOM LINE?
	JZ	CURDWN2			;IF SO, NO SCROLL
	INC	DH
	CMP	DH,23
	JLE	SETCURS
CURDWN2:RET
;
TAB:	MOV	AH,3			;PROCESS TABS
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	ADD	DL,8
	AND	DL,0F8H			;MOV TO NEXT TAB STOP
	JMP SHORT CURRT1
;
CURRT:	MOV	AH,3			;CURSOR RIGHT
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	INC	DL
CURRT1:	CMP	DL,79
	JBE	SETCURS
	RET				;CURSOR IN LAST COLUMN
;
CURLFT:	MOV	AH,3			;CURSOR LEFT
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	DEC	DL
	CMP	DL,0
	JAE	SETCURS
	RET				;CURSOR IN FIRST COLUMN

HOME:	MOV	DX,0			;HOME CURSOR
	JMP	SETCURS
;
DOCLR:	MOV	AX,600H			;CLEAR SCREEN
	MOV	BH,ATTRI
	MOV	CX,0			;ERASE LINES 1-24,COLS 1-80
	MOV	DH,23
	MOV	DL,79
	INT	10H
	JMP SHORT HOME
;
ERSEOL:	MOV	AH,3			;ERASE TO END OF LINE
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	MOV	AX,600H
	MOV	BH,ATTRI
	MOV	CX,DX
	MOV	DL,79
	INT	10H
	RET
;
ERSEOS:	MOV	AH,3			;ERASE TO END OF SCREEN
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	MOV	AX,600H
	MOV	BH,ATTRI		;ERSEOL FIRST
	MOV	CX,DX
	MOV	DL,79
	PUSH	CX			;SAVE CURSOR POSITION
	INT	10H
	POP	CX
	MOV	DH,23
	MOV	DL,79
	CMP	CH,23
	JE 	ERS_RET
	INC	CH
	MOV	AX,600H
	MOV	BH,ATTRI
	INT	10H
ERS_RET:RET

ERSLIN:	MOV	AH,3			;ERASE LINE
	MOV	BH,0
	INT	10H			;GET CURRENT LOCATION
	MOV	CX,DX
	MOV	CL,0
	MOV	DL,79
	MOV	AX,0600H		;SCROLL REGION (SINGLE LINE) CLEAR
	MOV	BH,ATTRI
	INT	10H
	RET
;
SAVCRS:	MOV	AH,3			;SAVE CURSOR POSITION
	MOV	BH,0
	INT	10H
	MOV	CURSAV,DX
	RET
;
RSTCRS:	MOV	DX,CURSAV		;RESTORE CURSOR POSITION
	JMP	SETCURS
;
DOREV:	MOV	BYTE PTR ATTRI,HICODE 	;REV. VIDEO
	RET
;
DONRM:	MOV	BYTE PTR ATTRI,7	;NOR. VIDEO
	RET

RESMOD:	MOV	WORD PTR IBMJMP,OFFSET RESMOD1	; GET NEXT CHAR
	RET
RESMOD1:MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	; RESET JUMP
	CMP	AL,'5'			; RESTORE CURSOR?
	JZ	CURON			; YES
	RET				; ELSE, IGNORE
CURON:	MOV	AH,1
	MOV	CX,CURTYPE
	INT	10H			; RESTORE CURSOR
	RET

IGNORE:	MOV	WORD PTR IBMJMP,OFFSET IGNORE1	;IGNORE NEXT CHAR
	RET
IGNORE1:MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	RET

IBMJMP	DW	IBMOUT1			;JUMP INTO CODE
GRAFLG	DB	0			;GRAPHICS MODE FLAG
ATTRI	DB	7  			;DEFAULT ATTRIBUTE (WHITE ON BLACK)
SAV_ROW	DB	0			;SAVED ROW POSITION
CURSAV	DW	0			;SAVED CURSOR POSITION
;
CODETABLE:				;ESC SEQUENCE PROCESSOR TABLE
	DB	'Y'
	DW	OFFSET DOADR
	DB	'E'
	DW	OFFSET DOCLR
	DB	'F'
	DW	OFFSET GRAFON
	DB	'G'
	DW	OFFSET GRAFOF
	DB	'J'
	DW	OFFSET ERSEOS
	DB	'K'
	DW	OFFSET ERSEOL
	DB	'A'
	DW	OFFSET CURUP
	DB	'B'
	DW	OFFSET CURDWN
	DB	'C'
	DW	OFFSET CURRT
	DB	'D'
	DW	OFFSET CURLFT
	DB	'H'
	DW	OFFSET HOME
	DB	'I'
	DW	OFFSET REVIND
	DB	'l'
	DW	ERSLIN
	DB	'p'
	DW	OFFSET DOREV
	DB	'q'
	DW	OFFSET DONRM
	DB	'j'
	DW	OFFSET SAVCRS
	DB	'k'
	DW	OFFSET RSTCRS
	DB	'x'
	DW	OFFSET IGNORE
	DB	'y'
	DW	OFFSET RESMOD
	DB	'z'
	DW	OFFSET IBMRST
	DB	0			;END OF TABLE
;
;      Z-100 to IBM PC graphic chr xlat table
;	only locs 5eh to 7eh are present    
;
IBMGRPH	LABEL	BYTE
	db	0f9h	; ^
	db	0dbh	; _
	db	0b3h	; `
	db	0c4h	; a
	db	0c5h	; b
	db	0bfh	; c
	db	0d9h	; d
	db	0c0h	; e
	db	0dah	; f
	db	0f1h	; g
	db	01ah	; h
	db	0b0h	; i
	db	0f6h	; j
	db	019h	; k
	db	0dah	; l
	db	0bfh	; m
	db	0d9h	; n
	db	0c0h	; o
	db	0dfh	; p
	db	0deh	; q
	db	0dbh	; r
	db	0c2h	; s
	db	0b4h	; t
	db	0c1h	; u
	db	0c3h	; v
	db	058h	; w
	db	02fh	; x
	db	05ch	; y
	db	0dfh	; z
	db	0dch	; {
	db	0ddh	; |
	db	0deh	; }
	db	014h	; ~
	db	0dbh	; del
;
BA:					; BUFFER AREA
BUFF		STRUC
		db	256 dup (?)
stack		DB	?
linebuf		db	128 dup (?)
DIRPTR		DB	2*512 DUP (?)	; DIRECTORY ENTRY POINTER
dir_ent_buf	db	17*512 dup (?)  ; ROOM FOR 512 ENTRIES
endcod		DB	?
BUFF		ENDS
filemgmt	ends
	end	start
                                  