	TITLE	ZBASIC VARIABLE CROSS REFERENCE
	PAGE	,132
;	ZBREF.ASM
;	BASIC Variables Cross Reference Utility
;	for Z-DOS ZBASIC (and MBASIC 5.2X)
; This program will scan a BASIC program for variables used
; and will print all the line numbers the variable is
; referenced in.  A maximum of 255 variables may be
; handled.  If a variable is referenced more than 56 times,
; an additional space in the variable array is used for
; each additional 56 references, or part thereof.  Those
; references figure in the maximum allowable count.
; Variables to a length of 14 characters may be processed.
; 60 variables are allowed to be contained in one logical
; BASIC source line before an overflow occurs.
;
; To run the program type: ZBREF <dev:>Filename
; If no filetype is given, it is assumed to be .BAS.
; The source file must be an ASCII type.
;
; No origination for the SORT routine is claimed.
; (But it's a simple bubble sort, so who cares?)
;
; Written AUG/82
;
; AUTHOR: R. DANIEL
;	  HUEGLSTR. 21
;	  6143 LORSCH
;	  W - Germany
;
;	Z-DOS VERSION BY P. SWAYNE, HUG  23-APR-84
;
;	MODIFIED BY P. SWAYNE, HUG  27-JUN-83
;		--> IF A VARIABLE OCCURS MORE THAN ONCE ON A LINE
;			THE LINE NO. IS PRINTED ONLY ONCE.
;		--> ALLOWS SPECIFIED FILE TYPE.  ASSUMES .BAS
;			ONLY IF NO FT GIVEN.
;		--> ALLOWS AS MANY VARIABLES AS THERE IS ROOM
;			IN MEMORY.
;		--> USES LSTOUT INSTEAD OF IOBYTE TO PRINT.
;		--> ALLOWS VARIABLES WITH IMBEDED RESERVED WORDS,
;			SUCH AS "REMOTE" OR "IFIT".
;		--> ARRAY ELEMENT SIZE REDUCED TO 128 BYTES, AND
;			VARIABLES FILLING ONE ELEMENT WITH REF-
;			ERENCES ARE ALLOWED TO SPILL OVER INTO
;			OTHER ELEMENTS.
;
; Printer output modified slightly by:
;		Terry L. Jensen
;		Heath Users' Group
;
M	EQU	Byte Ptr 0[BX]		;MEMORY POINTER
VERSN	EQU	3			;16-BIT VERSION
MODIF	EQU	0

CONINP	EQU	1			;CONSOLE INPUT
CONOUT	EQU	2			;CONSOLE OUTPUT
LSTOUT	EQU	5			;LIST OUTPUT
READCN	EQU	10			;READ CONSOLE BUFFER
OPENF	EQU	15			;OPEN FILE
READF	EQU	20			;READ FILE
SETDMA	EQU	26			;SET DMA ADDRESS

CR	EQU	0DH			;CARRIAGE RETURN
LF	EQU	0AH			;LINE FEED
EOL	EQU	80H			;END OF A LINE
TAB	EQU	9			;TAB CHARACTER
ESC	EQU	27			;ESCAPE CHARACTER
BELL	EQU	7			;BELL CHARACTER
FF	EQU	0CH			;FORMFEED

VARLN	EQU	15			;MAX. LENGTH OF VARIABLE (14 CHARS+EOL)
VARMAX	EQU	60			;MAXIMUM NUMBER OF VARIABLES IN 'WORK'
NUMMAX	EQU	8			;NUMBER OF LINE NUMBERS/PRINT LINE
LINMAX	EQU	56			;NUMBER OF LINES OF VARIABLES/PAGE

ARRNUM	EQU	15			;NUMBER OF LINE-NUMBERS IN THIS LINE
ARRLIN	EQU	16			;PLACE OF FIRST LINE-NUMBER IN THIS LINE

XREF	SEGMENT
	ASSUME	CS:XREF,DS:XREF,ES:XREF,SS:XREF
	ORG	0
Z	LABEL	NEAR			;ZERO POINTER
	ORG	5CH
FCB	LABEL	NEAR			;FILE CONTROL BLOCK ADDRESS
	ORG	(Offset FCB)+1
FCBFN	LABEL	NEAR			;FILE NAME IN FCB
	ORG	(Offset FCB)+9
FCBFT	LABEL	NEAR			;FILE TYPE IN FCB
	ORG	(Offset FCB)+12
FCBRL	LABEL	NEAR			;BLOCK NUMBER
	ORG	(Offset FCB)+14
FCBRS	LABEL	NEAR			;RECORD SIZE
	ORG	(Offset FCB)+32
FCBCR	LABEL	NEAR			;RECORD COUNT
	ORG	80H
BUFF	LABEL	NEAR			;DISK INPUT BUFFER ADDRESS

	ORG	100H

START:	MOV	AX,CS
	MOV	DS,AX			;PUT DS HERE
	CLI
	MOV	SS,AX			;PUT SS HERE
	MOV	SP,(Offset STACK)	;SET UP LOCAL STACK
	STI
	MOV	AL,Byte Ptr FCBFN	;GET FILE NAME FIRST CHAR
	CMP	AL,' '			;ANY GIVEN?
	JNZ	GOTFN			;YES
	CALL	TYPTX
	DB	CR,LF,'ERROR - No file specified.',CR,LF+EOL
	JMP	FINIS
GOTFN:	CALL	TYPTX
	DB	27,'Z'+80H		;ASK TERMINAL TYPE
	MOV	CX,50			;SET A COUNTER
WFCHR:	MOV	AH,0BH
	INT	21H			;TEST FOR REPLY
	OR	AL,AL
	JNZ	GOTCHR			;GOT REPLY
	LOOP	WFCHR			;ELSE, TRY AGAIN
GOTCHR:	MOV	AX,0C00H
	INT	21H			;FLUSH TYPE-AHEAD
	MOV	Byte Ptr CTYPE,CL	;SAVE COMPUTER TYPE (0 IF IBM)
	MOV	BX,Offset FCBFT
	MOV	AL,M
	CMP	AL,' '			;NO FILE TYPE?
	JNZ	START0			;NO, HE SPECIFIED ONE
	MOV	M,'B'			;ELSE, USE .BAS
	INC	BX
	MOV	M,'A'
	INC	BX
	MOV	M,'S'
START0:	MOV	BX,Word Ptr FCBFT
	MOV	Word Ptr HDR3+1,BX	;UPDATE HEADER MSG.
	MOV	AL,Byte Ptr FCBFT+2
	OR	AL,EOL
	MOV	Byte Ptr HDR3+3,AL
	MOV	BX,0FFH			;PREPARE TO TEST MEMORY
MEMLP:	DEC	BH
	MOV	AL,Byte Ptr [BX]	;GET A BYTE
	INC	Byte Ptr [BX]		;TRY TO CHANGE MEMORY
	CMP	AL,Byte Ptr [BX]	;TEST
	MOV	Byte Ptr [BX],AL	;REPLACE THE BYTE
	JZ	MEMLP			;NO CHANGE, IT'S NOT RAM
	MOV	CX,(Offset ARRAY)
	SUB	BX,CX			;SUBTRACT ARRAY ADDRESS
	MOV	AL,BH
	MOV	Byte Ptr MAXVAR,AL	;SAVE MAX VARIABLE SPACE ALLOWED

; PRINT INTRODUCTION

	CMP	Byte Ptr CTYPE,0		;IBM?
	JNZ	Z1001
	MOV	AH,5
	MOV	AL,0			;ACTIVE PAGE IS 0
	INT	10H
	MOV	AX,600H			;AH = SCROLL, AL = ZERO LINES
	MOV	BH,7			;WHITE ON BLACK
	MOV	CX,0			;START ROW, COLUMN
	MOV	DX,24*256+79		;END ROW, COLUMN
	INT	10H			;CLEAR SCREEN
	MOV	AH,2
	MOV	DX,0			;HOME CURSOR
	MOV	BH,0
	INT	10H
	JMP	SHORT IBM1
Z1001:	CALL	TYPTX
	DB	ESC,'E'+EOL		;CLEAR SCREEN
IBM1:	MOV	BX,(Offset HEADER)
	CALL	TYPT1

; INITIALIZE FOR 1ST FILE READING

START1:	XOR	AL,AL
	MOV	Byte Ptr INITFG,AL	;FLAG AS 1ST READING
	MOV	Byte Ptr ALLBLK,AL	;AND MEMORY SPACE NOT OVERFLOWED
	MOV	BX,(Offset BUFFER)	;SET START ADDRESS
	MOV	Word Ptr MEMPTR,BX	;OF DESTINATION OF FILE
	CALL	OPFILE			;TRY TO OPEN THE FILE
	MOV	Byte Ptr FCBCR,0	;CLEAR CURRENT RECORD
	MOV	Word Ptr FCBRL,0	;AND BLOCK NO.
	MOV	Word Ptr FCBRS,1	;SET RECORD SIZE TO 1 BYTE

START2:	CALL	MAP			;PROCESS THE FILE
	CMP	Byte Ptr CTYPE,0
	JZ	IBM2
	CALL	TYPTX
	DB	ESC,'y5',EOL		;TURN CURSOR ON

; WE RETURN HERE AT END OF FILE (CTRL-Z) FROM MAP1

IBM2:	CALL	SRTALL			;SORT AND DISPLAY FILE
RETURN	EQU	(Offset $)		;RETURN ADDRESS FOR REPEAT PRINT OUT

; FILE ALL PROCESSED, CHECK IF TO REPEAT

	CALL	TYPTX
	DB	CR,LF,'Do you want to output the '
	DB	'listing again (Y/N) <N> ? ',EOL
	CALL	GETCHR
	AND	AL,5FH			;CAPITALIZE
	CMP	AL,'Y'
	JZ	NEW
	JMP	FINIS

; INITIALIZE FOR MULTIPLE READING OF FILE

NEW:	MOV	AL,Byte Ptr ALLBLK	;HAD NEEDED ALL MEMORY?
	OR	AL,AL			;NOT IF ZERO
	JZ	START3			;SO DON'T READ DISK AGAIN
	MOV	Byte Ptr FCBCR,0	;CLEAR CURRENT RECORD
	MOV	Word Ptr FCBRL,0	;AND BLOCK NO.
	JMP	START1
START3:	MOV	BX,(Offset RETURN)	;PUSH RETURN ADDRESS
	PUSH	BX			;ON STACK
	JMP	DONES			;DO FILE AGAIN

; ZERO ARRAY

MAP:	MOV	BX,0
	MOV	Word Ptr LOGLIN,BX	;ZERO SOURCE LINE COUNTER
	MOV	Word Ptr BYTECT,BX	;ZERO SOURCE BYTE COUNTER
	MOV	DI,(Offset ARRAY)
	MOV	CH,Byte Ptr MAXVAR	;GET MAX VARIABLE SPACE ALLOWED
	DEC	CH
	MOV	CL,0			;BC = BYTES IN ARRAY
	PUSH	DS
	POP	ES			;ENSURE ES HERE
	CLD
	XOR	AL,AL			;GET A ZERO
	REP	STOSB			;ZERO ARRAY

; SET UP TO MOVE A LINE AT A TIME INTO MAPBUF

	CMP	Byte Ptr CTYPE,0
	JZ	IBM3
	CALL	TYPTX
	DB	ESC,'x','5'+80H		;TURN OFF CURSOR
IBM3:	CALL	TYPTX
	DB	CR,LF,LF,'Scanning Source File',CR,LF+EOL

	XOR	AL,AL
	MOV	Byte Ptr ARRIND,AL	;NO ARRAY LINES IN USE YET
	MOV	Byte Ptr VARCNT,AL	;CLEAR ACTUAL COUNT
MAP1:	CALL	MVMAP			;GET A LINE INTO MAP BUFFER
	CMP	AL,1AH			;EOF?
	JNZ	MAP1A	
	RET				;YES, AT FILE END
MAP1A:	MOV	CH,Byte Ptr MAXVAR	;GET MAX VARIABLES
	MOV	AL,Byte Ptr ARRPTR	;GET VARIABLE ARRAY END POINTER
	CMP	AL,CH			;AT MAX?
	JB	MAPOK			;NO, GO AHEAD
	CALL	TYPTX			;ELSE, ERROR
	DB	CR,LF,'ERROR - Not enough memory to do '
	DB	'the whole program!',CR,LF+EOL
	RET

MAPOK:	MOV	BX,(Offset MAPBUF)	;POINT TO 1ST DATA
	MOV	AL,M			;GET 1ST CHAR
	CMP	AL,EOL			;IF END MARKER THEN IS A 'NULL LINE'
	JZ	MAP1			;SO IGNORE THIS LINE (SHOULDN'T HAPPEN)
	MOV	Byte Ptr VARFLG,1	;FLAG 'NO VARIABLE'
	MOV	DI,(Offset WORK)	;CLEAR WORK BUFFER
	PUSH	DS
	POP	ES
	MOV	CX,3			;ZERO 3 PLACES	(SET VARNUM=0)
	XOR	AL,AL
	REP	STOSB
	MOV	CX,WORKLN-3		;FILL REMAINDER WITH SPACES
	MOV	AL,' '
	REP	STOSB

; EVALUATE CURRENT LINE, EXTRACT LINE NUMBER AND VARIABLES

	MOV	BX,(Offset MAPBUF)	;BEGIN OF STRING
	CALL	DECML			;EXTRACT LINE NUMBER, HOLD IN 'TERM'
	MOV	Word Ptr MAPPTR,BX	;SAVE POINTER TO NEXT CHAR IN LINE
	MOV	BX,Word Ptr TERM
	MOV	Word Ptr WORK,BX	;MOVE NUMBER
	CALL	TYPTX
	DB	'at Line Number:',' '+EOL
	CALL	OUTDEC			;DISPLAY CURRENTLY SCANNED LINE #
	CALL	TYPTX
	DB	13+80H
	INC	Word Ptr LOGLIN		;UPDATE SOURCE LINE COUNT

MAP2:	CALL	FNDWRD			;ENTER HERE AGAIN UNTIL LINE IS SCANNED
	CMP	AL,EOL			;DID WE REACH END OF LINE OR REMARK?
	JZ	MAP3			;SKIP IF SO
	CALL	MVVAR			;MOVE VARIABLE
	CMP	AL,EOL			;ERROR TRAPPING FOR TOO MANY VARIABLES
	JZ	MAP3			;IF TOO MANY
	JMP SHORT MAP2

; MOVE VARIABLES AND LINE NUMBERS INTO ARRAY
;	LINE-NUMBER IS IN 'WORK' (1ST TWO BYTES)

MAP3:	CMP	Byte Ptr VARFLG,0	;ANYTHING IN 'WORK'?
	JZ	MAP30
	JMP	MAP1			;NOTHING TO MOVE THEN

; POINT BX TO START LOCATIONS OF THE VARIABLES

MAP30:	MOV	AL,Byte Ptr VARNUM	;GET # OF VARIABLES
	MOV	Byte Ptr VARIND,AL	;SAVE # VARIABLES
	XOR	AL,AL
	MOV	Byte Ptr VARNUM,AL	;ZERO COUNT
MAP31:	MOV	AL,Byte Ptr VARNUM
	CALL	SETLOC			;GET OFFSET TO CURRENT VARIABLE
	CALL	ARSCAN			;SCAN ARRAY FOR MATCH
	MOV	AL,Byte Ptr ARRIND
	OR	AL,AL			;TOO MANY VARIABLES?
	JNZ	MAPOK1			;NO
	DEC	AL			;ELSE, SUBTRACT ONE
	MOV	Byte Ptr ARRIND,AL
	DEC	Byte Ptr VARCNT		;ALSO DECREMENT ACTUAL COUNT
	CALL	TYPTX
	DB	CR,LF,'ERROR - Too many variables in this '
	DB	'program.',CR,LF+EOL
	RET

MAPOK1:	MOV	CH,Byte Ptr VARIND	;NUMBER OF VARIABLES
	MOV	AL,Byte Ptr VARNUM
	INC	AL
	MOV	Byte Ptr VARNUM,AL
	CMP	AL,CH			;ALL VARIABLES PROCESSED?
	JNZ	MAP31			;NO
	JMP	MAP1

; SORT THE VARIABLES IN THE ARRAY

SRTALL:	MOV	CL,Byte Ptr ARRIND	;NUMBER TO SORT. INIT ORDER TABLE
	XOR	CH,CH
	OR	CL,CL			;ANY VARIABLES?
	JZ	DONES			;NO, EXIT
	MOV	BX,(Offset MAPBUF)	;USED AS ORDER TABLE
	MOV	DX,(Offset ARRAY)	;TABLE ADDRESS
	MOV	AX,128			;LENGTH OF EACH ENTRY

; BUILD THE ORDER TABLE

BLDORD:	MOV	[BX],DX			;SAVE ORDER ADDR
	INC	BX			;MOVE TO NEXT PLACE IN TABLE
	INC	BX
	ADD	DX,AX			;POINT TO NEXT ENTRY
	LOOP	BLDORD			;LOOP UNTIL DONE
	MOV	AL,Byte Ptr ARRIND	;GET COUNT OF LINES
	MOV	Byte Ptr SCOUNT,AL	;SAVE AS NUMBER TO SORT
	DEC	AL			;ONLY 1 ENTRY?
	JZ	DONES			;NOTHING TO SORT

SORT:	XOR	AL,AL
	MOV	Byte Ptr SWITCH,AL	;FLAG NONE SWITCHED
	MOV	AL,Byte Ptr SCOUNT	;GET COUNT
	DEC	AL			;USE 1 LESS
	MOV	Byte Ptr TEMP,AL	;SAVE NUMBER TO COMPARE
	MOV	Byte Ptr SCOUNT,AL	;SAVE HIGHEST ENTRY
	JZ	DONES			;EXIT IF ALL DONE
	MOV	BX,(Offset MAPBUF)	;POINT TO ORDER TABLE
SORTLP:	CALL	COMPR			;COMPARE TWO ENTRIES
	JNS	SORT1
	CALL	SWAP			;SWAP IF NOT IN ORDER
SORT1:	INC	BX
	INC	BX
	MOV	AL,Byte Ptr TEMP	;GET COUNT
	DEC	AL
	MOV	Byte Ptr TEMP,AL
	JNZ	SORTLP			;IF NOT DONE

; ONE PASS OF SORT IS DONE

	MOV	AL,Byte Ptr SWITCH	;ANY SWAPS DONE?
	OR	AL,AL
	JNZ	SORT

; SORT IS ALL DONE, SET UP POINTER TO 1ST ADDRESS

DONES:	MOV	BX,(Offset MAPBUF)	;POINT TO ORDER TABLE
	MOV	Word Ptr NEXTT,BX	;STORE POINTER

; ASK FOR SELECTION OF OUTPUT DEVICE

	MOV	AL,CONOUT
	MOV	Byte Ptr PRIFLG,AL	;EXPECT CRT
	MOV	BX,0
	MOV	Word Ptr PAGNUM,BX
	CALL	TYPTX
	DB	CR,LF,LF,'Cross Reference List now ready '
	DB	'for output',CR,LF,'Do you want to use the '
	DB	'Printer (Y/N) <CRT> ? ',EOL
	CALL	GETCHR
	PUSH	AX
	CALL	CRLF
	POP	AX
	AND	AL,5FH
	CMP	AL,'Y'			;PRINTER?
	JNZ	ARROUT			;NO
PRINT:	MOV	AL,LSTOUT
	MOV	Byte Ptr PRIFLG,AL	;SET PRINT FLAG TO LSTOUT

; PRINT OUT ARRAY

ARROUT:	MOV	AL,Byte Ptr PRIFLG
	CMP	AL,LSTOUT		;PRINTER
	JNZ	ARR01			;NO
	CALL	HDR			;ELSE PRINT A HEADER
ARR01:	MOV	AL,Byte Ptr ARRIND
	OR	AL,AL
	JNZ	ARR01A
	JMP	FPRINT			;NO VARIABLES
ARR01A:	MOV	CH,AL			;NUMBER OF LINES TO PRINT
ARR02:	MOV	BX,Word Ptr NEXTT	;GET ORDER TABLE POINTER
	MOV	DX,[BX]			;GET ADDRESS
	INC	BX
	INC	BX
	MOV	Word Ptr NEXTT,BX	;SAVE NEXT TABLE ADDRESS POINTER
	XCHG	BX,DX			;MOVE ADDRESS TO HL

; PRINT THE VARIABLE

	PUSH	BX			;START OF VARIABLE IN CURRENT ARRAY LINE
	MOV	AL,NUMMAX
	MOV	Byte Ptr NUMCNT,AL	;SET COUNTER FOR LINE NUMBERS TO PRINT/LINE
	MOV	AL,Byte Ptr PRIFLG
	CMP	AL,LSTOUT		;CHECK IF PRINTER
	JNZ	ARR03			;NO
	DEC	Byte Ptr LINCNT		;COUNT THIS LINE
	JNZ	ARR03			;FULL PAGE NOT PRINTED
	MOV	AL,FF
	CALL	PCHAR			;EJECT PAGE
	CALL	HDR			;PRINT A HEADER
ARR03:	CALL	CRLF			;START A NEW LINE
	MOV	DX,(Offset OLDVAR)	;POINT TO OLD VARIABLE
	MOV	CL,14			;COMPARE 14 CHARACTERS
	CALL	MATCH			;CHECK FOR MATCH
	JNZ	ARR04			;NO MATCH, PRINT VARIABLE
	DEC	Byte Ptr VARCNT		;ELSE, DECREMENT ACTUAL COUNT
	CALL	TYPTX			;SPACE OVER SKIPPED VAR.
	DB	'             ',' '+EOL
	JMP SHORT ARR05			;AND DON'T PRINT VARIABLE
ARR04:	POP	BX			;RESTORE VARIABLE ADDRESS
	PUSH	BX			;SAVE AGAIN
	CALL	TYPT1			;PRINT VARIABLE
	MOV	BX,0
	MOV	Word Ptr OLDNUM,BX	;CLEAR OLD NUMBER
	POP	BX
	PUSH	BX
	MOV	DX,(Offset OLDVAR)
	XCHG	BX,DX
	CALL	VARMOV			;SAVE LATEST VARIABLE
ARR05:	POP	BX
	CALL	TYPTX
	DB	'  ',' '+EOL

; PRINT THE LINE NUMBERS REFERENCING THE VARIABLE

	ADD	BL,(Offset ARRNUM)	;ADD OFFSET TO LINE NUMBER COUNT
	MOV	CL,M			;LINE NUMBERS TO PRINT TO C
	INC	BX			;MOVE TO LOCATION OF 1ST LINE NUMBER (ARRLIN)
ARR06:	PUSH	BX			;SAVE PLACE
	MOV	BX,[BX]			;MOVE LINE NUMBER TO BX INDIRECT
	MOV	DX,Word Ptr OLDNUM	;GET PREVIOUS NUMBER
	CMP	BX,DX			;COMPARE THE TWO
	JNZ	ARR07			;NOT SAME NOS., PRINT
	POP	BX
	DEC	CL			;COUNT THIS ONE
	JZ	ARR10			;ALL NUMBERS ACCOUNTED FOR
	JMP SHORT ARR09
ARR07:	MOV	Word Ptr OLDNUM,BX	;ELSE UPDATE OLD NUMBER
	CALL	OUTDEC			;PRINT THE NUMBER
	POP	BX			;RESTORE POINTER
	CALL	TYPTX			;ADD THREE SPACES
	DB	'  ',' '+EOL
	DEC	CL			;ALL LINE NUMBERS PRINTED?
	JZ	ARR10			;YES, SKIP
	MOV	AL,Byte Ptr NUMCNT	;CHECK IF ENOUGH NUMBERS IN CURRENT LINE
	DEC	AL
	MOV	Byte Ptr NUMCNT,AL
	JNZ	ARR09			;NOT ENOUGH YET
	MOV	AL,NUMMAX		;RESET COUNT
	MOV	Byte Ptr NUMCNT,AL
	MOV	AL,Byte Ptr PRIFLG
	CMP	AL,LSTOUT		;PRINTER?
	JNZ	ARR08			;NO
	MOV	AL,Byte Ptr LINCNT
	DEC	AL
	MOV	Byte Ptr LINCNT,AL
	OR	AL,AL			;FULL PAGE PRINTED?
	JNZ	ARR08			;NO
	MOV	AL,FF
	CALL	PCHAR			;ELSE FORMFEED
	CALL	HDR			;PRINT A HEADER
ARR08:	CALL	TYPTX
	DB	CR,LF,'        '
	DB	'         ',EOL
ARR09:	INC	BX			;MOVE POINTER TO NEXT LINE NUMBER
	INC	BX
	JMP	ARR06			;AND PRINT NEXT
ARR10:	DEC	CH			;ALL ARRAY LINES PRINTED?
	JZ	FPRINT			;YES, EXIT
	JMP	ARR02			;ELSE MOVE TO NEXT ARRAY LINE

; FINISH UP PRINTOUT

FPRINT:	MOV	AL,Byte Ptr PRIFLG
	CMP	AL,LSTOUT		;PRINTER?
	JNZ	FPRIN1			;NO
	MOV	AL,Byte Ptr LINCNT	;ELSE GET LINE COUNTER
	CMP	AL,7			;LESS THAN 7 LINES
	JNB	FPRIN1			;NO, GO ON
	MOV	AL,FF			;ELSE, FEED PAGE
	CALL	PCHAR
FPRIN1:	CALL	TYPTX
	DB	CR,LF,LF,'        Number of Variables:'
	DB	'            ',EOL
	MOV	AL,Byte Ptr VARCNT	;GET NUMBER OF VARIABLES (ARRAY LINES)
	MOV	BL,AL			;TO L
	MOV	BH,0
	CALL	OUTDEC
	CALL	TYPTX
	DB	CR,LF,'        Number of Logical Lines:'
	DB	'        ',EOL
	MOV	BX,Word Ptr LOGLIN
	CALL	OUTDEC
	CALL	TYPTX
	DB	CR,LF,'        Number of Bytes:'
	DB	'                ',EOL
	MOV	BX,Word Ptr BYTECT
	CALL	OUTDEC
	CALL	CRLF
	MOV	AL,Byte Ptr PRIFLG
	CMP	AL,LSTOUT		;PRINTER
	JZ	FPRIN2
	RET				;NO, ALL DONE
FPRIN2:	MOV	AL,FF			;ELSE EJECT PAGE
	CALL	PCHAR

; IF PRINTER WAS USED THEN BE SURE FUNCTION IS RESET!

	MOV	AL,CONOUT
	MOV	Byte Ptr PRIFLG,AL	;RESET PRINT FLAG
	RET

; HANDLE HEADER AND PAGE NUMBER IF PRINTER OPERATION

HDR:	PUSH	BX
	PUSH	CX
	CALL	CRLF
	MOV	BX,(Offset HEADER)
	CALL	TYPT1
	CALL	TYPTX
	DB	'               Page',EOL
	MOV	BX,Word Ptr PAGNUM
	INC	BX
	MOV	Word Ptr PAGNUM,BX
	CALL	OUTDEC

; GET FILE NAME UNDER THE HEADER

	CALL	TYPTX
	DB	CR,LF,'        Processed File: ',EOL
	MOV	BX,Offset FCBFN		;GET THE FILENAME
	MOV	CH,8
HDR1:	MOV	AL,M			;GETA CHAR
	CMP	AL,' '			;SPACE?
	JZ	HDR2			;YES, DONE
	CALL	PCHAR			;ELSE PRINT
	LAHF
	INC	BX
	SAHF
	DEC	CH
	JNZ	HDR1
HDR2:	CALL	TYPTX
HDR3	DB	'.BAS'
	CALL	CRLF
	CALL	CRLF
	MOV	AL,LINMAX
	MOV	Byte Ptr LINCNT,AL	;SET COUNTER TO LINES/PAGE
	POP	CX
	POP	BX
	RET

; COMPARE ROUTINE FOR SORT

COMPR:	PUSH	BX			;SAVE TABLE ADDR
	MOV	DI,[BX]			;LOAD LO ADDR
	INC	BX
	INC	BX
	MOV	SI,[BX]

; SI AND DI POINT TO ENTRIES TO BE COMPARED

	PUSH	DS
	POP	ES
	MOV	AL,VARLN-1		;MAXIMUM NUMBER OF BYTES TO COMPARE
	MOV	Byte Ptr COMPLN,AL
CMPLP:	DEC	Byte Ptr COMPLN		;WE WILL ONLY COMPARE LENGTH OF VARIABLE
	JZ	CMPLP0			;EXIT IF ENOUGH SCANNED
	CMPSB				;COMPARE BYTES IN STRINGS
	JZ	CMPLP
CMPLP0:	POP	BX
	RET

; SWAP ENTRIES IN THE ORDER TABLE

SWAP:	MOV	Byte Ptr SWITCH,1	;FLAG A SWAP WAS MADE
	MOV	CX,[BX]
	PUSH	BX			;SAVE TABLE ADDR
	INC	BX
	INC	BX
	MOV	DX,[BX]
	MOV	[BX],CX
	POP	BX
	MOV	[BX],DX
	RET

; MOVE VARIABLE AND LINE NUMBERS TO ARRAY
;	ON ENTRY HL POINTS TO VARIABLE IN 'WORK'

ARSCAN:	XCHG	BX,DX			;HL TO DE
	MOV	BX,(Offset ARRAY)	;START OF ARRAY (STRING2)
	CMP	Byte Ptr ARRIND,0	;TEST COUNT OF ARRAY LINES IN USE
	JNZ	ARSCN1			;NOT FIRST LINE
	JMP SHORT ARSCN4

ARSCN1:	MOV	CH,Byte Ptr ARRIND	;# OF LINES TO COMPARE	(VARIABLES)
ARSCN2:	MOV	CL,VARLN		;LENGTH OF STRING2
	PUSH	DX			;SAVE POINTER TO VARIABLE IN 'WORK' (STRING1)
	PUSH	BX			;POINTER TO 'ARRAY'+CURRENT LINE IN ARRAY
	CALL	MATCH			;TRY TO MATCH
	JZ	GOTMCH
ARSCN2A:POP	BX			;GET POINTER
	ADD	BX,128			;POINT TO NEXT VARIABLE
	POP	DX			;POINT TO WORK AGAIN
	DEC	CH			;ALL COMPARED?
	JNZ	ARSCN2			;NO, COMPARE MORE - ELSE ADD NEW VARIABLE
ARSCN4:	MOV	AL,BH
	MOV	Byte Ptr ARRPTR,AL	;SET ARRAY END POINTER
	CALL	VARMOV			;ON RETURN POINTS TO ARRNUM
	MOV	M,1			;ONE LINE NUMBER IN LINE
	INC	Byte Ptr ARRIND		;ADD 1 TO LINES NOW USED
	INC	Byte Ptr VARCNT
	INC	BX			;WHERE LINE NUMBER GOES (ARRLIN)
	JMP SHORT GOTMC1		;STORE LINE NUMBER

; ALREADY HAVE A VARIABLE IN THIS LINE

GOTMCH:	POP	BX			;POINT TO VARIABLE IN LINE
	MOV	Word Ptr VARPTR,BX	;SAVE POINTER IN CASE OF OVERFLOW
	POP	DX
	ADD	BL,Offset ARRNUM	;POINT TO LINE NUMBER COUNT
	MOV	AL,M			;GET IT
	CMP	AL,56			;CHECK FOR OVERFLOW (MAX=56)
	JS	GOTMC0
	PUSH	DX			;HAVE OVERFLOW, FIX STACK
	MOV	BX,Word Ptr VARPTR	;AND VARPTR
	PUSH	BX
	JMP SHORT ARSCN2A		;MAKE ANOTHER ENTRY FOR THIS VAR.

GOTMC0:	PUSH	AX			;SAVE COUNT
	INC	AL			;ADD 1
	MOV	M,AL			;NEW COUNT TO ARRNUM
	MOV	Word Ptr CNTPTR,BX	;SAVE COUNT POINTER
	POP	AX			;RESTORE COUNT
	ADD	AL,AL			;*2 (IS DW)
	INC	BL			;POINTS TO ARRLIN
	ADD	BL,AL			;DESTINATION FOR LINE NUMBER
GOTMC1:	MOV	DX,(Offset WORK)	;MOVE NUMBER
	MOV	AL,BL
	CMP	AL,10H			;FIRST NUMBER FOR THIS VARIABLE?
	JZ	GOTMC2			;YES, DON'T CHECK FOR REPEAT NO.
	DEC	BX			;ELSE, BACK UP TO PREVIOUS NUMBER
	DEC	BX
	MOV	SI,DX			;GET NEW NUMBER LOW BYTE
	MOV	AX,[SI]
	CMP	AX,[BX]			;COMPARE WITH OLD NO.
	LAHF
	INC	BX
	INC	BX
	SAHF
	JNZ	GOTMC2			;NOS. DO NOT MATCH
	MOV	BX,Word Ptr CNTPTR	;ELSE, GET COUNT POINTER
	DEC	M			;DECREMENT COUNT
	RET				;AND LEAVE
GOTMC2:	MOV	SI,DX
	MOV	AX,[SI]
	MOV	[BX],AX
	RET

; MOVE VARIABLE TO PROPER PLACE IN ARRAY
;	ENTRY	BX = DESTINATION
;		DX = SOURCE
;	EXIT	BX POINTS TO ARRNUM (COUNT OF LINE NUMBERS)

VARMOV:	PUSH	CX
	MOV	CX,VARLN		;NUMBER CHARS TO MOVE
	MOV	SI,DX
	MOV	DI,BX
	PUSH	DS
	POP	ES
	REP	MOVSB
	MOV	BX,DI			;NEXT LOCATION TO BX
	POP	CX
	RET

; MOVE VARIABLE TO WORK BUFFER
;	EACH VARIABLE MAY HAVE A LENGTH OF 14 CHARS
;	AND IS TERMINATED WITH A 'EOL'

MVVAR:	MOV	AL,Byte Ptr VARNUM	;GET # OF VARIABLE IN 'WORK'
	CMP	AL,VARMAX		;'WORK' FILLED?
	JNZ	MVVAR0
	JMP	MVVA02			;YES
MVVAR0:	XCHG	BX,DX			;SAVE HL IN DE
	CALL	SETLOC			;GET OFFSET TO CURRENT VARIABLE
	PUSH	BX			;SAVE OFFSET
	XCHG	BX,DX			;'WORK' TO DE
	MOV	CH,0			;CHARS COUNTER
MVVAR1:	MOV	AL,M
	MOV	SI,DX
	MOV	[SI],AL
	INC	CH			;COUNT CHARS.
	CALL	MVVA01			;CHECK FOR OVERFLOW
	INC	BX
	INC	DX
	DEC	CL			;TEST FOR END OF VARIABLE
	JNZ	MVVAR1
	MOV	CH,14-3
	CALL	MVVA01			;MAKE SURE NO OVERFLOW OCCURS
	MOV	AL,M			;CHECK IF WE HAVE ARRAY-VARIABLE
	CMP	AL,'('
	JNZ	MVVAR2			;SKIP IF NOT
	MOV	SI,DX			;ELSE ADD "(x)"
	MOV	[SI],AL
	INC	SI
	MOV	Word Ptr [SI],')x'	;INSERT "x)"
	ADD	DX,2			;UPDATE DX
MVVAR2:	POP	BX			;GET OFFSET
	ADD	BX,14			;POINT TO END OF ARRAY
	MOV	M,EOL			;MARK END
	INC	Byte Ptr VARNUM		;INCR. COUNTER
	XOR	AL,AL			;FLAG ALL OK
	RET

MVVA01:	MOV	AL,14			;NOT MORE THAN 14 CHARS ALLOWED
	CMP	AL,CH
	JS	MVVA01A
	RET
MVVA01A:CALL	TYPTX
	DB	BELL,CR,LF,'ERROR - Variable too long in line ',EOL
	MOV	BX,Word Ptr WORK
	CALL	OUTDEC
	CALL	TYPTX
	DB	'  ',' '+EOL
	POP	AX			;FIX STACK
	JMP SHORT MVVAR2		;DROP REMAINDER OF VARIABLE

MVVA02:	CALL	TYPTX
	DB	BELL,CR,LF,'ERROR - Too many variables in line ',EOL
	MOV	BX,Word Ptr WORK
	CALL	OUTDEC
	CALL	TYPTX
	DB	'  ',' '+EOL
	MOV	AL,EOL			;END LINE
	RET

; CALCULATE OFFSET TO CURRENT VARIABLE (NO. OF VARIABLE*15)
;	ENTRY	A = VARNUM
;	EXIT	HL= OFFSET TO CURRENT VARIABLE
;	USES	A,H,L

SETLOC:	XOR	AH,AH			;CLEAR AH
	MOV	BL,15
	MUL	BL			;MULTIPLY NUMBER BY 15
	MOV	BX,Offset VARBLS	;POINT TO FIRST VARIABLE
	ADD	BX,AX			;ADD OFFSET
	RET

; FIND A WORD IN STRING (VARIABLE OR RESERVED WORD)

FNDWRD:	MOV	BX,Word Ptr MAPPTR	;CURRENT LOCATION
	CALL	FNDLET			;FIND 1ST LETTER
	CMP	AL,EOL
	JNZ	FNDWR0
	RET				;IF WE HIT EOL
FNDWR0:	PUSH	BX			;SAVE 1ST CHAR LOCATION
	MOV	CL,1			;COUNT LENGTH OF WORD (HAVE 1ST CHAR)
FNDWR1:	INC	BX			;POINT TO NEXT
	MOV	AL,M			;GET IT
	CMP	AL,EOL
	JZ	FNDWR2			;AT END OF LINE
	CMP	AL,'.'			;PERIOD?  (LEGAL LABEL CHARACTER)
	JZ	INCLD0			;YES, INCLUDE
	CMP	AL,'!'			;SINGLE PRECISION?
	JZ	INCLUD			;TAKE IT
	CMP	AL,'#'			;DOUBLE PRECISION?
	JZ	INCLUD
	CMP	AL,'%'			;INTEGER?
	JZ	INCLUD
	CMP	AL,'$'			;STRING?
	JZ	INCLUD
	CALL	NUMCHK			;IS IT DIGIT?
	JB	INCLD0
	CMP	AL,'A'			;ANYTHING ELSE BELOW 'A' OR ABOVE 'Z' ENDS IT
	JB	FNDWR2			;GOT ALL
	CMP	AL,'Z'+1
	JNB	FNDWR2
INCLD0:	INC	CL			;KEEP COUNT
	JMP SHORT FNDWR1		;GET NEXT
INCLUD:	INC	CL			;ENTER HERE WITH LAST CHAR OF VARIABLE
FNDWR2:	MOV	Word Ptr MAPPTR,BX	;SAVE POINTER TO NEXT WORD
	POP	BX			;POINT TO START OF WORD
	CALL	CMPRES			;CHECK FOR RESERVED WORD
	OR	AL,AL			;WAS A VARIABLE?
	JNZ	FNDWRD			;NO, TRY NEXT
	RET				;YES, RETURN

; GET DATA TO BUFFER AND EXTRACT LINES
; MOVE LINE TO MAPBUF
; EACH LINE CONTAINS TEXT IN THE FORM "TEXT",80H
; RETURNS WITH 1AH IN 'AL' IF EOF

MVMAP:	MOV	AL,Byte Ptr INITFG	;ANY DISK READING DONE?
	OR	AL,AL			;IF NOT ZERO, THEN
	JNZ	MVMAP1			;THE BUFFER IS FILLED
	CALL	READFI			;ELSE FILL IT
	MOV	AL,1			;BUFFER FILLED, SET FLAG
	MOV	Byte Ptr INITFG,AL
	MOV	BX,(Offset BUFFER)	;POINT TO 1ST DATA
	MOV	Word Ptr NXTPTR,BX	;SAVE POINTER
MVMAP1:	MOV	BX,Word Ptr NXTPTR	;DATA STARTS HERE
	MOV	Word Ptr BEGPTR,BX	;SAVE OLD BEGIN
	MOV	DX,(Offset MAPBUF)	;DESTINATION
MVMAP2:	MOV	AL,M			;GET VERY 1ST BYTE
	CMP	AL,CR			;A 'NULL LINE'?
	JNZ	MVMAP3			;NO, SKIP
	INC	BX			;POINT TO NEXT
	MOV	AL,M			;GET IT
	INC	BX			;PASS WHAT WE HAVE
	MOV	Word Ptr NXTPTR,BX	;SAVE AS NEXT LINE ADDRESS
	CMP	AL,04H			;END OF PARTIAL LINE?
	JZ	MOVE			;THEN MUST MOVE LEFT-OVERS
	JMP SHORT MVMAP6		;ELSE END PRESENT LINE
MVMAP3:	MOV	AL,M
	INC	BX
	MOV	Word Ptr NXTPTR,BX	;ADDR POINTING TO NEXT LINE
	CMP	AL,1AH			;CTRL-Z (EOF)?
	JNZ	MVMAP3A
	RET				;ALL DONE
MVMAP3A:CMP	AL,04H			;END OF PARTIAL LINE?
	JZ	MOVE			;YES
	CMP	AL,CR
	JZ	MVMAP4			;CHECK FOR END OF LINE
	MOV	SI,DX			;ELSE SAVE IN MAPBUF
	MOV	[SI],AL
	INC	DX
	JMP SHORT MVMAP3		;GET MORE
MVMAP4:	PUSH	AX			;SAVE THE 'CR' WE HAVE
	DEC	DX			;BACK UP TO FORMER BYTE
	MOV	SI,DX			;GET IT
	MOV	AL,[SI]
	INC	DX			;RESTORE POINTER
	CMP	AL,LF			;HAD A 'LF' BEFORE THE 'CR'?
	JNZ	MVMAP5			;NO, WAS NOT
	POP	AX			;YES, RESTORE THE 'CR'
	MOV	SI,DX			;AND STORE. IS A BASIC LOGICAL LINE
	MOV	[SI],AL
	INC	DX
	JMP SHORT MVMAP3
MVMAP5:	POP	AX			;FIX STACK
	MOV	AL,M			;GET BYTE AFTER 'CR'
	INC	BX			;PASS CR/LF
	MOV	Word Ptr NXTPTR,BX	;SAVE NEXT LINE ADDRESS
	CMP	AL,04H			;BE SURE IS NOT END OF PARTIAL LINE
	JZ	MOVE			;IF SO, MOVE LEFT-OVERS
MVMAP6:	MOV	AL,EOL			;MARK END OF EXTRACTED LINE
	MOV	SI,DX
	MOV	[SI],AL
	RET

; MOVE LEFT-OVERS DOWN IN BUFFER

MOVE:	MOV	BX,Word Ptr BEGPTR	;BEGIN OF LAST PARTIAL LINE
	XCHG	BX,DX			;TO DE
	MOV	BX,(Offset BUFFER)	;WHERE LEFT-OVERS GO TO
	MOV	SI,DX			;GET BYTE IN BEGPTR
	MOV	AL,[SI]
	CMP	AL,04H			;END MARKER OF PARTIAL LINE?
	JNZ	MOVE1			;NO, OK
	JMP SHORT MOVE2			;ELSE NOTHING TO MOVE
MOVE1:	MOV	SI,DX			;GET BYTE
	MOV	AL,[SI]
	CMP	AL,04H			;END OF PARTIAL LINE?
	JZ	MOVE2			;YES, LINE MOVED
	MOV	M,AL			;ELSE MOVE DATA
	INC	DX
	INC	BX
	JMP SHORT MOVE1
MOVE2:	MOV	Word Ptr MEMPTR,BX	;START ADDRESS FOR NEXT READ
	XOR	AL,AL			;ALLOW DISK READ
	MOV	Byte Ptr INITFG,AL
	JMP	MVMAP			;INPUT FROM DISK

; READ THE FILE TO MEMORY, MARK END IF MEMORY OVERFLOW

READFI:	MOV	DX,Word Ptr MEMPTR
	MOV	AH,SETDMA
	INT	21H			;SET DMA FOR READ
	MOV	DX,Offset FCB		;FILE CONTROL BLOCK
	PUSH	DX
	MOV	AH,24H			;SET RANDOM RECORD
	INT	21H
	POP	DX
	MOV	CX,1024			;READ 1K OF FILE
	MOV	AH,27H			;RANDOM BLOCK READ
	INT	21H			;'A' RETURNS ZERO IF OK
	ADD	Word Ptr BYTECT,CX	;UPDATE BYTE COUNT
	MOV	BX,Word Ptr MEMPTR
	ADD	BX,CX			;UPDATE MEMORY POINTER
	MOV	Word Ptr MEMPTR,BX
	OR	AL,AL			;ZERO IF READ OK
	JZ	READ0A
	MOV	M,1AH			;AND FLAG END OF TEXT
	RET
READ0A:	MOV	M,4			;MARK PARTIAL READ
	MOV	Byte Ptr ALLBLK,1	;MARK ALL BLOCK USED
	RET

; CHECK FOR ASCII DIGIT - RETURNS CARRY SET IF A DIGIT

NUMCHK:	CMP	AL,'0'
	JB	NONUM			;NOT DIGIT
	CMP	AL,'9'+1
	JNB	NONUM			;NOT DIGIT
	STC				;SET CARRY - WAS A DIGIT
	RET
NONUM:	STC				;CLEAR CARRY IF WAS NOT
	CMC
	RET

; SCAN LINE AND FIND 1ST OCCURRENCE OF A LETTER

FNDLT0:	INC	BX			;POINT TO NEXT
FNDLET:	MOV	AL,M			;GET A CHAR
	CMP	AL,81H			;CHECK FOR ILLEGAL CHAR
	JNAE	FNTLTA
	JMP	ERRFIL			;ERROR IF IT IS
FNTLTA:	CMP	AL,EOL			;CHECK FOR END OF LINE
	JNZ	FNDLTB
	RET				;RETURN IF SO
FNDLTB:	CMP	AL,27H			;REMARK?  - "'"
	JZ	FNDLT2
	CMP	AL,'"'			;CHECK FOR QUOTED STRING
	JZ	FNDLT1
	CMP	AL,'&'			;HEX OR OCTAL NUMBER?
	JNZ	FNDLTC
	JMP	FNDLT3			;IF SO, CHECK IT
FNDLTC:	CMP	AL,'A'
	JB	FNDLT0			;IF NOT LETTER
	CMP	AL,'Z'+1
	JNB	FNDLT0			;IF NOT LETTER
	CMP	AL,'R'			;POSSIBLE REM?
	JZ	FND001			;YES, CHECK IT
	CMP	AL,'D'			;POSSIBLE DATA?
	JZ	FND002			;YES, CHECK IT
	RET				;RETURN WITH LETTER
FNDLT1:	INC	BX			;GET NEXT
	MOV	AL,M
	CMP	AL,'"'			;2ND QUOTE?
	JZ	FNDLT0			;THEN RESUME SEARCH FOR LETTER
	CMP	AL,EOL
	JZ	FNDLT2			;ELSE EXIT ON EOL
	JMP SHORT FNDLT1
FNDLT2:	MOV	AL,EOL			;REMARK - SO CANCEL REMAINDER OF LINE
	RET
FND001:	PUSH	BX			;SAVE HL
	INC	BX			;MOVE TO NEXT CHAR
	MOV	AL,M
	CMP	AL,'E'
	JNZ	FND00B			;NOT REM
	INC	BX
	MOV	AL,M
	CMP	AL,'M'
	JNZ	FND00B			;NOT REM
FND003:	INC	BX
	MOV	AL,M
	CMP	AL,'A'			;LESS THAN "A"
	JNB	FND00B			;NO, NOT REM
FND00A:	MOV	AL,EOL			;ELSE, MARK END OF LINE
	POP	BX			;RESTORE HL
	RET				;AND RETURN
FND002:	PUSH	BX
	INC	BX
	MOV	AL,M
	CMP	AL,'A'
	JNZ	FND00B			;NOT DATA
	INC	BX
	MOV	AL,M
	CMP	AL,'T'
	JNZ	FND00B			;NOT DATA
	INC	BX
	MOV	AL,M
	CMP	AL,'A'
	JNZ	FND00B			;NOT DATA
	JMP SHORT FND003		;CHECK END
FND00B:	POP	BX
	MOV	AL,M			;GET ORIGINAL LETTER
	RET
FNDLT3:	INC	BX			;SKIP OVER "&"
	MOV	AL,M			;GET NEXT CHAR
	CMP	AL,'O'
	JNZ	FNDLTD
	JMP	FNDLT0			;IT'S OCTAL, CHECK NEXT CHAR
FNDLTD:	CMP	AL,'H'
	JZ	FNDLTE
	JMP	FNDLET			;NOT H OR O, SEE WHAT IT IS
FNDLTE:	JMP	FNDLT0			;ELSE, CHECK NEXT CHARACTER

ERRFIL:	CMP	Byte Ptr CTYPE,0
	JZ	IBM4
	CALL	TYPTX
	DB	ESC,'y','5'+80H
IBM4:	CALL	TYPTX
	DB	CR,LF,'ERROR - This is not an ASCII file!',CR,LF+EOL
	JMP	FINIS

; CONVERT DECIMAL TO BINARY, HL POINTS TO NUMBER ON ENTRY

DECML:	XCHG	BX,DX			;MOVE TO DE
	MOV	BX,0
DECML1:	MOV	SI,DX			;GET 1ST CHAR
	MOV	AL,[SI]
	SUB	AL,30H			;REMOVE ASCII BIAS
	JB	DECML2			;IF NOT A DIGIT
	CMP	AL,10
	JNB	DECML2			;THEN FINISHED
	SHL	BX,1			;NUMBER *2
	MOV	DI,BX			;SAVE (NO.*2)
	SHL	BX,1			;NUMBER*4
	SHL	BX,1			;NUMBER*8
	ADD	BX,DI			;NUMBER*10
	XOR	AH,AH
	ADD	BX,AX			;ADD IN DIGIT'S VALUE
	INC	DX			;POINT TO NEXT
	JMP SHORT DECML1
DECML2:	MOV	Word Ptr TERM,BX	;SAVE NUMBER
	XCHG	BX,DX			;DE TO HL
	RET

; INPUT A CHARACTER FROM CONSOLE

GETCHR:	PUSH	BX
	PUSH	DX
	PUSH	CX
	MOV	AH,CONINP
	INT	21H
	POP	CX
	POP	DX
	POP	BX
	RET

; DO A CR/LF

CRLF:	MOV	AL,CR
	CALL	PCHAR
	MOV	AL,LF

; PRINT A CHARCTER
;	USES	NONE

PCHAR:	PUSH	BX
	PUSH	DX
	PUSH	CX
	PUSH	AX
	MOV	DL,AL
	MOV	AL,Byte Ptr PRIFLG	;GET PRINT FUNCTION
	MOV	AH,AL			;IN C
	INT	21H
	POP	AX
	POP	CX
	POP	DX
	POP	BX
	RET

; TYPTX - TYPE A BLOCK OF TEXT UNTIL BIT 7 FOUND
;	ENTRY	(RET) = TEXT
;	EXIT	TO (RET + LENGTH)
;	USES	A,F

TYPTX:	MOV	BP,SP			;HL = TEXT ADDRESS
	XCHG	BX,[BP]
	CALL	TYPT1			;TYPE IT
	MOV	BP,SP
	XCHG	BX,[BP]
	RET
TYPT1:	MOV	AL,M
	AND	AL,7FH
	CALL	PCHAR
	CMP	AL,M
	LAHF
	INC	BX
	SAHF
	JZ	TYPT1			;MORE TO GO
	RET

;  OUTPUT A DECIMAL NUMBER
; OUTPUTS THE BINARY VALUE IN THE
; HL REG IN 5 DECIMAL DIGITS WITH
; LEADING ZEROS REPLACED BY SPACES
;  USES A,F,H,L

OUTDEC:	PUSH	DX
	PUSH	CX
	CALL	OUTDC
	POP	CX
	POP	DX
	RET				;RETURN TO CALLER
OUTDC:	MOV	CH,80H			;SET NO PRINTING FLAG
	MOV	DX,-10000
	CALL	DIGIT
	MOV	DX,-1000
	CALL	DIGIT
	MOV	DX,-100
	CALL	DIGIT
	MOV	DX,-10
	CALL	DIGIT
	MOV	CH,0			;CLEAR NO PRINT FLAG
	MOV	DX,-1
DIGIT:	INC	CH
	ADD	BX,DX			;SUBTRACT OFF
	JB	DIGIT			;LOOP IF > ZERO
	DEC	CH			;BACKUP VALUE
	NEG	DX			;NEGATE DX
	ADD	BX,DX			;ADD BACK IN
	MOV	AL,CH
	CMP	AL,80H			;ANY PRINTING YET?
	JNZ	OUTDC1			;SKIP IF SO
	MOV	AL,' '			;ELSE PRINT A SPACE
	CALL	PCHAR
	RET				;IF NOT, THEN IGNORE
OUTDC1:	AND	AL,0FH			;MASK OFF LEFT HALF
	ADD	AL,30H			;ADD IN ASCII BIAS
	CALL	PCHAR			;PRINT DIGIT
	MOV	CH,0			;CLEAR NO PRINTING FLAG
	RET

; COMPARE WORD IN MAPBUF TO RESERVED WORD IN TABLE

CMPRES:	PUSH	CX
	XCHG	BX,DX			;HL TO DE
	MOV	BX,(Offset RESERV)	;POINT TO TABLE
CMPR1:	PUSH	DX			;SAVE LOC
	PUSH	BX
	MOV	AL,M			;GET BYTE COUNT IN TABLE
	OR	AL,AL			;END OF TABLE?
	JZ	CMPR3			;THEN IS VARIABLE, EXIT
	MOV	CL,M			;COUNT STRING2
	INC	BX
	CALL	MATCH			;TRY TO MATCH STRINGS
	JZ	CMPR2			;YES, HAD A MATCH (NOT VARIABLE THEN)
CMPR1A:	POP	BX			;GET CURRENT PLACE IN TABLE
	MOV	AL,M			;GET LENGTH OF WORD IN TABLE
	INC	AL			;ADD ONE
	XOR	AH,AH
	ADD	BX,AX			;ADD TO HL
	POP	DX			;POINT TO STRING1 AGAIN (WORD)
	JMP SHORT CMPR1
CMPR2:	MOV	SI,DX			;GET CHAR AFTER MATCHED WORD
	MOV	AL,[SI]
	CMP	AL,EOL			;END OF LINE?
	JZ	CMPR2A			;IF SO, IT'S A RESERVED WORD
	CMP	AL,'A'			;LESS THAN "A"
	JNB	CMPR1A			;IF NOT, IT'S NOT A RESERVED WORD
CMPR2A:	POP	BX			;WAS RESERVED WORD, EXIT
	POP	DX
	POP	CX
	XCHG	BX,DX
	MOV	AL,1
	RET
CMPR3:	POP	BX
	POP	DX
	POP	CX
	XCHG	BX,DX			;POINT HL TO VARIABLE
	XOR	AL,AL			;FLAG AS A VARIABLE
	MOV	Byte Ptr VARFLG,AL	;SET VARIABLE FLAG
	RET

; TRY TO OPEN FILE, ELSE REPORT ERROR

OPFILE:	MOV	DX,Offset FCB
	MOV	AH,OPENF
	INT	21H
	CMP	AL,255			;CHECK IF FILE IS THERE
	JZ	OPENF0
	RET				;FILE OPENED OK
OPENF0:	CALL	TYPTX
	DB	CR,LF,BELL,'ERROR - File NOT Found!',CR,LF+EOL
FINIS:	INT	20H			;RETURN TO Z-DOS

; MATCH A STRING
;	ENTRY	DX = STRING1
;		BX = STRING2
;		CL = LENGTH OF STRING2

MATCH:	PUSH	CX			;SAVE CX
	PUSH	DS
	POP	ES			;PUT ES HERE
	MOV	SI,DX			;SOURCE TO SI
	MOV	DI,BX			;DEST. TO DI
	XOR	CH,CH			;ZERO CH
	REPZ	CMPSB			;COMPARE STRINGS
	MOV	DX,SI			;POINT TO AFTER MATCH
	POP	CX			;RESTORE CX
	RET

; TABLE OF RESERVED WORDS

RESERV	DB	3,'ABS'
	DB	3,'AND'
	DB	3,'ASC'
	DB	2,'AS'
	DB	3,'ATN'
	DB	4,'AUTO'
	DB	4,'BASE'
	DB	4,'BEEP'
	DB	5,'BLOAD'
	DB	5,'BSAVE'
	DB	4,'CALL'
	DB	4,'CDBL'
	DB	4,'CINT'
	DB	6,'CIRCLE'
	DB	5,'CHAIN'
	DB	4,'CHR$'
	DB	5,'CLEAR'
	DB	5,'CLOSE'
	DB	3,'CLS'
	DB	6,'COMMON'
	DB	3,'COM'
	DB	4,'CONT'
	DB	5,'COLOR'
	DB	3,'COS'
	DB	4,'CSNG'
	DB	6,'CSRLIN'
	DB	3,'CVD'
	DB	3,'CVI'
	DB	3,'CVS'
	DB	4,'DATA'
	DB	5,'DATE$'
	DB	6,'DEFDBL'
	DB	6,'DEFINT'
	DB	6,'DEFSEG'
	DB	6,'DEFSNG'
	DB	6,'DEFSTR'
	DB	6,'DEFUSR'
	DB	3,'DEF'
	DB	6,'DELETE'
	DB	3,'DIM'
	DB	4,'DRAW'
	DB	4,'EDIT'
	DB	4,'ELSE'
	DB	3,'END'
	DB	3,'EOF'
	DB	5,'ERASE'
	DB	5,'ERROR'
	DB	3,'EXP'
	DB	5,'FIELD'
	DB	5,'FILES'
	DB	3,'FIX'
	DB	2,'FN'
	DB	3,'FOR'
	DB	3,'FRE'
	DB	3,'GET'
	DB	5,'GOSUB'
	DB	4,'GOTO'
	DB	4,'HEX$'
	DB	2,'IF'
	DB	3,'IMP'
	DB	6,'INKEY$'
	DB	6,'INPUT#'
	DB	6,'INPUT$'
	DB	5,'INPUT'
	DB	3,'INP'
	DB	5,'INSTR'
	DB	3,'INT'
	DB	3,'KEY'
	DB	4,'KILL'
	DB	5,'LEFT$'
	DB	3,'LEN'
	DB	3,'LET'
	DB	4,'LINE'
	DB	4,'LIST'
	DB	5,'LLIST'
	DB	4,'LOAD'
	DB	6,'LOCATE'
	DB	3,'LOC'
	DB	3,'LOF'
	DB	3,'LOG'
	DB	4,'LPOS'
	DB	6,'LPRINT'
	DB	4,'LSET'
	DB	5,'MERGE'
	DB	4,'MID$'
	DB	4,'MKD$'
	DB	4,'MKI$'
	DB	4,'MKS$'
	DB	3,'MOD'
	DB	5,'MOTOR'
	DB	4,'NAME'
	DB	3,'NEW'
	DB	4,'NEXT'
	DB	3,'NOT'
	DB	4,'NULL'
	DB	4,'OCT$'
	DB	3,'OFF'
	DB	2,'ON'
	DB	4,'OPEN'
	DB	6,'OPTION'
	DB	2,'OR'
	DB	6,'OUTPUT'
	DB	3,'OUT'
	DB	5,'PAINT'
	DB	4,'PEEK'
	DB	3,'PEN'
	DB	4,'PLAY'
	DB	5,'POINT'
	DB	4,'POKE'
	DB	3,'POS'
	DB	6,'PRESET'
	DB	5,'PRINT'
	DB	4,'PSET'
	DB	3,'PUT'
	DB	9,'RANDOMIZE'
	DB	4,'READ'
	DB	3,'REM'
	DB	5,'RENUM'
	DB	5,'RESET'
	DB	7,'RESTORE'
	DB	6,'RESUME'
	DB	6,'RETURN'
	DB	6,'RIGHT$'
	DB	3,'RND'
	DB	4,'RSET'
	DB	3,'RUN'
	DB	4,'SAVE'
	DB	6,'SCREEN'
	DB	3,'SEG'
	DB	3,'SGN'
	DB	3,'SIN'
	DB	5,'SOUND'
	DB	6,'SPACE$'
	DB	3,'SPC'
	DB	3,'SQR'
	DB	4,'STEP'
	DB	5,'STICK'
	DB	4,'STOP'
	DB	4,'STR$'
	DB	5,'STRIG'
	DB	7,'STRING$'
	DB	4,'SWAP'
	DB	6,'SYSTEM'
	DB	3,'TAB'
	DB	3,'TAN'
	DB	4,'THEN'
	DB	5,'TIME$'
	DB	2,'TO'
	DB	5,'TROFF'
	DB	4,'TRON'
	DB	3,'USR'
	DB	5,'USING'
	DB	3,'VAL'
	DB	6,'VARPTR'
	DB	7,'VARPTR$'
	DB	4,'WAIT'
	DB	5,'WAIT$'
	DB	4,'WEND'
	DB	5,'WHILE'
	DB	5,'WIDTH'
	DB	5,'WRITE'
	DB	3,'XOR'
	DB	0			;END OF TABLE MARKER

; RAM LOCATIONS

CTYPE	DB	1			;COMPUTER TYPE
OLDVAR	DB	'              ',EOL	;TEMP. VARIABLE STORAGE
PRIFLG	DB	CONOUT			;PRINT FLAG (= FUNCTION TO USE)
OLDNUM	DB	2 DUP (?)		;TEMP. NUMBER STORAGE
INITFG	DB	1 DUP (?)
MEMPTR	DB	2 DUP (?)
BEGPTR	DB	2 DUP (?)
NXTPTR	DB	2 DUP (?)
BLKMAX	DB	1 DUP (?)
MAXVAR	DB	1 DUP (?)
ALLBLK	DB	1 DUP (?)
MAXMEM	DB	2 DUP (?)
MAPPTR	DB	2 DUP (?)		;CURRENT PLACE IN MAPBUF
WRKPTR	DB	2 DUP (?)		;POINTER TO WORK BUFFER
TERM	DB	2 DUP (?)		;CURRENT LINE NUMBER OF SOURCE LINE
VARFLG	DB	1 DUP (?)		;NOT 0=NO VARIABLE YET IN THIS LINE
ARRIND	DB	1 DUP (?)		;NUMBER OF VARIABLES IN ARRAY (LINES IN USE)
ARRPTR	DB	1 DUP (?)		;ARRAY END POINTER
VARCNT	DB	1 DUP (?)		;ACTUAL VARIABLE COUNT
VARIND	DB	1 DUP (?)		;NUMBER OF VARIABLES IN 'WORK'
VARPTR	DB	2 DUP (?)		;POINTER TO CURRENT VARIABLE
NUMCNT	DB	1 DUP (?)		;NUMBER OF LINE NUMBERS/PRINT LINE
SCOUNT	DB	1 DUP (?)		;NO. TO SORT
SWITCH	DB	1 DUP (?)		;INDICATE SWITCH WAS MADE IN SORT
TEMP	DB	1 DUP (?)		;NO. TO COMPARE IN SORT
NEXTT	DB	2 DUP (?)		;ORDER TABLE POINTER
COMPLN	DB	1 DUP (?)		;LIMITS SCAN FOR SORT
PAGNUM	DB	2 DUP (?)		;PAGE NUMBER
LINCNT	DB	1 DUP (?)		;LINES/PAGE
LOGLIN	DB	2 DUP (?)		;NUMBER OF LOGICAL LINES IN BASIC SOURCE
BYTECT	DB	2 DUP (?)		;NUMBER OF BYTES IN BASIC SOURCE
CNTPTR	DB	2 DUP (?)		;COUNT POINTER
HEADER	DB	'ZBREF -  ZBASIC Variables Cross Reference Utility  V '
	DB	VERSN+30H,'.',MODIF+30H+EOL

; LOCAL STACK

	DB	100H DUP (?)
STACK	EQU	Offset $		;STACK STARTS HERE

; STORAGE AREA FOR VARIABLES OF ONE LINE

WORK	DB	2 DUP (?)		;PLACE FOR LINE NUMBER
VARNUM	DB	1 DUP (?)		;NUMBER OF VARIABLES STORED
VARBLS	EQU	Offset $		;ROOM FOR VARMAX VARIABLES OF 15 CHARS
MAPBUF	EQU	(Offset VARBLS)+(VARMAX*15)	;TEMP BUFFER
						;FOR SOURCE LINE AND ORDER TABLE
WORKLN	EQU	(Offset MAPBUF)-(Offset WORK)	;LENGTH. LOC'N 15 IS A 'EOL'
BUFFER	EQU	(Offset MAPBUF)+512	;1K FILE BUFFER
FSPC	EQU	(Offset BUFFER)+500H	;(SPACE FOR BUFFER)

; STORAGE ARRAY FOR ENTIRE RESULTS OF VARIABLE SCAN
;	DIMENSION	= MAXVAR * 256 BYTES

ARRAY	EQU	(((Offset (FSPC-Z))/256)+1)*256	;WE WANT AN EVEN PAGE HERE
XREF	ENDS
	END	START
                                                                                                                           