	TITLE   Z-100 SWAP PROGRAM
	PAGE ,132
;	SWAP -- CONSOLE SWAPPING PROGRAM
;
;	THIS PROGRAM ALLOWS YOU TO SWAP THE CONSOLE
;	BETWEEN THE NORMAL KEYBPOARD/SCREEN AND A REMOTE
;	TERMINAL CONNECTED TO THE AUX PORT.

;	BY MARK O. AAGENAS, ZENITH DATA SYSTEMS

	.XLIST
	INCLUDE DEFMS.ASM
	INCLUDE DEFCHR.ASM

	.LIST
;
;*******************  PROGRAM SETUP  *****************************
;
;
STKSEG	SEGMENT	STACK
	DB	100H DUP(?)
STKSEG	ENDS
;
DATSEG	SEGMENT
;
RT_ADDR DD	0
;
CON_CHRD	DB 10H DUP(0)		;CONSOLE TABLE SWAP AREA
AUX_CHRD	DB 10H DUP(0)		;AUX DEVICE TABLE SWAP AREA
;
MESSAGE1	DB 027,'E Console is avalable.',07,'$'
MESSAGE2	DB 027,'E',027,'Y',43,64,'System busy!',027,'H$'
MESSAGE3	DB 027,'E',07,0DH,0AH,'$'
		DB 'Copyright 1983 by Marc O. Aagenas'
;
DATSEG	ENDS
;
;
PGMSEG	SEGMENT
;
	ASSUME CS:PGMSEG,SS:STKSEG,DS:DATSEG,ES:NOTHING
;
HERE:
	MOV	AX,DATSEG		;  SET UP DATA SEGMENT
	MOV	DS,AX			;  REGISTER
	MOV	WORD PTR RT_ADDR+2,ES	;  SET UP EXIT ADDRESS
	MOV	ES,AX			;  COPY DS TO ES
	JMP	MAIN_LOOP
	PAGE
;
;**********************  CALLED PROCEDURES  ***********************
;
RD_CHRDS	PROC NEAR		; READ IN DEVICE TABLES (AND SWAP THEM)
;
	MOV	AH,CHR_STATUS		; THIS IS A STATUS OPERATION
	MOV	AL,CHR_SFGC		; LOAD READ TABLE COMMAND
	PUSH	AX			; SAVE COPY OF COMMAND
	MOV	BX,OFFSET AUX_CHRD	; LOAD TABLE POINTER
	CALL	BIOS_CONFUNC		; EXECUTE FUNCTION
	POP	AX			; RETRIEVE COMMAND
	MOV	BX,OFFSET CON_CHRD	; READ OTHER TABLE
	CALL	BIOS_AUXFUNC
	RET
RD_CHRDS	ENDP
;
WR_CHRDS	PROC NEAR		; WRITE TABLES OUT
;
	MOV	AH,CHR_CONTROL		; THIS IS A CONTROL OPERATION
	MOV	AL,CHR_CFSU		; LOAD WRITE TABLE COMMAND
	PUSH	AX			; SAVE IT
	MOV	BX,OFFSET CON_CHRD	; LOAD POINTER
	CALL	BIOS_CONFUNC		; EXECUTE
	POP	AX			; RETRIEVE COMMAND
	MOV	BX,OFFSET AUX_CHRD	; WRITE OTHER TABLE
	CALL	BIOS_AUXFUNC
	RET
WR_CHRDS	ENDP
;
MESS	PROC NEAR			; PRINT MESSAGE
;
	MOV	AH,DOSF_OUTSTR
	INT	21H
	RET
MESS	ENDP
;
READ_AUX PROC NEAR			; TEST AUX DEVICE FOR A CHARACTER
;
	MOV	AH,CHR_READ
	CALL	BIOS_AUXFUNC
	JC	BACK			; NO CHARACTER THEN RETURN
	CMP	AL,0DH			; TEST FOR CARRIAGE RETURN
	JNE	BACK
	POP	AX			; CLEAN UP STACK
	JMP	AUX_USER
BACK:	RET
READ_AUX ENDP
READ_CON PROC NEAR			; TEST CON DEVICE FOR A CHARACTER
;
	MOV	AH,CHR_READ
	CALL	BIOS_CONFUNC
	JC	BACK1			; NO CHARACTER THEN RETURN
	CMP	AL,0DH			; TEST FOR CARRIAGE RETURN
	JNE	BACK1
	POP	AX			; CLEAN UP STACK
	JMP	CON_USER
BACK1:	RET
READ_CON ENDP
	PAGE
;
;***********************  MAIN BODY  ********************************
;
;
MAIN_LOOP:
;
	CALL	READ_AUX		; FIRST SEE IF NON-ACTIVE USER WANTS
					; THE SYSTEM. IF HE DOES THEN HE WILL
					; GET IT OTHER WISE BOTH USERS WILL
					; HAVE EQUAL OPPERTUNITY.
	MOV	DX,OFFSET MESSAGE1	; GET MESSAGE POINTER
	PUSH	DX			; SAVE IT
	CALL	MESS			; SEND TO PRESENT CON:
	CALL	RD_CHRDS		;
	CALL	WR_CHRDS		; SWAP USERS
	POP	DX			; SEND MESSAGE TO PRESENT AUX:
	CALL	MESS			;
	CALL	RD_CHRDS		; SWAP USERS AGAIN
	CALL	WR_CHRDS
;
WAIT_LOOP:				; WAIT UNTILL SOMEBODY WANTS THE CONSOLE!
;
	CALL	READ_AUX
	CALL	READ_CON
	JMP	WAIT_LOOP
;
CON_USER:				; THE CURRENT CONSOLE WANTS TO RETAIN USE
;
	CALL	RD_CHRDS		; SEND OTHER USER
	CALL	WR_CHRDS		; THE NOT AVAILABLE
	MOV	DX,OFFSET MESSAGE2	; MESSAGE
	CALL	MESS
	CALL	RD_CHRDS
	CALL	WR_CHRDS
	MOV	DX,OFFSET MESSAGE3	; RETURN CONTROL TO
	CALL	MESS			; CURRENT CONSOLE
	JMP	RT_ADDR
;
AUX_USER:				; THE CURRENT AUX USER WANTS THE SYSTEM
;
	MOV	DX,OFFSET MESSAGE2	; SEND THE NOT AVAILABLE
	CALL	MESS			; MESSAGE TO CURRENT CONSOLE
	CALL	RD_CHRDS		; SWAP
	CALL	WR_CHRDS		; CON: & AUX:
	MOV	DX,OFFSET MESSAGE3	;
	CALL	MESS			; RETURN TO Z-DOS WITH NEW CONSOLE
	JMP	RT_ADDR
PGMSEG	ENDS
	END	HERE
                                                                         