	PAGE	,132
	TITLE	SEE, A REPLACEMENT FOR "TYPE"
;	SEE - A PROGRAM TO LOOK AT TEXT FILES

;	THIS PROGRAM PROVIDES AN EASY WAY TO LOOK AT
;	TEXT FILES, AND INCLUDES THE ABILITY TO SCROLL
;	FORWARD OR BACKWARD BY LINES OR PAGES, TO SEARCH
;	FOR CHARACTER STRINGS, AND TO PRINT SCREENS OF
;	THE FILE.  THIS PROGRAM WAS INSPIRED BY "SC" BY
;	JOHN STETSON, BUT WAS DEVELOPED INDEPENDENTLY.
;	TO USE THIS PROGRAM, ENTER

;		SEE d:FILENAME.EXT

;	WHERE d: IS AN APPROPRIATE DRIVE DESIGNATION, AND
;	FILENAME.EXT IS THE NAME OF THE TEXT FILE TO SEE.

;	BY P. SWAYNE, HUG  25-FEB-83  28-MAY-83
;	Z-DOS VERSION  17-FEB-84  01-MAY-84
;	H150 MODS  17-MAY-84
;		IBM SCREEN CONTROL DERIVED FROM PROGRAMS BY BOB METZ

SEE	SEGMENT
	ASSUME	CS:SEE,DS:SEE,SS:SEE,ES:SEE

;	DEFINITIONS

M	EQU	Byte Ptr 0[BX]		;DEFINE MEMORY POINTER
CONIN	EQU	1			;CONSOLE INPUT
CONOUT	EQU	2			;CONSOLE OUTPUT
LSTOUT	EQU	5			;LST OUTPUT
DCIO	EQU	6			;DIRECT CONSOLE I/O
DCIN	EQU	7			;DIRECT CONSOLE INPUT
OPENF	EQU	15			;OPEN FILE
CLOSEF	EQU	16			;CLOSE FILE
READF	EQU	20			;READ FILE (SEQUENTIAL)
SETDMA	EQU	26			;SET DMA ADDRESS

	ORG	0
Z	LABEL	NEAR			;DEFINE ZERO LABEL
	ORG	5CH
FCB	LABEL	NEAR			;FILE CONTROL BLOCK
	ORG	6CH
FCB2	LABEL	NEAR			;SECOND FILE CONTROL BLOCK
	ORG	100H

;	MAIN PROGRAM

START:	MOV	AX,CS			;GET THIS SEGMENT
	MOV	DS,AX			;USE IT FOR DATA
	MOV	ES,AX			;AND ES
	MOV	SS,AX			;AND STACK
	MOV	SP,OFFSET STAK		;SET STACK
	MOV	DI,(Offset BUFFER)-1	;POINT TO BUFFER-1
	MOV	CX,128			;SET A COUNTER
	MOV	AL,1			;NON-NULL, NON-ASCII DATA
	STD				;MOVE BACKWARDS
	REP	STOSB			;CLEAR BEHIND BUFFER
	MOV	BX,0FFH			;PREPARE TO TEST MEMORY
MEMLP:	DEC	BH
	MOV	AL,M			;GET A BYTE
	INC	M			;TRY TO CHANGE MEMORY
	CMP	AL,M			;TEST
	MOV	M,AL			;REPLACE THE BYTE
	JZ	MEMLP			;NO CHANGE, IT'S NOT RAM
	MOV	Word Ptr MEMTOP,BX	;SAVE AS MEMORY TOP
	MOV	DX,(Offset FCB)+1	;POINT TO FCB FILE NAME POS.
	MOV	SI,DX			;GET CHARACTER THERE
	MOV	AL,[SI]
	CMP	AL,' '			;ANY FILE ENTERED?
	JZ	NOFILE			;NO
	MOV	AL,Byte Ptr FCB2+1	;ELSE, CHECK SECOND FCB
	CMP	AL,'P'			;"P" ENTERED?
	JNZ	NOLP			;NO, PRINTER NOT WANTED
	XOR	AL,AL
	MOV	Byte Ptr PRON,AL	;ELSE, FLAG PRINTER ON
NOLP:	DEC	DX			;POINT TO FCB
	MOV	Word Ptr FNAME,DX	;SAVE FILE NAME
	MOV	AH,OPENF
	INT	21H			;TRY TO OPEN FILE
	INC	AL			;GOOD OPEN?
	JZ	L_1	
	JMP	READ			;YES, READ FILE
L_1:	CALL	TYPTX
	DB	13,10,'ERROR - File cannot be found.',13,10+80H
	MOV	AH,0
	INT	21H			;RETURN TO Z-DOS
NOFILE:	CALL	TYPTX
	DB	13,10,'SEE Version 1.2 by PS:',13,10,10
	DB	'The correct use of this program is',13,10,10
	DB	'A'
	DB	'>SEE d'
	DB	':FILENAME.EXT',13,10,10
	DB	'where d'
	DB	': is a drive designation, and',13,10
	DB	'FILENAME.EXT is the file you want to SEE.',13,10+80H
	MOV	AH,0
	INT	21H			;RETURN TO Z-DOS

READ:	CALL	TYPTX
	DB	27,'Z'+80H		;ASK TERMINAL TYPE
	MOV	CX,50			;SET A COUNTER
WFCHR:	MOV	AH,0BH
	INT	21H			;TEST FOR REPLY
	OR	AL,AL
	JNZ	GOTCHR			;GOT REPLY
	LOOP	WFCHR			;ELSE, TRY AGAIN
	PUSH	CX
	MOV	AH,15
	INT	10H			;READ DISPLAY TYPE
	MOV	DISPLAY,AL		;SAVE DISPLAY TYPE
	CMP	AL,2			;80 COLUMN MODE?
	JNB	COL80			;YES
	INC	AL			;ELSE, CONVERT TO 80 COLUMNS
	INC	AL
	XOR	AH,AH
	INT	10H
COL80:	POP	CX
GOTCHR:	MOV	AX,0C00H
	INT	21H			;FLUSH TYPE-AHEAD
	MOV	SI,DX			;POINT SI TO FCB
	MOV	Word Ptr 12[SI],0	;CLEAR CURRENT BLOCK
	MOV	Byte Ptr 32[SI],0	;CLEAR CURRENT RECORD
	OR	CL,CL			;H150?
	JZ	H150			;IF SO, SET UP FOR IT
	CALL	TYPTX
	DB	27,'i','0'+80H		;REQUEST TERMINAL TYPE
	MOV	CL,0			;PRESET TERMINAL TYPE CODE (H19)
	CALL	SCINWT			;TEST FOR RESPONSE
	JZ	H19			;NO CHARACTER, MUST BE H19-TYPE
GOTRES:	CMP	AL,27			;ESCAPE?
	JNZ	H19			;NO, IT'S H19
	CALL	SCINWT			;GET NEXT CHARACTER
	JZ	H19			;NONE, H19
	CMP	AL,'i'			;LITTLE I?
	JNZ	H19			;NO, H19
	CALL	SCINWT			;GET NEXT CHARACTER
	JZ	H19			;NONE, H19
	CMP	AL,'B'			;"B"?
	JZ	H29			;IF SO, IT'S AN H29
	CMP	AL,'C'			;"C"?
	JZ	H29			;IT'S AN H49, USE H29
	CMP	AL,'E'			;"E"?
	JZ	H100			;IF SO, IT'S AN H100
	JMP	SHORT H19		;ELSE, IT'S AN H19
H150:	INC	CL			;ADD 1 FOR H150
H100:	INC	CL			;ADD 1 FOR H100
H29:	INC	CL			;ADD 1 FOR H29
H19:	MOV	AL,CL			;GET TERMINAL TYPE CODE
	MOV	Byte Ptr TTYPE,AL	;MARK TERMINAL TYPE
	CALL	SCINWT			;DUMP EXTRA CHARACTER
	MOV	CX,Word Ptr MEMTOP	;GET MEMORY TOP
	MOV	BX,(Offset BUFFER)
	SUB	CX,BX			;GET BUFFER SIZE
	MOV	BX,(Offset BUFFER)	;PUT FILE HERE
	MOV	Word Ptr TXTSTRT,BX	;SET UP TEXT START

READLP:	CALL	READFIL			;READ THE FILE
	JB	READ2			;GOT ALL OF IT
READ1:	XOR	AL,AL
	MOV	Byte Ptr NEXTFLG,AL	;CLEAR "NEXT" INHIBIT FLAG
READ2:	MOV	CX,128			;SET A COUNTER
	SUB	BX,128			;SUBTRACT 128 FROM ADDR
READ3:	MOV	AL,M			;GET A BYTE
	CMP	AL,'Z'-40H		;CONTROL-Z?
	JZ	READ4			;YES, FOUND END OF TEXT
	INC	BX			;INCREMENT POINTER
	LOOP	READ3			;LOOP FOR 128 BYTES
READ4:	MOV	Word Ptr RDEND,BX	;SAVE END OF READING
	MOV	Word Ptr TXTEND,BX	;SAVE END OF TEXT
	CMP	CX,0			;SEARCHED ALL OF END?
	MOV	AL,0
	JNZ	FNDEND			;IF NOT, END FOUND
READ5:	DEC	BX			;BACK UP
	INC	CX			;COUNT THE BACK-UP
	MOV	AL,M			;GET CHARACRER
	AND	AL,7FH			;STRIP PARITY
	CMP	AL,10			;LINE FEED?
	JNZ	READ5			;NOPE
	DEC	CX			;DON'T COUNT THE LINE FEED
	INC	BX			;MOVE PAST IT
	MOV	Word Ptr TXTEND,BX	;MARK REAL END OF TEXT
	MOV	AX,CX			;GET END COUNT
FNDEND:	MOV	Byte Ptr ENDCNT,AL	;SAVE IT
	MOV	DX,(Offset BUFFER)
	SUB	BX,DX			;FIND SIZE OF FILE IN BYTES
	XCHG	BX,DX			;DX = FILE SIZE
	MOV	BX,Word Ptr LINCNT	;GET LINE COUNT
	MOV	Word Ptr LINSTRT,BX	;UPDATE FIRST LINE
	XOR	CX,CX			;CLEAR A COUNTER
	MOV	BX,Word Ptr TXTSTRT	;POINT TO START OF TEXT
CNTLNS:	MOV	AL,M			;GET A CHARACTER
	AND	AL,7FH			;STRIP PARITY
	INC	BX			;INCREMENT POINTER
	CMP	AL,10			;LINE FEED?
	JNZ	CNTLN1			;NO
	INC	CX			;COUNT THIS LINE
CNTLN1:	DEC	DX			;DECREMENT SIZE COUNTER
	JNZ	CNTLNS			;LOOP UNTIL DONE
	MOV	BX,Word Ptr LINSTRT	;GET STARTING LINE
	ADD	BX,CX			;ADD LINE COUNT
	MOV	Word Ptr LINCNT,BX	;UPDATE LINE COUNT
	CMP	CX,25			;LESS THAN 25 LINES?
	JNB	FNDLP			;NO, FIND LAST PAGE
	MOV	BX,(Offset BUFFER)
	MOV	Word Ptr LASTPG,BX	;ELSE, LAST PAGE = BUFFER START
	JMP	SHORT PFN		;PRINT FILE NAME
FNDLP:	MOV	BX,Word Ptr TXTEND	;GET END OF TEXT
	DEC	BX			;SKIP LAST LINE FEED
	MOV	CX,24			;24 LINES/PAGE
FLP:	DEC	BX			;BACK UP ONE CHARACTER
	MOV	AL,M			;GET CHARACTER
	AND	AL,7FH			;REMOVE PARITY
	CMP	AL,10			;LINE FEED?
	JNZ	FLP			;NO, KEEP LOOKING
	LOOP	FLP			;LOOP FOR 24 LINES
	INC	BX			;MOVE TO FIRST CHAR IN PAGE
	MOV	Word Ptr LASTPG,BX	;SAVE LAST PAGE ADDRESS
PFN:	CALL	PBMSG			;PRINT BOTTOM MESSAGE
	MOV	BX,(Offset BUFFER)	;POINT TO BUFFER
	JMP	TOP0			;DISPLAY TOP OF FILE

;	MAIN COMMAND LOOP

CMDLP:	CALL	TYPTX
	DB	27,'Y8',' '+80H
	MOV	AL,Byte Ptr TTYPE	;GET TERMINAL TYPE
	DEC	AL			;H29?
	JZ	CMDLP01			;YES
	DEC	AL			;H100?
	JZ	CMDLP02			;YES
	DEC	AL			;H150?
	JZ	CMDLP02A		;YES
	CALL	TYPTX			;ELSE, PRINT H19 MESSAGE
	DB	27,'x6',27,'p',27,'Fiiii','i'+80H
	JMP	SHORT CMDLP03
CMDLP01:CALL	TYPTX			;PRINT H29 MESSAGE
	DB	27,'p',27,'Fiii',27,'s5F1',27,'s','1'+80H
	JMP	SHORT CMDLP03
CMDLP02:CALL	TYPTX			;PRINT H100 MESSAGE
	DB	27,'Fiii',27,'pF0',27,'q'+80H
	JMP	SHORT CMDLP03
CMDLP02A:CALL	TYPTX			;PRINT H150 MESSAGE
	DB	27,'Fiii',27,'pF1',27,'q'+80H
CMDLP03:CALL	TYPTX
	DB	8,8,8,8,8+80H
	MOV	BX,Word Ptr CURLIN	;GET CURRENT LINE NO.
	CALL	DECOUT			;PRINT IT
	CALL	TYPTX
	DB	27,'G',27,'q',27,'Y7',' '+80H
CMDLP0:	CALL	SCIN			;GET A CHARACTER
	CMP	AL,13			;CR?
	JNZ	CMDLP1	
	JMP	PLINE			;IF SO, MOVE DOWN ONE LINE
CMDLP1:	CMP	AL,27			;ESCAPE?
	JZ	CMDLP2			;YES
	OR	AL,AL			;NULL?
	JNZ	BEEP			;NO, ILLEGAL ENTRY
CMDLP2:	CALL	SCINWT			;LOOK FOR SECOND CHARACTER
	JZ	BEEP			;DIDN'T GET ONE
GOTCHAR:CMP	AL,'C'			;RIGHT WINDOW?
	JZ	RWINDJ			;YES
	CMP	AL,'D'			;LEFT WINDOW?
	JZ	LWINDJ			;YES
	CMP	AL,'M'			;RIGHT WINDOW IBM?
	JZ	RWINDJ			;YES
	CMP	AL,'K'			;LEFT WINDOW IBM?
	JZ	LWINDJ			;YES
	JMP	L_4			;ELSE, NO WINDOW
RWINDJ:	JMP	RWINDOW
LWINDJ:	JMP	LWINDOW
L_4:	MOV	CL,AL			;ELSE, SAVE CHARACTER IN C
	MOV	BX,(Offset CHRTBL)	;POINT TO CHARACTER TABLE
	MOV	DX,9			;9 CHARACTERS/TABLE
	MOV	AL,Byte Ptr TTYPE	;GET TERMINAL TYPE
	OR	AL,AL			;TEST FOR H19
	JZ	GOTTBL			;IT'S IT
	ADD	BX,DX			;MOVE TO 29 TABLE
	DEC	AL			;TEST
	JZ	GOTTBL			;IT'S H29
	ADD	BX,DX			;MOVE TO H100 TABLE
	DEC	AL			;TEST
	JZ	GOTTBL			;IT'S H100
	ADD	BX,DX			;ELSE, IT'S AN H150
GOTTBL:	MOV	CH,9			;SET A COUNTER
	MOV	DX,(Offset CMDTBL)	;POINT TO COMMAND TABLE
FCHAR:	MOV	AL,M			;GET A CHARACTER
	CMP	AL,CL			;IS THIS THE ONE ENTERED?
	JZ	EXECUT			;YES, EXECUTE THE COMMAND
	INC	DX			;ELSE, INCREMENT COMMAND POINTER
	INC	DX
	INC	BX			;INCREMENT CHARACTER POINTER
	DEC	CH			;DONE WITH LIST?
	JNZ	FCHAR			;NO, KEEP LOOKING
BEEP:	MOV	AL,7
	CALL	SCOUT			;BEEP
	JMP	CMDLP
EXECUT:	CMP	AL,'0'			;H29 F9 KEY?
	JNZ	EXECUT1			;NO
	CALL	SCIN			;ELSE, DUMP EXTRA CHARACTER
EXECUT1:XCHG	BX,DX			;BX POINTS TO COMMAND ADDRESS
	MOV	BX,Word Ptr [BX]	;GET COMMAND ADDRESS
	JMP	BX			;EXECUTE THE COMMAND

;	THE COMMANDS

PPAGE:	MOV	AL,Byte Ptr TTYPE	;GET TERMINAL TYPE
	DEC	AL			;H29?
	JZ	PPAGE0			;IF SO, LEAVE 25TH LINE ON
	CALL	TYPTX
	DB	27,'y','1'+80H		;TURN OFF 25TH LINE
PPAGE0:	MOV	CH,24			;SET A COUNTER
PPAGE1:	CALL	PLINE1			;PLUS ONE LINE
	DEC	CH			;DONE?
	JNZ	PPAGE1			;LOOP UNTIL DONE
	MOV	AL,Byte Ptr TTYPE	;GET TERMINAL TYPE
	DEC	AL			;H29?
	JZ	L_5A			;YES
	DEC	AL
	DEC	AL			;H150?
	JNZ	L_5			;NO
L_5A:	JMP	CMDLP			;IF SO, DONE
L_5:	CALL	PBMSG0			;PRINT BOTTOM LINE MSG
	JMP	CMDLP			;GET ANOTHER COMMAND

PLINE:	CALL	PLINE1			;PLUS ONE LINE
	JMP	CMDLP			;GET ANOTHER COMMAND
PLINE1:	MOV	BX,Word Ptr LASTPG	;GET LAST PAGE ADDRESS
	XCHG	BX,DX			;IN DE
	MOV	BX,Word Ptr TPADR	;GET TOP PAGE ADDRESS
	CMP	BX,DX			;COMPARE
	JNZ	PLINE2	
	RET				;SAME, DO NOT INCREMENT
PLINE2:	MOV	AL,M			;GET A CHARACTER
	AND	AL,7FH			;STRIP PARITY
	INC	BX			;MOVE TO NEXT CHAR
	CMP	AL,10			;LINE FEED?
	JNZ	PLINE2			;FIND LINE FEED
	MOV	Word Ptr TPADR,BX	;SAVE TOP PAGE ADDRESS
	CALL	TYPTX
	DB	27,'Y7 ',10+80H		;MOVE TEXT UP
	MOV	BX,Word Ptr BPADR	;GET BOTTOM PAGE ADDRESS
	CALL	PRLINE			;PRINT NEXT LINE
	INC	BX			;SKIP LINE FEED
	MOV	Word Ptr BPADR,BX	;UPDATE BOTTOM ADDR
	INC	Word Ptr CURLIN		;INCREMENT CURRENT LINE
	RET

TOP:	MOV	BX,Word Ptr TPADR	;GET TOP PAGE ADDRESS
	XCHG	BX,DX			;IN DE
	MOV	BX,(Offset BUFFER)
	CMP	BX,DX			;COMPARE
	JNZ	TOP0	
	JMP	CMDLP			;ALREADY AT TOP
TOP0:	MOV	Word Ptr TPADR,BX	;UPDATE TOP PAGE ADDRESS
	CALL	DISPPG			;DISPLAY PAGE
	MOV	BX,Word Ptr LINSTRT	;GET FIRST LINE NUMBER
	MOV	Word Ptr CURLIN,BX	;UPDATE CURRENT LINE
	JMP	CMDLP			;GET NEXT COMMAND

MLINE:	CALL	MLINE1			;MINUS ONE LINE
	JMP	CMDLP			;GET NEXT COMMAND
MLINE1:	MOV	BX,(Offset BUFFER)	;GET BUFFER ADDR
	XCHG	BX,DX			;IN DE
	MOV	BX,Word Ptr TPADR	;GET TOP PAGE ADDR
	CMP	BX,DX			;COMPARE
	JNZ	L_8	
	RET				;SAME, DO NOT DECREMENT
L_8:	DEC	BX			;BACK UP OVER LINE FEED
	CMP	BX,DX
	JZ	MLINE2A			;FOUND TOP
	DEC	BX
MLINE2:	CMP	BX,DX			;AT TOP OF PAGE?
	JZ	MLINE2A			;YES, QUIT BACKING UP
	MOV	AL,M			;GET A CHARACTER
	AND	AL,7FH			;STRIP PARITY
	DEC	BX			;MOVE TO PREVIOUS CHARACTER
	CMP	AL,10			;LINE FEED?
	JNZ	MLINE2			;FIND LINE FEED
	INC	BX			;SKIP OVER LINE FEED
	INC	BX
MLINE2A:MOV	Word Ptr TPADR,BX	;SAVE TOP PAGE ADDESS
	MOV	BX,Word Ptr BPADR	;GET BOTTOM PAGE ADDR
	DEC	BX			;BACK UP OVER LINE FEED
	DEC	BX
MLINE3:	MOV	AL,M			;FIND PREVIOUS LINE FEED
	AND	AL,7FH
	DEC	BX
	CMP	AL,10
	JNZ	MLINE3
	INC	BX
	INC	BX
	MOV	Word Ptr BPADR,BX	;UPDATE BOTTOM PAGE ADDR
	MOV	BX,Word Ptr CURLIN
	DEC	BX			;DECREMENT CURRENT LINE
	MOV	Word Ptr CURLIN,BX
	CALL	TYPTX
	DB	27,'H',27,'I'+80H	;BACK UP ONE LINE
	MOV	BX,Word Ptr TPADR	;GET TOP PAGE ADDR
	CALL	PRLINE			;PRINT THE LINE THERE
	RET

MPAGE:	MOV	BX,Word Ptr TPADR	;GET TOP PAGE ADDRESS
	MOV	DX,(Offset BUFFER)	;POINT TO BUFFER
	CMP	BX,DX			;COMPARE
	JNZ	L_10	
	JMP	CMDLP			;ALREADY AT TOP
L_10:	MOV	AL,Byte Ptr TTYPE	;GET TERMINAL TYPE
	DEC	AL			;H29?
	JZ	MPAGE1			;YES
MPAGE0:	CALL	TYPTX
	DB	27,'y','1'+80H		;TURN OFF 25TH LINE
MPAGE1:	MOV	CH,24			;SET A COUNTER
MPAGE2:	CALL	MLINE1			;MINUS ONE LINE
	DEC	CH
	JNZ	MPAGE2			;LOOP UNTIL DONE
	MOV	AL,Byte Ptr TTYPE	;GET TERMINAL TYPE
	DEC	AL			;H29?
	JZ	L_11A			;YES
	DEC	AL
	DEC	AL			;H150?
	JNZ	L_11
L_11A:	JMP	CMDLP			;IF SO, DONE
L_11:	CALL	PBMSG0			;ELSE, PRINT BOTTOM LINE MESSAGE
	JMP	CMDLP

BOTTOM:	MOV	BX,Word Ptr TPADR	;GET TOP PAGE ADDR
	XCHG	BX,DX			;IN DE
	MOV	BX,Word Ptr LASTPG	;GET LAST PAGE ADDR
	CMP	BX,DX			;COMPARE
	JNZ	L_12	
	JMP	CMDLP			;ALREADY AT BOTTOM
L_12:	MOV	Word Ptr TPADR,BX	;SET TOP PAGE ADDRESS
	MOV	BX,Word Ptr LINCNT	;GET LINE COUNT
	SUB	BX,24			;SUBTRACT 24
	MOV	Word Ptr CURLIN,BX	;UPDATE CURRENT LINE
	MOV	BX,Word Ptr TPADR
	CALL	DISPPG			;DISPLAY PAGE
	JMP	CMDLP			;GET NEXT COMMAND

PRPAGE:	MOV	AL,Byte Ptr PRON
	OR	AL,AL			;IS PRINTER ON?
	JZ	L_13	
	JMP	BEEP			;NO, DON'T EVEN TRY
L_13:	MOV	AL,1
	MOV	Byte Ptr PFLAG,AL	;SET PRINT FLAG
	MOV	BX,Word Ptr TPADR	;GET TOP PAGE ADDRESS
	CALL	DISP0			;DISPLAY PAGE (ON PRINTER THIS TIME)
	XOR	AL,AL
	MOV	Byte Ptr PFLAG,AL	;CLEAR PRINT FLAG
	JMP	BEEP

FIND:	CALL	LINPUT			;INPUT SEARCH LINE
	JNZ	L_14	
	JMP	FIND4			;ESC
L_14:	CALL	TYPTX			;PRINT "SEARCHING..."
	DB	27,'x5',27,'Y8 ',27,'K',27,'p'
	DB	'Searching for: ',' '+80H
	PUSH	DX			;SAVE SEARCH ARG ADDR
	MOV	AL,Byte Ptr LINLEN	;GET STRING LENGTH
	MOV	CH,AL			;IN B
PSMSG:	MOV	SI,DX			;GET A CHARACTER
	MOV	AL,[SI]
	CALL	SCOUT			;PRINT IT
	INC	DX
	DEC	CH
	JNZ	PSMSG			;LOOP UNTIL DONE
	POP	DX			;RESTORE SEARCH ARG ADDR
	CALL	TYPTX
	DB	27,'q',27,'Y7',' '+80H
	MOV	BX,Word Ptr CURLIN	;GET CURRENT LINE
	PUSH	BX			;SAVE IT
	INC	BX			;START WITH NEXT LINE
	MOV	Word Ptr CURLIN,BX	;SAVE NEW LINE NO.
	MOV	BX,Word Ptr TPADR	;GET TOP PAGE ADDRESS
	PUSH	BX			;SAVE IT
FIND1:	MOV	AL,M			;FIND NEXT LINE
	AND	AL,7FH
	INC	BX
	CMP	AL,10
	JNZ	FIND1
	PUSH	DX			;SAVE SUBSTRING
	PUSH	BX			;SAVE STRING
	NEG	BX			;GET -STRING ADDR
	XCHG	BX,DX			;IN DE
	MOV	BX,Word Ptr TXTEND	;GET TEXT END
	ADD	BX,DX			;COMPUTE STRING LENGTH
	MOV	CX,BX			;IN CX
	POP	BX
	POP	DX			;RESTORE ADDRESSES
	MOV	AL,Byte Ptr LINLEN	;GET INPUT LENGTH
	CALL	INSTR			;LOOK FOR STRING
	JZ	FIND2	
	JMP	NOFIND			;COULD NOT FIND IT
FIND2:	DEC	BX			;BACK UP TO BEGINNING OF STRING
	MOV	AL,M
	AND	AL,7FH
	CMP	AL,10
	JNZ	FIND2
	INC	BX			;SKIP LINE FEED
	MOV	Word Ptr TPADR,BX	;UPDATE TOP PAGE ADDRESS
	CALL	DISPPG			;DISPLAY PAGE WITH MATCH
	MOV	BX,Word Ptr LASTPG	;GET LAST PAGE
	XCHG	BX,DX			;IN DE
	MOV	BX,Word Ptr TPADR	;AND TOP PAGE ADDR
	CMP	BX,DX			;ON LAST PAGE?
	JNZ	FIND3			;NO
	MOV	BX,Word Ptr LINCNT	;ELSE, GET LINE COUNTER
	MOV	DX,-24
	ADD	BX,DX			;SUBTRACT 24
	MOV	AL,BH			;GET LINE NUMBER HIGH
	CMP	AL,0FFH			;IMPOSSIBLY HIGH?
	JNZ	GDLNO			;NO, GOOD NO.
	POP	DX
	POP	BX			;ELSE, GET ORIGINAL LINE NUMBER
	PUSH	BX			;FIX STACK
	PUSH	DX
GDLNO:	MOV	Word Ptr CURLIN,BX	;UPDATE CURRENT LINE
	CALL	TYPTX
	DB	7+80H			;BEEP
	MOV	BX,0
BPDLY:	DEC	BX			;WAIT A WHILE
	MOV	AL,BH
	OR	AL,BL
	JNZ	BPDLY
	CALL	TYPTX
	DB	7+80H			;BEEP AGAIN
FIND3:	POP	BX			;FIX STACK
	POP	BX
FIND4:	CALL	PBMSG0			;RESTORE BOTTOM LINE
	JMP	CMDLP
NOFIND:	POP	BX			;RESTORE OLD TOP ADDR
	MOV	Word Ptr TPADR,BX
	POP	BX			;RESTORE OLD LINE NUMBER
	MOV	Word Ptr CURLIN,BX
	CALL	PBMSG0			;RESTORE BOTTOM LINE
	JMP	BEEP

NEXT:	MOV	AL,Byte Ptr NEXTFLG	;GET "NEXT" INHIBIT FLAG
	OR	AL,AL			;IS IT SET?
	JZ	L_16	
	JMP	BEEP			;YES, IGNORE NEXT COMMAND
L_16:	INC	AL			;A = 1
	MOV	Byte Ptr NEXTFLG,AL	;SET FLAG
	MOV	BX,Word Ptr TXTEND	;POINT TO TEXT END
	MOV	AL,Byte Ptr ENDCNT	;GET END TEXT COUNT
	MOV	CH,AL
	MOV	DX,(Offset BUFFER)	;PUT TEXT HERE
	OR	AL,AL			;ANY END TEXT
	JZ	NETXT			;NO
NEXTLP:	MOV	AL,M			;MOVE THE TEXT
	MOV	SI,DX
	MOV	[SI],AL
	INC	BX
	INC	DX
	DEC	CH
	JNZ	NEXTLP
NETXT:	XCHG	BX,DX			;BX = NEXT TEXT AREA
	MOV	Word Ptr TXTSTRT,BX	;UPDATE TEXT START
	MOV	CX,Word Ptr MEMTOP	;GET MEMORY TOP
	SUB	CX,BX			;FIND FREE SPACE
	MOV	BX,Word Ptr TXTSTRT	;START READING HERE
	JMP	READLP			;READ THE TEXT

RWINDOW:MOV	AL,56			;SKIP 56 CHARACTERS
	MOV	Byte Ptr WFLAG,AL	;TO SHOW RIGHT WINDOW
	CALL	DISPPG			;DISPLAY PAGE
	JMP	CMDLP

LWINDOW:XOR	AL,AL
	MOV	Byte Ptr WFLAG,AL	;ZERO WINDOW FLAG
	CALL	DISPPG			;DISPLAY PAGE
	JMP	CMDLP

EXIT:	CALL	TYPTX
	DB	27,'z'+80H		;RESET TO POWER-UP CONFIG.
	MOV	CX,8000H
EWAIT:	LOOP	EWAIT
	CMP	Byte Ptr TTYPE,3	;H150?
	JNZ	EXIT1			;NO
	MOV	AL,DISPLAY		;ELSE, GET OLD DISPLAY TYPE
	XOR	AH,AH
	INT	10H			;SET IT
EXIT1:	INT	20H			;RETURN TO Z-DOS

;	SUBROUTINES
;	READFIL - READ DISK FILE
;	ENTRY:	BX = ADDRESS TO READ INTO
;	CX = NUMBER OF BYTES TO READ
;	EXIT:	CY = 1 IF END OR ERROR, AND
;	BX = NEXT FREE BYTE

READFIL:MOV	DX,Offset FCB		;(LEAVE OUT IF EXTERNAL FCB)
	MOV	SI,DX			;FCB ADDR IN SI
	MOV	Word Ptr 14[SI],1	;SET RECORD SIZE TO 1 BYTE
	PUSH	CX			;SAVE COUNT
	XCHG	BX,DX			;DX = ADDRESS
	MOV	AH,SETDMA
	INT	21H			;SET DMA ADDRESS
	XCHG	BX,DX			;DX = FCB
	PUSH	DX
	MOV	AH,24H			;SET RANDOM RECORD
	INT	21H
	POP	DX
	POP	CX			;GET AMOUNT TO READ
	MOV	AH,27H			;USE RANDOM BLOCK READ
	INT	21H			;READ FILE
	ADD	BX,CX			;POINT TO END OF TEXT READ
	OR	AL,AL			;OPERATION OK?
	JNZ	RFIL1			;NO, EXIT
	RET				;RETURN
RFIL1:	STC				;MARK EOF FOUND
	RET

;	TYPTX - TYPE TEXT UNTIL PARITY BIT SET

TYPTX:	MOV	BP,SP			;GET TEXT ADDR
	XCHG	BX,[BP]
TYPTX1:	MOV	AL,M
	AND	AL,7FH
	CALL	SCOUT
	CMP	AL,M
	LAHF
	INC	BX
	SAHF
	JZ	TYPTX1
	MOV	BP,SP
	XCHG	BX,[BP]
	RET
;	SCIN - SINGLE CHARACTER INPUT


SCIN:	PUSH	DX
	MOV	AH,DCIN
	INT	21H
	POP	DX
	CMP	AL,'C'-40H		;CONTROL-C?
	JNZ	L_19	
	JMP	EXIT			;IF SO, QUIT
L_19:	RET

;	SCINWT - CHECK FOR CHARACTER WITHIN SHORT TIME

SCINWT:	MOV	CH,150			;SET A COUNTER
SCINWLP:MOV	AH,DCIO
	PUSH	DX
	MOV	DL,0FFH			;SIGNAL INPUT
	INT	21H
	POP	DX
	OR	AL,AL
	JZ	L_20	
	RET				;GOT ONE
L_20:	DEC	CH			;DECREMENT COUNTER
	JNZ	SCINWLP			;TRY AGAIN
	RET				;RETURN WITH Z FLAG SET

;	SCOUT - OUTPUT CHARACTER

SCOUT:	PUSH	AX
	PUSH	CX
	PUSH	BX
	PUSH	DX
	CMP	Byte Ptr TTYPE,3	;H150?
	JNZ	SCOUT1
	CALL	IBMOUT
	JMP	SCOUT2
SCOUT1:	MOV	DL,AL
	MOV	AH,DCIO
	INT	21H
SCOUT2:	POP	DX
	POP	BX
	POP	CX
	POP	AX
	RET

;	POUT - OUTPUT CHARACTER TO PRINTER

POUT:	PUSH	CX
	PUSH	DX
	MOV	DL,AL			;CHARACTER TO E
	MOV	AH,LSTOUT
	INT	21H			;PRINT CHARACTER
	POP	DX
	POP	CX
	RET

;	PRLINE - PRINT LINE AT (BX)

PRLINE:	MOV	AL,Byte Ptr PFLAG	;GET PRINT FLAG
	OR	AL,AL			;PRINTING?
	JNZ	PRLINE3			;YES, NO WINDOW CHECK
	MOV	AL,Byte Ptr WFLAG	;GET WINDOW FLAG
	OR	AL,AL			;ZERO?
	JZ	PRLINE3			;YES, SHOW LEFT WINDOW
	PUSH	CX			;ELSE, SAVE CX
	MOV	CL,0			;ZERO A COUNTER
	MOV	CH,AL			;PUT FLAG IN B
PRLINE1:MOV	AL,M			;GET A CHARACTER
	AND	AL,7FH			;STRIP PARITY
	CMP	AL,10			;END OF LINE?
	JZ	PRLINE2			;YES
	INC	BX			;MOVE TO NEXT CHARACTER
	CMP	AL,9			;TAB?
	JZ	PRTAB			;YES, PROCESS IT
	CMP	AL,27			;ESCAPE?
	JNZ	NOTESC			;NOT AN ESCAPE
	INC	BX			;ELSE, SKIP NEXT CHARACTER
	MOV	AL,M			;GET NEXT CHARACTER
	CMP	AL,'s'			;H29 ATTRIBUTE?
	JZ	SKIP1			;IF SO, SKIP ONE MORE CHAR
	CMP	AL,'m'			;H100 COLOR SETTING?
	JNZ	PRLINE1			;NO
	INC	BX			;ELSE, SKIP TWO MORE CHARS
SKIP1:	INC	BX
	JMP	SHORT PRLINE1		;AND CHECK FOLLOWING ONE
NOTESC:	CMP	AL,' '			;ANY OTHER CONTROL CHARACTER?
	JB	PRLINE1			;IF SO, DON'T COUNT IT
	INC	CL			;ELSE, COUNT CHARACTER
	DEC	CH			;DONE?
	JNZ	PRLINE1
	JMP	SHORT PRLINE2		;PRINT REST OF LINE NORMALLY
PRTAB:	DEC	CH			;DECREMENT WINDOW COUNTER
	JZ	PRLINE2			;DONE, PRINT NORMALLY
	INC	CL			;INCREMENT PLACE COUNTER
	MOV	AL,CL			;GET IT
	AND	AL,7			;AT TAB STOP?
	JNZ	PRTAB			;IF NOT, KEEP COUNTING
	JMP	SHORT PRLINE1		;ELSE, CHECK NEXT CHARACTER
PRLINE2:POP	CX			;RESTORE CX
PRLINE3:MOV	AL,M			;GET A CHARACTER
	AND	AL,7FH			;STRIP PARITY
	CMP	AL,' '			;SPACE OR MORE
	JNB	PRL0			;IF SO, PRINT CHAR
	CMP	AL,27			;ESCAPE?
	JZ	PRL0			;OK
	CMP	AL,7			;LESS THAN 7
	JB	PRL2			;DON'T PRINT
	CMP	AL,10			;10 OR LESS
	JZ	PREND			;LINE FEED, RETURN
	JNB	PRL2			;DON'T PRINT MORE THAN 10
PRL0:	CMP	Byte Ptr PFLAG,0	;PRINTER ON?
	JZ	PRL1			;NO
	CALL	POUT			;ELSE, USE PRINTER OUT
	JMP	SHORT PRL2
PRL1:	CALL	SCOUT			;NOT PRINTER, USE SCOUT
PRL2:	INC	BX			;MOVE TO NEXT CHARACTER
	JMP	SHORT PRLINE3		;PRINT IT
PREND:	CMP	Byte Ptr PFLAG,0	;USING PRINTER?
	JZ	L_21	
	RET				;IF SO, RETURN
L_21:	CALL	TYPTX			;ELSE, PRINT SPACE AFTER LINE
	DB	' '+80H			;TO CLEAR >80 CHAR PILEUP
	RET

;	DISPPG - DISPLAY PAGE AT (TPADR)

DISPPG:	CALL	TYPTX
	DB	27,'w',27,'E'+80H	;CLEAR WRAP AND SCREEN
DISP0:	MOV	BX,Word Ptr LASTPG	;GET LAST PAGE ADDRESS
	XCHG	BX,DX			;IN DE
	MOV	BX,Word Ptr TPADR	;GET TOP PAGE ADDRESS
	CMP	BX,DX			;COMPARE LASTPG WITH TPADR
					;TO SEE IF SHORT PAGE
	JB	DISP1			;LASTPG BIGGER, IT'S OK
	XCHG	BX,DX			;ELSE, USE LASTPG FOR START
	MOV	Word Ptr TPADR,BX	;UPDATE TOP PAGE ADDRESS
DISP1:	XCHG	BX,DX			;SAVE TOP ADDR
	MOV	BX,Word Ptr TXTEND	;GET END OF TEXT
	XCHG	BX,DX			;IN DE
	MOV	CH,24			;SET A COUNTER
DISP2:	CALL	PRLINE			;PRINT A LINE
	MOV	AL,Byte Ptr PFLAG	;GET PRINT FLAG
	OR	AL,AL			;PRINTING?
	JZ	DISPNP			;NO
	MOV	AL,13
	CALL	POUT			;PRINT CR
	MOV	AL,10
	CALL	POUT			;PRINT LF
DISPNP:	INC	BX			;SKIP LINE FEED
	CMP	BX,DX			;END OF TEXT?
	JZ	DISP3			;YES, END EARLY
	DEC	CH			;DONE?
	JZ	DISP3			;DONE
	MOV	AL,Byte Ptr PFLAG
	OR	AL,AL			;PRINTING
	JNZ	DISP2			;YES, NO CRLF ON SCREEN
	CALL	TYPTX
	DB	13,10+80H		;MOVE TO NEXT LINE
	JMP	SHORT DISP2		;PRINT IT
DISP3:	MOV	Word Ptr BPADR,BX	;SET BOTTOM PAGE ADDR
	RET

;	DECOUT - PRINT BX IN DECIMAL
;	THIS IS A TRICKY ROUTINE THAT MAKES USE OF THE
;	STACK TO STORE DECODED DIGITS.

DECOUT:	PUSH	CX
	PUSH	DX
	PUSH	BX			;SAVE REGISTERS
	MOV	CX,10			;RADIX FOR CONVERSION
	MOV	DX,0
	MOV	AX,BX
	DIV	CX			;DIVIDE BY 10
	MOV	BX,AX			;ANSWER TO BX (DX [REMAINDER] = DIGIT)
	CMP	BX,0			;DONE?
	JZ	DEC1	
	CALL	DECOUT			;CALL RECURSIVELY UNTIL DONE
DEC1:	MOV	AL,DL			;GET CHARACTER TO PRINT
	ADD	AL,'0'			;ADD ASCII BIAS
	CALL	SCOUT			;PRINT IT
	POP	BX			;RESTORE REGISTERS
	POP	DX
	POP	CX
	RET

;	INSTR - SEARCH STRING FOR SUBSTRING
;	BX = STRING
;	DX = SUBSTRING
;	CX = STRING LENGTH
;	AL = SUBSTRING LENGTH
;	RETURNS Z FLAG IF FOUND, WITH BX = END OF SUBSTRING

INSTR:	PUSH	DS
	POP	ES			;ENSURE ES IS HERE
	CLD				;ENSURE DIRECTION IS FORWARD
	MOV	AH,0
	MOV	BP,AX			;SAVE SUBSTRING LENGTH
	SUB	CX,AX			;SUBTRACT SUB. L. FROM STRING LENGTH
INSTR0:	PUSH	CX			;SAVE STRING SIZE
	MOV	CX,BP
	MOV	AL,M			;GET FIRST CHARACTER
	AND	AL,7FH			;STRIP PARITY
	CMP	AL,10			;LINE FEED?
	JNZ	INSTR1			;NO
	INC	Word Ptr CURLIN		;INCREMENT LINE COUNTER
	JMP	SHORT INSTR3		;NO MATCH ON LINE FEED
INSTR1:	MOV	DI,DX			;SUBSTRING TO DI
	MOV	SI,BX			;MAIN STRING TO SI
INSTR2:	LODSB				;GET A BYTE FROM SRING
	AND	AL,7FH			;REMOVE PARITY
	SCASB				;COMPARE WITH SUBSTRING
	LOOPZ	INSTR2			;LOOP IF MATCH
INSTR3:	POP	CX
	JZ	INSTR4			;FOUND SUBSTRING
	INC	BX			;INCREMENT STRING POINTER
	LOOP	INSTR0			;TRY AGAIN
	RET				;NO MATCH
INSTR4:	ADD	BX,BP			;MOVE TO END OF STRING
	XOR	AL,AL			;SET ZERO
	RET

;	LINPUT - LINE INPUT (FOR SEARCH STRING)

LINPUT:	CALL	TYPTX
	DB	27,'Y8 ',27,'l',27,'p',27,'y5'
	DB	' Enter string (RET = last, ESC = exit): '
	DB	27,'q'+80H
	MOV	BX,(Offset LINBUF)	;POINT TO LINE BUFFER
	MOV	CH,0			;SET A COUNTER
LINPUT1:CALL	SCIN			;GET A CHARACTER
	JZ	LINPUT1
	CMP	AL,13
	JZ	LINEND			;YES, END
	CMP	AL,8			;BACK SPACE?
	JZ	BACKUP
	CMP	AL,7FH			;DELETE?
	JZ	BACKUP
	CMP	AL,27			;ESCAPE?
	JNZ	L_27	
	RET				;YES, ABORT
L_27:	CMP	AL,9			;TAB?
	JZ	LINTAB			;YES, INPUT TAB
	CMP	AL,' '			;OTHER CONTROL CHARACTER?
	JB	LINPUT1			;IF SO, DON'T TAKE IT
LINTAB:	MOV	M,AL			;ELSE, STORE CHARACTER
	CALL	SCOUT			;PRINT IT
	INC	BX			;INCREMENT POINTER
	INC	CH			;INCREMENT COUNTER
	MOV	AL,CH
	CMP	AL,40			;40 CHARACTERS?
	JZ	LINEND			;YES
	JMP	SHORT LINPUT1		;GET ANOTHER CHARACTER
BACKUP:	INC	CH
	DEC	CH			;SET FLAGS
	JZ	LINPUT1			;TAKE NO ACTION
	CALL	TYPTX
	DB	8,' ',8+80H		;WIPE OUT CHARACTER
	DEC	CH			;DECREMENT COUNTER
	DEC	BX			;AND POINTER
	JMP	SHORT LINPUT1
LINEND:	MOV	AL,CH			;GET COUNT
	OR	AL,AL			;IS IT ZERO?
	JNZ	LINPUT2			;NO, USE THIS STRING
	MOV	DX,(Offset PRVSTR)	;ELSE, USE PREVIOUS STRING
	MOV	AL,Byte Ptr LINLEN	;GET OLD LINE LENGTH
	OR	AL,AL			;SET FLAGS
	RET
LINPUT2:MOV	BX,(Offset LINBUF)	;POINT TO BUFFER
	MOV	DX,(Offset PRVSTR)	;AND PREVIOUS STRING SPACE
	MOV	Byte Ptr LINLEN,AL	;SET LENGTH
LINPUT3:MOV	AL,M
	MOV	SI,DX			;UPDATE PREV. STRING
	MOV	[SI],AL
	INC	BX
	INC	DX
	DEC	CH
	JNZ	LINPUT3
	MOV	DX,(Offset LINBUF)	;GET BUFFER
	INC	CH			;SET FLAGS
	RET

;	PBMSG - PRINT BOTTOM LINE MESSAGE

PBMSG:	CALL	TYPTX
	DB	27,'E'+80H
PBMSG0:	MOV	AL,Byte Ptr TTYPE	;GET TERMINAL TYPE
	DEC	AL			;H29?
	JNZ	L_28	
	JMP	PBMSG29			;YES
L_28:	DEC	AL			;H100?
	JNZ	L_29	
	JMP	PBMS100			;YES
L_29:	DEC	AL			;H150?
	JNZ	L_30
	JMP	PBMS150
L_30:	CALL	TYPTX			;ELSE, PRINT H19 MSG.
	DB	27,'x5',27,'x1',27,'Y8 ',27,'K',27,'p',27,'F'
	DB	'iiiii',27,'G+Page',27,'Fii',27,'G+Line'
	DB	27,'Fii',27,'G-Line',27,'Fii',27,'G-Page'
	DB	27,'Fii',27,'GTop',27,'Fii',27,'GBottom'
	DB	27,'Fii',27,'GPrint',27,'Fii',27,'GFind'
	DB	27,'Fii',27,'GNext',27,'Fi',27,'G'+80H
	JMP	PFNAM			;GO PRINT FILE NAME
PBMSG29:CALL	TYPTX			;PRINT H29 MESSAGE
	DB	27,'x5',27,'x1',27,'Y8 ',27,'K',27,'p',27,'Fiii'
	DB	27,'G',27,'s5F1',27,'s1+Page',27,'s5F2',27,'s1+Line'
	DB	27,'s5F3',27,'s1-Line',27,'s5F4',27,'s1-Page'
	DB	27,'s5F5',27,'s1Top',27,'s5F6',27,'s1Bottom'
	DB	27,'s5F7',27,'s1Print',27,'s5F8',27,'s1Find'
	DB	27,'s5F9',27,'s1Next',27,'Fi',27,'G'+80H
	JMP	PFNAM
PBMS100:CALL	TYPTX			;PRINT H100 MESSAGE
	DB	27,'x5',27,'x1',27,'Y8 ',27,'K',27,'Fiii'
	DB	27,'G',27,'pF0',27,'q+Page',27,'pF1',27,'q+Line'
	DB	27,'pF2',27,'q-Line',27,'pF3',27,'q-Page'
	DB	27,'pF4',27,'qTop',27,'pF5',27,'qBottom'
	DB	27,'pF6',27,'qPrint',27,'pF7',27,'qFind'
	DB	27,'pF8',27,'qNext',27,'Fi',27,'G'+80H
	JMP	PFNAM
PBMS150:CALL	TYPTX			;PRINT H150 MESSAGE
	DB	27,'x5',27,'x1',27,'Y8 ',27,'K',27,'Fiii'
	DB	27,'G',27,'pF1',27,'q+Page',27,'pF2',27,'q-Page'
	DB	27,'pF3',27,'q+Line',27,'pF4',27,'q-Line'
	DB	27,'pF5',27,'qTop',27,'pF6',27,'qBottom'
	DB	27,'pF7',27,'qPrint',27,'pF8',27,'qFind'
	DB	27,'pF9',27,'qNext',27,'Fi',27,'G'+80H
PFNAM:	MOV	BX,Word Ptr FNAME	;GET FILE NAME
	MOV	AL,M			;GET DRIVE CODE
	OR	AL,AL			;ANY THERE
	JZ	FNAA			;NO
	ADD	AL,'@'			;ADD ASCII
	CALL	SCOUT			;PRINT IT
	MOV	AL,':'
	CALL	SCOUT			;PRINT COLON
FNAA:	INC	BX			;SKIP TO NAME
	MOV	CH,8
FNAMLP:	MOV	AL,M			;GET A CHARACTER
	INC	BX			;MOVE TO NEXT
	OR	AL,AL			;END OF NAME?
	JZ	FNEND			;YES
	CMP	AL,' '			;SPACE?
	JZ	FNAM1			;YES, DON'T PRINT
	CALL	SCOUT			;PRINT NAME CHARACTER
FNAM1:	DEC	CH
	JNZ	FNAMLP			;LOOP UNTIL DONE
	MOV	AL,'.'
	CALL	SCOUT			;PRINT PERIOD
	MOV	CH,3
FNAMLP1:MOV	AL,M			;GET CHARACTER
	INC	BX			;MOVE TO NEXT
	CALL	SCOUT			;PRINT CHARACTER
	DEC	CH
	JNZ	FNAMLP1			;LOOP UNTIL DONE
FNEND:	CALL	TYPTX
	DB	' '+80H
FNEND0:	CALL	TYPTX
	DB	27,'q',27,'Y7',' '+80H
	RET

;	Z19 CODE TO IBM TRANSLATOR -- WITH THANKS TO BOB METZ

IBMOUT:	JMP	WORD PTR IBMJMP
IBMOUT1:AND	AL,7FH
	CMP	AL,1BH			;ESCAPE?
	JNZ	CRT_OUT			;NO, NORMAL CHAR
	MOV	WORD PTR IBMJMP,OFFSET FIND_CODE	;ELSE, FIND CODE NEXT
IBMRET:	RET				;AND IGNORE ESC

CRT_OUT:OR	AL,AL			;NUL?
	JZ	IBMRET			;IF SO, RETURN
	CMP	AL,9			;TAB?
	JNZ	CRTOT1
	JMP	TAB			;IF SO, PROCESS IT HERE
CRTOT1:	CMP	AL,' '			;LET WRT TTY DO CONTROL
	JB	WRT_TTY
	CMP	BYTE PTR GRAFLG,0	;GRAPHICS MODE?
	JE	SCREEN_OUT		; NO - NORMAL
	CMP	AL,5EH			; YES - GRAPHICS CHR?
	JB	SCREEN_OUT
	CMP	AL,7EH		
	JA	SCREEN_OUT
	SUB	AL,5EH
	MOV	BX,OFFSET IBMGRPH
	XLAT
SCREEN_OUT:
	MOV	AH,9
	MOV	BL,ATTR
	MOV	BH,0			;WRITE CHR W/ ATTRIBUTE
	MOV	CX,1
	INT	10H
	JMP	DORT			;MOVE CURSOR OVER
WRT_TTY:CMP	AL,10			;LF?
	JNE	WRT_TTY1
	MOV	AH,3			; YES, GET CURSOR POSITION
	MOV	BH,0
	INT	10H
	MOV	AL,10
	CMP	DH,23			;IF LINE <24 THEN NORMAL LF
	JL	WRT_TTY1
	JE	SCROL_24		;IF LINE = 24 THEN SCROLL 1-24
	RET				;IF LINE = 25 THEN IGNORE LF
SCROL_24:
	MOV	AX,601H
	MOV	CX,0
	MOV	DH,23
	MOV	DL,79
	MOV	BH,ATTR
	INT	10H
	RET
WRT_TTY1:MOV	AH,14			; WRITE TTY TO SCREEN
	MOV	BL,ATTR 
	MOV	BH,0
	INT	10H
	RET
;
FIND_CODE:
	MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	MOV	BX,OFFSET CODETABLE
FIND_LP:CMP	BYTE PTR [BX],0		;END OF TABLE?
	JNE	CHKIT			; NO
	RET				; YES - IGNORE ESC SEQUENCE
CHKIT:	CMP	AL,[BX]	
	JE	PROCESSIT
	ADD	BX,3			;NOT THIS ENTRY - CHECK NXT
	JMP	FIND_LP
PROCESSIT:
	JMP	WORD PTR 1[BX]		;ENTER ESC SEQ PROCESSOR

;	ESCAPE SEQUENCE PROCESSORS

;	RESET SCREEN

IBMRST:	MOV	BYTE PTR ATTR,7		;RESET ATTRIBUTE
	MOV	BYTE PTR GRAFLG,0	;GRAPHIC MODE OFF
	MOV	AH,5
	MOV	AL,0			;ACTIVE PAGE IS 0
	INT	10H
	MOV	AX,600H
	MOV	BH,ATTR			;GET ATTRIBUTE
	MOV	CX,0
	MOV	DH,24			;CLEAR SCREEN
	MOV	DL,79
	INT	10H
	JMP	DOHOME

GRAFON:	MOV	BYTE PTR GRAFLG,1	;GRAPHIC MODE ON
	RET
GRAFOF:	MOV	BYTE PTR GRAFLG,0	;GRAPHIC MODE OFF
	RET

REVIND:	MOV	AH,3			;REVERSE INDEX
	MOV	BH,0
	INT	10H			;GET CURSOR LOCATION
	CMP	DH,0			;LINE 1?
	JNZ	DOUP			;NO
	MOV	AX,701H			;ELSE, SCROLL DOWN
	MOV	CX,0
	MOV	DH,23
	MOV	DL,79
	MOV	BH,ATTR
	INT	10H
	RET

;	CURSOR ADDRESSING

DOADR:	MOV	WORD PTR IBMJMP,OFFSET GETROW	;NEXT CHAR IS ROW
	RET
GETROW:	MOV	SAV_ROW,AL			;SAVE ROW
	MOV	WORD PTR IBMJMP,OFFSET GETCOL	;NEXT CHAR IS COLUMN
	RET
GETCOL:	MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	MOV	DH,SAV_ROW
	MOV	DL,AL				;AL = COLUMN
	SUB	DX,'  '			;CONVERT TO 0 BASE
SETCURS:MOV	AH,2
	MOV	BH,0
	INT	10H			;SET CURSOR POSITION CALL
	RET
;
DOUP:	MOV	AH,3			;CURSOR UP
	MOV	BH,0
	INT	10H			;GET CURRENT POS
DOUP1:	DEC	DH
	CMP	DH,0
	JAE	SETCURS
	INC	DH			;DON'T ALLOW TO GO OFF SCREEN
	JMP SHORT SETCURS
;
DODWN:	MOV	AH,3			;CURSOR DOWN
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
DODWN1:	CMP	DH,24			;AT BOTTOM LINE?
	JZ	DODWN2			;IF SO, NO SCROLL
	INC	DH
	CMP	DH,23
	JLE	SETCURS
DODWN2:	RET
;
TAB:	MOV	AH,3			;PROCESS TABS
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	ADD	DL,8
	AND	DL,0F8H			;MOV TO NEXT TAB STOP
	JMP SHORT DORT1
;
DORT:	MOV	AH,3			;CURSOR RIGHT
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	INC	DL
DORT1:	CMP	DL,79
	JBE	SETCURS
	RET				;CURSOR IN LAST COLUMN
;
DOLFT:	MOV	AH,3			;CURSOR LEFT
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	DEC	DL
	CMP	DL,0
	JAE	SETCURS
	RET				;CURSOR IN FIRST COLUMN

DOHOME:	MOV	DX,0			;HOME CURSOR
	JMP	SETCURS
;
DOCLR:	MOV	AX,600H			;CLEAR SCREEN
	MOV	BH,ATTR
	MOV	CX,0			;ERASE LINES 1-24,COLS 1-80
	MOV	DH,23
	MOV	DL,79
	INT	10H
	JMP SHORT DOHOME
;
ERSEOL:	MOV	AH,3			;ERASE TO END OF LINE
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	MOV	AX,600H
	MOV	BH,ATTR
	MOV	CX,DX
	MOV	DL,79
	INT	10H
	RET
;
ERSEOS:	MOV	AH,3			;ERASE TO END OF SCREEN
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	MOV	AX,600H
	MOV	BH,ATTR			;ERSEOL FIRST
	MOV	CX,DX
	MOV	DL,79
	PUSH	CX			;SAVE CURSOR POSITION
	INT	10H
	POP	CX
	MOV	DH,23
	MOV	DL,79
	CMP	CH,23
	JE 	ERS_RET
	INC	CH
	MOV	AX,600H
	MOV	BH,ATTR
	INT	10H
ERS_RET:RET

ERSLIN:	MOV	AH,3			;ERASE LINE
	MOV	BH,0
	INT	10H			;GET CURRENT LOCATION
	MOV	CX,DX
	MOV	CL,0
	MOV	DL,79
	MOV	AX,0600H		;SCROLL REGION (SINGLE LINE) CLEAR
	MOV	BH,ATTR
	INT	10H
	RET
;
SAVCRS:	MOV	AH,3			;SAVE CURSOR POSITION
	MOV	BH,0
	INT	10H
	MOV	CURSAV,DX
	RET
;
RSTCRS:	MOV	DX,CURSAV		;RESTORE CURSOR POSITION
	JMP	SETCURS
;
DOREV:	MOV	BYTE PTR ATTR,70H 	;REV. VIDEO
	RET
;
DONRM:	MOV	BYTE PTR ATTR,7		;NOR. VIDEO
	RET

IGNORE:	MOV	WORD PTR IBMJMP,OFFSET IGNORE1	;IGNORE NEXT CHAR
	RET
IGNORE1:MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	RET

IBMJMP	DW	IBMOUT1			;JUMP INTO CODE
GRAFLG	DB	0			;GRAPHICS MODE FLAG
ATTR	DB	2  			;DEFAULT ATTRIBUTE (GREEN ON BLACK)
SAV_ROW	DB	0			;SAVED ROW POSITION
CURSAV	DW	0			;SAVED CURSOR POSITION
;
CODETABLE:				;ESC SEQUENCE PROCESSOR TABLE
	DB	'Y'
	DW	OFFSET DOADR
	DB	'E'
	DW	OFFSET DOCLR
	DB	'F'
	DW	OFFSET GRAFON
	DB	'G'
	DW	OFFSET GRAFOF
	DB	'J'
	DW	OFFSET ERSEOS
	DB	'K'
	DW	OFFSET ERSEOL
	DB	'A'
	DW	OFFSET DOUP
	DB	'B'
	DW	OFFSET DODWN
	DB	'C'
	DW	OFFSET DORT
	DB	'D'
	DW	OFFSET DOLFT
	DB	'H'
	DW	OFFSET DOHOME
	DB	'I'
	DW	OFFSET REVIND
	DB	'l'
	DW	ERSLIN
	DB	'p'
	DW	OFFSET DOREV
	DB	'q'
	DW	OFFSET DONRM
	DB	'j'
	DW	OFFSET SAVCRS
	DB	'k'
	DW	OFFSET RSTCRS
	DB	'x'
	DW	OFFSET IGNORE
	DB	'y'
	DW	OFFSET IGNORE
	DB	'z'
	DW	OFFSET IBMRST
	DB	0			;END OF TABLE
;
;      Z-100 to IBM PC graphic chr xlat table
;	only locs 5eh to 7eh are present    
;
IBMGRPH	LABEL	BYTE
	db	0f9h	; ^
	db	0dbh	; _
	db	0bah	; `
	db	0cdh	; a
	db	0ceh	; b
	db	0bbh	; c
	db	0bch	; d
	db	0c8h	; e
	db	0c9h	; f
	db	0f1h	; g
	db	01ah	; h
	db	0b0h	; i
	db	0f6h	; j
	db	019h	; k
	db	0dah	; l
	db	0dbh	; m
	db	0d9h	; n
	db	0dbh	; o
	db	0dfh	; p
	db	0deh	; q
	db	0dbh	; r
	db	0cbh	; s
	db	0b9h	; t
	db	0cah	; u
	db	0cch	; v
	db	0dbh	; w
	db	0dbh	; x
	db	0dbh	; y
	db	0dbh	; z
	db	0dbh	; {
	db	0dbh	; |
	db	0dbh	; }
	db	014h	; ~
	db	0dbh	; del

;	VARIABLES AND BUFFER

MEMTOP	DW	0			;MEMORY TOP
FNAME	DW	0			;FILE NAME ADDRESS
DISPLAY	DB	0			;DISPLAY TYPE
TTYPE	DB	0			;TERMINAL TYPE FLAG
TXTSTRT	DW	0			;START OF TEXT
TXTEND	DW	0			;END OF TEXT
RDEND	DW	0			;END OF READING
ENDCNT	DB	0			;COUNT BETWEEN RDEND AND TXTEND
LINCNT	DW	1			;LINE COUNTER (PRESET TO 1)
LINSTRT	DW	0			;FIRST LINE NUMBER
CURLIN	DW	0			;CURRENT LINE NUMBER
TPADR	DW	0			;TOP PAGE ADDRESS IN FILE
BPADR	DW	0			;BOTTOM PAGE ADDRESS IN FILE
LASTPG	DW	0			;LAST PAGE POINTER
NEXTFLG	DB	1			;"NEXT" FLAG
PRON	DB	1			;PRINTER ON FLAG
PFLAG	DB	0			;PRINT FLAG
WFLAG	DB	0			;WINDOW FLAG
MPFLG	DB	0			;MINUS PAGE FLAG
LINLEN	DB	0			;LINE INPUT LENGTH
CHRTBL	DB	'STUVWJPQR'		;H19 FUNCTION KEYS
	DB	'STUVWPQR0'		;H29 FUNCTION KEYS
	DB	'JSTUVWPQR'		;H100 FUNCTION KEYS
	DB	';=><?@ABC'		;H150 FUNCTION KEYS
CMDTBL	DW	(Offset PPAGE)
	DW	(Offset PLINE)
	DW	(Offset MLINE)
	DW	(Offset MPAGE)
	DW	(Offset TOP)
	DW	(Offset BOTTOM)
	DW	(Offset PRPAGE)
	DW	(Offset FIND)
	DW	(Offset NEXT)
PRVSTR	EQU	Offset $		;PREVIOUS LINE INPUT
LINBUF	EQU	(Offset PRVSTR)+40	;LINE INPUT BUFFER
STAK	EQU	(Offset LINBUF)+256+40	;STACK SPACE
BUFFER	EQU	(Offset STAK)+129	;BUFFER STARTS HERE

SEE	ENDS
	END	START
                                                   