	PAGE	,132
;DISKID -- WRITE DISK IDENTIFICATION FILE
;VERSION 2.0
;
;BY	MARVIN O. FICHTER	02-JUL-81
;	85 MECHANIC ST.
;	UPTON, MA 01568
;
;THIS PROGRAM WRITES A DISK IDENTIFICATION FILE
;CONTAINING A VOLUME NUMBER AND A LABEL
;
;THE ID IS READ BY THE "DIR100" PROGRAM
;
;MODIFIED BY P. SWAYNE, HUG  29-JUL-81 AS FOLLOWS:
;	USES CP/M READ BUFFER FUNCTION TO GET INPUT.
;	IDENTIFICATION FILE HAS THE SYSTEM FLAG SET.
;
;	Z-DOS VERSION BY P. SWAYNE, HUG  12-DEC-83
;
;	NOTE: THE FILE CREATED BY THIS PROGRAM IS CALLED
;	"IDENT.SYS", AND IS A HIDDEN FILE THAT CANNOT BE
;	DELETED BY ORDINARY MEANS.  HOWEVER, YOU CAN DELETE
;	IT WITH THIS PROGRAM BY ENTERING
;
;	A:DISKID D
;	A:DISKID B:D   (ETC.)

DISKID	SEGMENT
	ASSUME	CS:DISKID,DS:DISKID,ES:DISKID,SS:DISKID

	ORG	100H
DMA	EQU	80H
LF	EQU	0AH
CR	EQU	0DH
ESC	EQU	1BH
M	EQU	Byte Ptr 0[BX]

START:
	MOV	BX,Offset 5DH
	CMP	M,'D'			;DELETE FILE?
	JNZ	NOTDEL			;NO
	DEC	BX
	MOV	AL,M			;ELSE, GET DRIVE CODE
	INC	Byte Ptr DELFLG		;SET DELETE FLAG
	JMP	DEL			;GO DELETE IDENT.SYS FILE
NOTDEL:	MOV	DX,(Offset MESS1)
	CALL	PRINT
	MOV	DX,(Offset MESS3)
	CALL	PRINT
	MOV	BX,DMA
	MOV	M,10			;MAX CHARACTERS IN NUMBER
	XCHG	BX,DX
DIS1:
	CALL	INPUT			;GET NUMBER
	XCHG	BX,DX
	MOV	M,'"'			;OVERWRITE COUNT
	INC	BX			;POINT TO NO. OF CHARS
	MOV	AL,M			;GET NO.
	MOV	M,'"'			;MARK START OF NUMBER
	INC	BX			;POINT TO START OF DATA
	MOV	AH,0
	ADD	BX,AX			;BX = END OF NUMBER
	MOV	DX,(Offset MESS2)
	CALL	PRINT
	MOV	DX,(Offset MESS4)
	CALL	PRINT
	MOV	M,60			;MAX CHARS IN LABEL
	XCHG	BX,DX
	CALL	INPUT			;GET LABEL
	XCHG	BX,DX
	MOV	M,'$'			;MARK END OF NUMBER
	INC	BX
	MOV	AL,M			;GET SIZE OF LABEL
	MOV	M,'"'
	INC	BX			;POINT TO LABEL
	MOV	DX,BX			;SAVE LABEL START
	MOV	AH,0
	ADD	BX,AX			;BX = END OF LABEL
	MOV	M,'$'			;MARK IT
	INC	BX
	MOV	M,1AH			;MARK END OF FILE
	XCHG	BX,DX			;BX = LABEL START, DX = END
ESCLP:	CMP	M,'@'			;LOOK FOR "@" CHARACTERS
	JNZ	NOTAT
	MOV	M,1BH			;AND REPLACE THEM WITH ESCAPES
NOTAT:	INC	BX
	CMP	BX,DX
	JNZ	ESCLP
	MOV	DX,(Offset MESS2)
	CALL	PRINT
DIS3:
	MOV	DX,(Offset MESS5)
	CALL	PRINT
	MOV	DX,(Offset DRBUFF)	;PUT DRIVE NAME HERE
	CALL	INPUT			;GET IT
	INC	DX
	INC	DX			;SKIP OVER COUNTS
	MOV	SI,DX			;GET DRIVE NAME
	MOV	AL,[SI]
	PUSH	AX
	XCHG	AL,AH
	MOV	DX,(Offset MESS2)
	CALL	PRINT
	POP	AX
	CMP	AL,ESC
	JNZ	L_1	
	INT	20H
L_1:
	AND	AL,5FH			;CAPITALIZE
	CMP	AL,'A'
	JB	BADDRV
	CMP	AL,'F'+1
	JNB	BADDRV
	MOV	Byte Ptr MESS6A,AL
	SUB	AL,040H			;REMOVE ASCII BIAS
DEL:	MOV	Byte Ptr FCBDR,AL	;STORE DRIVE NAME IN FCB
	MOV	DX,(Offset FCB)
	PUSH	DX
	CALL	DELETE			;DELETE OLD ID IF ANY
	CMP	Byte Ptr DELFLG,0	;DELETE ONLY?
	JNZ	EXIT			;IF SO, EXIT
	POP	DX
	PUSH	DX
	CALL	MAKE			;MAKE NEW ID FILE
	INC	AL
	JZ	ERROR1
	POP	DX
	PUSH	DX
	CALL	WRITE			;WRITE THE ID FILE
	OR	AL,AL
	JNZ	ERROR2
	POP	DX
	CALL	CLOSE
	INC	AL
	JZ	ERROR3
	MOV	DX,(Offset MESS6)
	CALL	PRINT
	JMP	SHORT EXIT
BADDRV:
	MOV	DX,(Offset MESS10)
	CALL	PRINT
	JMP	DIS3
ERROR1:
	MOV	DX,(Offset MESS7)
ERR1:
	CALL	PRINT
EXIT:	INT	20H

ERROR2:
	MOV	DX,(Offset MESS8)
	JMP	SHORT ERR1
ERROR3:
	MOV	DX,(Offset MESS9)
	JMP	SHORT ERR1
PRINT:
	PUSH	BX
	MOV	AH,009H			;PRINT FUNCTION
	INT	21H
	POP	BX
	RET
INPUT:
	PUSH	DX
	PUSH	BX
	MOV	AH,00AH			;INPUT BUFFER FUNCTION
	INT	21H
	POP	BX
	POP	DX
	RET
CLOSE:
	MOV	AH,010H
	INT	21H
	RET
DELETE:
	MOV	AH,013H
	INT	21H
	RET
WRITE:
	MOV	AH,015H
	INT	21H
	RET
MAKE:
	MOV	AH,016H
	INT	21H
	RET

MESS1	DB	CR,LF
	DB	'This program writes an identification file'
	DB	' named "IDENT.SYS",',CR,LF
	DB	'which contains an alpha-numeric disk'
	DB	' ID number and a label.'
MESS2	DB	CR,LF,LF,'$'
MESS3	DB	'ENTER DISK ID NUMBER: $'
MESS4	DB	'ENTER DISK LABEL: $'
MESS5	DB	'WHICH DRIVE? (A-F) $'
MESS6	DB	'File IDENT.SYS sucessfully written on drive '
MESS6A	DB	'X:.',CR,LF,'$'
MESS7	DB	'DISK ERROR ON OPEN',CR,LF,'$'
MESS8	DB	'DISK ERROR ON WRITE',CR,LF,'$'
MESS9	DB	'DISK ERROR ON CLOSE',CR,LF,'$'
MESS10	DB	'BAD DRIVE DESIGNATION',CR,LF,'$'
DELFLG	DB	0
FCB	DB	0FFH,0,0,0,0,0,2	;FCB EXTENSION
FCBDR	DB	0,'IDENT   SYS',0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DRBUFF	DB	10,'           '
DISKID	ENDS
	END	START
                                                                                  