	TITLE	BASIC BRNCH STATEMENT CROSS REFERENCE
	PAGE	,132
;	BRNCHREF.ASM
;	BASIC Branch Statements Cross Reference Utility
;	for Z-DOS ZBASIC (and MBASIC 5.2X)
;
; This program will scan a BASIC program for Branch Statements
; and will print all the line numbers the branch is to.
;
; Branch Statements included are: GOTO, GOSUB, THEN, ELSE, RESUME
;
; To run the program type: BRNCHREF <dev:>Filename
; If no filetype is given, it is assumed to be .BAS.
; The source file must be an ASCII type.
;
; Written SEP/82
;
; AUTHOR: R. DANIEL
;	  HUEGLSTR. 21
;	  6143 LORSCH
;	  W - Germany
;
;	Z-DOS VERSION BY P. SWAYNE, HUG  23-APR-84
;
;	MODIFIED BY P. SWAYNE, HUG  24-JUN-83
;		--> ALLOWS SPECIFIED FILETYPE.  ASSUMES .BAS
;			ONLY IF NO FILETYPE GIVEN.
;		--> USES LSTOUT FOR PRINTER INSTEAD OF IOBYTE.
;		--> ALLOWS VARIABLES WITH IMBEDED BRANCH
;			STATEMENTS, SUCH AS "GOTOLOG"
;		--> ALLOWS MULTIPLE LINE NOS. AFTER "ON GOTO",
;			ETC. TO BE SPLIT INTO PHYSICAL LINES ON
;			ONE LOGICAL LINE.
;
; Printer output modified slightly by
; 		Terry L. Jensen
;		Heath Users' Group
;
;
M	EQU	Byte Ptr 0[BX]		;MEMORY POINTER
VERSN	EQU	3			;16-BIT VERSION
MODIF	EQU	0
;
CONINP	EQU	1			;CONSOLE INPUT
CONOUT	EQU	2			;CONSOLE OUTPUT
LSTOUT	EQU	5			;LIST OUTPUT
READCN	EQU	10			;READ CONSOLE BUFFER
OPENF	EQU	15			;OPEN FILE
READF	EQU	20			;READ FILE
SETDMA	EQU	26			;SET DMA ADDRESS
;
CR	EQU	0DH			;CARRIAGE RETURN
LF	EQU	0AH			;LINE FEED
EOL	EQU	80H			;END OF A LINE
TAB	EQU	9			;TAB CHARACTER
ESC	EQU	27			;ESCAPE CHARACTER
BELL	EQU	7			;BELL CHARACTER
FF	EQU	0CH			;FORMFEED
NUMMAX	EQU	9			;LINE NUMBERS/PRINT LINE
;
BRN	SEGMENT
	ASSUME	CS:BRN,DS:BRN,ES:BRN,SS:BRN
	ORG	5CH
FCB	LABEL	NEAR			;FILE CONTROL BLOCK ADDRESS
	ORG	(Offset FCB)+1
FCBFN	LABEL	NEAR			;FILE NAME IN FCB
	ORG	(Offset FCB)+9
FCBFT	LABEL	NEAR			;FILE TYPE IN FCB
	ORG	(Offset FCB)+12
FCBRL	LABEL	NEAR			;BLOCK NUMBER
	ORG	(Offset FCB)+14
FCBRS	LABEL	NEAR			;RECORD SIZE
	ORG	(Offset FCB)+32
FCBCR	LABEL	NEAR			;RECORD COUNT
	ORG	80H
BUFF	LABEL	NEAR			;DISK INPUT BUFFER ADDRESS
;
	ORG	100H
;
START:	MOV	AX,CS
	MOV	DS,AX			;PUT DS HERE
	CLI
	MOV	SS,AX			;PUT SS HERE
	MOV	SP,(Offset STACK)	;SET UP LOCAL STACK
	STI
	MOV	AL,CONOUT
	MOV	Byte Ptr PRIFLG,AL	;SET PRINTER FLAG FOR CRT
	MOV	AL,Byte Ptr FCBFN
	CMP	AL,' '			;ANY FILE GIVEN?
	JNZ	START0			;YES
	CALL	TYPTX			;ELSE, ERROR
	DB	CR,LF,'ERROR - No file specified.',CR,LF+EOL
	JMP	FINIS
START0:	CALL	TYPTX
	DB	27,'Z'+80H		;ASK TERMINAL TYPE
	MOV	CX,50			;SET A COUNTER
WFCHR:	MOV	AH,0BH
	INT	21H			;TEST FOR REPLY
	OR	AL,AL
	JNZ	GOTCHR			;GOT REPLY
	LOOP	WFCHR			;ELSE, TRY AGAIN
GOTCHR:	MOV	AX,0C00H
	INT	21H			;FLUSH TYPE-AHEAD
	MOV	Byte Ptr CTYPE,CL	;SAVE COMPUTER TYPE (0 IF IBM)
	MOV	BX,Offset FCBFT
	MOV	AL,M
	CMP	AL,' '			;ANY EXTENSION?
	JNZ	START01			;YES
	MOV	M,'B'			;ELSE, MAKE IT .BAS
	INC	BX
	MOV	M,'A'
	INC	BX
	MOV	M,'S'
START01:MOV	BX,Word Ptr FCBFT
	MOV	Word Ptr HDR3+1,BX	;UPDATE HEADER MESSAGE
	MOV	AL,Byte Ptr FCBFT+2
	MOV	Byte Ptr HDR3+3,AL
	MOV	BX,0FFH			;PREPARE TO TEST MEMORY
MEMLP:	DEC	BH
	MOV	AL,Byte Ptr [BX]	;GET A BYTE
	INC	Byte Ptr [BX]		;TRY TO CHANGE MEMORY
	CMP	AL,Byte Ptr [BX]	;TEST
	MOV	Byte Ptr [BX],AL	;REPLACE THE BYTE
	JZ	MEMLP			;NO CHANGE, IT'S NOT RAM
	SUB	BX,Offset BUFFER	;SUBTRACT BUFFER FROM MAX
	SUB	BX,256			;ALLOW FOR PARTIAL LINE
	MOV	Word Ptr MAXMEM,BX	;TO GET MAX MEMORY
;
; PRINT INTRODUCTION
;
	CMP	Byte Ptr CTYPE,0	;IBM?
	JNZ	Z1001
	MOV	AH,5
	MOV	AL,0			;ACTIVE PAGE IS 0
	INT	10H
	MOV	AX,600H			;AH = SCROLL, AL = ZERO LINES
	MOV	BH,7			;WHITE ON BLACK
	MOV	CX,0			;START ROW, COLUMN
	MOV	DX,24*256+79		;END ROW, COLUMN
	INT	10H			;CLEAR SCREEN
	MOV	AH,2
	MOV	DX,0			;HOME CURSOR
	MOV	BH,0
	INT	10H
	JMP	SHORT IBM1
Z1001:	CALL	TYPTX
	DB	ESC,'E'+EOL		;CLEAR SCREEN
IBM1:	MOV	BX,(Offset HEADER)
	CALL	TYPT1
;
; INITIALIZE FOR 1ST FILE READING
;
START1:	XOR	AL,AL
	MOV	Byte Ptr INITFG,AL	;FLAG AS 1ST READING
	MOV	Byte Ptr ALLBLK,AL	;AND MEMORY SPACE NOT OVERFLOWED
	MOV	Word Ptr MEMPTR,Offset Buffer	;SET MEMORY POINTER
	CALL	OPFILE			;TRY TO OPEN THE FILE
	MOV	Byte Ptr FCBCR,0	;CLEAR CURRENT RECORD
	MOV	Word Ptr FCBRL,0	;AND BLOCK NO.
	MOV	Word Ptr FCBRS,1	;SET RECORD SIZE TO 1
;
START2:	CALL	OVER			;PROCESS THE FILE
;
; WE RETURN HERE AT END OF FILE (CTRL-Z) FROM MAP1
;
	CALL	ENDUP			;FINISH PRINTOUT
	CALL	TYPTX
	DB	CR,LF,'Do you want to output the '
	DB	'listing again (Y/N) <N> ? ',EOL
	CALL	GETCHR
	AND	AL,5FH
	CMP	AL,'Y'
	JZ	NEW
	JMP	FINIS
;
; INITIALIZE FOR MULTIPLE READING OF FILE
;
NEW:	MOV	AL,Byte Ptr ALLBLK	;HAD NEEDED ALL MEMORY?
	OR	AL,AL			;NOT IF ZERO
	JZ	START3			;SO DON'T READ DISK AGAIN
	MOV	Byte Ptr FCBCR,0	;CLEAR CURRENT RECORD
	MOV	Word Ptr FCBRL,0	;AND BLOCK NO.
	JMP	START1
START3:	MOV	BX,(Offset BUFFER)	;IF HERE, USE FILE ALREADY IN MEMORY
	MOV	Word Ptr NXTPTR,BX	;POINT TO 1ST DATA
	JMP SHORT START2		;AND PROCESS FILE AGAIN
;
; ASK FOR SELECTION OF OUTPUT DEVICE
;
OVER:	MOV	AL,CONOUT
	MOV	Byte Ptr PRIFLG,AL	;EXPECT CRT
	MOV	BX,0
	MOV	Word Ptr PAGNUM,BX
	CALL	TYPTX
	DB	CR,LF,LF
	DB	'Do you want to use the '
	DB	'Printer (Y/N) <CRT> ? ',EOL
	CALL	GETCHR
	AND	AL,5FH			;CAPITALIZE
	CMP	AL,'Y'			;PRINTER?
	JNZ	PRINT1			;NO
PRINT:	MOV	AL,LSTOUT
	MOV	Byte Ptr PRIFLG,AL	;SET OUTPUT TO PRINTER
PRINT1:	CALL	CRLF
	MOV	AL,Byte Ptr PRIFLG
	CMP	AL,LSTOUT		;PRINTER?
	JNZ	MAP			;NO
	CALL	HDR			;ELSE PRINT A HEADER
;
; SET UP TO MOVE A LINE AT A TIME INTO MAPBUF
;
MAP:
MAP1:	CALL	MVMAP			;GET A LINE INTO MAP BUFFER
	CMP	AL,1AH			;EOF?
	JNZ	MAP1A
	RET				;YES, AT FILE END
MAP1A:	MOV	AL,Byte Ptr BRCHNM	;GET NUMBER OF BRANCH STMTS IN TABLE
	MOV	Byte Ptr BRCHWD,AL	;SET CNTER
	XOR	AL,AL
	MOV	Byte Ptr BRCHCR,AL	;OFFSET TO TABLE
;
; EVALUATE CURRENT LINE, LOOK FOR BRANCH STATEMENTS
;
	MOV	BX,(Offset MAPBUF)	;BEGIN OF STRING
	CALL	DECML			;EXTRACT LINE NUMBER, HOLD IN 'TERM'
	MOV	Word Ptr CURLIN,BX	;PTR TO CURRENT LINE (POINTS AFTER LINE #)
	MOV	BX,Word Ptr TERM
	MOV	Word Ptr WORK,BX	;MOVE NUMBER
MAP01:	MOV	BX,Word Ptr CURLIN
	MOV	Word Ptr MAPPTR,BX	;PTR TO NEXT CHAR IN LINE
	MOV	Byte Ptr BRFLG,0	;NO BRANCH STMT YET
MAP2:	CALL	FNDWRD			;ENTER HERE AGAIN UNTIL LINE IS SCANNED
	CMP	AL,EOL			;DID WE REACH END OF LINE OR REMARK?
	JNZ	MAP2A
	JMP	MAP3			;SKIP IF SO
MAP2A:	CMP	Byte Ptr BRFLG,0	;CHECK IF STATEMENT IS DUPLICATE IN LINE
	JZ	MAP2B
	JMP	MAP23
MAP2B:	PUSH	BX
	PUSH	CX			;SAVE LENGTH OF BRCH STMT IN C
MAP20:	INC	BX			;SKIP TO BYTE AFTER STMT
	DEC	CL
	JNZ	MAP20
	CALL	FNDDGT			;SEE IF LINE NUMBER FOLLOWS
	JB	MAP200
	JMP	MAP28			;NO, SO SKIP
MAP200:	POP	CX
	MOV	AL,Byte Ptr PRIFLG
	CMP	AL,LSTOUT		;CHECK IF PRINTER
	JNZ	MAP201			;NO
	DEC	Byte Ptr LINCNT		;FULL PAGE PRINTED
	JNZ	MAP201			;NO
	MOV	AL,FF
	CALL	PCHAR			;EJECT PAGE
	CALL	HDR
MAP201:	CALL	CRLF
;
; PRINT BASIC SOURCE LINE NUMBER AND BRANCH STATEMENT
;
MAP202:	MOV	BX,Word Ptr WORK	;GET LINE NUMBER
	CALL	OUTDEC
	CALL	TYPTX
	DB	'  ',' '+EOL
	POP	BX			;POINT TO BRANCH STATEMENT
	PUSH	CX			;SAVE CHAR COUNT
MAP21:	MOV	AL,M			;PRINT IT
	INC	BX
	CALL	PCHAR
	DEC	CL			;LENGTH OF WORD
	JNZ	MAP21
	POP	CX			;GET CHAR COUNT
	MOV	AL,8			;NO. OF CHARACTERS IN A TAB
	SUB	AL,CL			;SUBTRACT CHARS USED
	MOV	CL,AL			;RESULT TO C
MAP22:	MOV	AL,' '
	CALL	PCHAR			;PRINT A SPACE
	DEC	CL
	JNZ	MAP22
	MOV	Byte Ptr BRFLG,AL	;FLAG THIS BRANCH STMT PRINTED
	MOV	AL,NUMMAX		;NUMBER OF LINE NUMBERS/LINE
	MOV	Byte Ptr NUMCNT,AL
;
; PRINT ALL THE LINE NUMBERS THE BRANCH IS TO
;
MAP23:	MOV	BX,Word Ptr MAPPTR
	CALL	FNDDGT
	JB	MAP23A
	JMP	MAP2
MAP23A:	DEC	Byte Ptr NUMCNT		;ENOUGH NUMBERS IN CURRENT LINE?
	JNS	MAP24			;NO, DON'T DO NEW LINE
	PUSH	BX
	MOV	Byte Ptr NUMCNT,NUMMAX	;ELSE, RESET COUNT
	MOV	AL,Byte Ptr PRIFLG
	CMP	AL,LSTOUT		;PRINTER?
	JNZ	MAP203			;NO
	DEC	Byte Ptr LINCNT		;FULL PAGE PRINTED?
	JNZ	MAP203			;NO
	MOV	AL,FF
	CALL	PCHAR			;ELSE FORMFEED
	CALL	HDR			;DO A HEADER
MAP203:	CALL	TYPTX
	DB	CR,LF,'                ',EOL
	MOV	AL,Byte Ptr PRIFLG
	CMP	AL,LSTOUT		;PRINTER?
	POP	BX
MAP24:	DEC	BX			;BACK UP ONE
	CALL	DECML
	MOV	Word Ptr MAPPTR,BX	;SAVE NEXT IN LINE
	MOV	BX,Word Ptr TERM
	CALL	OUTDEC
	CALL	TYPTX			;ADD TWO SPACES
	DB	'  ',EOL
	JMP SHORT MAP23
MAP28:	POP	CX
	POP	BX
	JMP	MAP2
;
; IF HERE THEN CHECK IF ALL LINES IN FILE HAVE BEEN SCANNED
;
MAP3:	MOV	Byte Ptr BRFLG,0	;FLAG NO BRANCH STMT YET
	INC	Byte Ptr BRCHCR		;MOVE OFFSET TO NEXT WORD IN TABLE
	DEC	Byte Ptr BRCHWD		;NUMBER OF BRANCH STATEMENTS TO SCAN
	JZ	MAP4
	JMP	MAP01			;SCAN SAME LINE AGAIN FOR NEXT BRANCH STMT
MAP4:	JMP	MAP1
;
; FINISH UP PRINTOUT
;
ENDUP:	CALL	CRLF
	MOV	AL,Byte Ptr PRIFLG
	CMP	AL,LSTOUT		;PRINTER?
	JZ	ENDUP1
	RET				;NO, FINISHED
ENDUP1:	CALL	TYPTX
	DB	CR,LF,'                        -- eof --',FF,EOL
;
; IF PRINTER WAS USED THEN BE SURE FUNCTION IS RESET!
;
	MOV	Byte Ptr PRIFLG,CONOUT	;RESET OUTPUT TO CRT
	RET
;
; HANDLE HEADER AND PAGE NUMBER IF PRINTER OPERATION
;
HDR:	PUSH	BX
	PUSH	CX
	CALL	CRLF
	MOV	BX,(Offset HEADER)
	CALL	TYPT1
	CALL	TYPTX
	DB	'   Page',EOL
	MOV	BX,Word Ptr PAGNUM
	INC	BX
	MOV	Word Ptr PAGNUM,BX
	CALL	OUTDEC
;
; GET FILE NAME UNDER THE HEADER
;
	CALL	TYPTX
	DB	CR,LF,'        Processed File: ',EOL
	MOV	BX,Offset FCBFN		;GET THE FILENAME
	MOV	CH,8
HDR1:	MOV	AL,M			;GETA CHAR
	CMP	AL,' '			;SPACE?
	JZ	HDR2			;YES, DONE
	CALL	PCHAR			;ELSE PRINT
	INC	BX
	DEC	CH
	JNZ	HDR1
HDR2:	CALL	TYPTX
HDR3	DB	'.BAS',EOL
	CALL	CRLF
	CALL	CRLF
	MOV	AL,50
	MOV	Byte Ptr LINCNT,AL	;SET COUNTER TO LINES/PAGE
	POP	CX
	POP	BX
	RET
;
; FIND A WORD IN STRING (WE WANT TO FIND A BRANCH STATEMENT)
;
FNDWRD:	MOV	BX,Word Ptr MAPPTR	;CURRENT LOCATION
	CALL	FNDLET			;FIND 1ST LETTER
	CMP	AL,EOL
	JNZ	FNDWR0
	RET				;IF WE HIT EOL
FNDWR0:	PUSH	BX			;SAVE 1ST CHAR LOCATION
	MOV	CL,1			;COUNT LENGTH OF WORD (HAVE 1ST CHAR)
FNDWR1:	INC	BX			;POINT TO NEXT
	MOV	AL,M			;GET IT
	CMP	AL,EOL
	JZ	FNDWR2			;AT END OF LINE
	CMP	AL,'A'			;ANYTHING ELSE BELOW 'A' OR ABOVE 'Z' ENDS IT
	JB	FNDWR2			;GOT ALL
	CMP	AL,'Z'+1
	JNB	FNDWR2
INCLUD:	INC	CL			;KEEP COUNT
	JMP SHORT FNDWR1		;GET NEXT
FNDWR2:	MOV	Word Ptr MAPPTR,BX	;SAVE POINTER TO NEXT WORD
	POP	BX			;POINT TO START OF WORD
	CALL	CMPRES			;CHECK FOR BRANCH STATEMENT
	CMP	AL,0			;WAS A BRANCH STATEMENT?
	JNZ	FNDWRD			;NO, TRY NEXT
	RET				;ELSE, RETURN
;
; FILE TYPE ERROR
;
ERRFIL:	CALL	TYPTX
	DB	CR,LF,'ERROR - This is not an ASCII file!',CR,LF+EOL
	JMP	FINIS
;
; MOVE LINE TO MAPBUF
; EACH LINE CONTAINS TEXT IN THE FORM "TEXT",80H
; RETURNS WITH 1AH IN 'A' IF EOF
;
MVMAP:	MOV	AL,Byte Ptr INITFG	;ANY DISK READING DONE?
	OR	AL,AL			;IF NOT ZERO, THEN
	JNZ	MVMAP1			;THE BUFFER IS FILLED
	CALL	READFI			;ELSE FILL IT
	MOV	AL,1			;BUFFER FILLED, SET FLAG
	MOV	Byte Ptr INITFG,AL
	MOV	BX,(Offset BUFFER)	;POINT TO 1ST DATA
	MOV	Word Ptr NXTPTR,BX	;SAVE POINTER
MVMAP1:	MOV	BX,Word Ptr NXTPTR	;DATA STARTS HERE
	MOV	Word Ptr BEGPTR,BX	;SAVE OLD BEGIN
	MOV	DX,(Offset MAPBUF)
;
; CKECK IF LINE IS ONLY CR/LF (A 'NULL LINE')
; THESE WILL NOT OCCUR IN A BASIC SOURCE FILE
; BUT ROUTINE IS INCLUDED IF TO BE USED OTHERWISE
;
MVMAP2:	MOV	AL,M			;GET VERY FIRST BYTE
	OR	AL,AL
	JNZ	MVMAP2A			;NOT NULL
	INC	BX
	JMP SHORT MVMAP2		;SKIP NULL
MVMAP2A:CMP	AL,80H			;CHECK FOR LEGAL FILE
	JNB	ERRFIL			;NOT ASCII
	CMP	AL,CR			;A 'CR' ('NULL LINE')?
	JNZ	MVMAP3			;NO, SO SKIP
	INC	BX			;ELSE POINT TO NEXT
	MOV	AL,M			;GET IT
	INC	BX			;PASS WHAT WE HAVE
	MOV	Word Ptr NXTPTR,BX	;SAVE AS NEXT LINE ADDR
	CMP	AL,04H			;HAD END OF PARTIAL LINE?
	JZ	MOVE			;THEN MUST MOVE LEFT-OVERS
	JMP SHORT MVMAP6		;ELSE END PRESENT LINE
;
; IF HERE, WE HAVE A TEXT LINE
;
MVMAP3:	MOV	AL,M
	INC	BX
	MOV	Word Ptr NXTPTR,BX	;ADDR POINTING TO NEXT
	CMP	AL,1AH			;CNTRL-Z? (EOF)?
	JNZ	MVMAP3A
	RET				;ALL DONE
MVMAP3A:CMP	AL,04H			;END OF PARTIAL LINE?
	JZ	MOVE			;YES
	CMP	AL,CR			;FOUND END OF LINE?
	JZ	MVMAP4			;YES, GO PUT END MARKER
	MOV	SI,DX
	MOV	[SI],AL
	INC	DX
	JMP SHORT MVMAP3
;
; CHECK IF LINE BEING EXTRACTED IS A 'BASIC LOGICAL LINE'
; IN WHICH THE 'LF' GOES AHEAD OF THE 'CR'
;
MVMAP4:	PUSH	AX			;SAVE THE 'CR' WE HAVE
	DEC	DX			;BACK UP TO FORMER BYTE
	MOV	SI,DX
	MOV	AL,[SI]
	INC	DX			;RESTORE POINTER
	CMP	AL,LF			;HAD A 'LF' BEFORE THE 'CR'?
	JNZ	MVMAP5			;NO, WAS NOT A 'LF'
	POP	AX			;YES, SO RESTORE THE 'CR'
	MOV	SI,DX			;AND STORE. IS A BASIC LOGICAL LINE
	MOV	[SI],AL
	INC	DX			;SO MUST RETAIN IT
	JMP SHORT MVMAP3
MVMAP5:	POP	AX			;FIX STACK
	MOV	AL,M
	INC	BX			;PASS CR/LF
	MOV	Word Ptr NXTPTR,BX	;SAVE NEXT LINE ADDRESS
	CMP	AL,04H			;BE SURE IS NOT END OF PARTIAL LINE
	JZ	MOVE			;IF SO, HAVE TO MOVE
MVMAP6:	MOV	AL,EOL			;MARK END OF EXTRACTED LINE
	MOV	SI,DX
	MOV	[SI],AL
	RET
;
; MOVE LEFT-OVERS DOWN IN BUFFER
;
MOVE:	MOV	SI,Word Ptr BEGPTR	;BEGIN OF LAST PARTIAL LINE
	MOV	BX,(Offset BUFFER)	;WHERE LEFT-OVERS GO TO
MOVE1:	MOV	AL,[SI]			;GET BYTE
	CMP	AL,04H			;END OF PARTIAL LINE?
	JZ	MOVE2			;YES, LINE MOVED
	MOV	M,AL			;ELSE MOVE DATA
	INC	SI
	INC	BX
	JMP SHORT MOVE1
MOVE2:	MOV	Word Ptr MEMPTR,BX	;START ADDRESS FOR NEXT READ
	MOV	Byte Ptr INITFG,0	;ALLOW DISK READ
	JMP	MVMAP			;INPUT FROM DISK
;
; READ THE FILE TO MEMORY, MARK END IF MEMORY OVERFLOW
;
READFI:	MOV	DX,Word Ptr MEMPTR
	MOV	AH,SETDMA
	INT	21H			;SET DMA TO BUFFER AREA
	MOV	DX,Offset FCB		;FILE CONTROL BLOCK
	PUSH	DX
	MOV	AH,24H			;SET RANDOM RECORD
	INT	21H
	POP	DX
	MOV	CX,Word Ptr MAXMEM	;GET SIZE OF BUFFER
	MOV	AH,27H			;RANDOM BLOCK READ
	INT	21H			;'A' RETURNS ZERO IF OK
	OR	AL,AL			;ZERO IF READ OK
	MOV	AH,4			;ASSUME AL=0
	JZ	MRKEND			;AND MARK END OF FILE
	MOV	AH,1AH			;ELSE, EOF FOUND
MRKEND:	MOV	BX,Offset BUFFER
	ADD	BX,CX			;FIND END OF FILE
	MOV	M,AH			;MARK IT
	CMP	AH,4			;PART READ?
	JNZ	NOTPRT
	MOV	Byte Ptr ALLBLK,1	;ELES, MARK ALL BLOCK USED
NOTPRT:	RET				;ELSE WE HAVE EOF
;
; PASS UP SPACES THEN CHECK IF A NUMBER FOLLOWS
;	ENTRY	HL = 1ST BYTE TO SCAN
;	EXIT	CARRY SET IF A NUMBER
;
FNDDGT:	MOV	AL,M			;GET A BYTE
	INC	BX
	CMP	AL,' '
	JZ	FNDDGT			;IGNORE SPACE
	CMP	AL,','
	JZ	FNDDGT			;AND COMMAS
	CMP	AL,CR
	JZ	FNDDGT			;AND CR'S
	CMP	AL,LF
	JZ	FNDDGT			;AND LF'S
	CMP	AL,'A'			;A LETTER?
	JB	NOTLET			;NO
	CMP	AL,'Z'+1
	JNB	NOTLET
	STC
	CMC				;CLEAR CARRY
	RET
NOTLET:
;
; CHECK FOR ASCII DIGIT - RETURNS CARRY SET IF A DIGIT
;
NUMCHK:	CMP	AL,'0'
	JB	NONUM			;NOT DIGIT
	CMP	AL,'9'+1
	JNB	NONUM			;NOT DIGIT
	STC				;SET CARRY - WAS A DIGIT
	RET
NONUM:	STC				;CLEAR CARRY IF WAS NOT
	CMC
	RET
;
; SCAN LINE AND FIND 1ST OCCURRENCE OF A LETTER
;
FNDLT0:	INC	BX			;POINT TO NEXT
FNDLET:	MOV	AL,M			;GET A CHAR
	CMP	AL,EOL			;CHECK FOR END OF LINE
	JNZ	FND000
	RET				;RETURN IF SO
FND000:	CMP	AL,27H			;REMARK?  - "'"
	JZ	FNDLT2
	CMP	AL,'"'			;CHECK FOR QUOTED STRING
	JZ	FNDLT1
	CMP	AL,'A'
	JB	FNDLT0			;IF NOT LETTER
	CMP	AL,'Z'+1
	JNB	FNDLT0			;IF NOT LETTER
	CMP	AL,'R'			;TEST FOR "REM"
	JZ	FND001			;YES IS "R"
	CMP	AL,'D'			;TEST FOR "DATA"
	JZ	FND002
	RET				;IS A LETTER, RETURN
FND001:	PUSH	BX
	INC	BX
	MOV	AL,M			;GET NEXT
	CMP	AL,'E'
	JNZ	FNDL01
	INC	BX
	MOV	AL,M
	CMP	AL,'M'
FND001A:INC	BX
	MOV	AL,M			;CHECK CHAR AFTER WORD
	CMP	AL,EOL
	JZ	FNDL02			;IT'S EOL, REM FOUND
	CMP	AL,'A'
	JB	FNDL02			;LESS THAN "A", SO REM FOUND
FNDL01:	POP	BX
	MOV	AL,M			;GET ORIGINAL LETTER
	RET				;IF A LETTER, POINTS TO IT
FNDLT1:	INC	BX			;GET NEXT
	MOV	AL,M
	CMP	AL,'"'			;2ND QUOTE?
	JZ	FNDLT0			;THEN RESUME SEARCH FOR LETTER
	CMP	AL,EOL
	JZ	FNDL02			;ELSE EXIT ON EOL
	JMP SHORT FNDLT1
FNDL02:	POP	BX
FNDLT2:	MOV	AL,EOL			;REMARK - SO CANCEL REMAINDER OF LINE
	RET
FND002:	PUSH	BX			;SAVE HL
	INC	BX			;CHECK FOR REST OF "DATA"
	MOV	AL,M
	CMP	AL,'A'
	JNZ	FNDL01
	INC	BX
	MOV	AL,M
	CMP	AL,'T'
	JNZ	FNDL01
	INC	BX
	MOV	AL,M
	CMP	AL,'A'
	JNZ	FNDL01
	JMP SHORT FND001A		;CHECK END OF WORD
;
; CONVERT DECIMAL TO BINARY, BX POINTS TO NUMBER ON ENTRY
;
DECML:	XCHG	BX,DX			;MOVE TO DX
	MOV	BX,0
DECML1:	MOV	SI,DX			;GET 1ST CHAR
	MOV	AL,[SI]
	SUB	AL,30H			;REMOVE ASCII BIAS
	JB	DECML2			;IF NOT A DIGIT
	CMP	AL,10
	JNB	DECML2			;THEN FINISHED
	SHL	BX,1			;NUMBER *2
	MOV	DI,BX			;SAVE (NO.*2)
	SHL	BX,1			;NUMBER*4
	SHL	BX,1			;NUMBER*8
	ADD	BX,DI			;NUMBER*10
	XOR	AH,AH
	ADD	BX,AX			;ADD IN DIGIT'S VALUE
	INC	DX			;POINT TO NEXT
	JMP SHORT DECML1
DECML2:	MOV	Word Ptr TERM,BX	;SAVE NUMBER
	XCHG	BX,DX			;DX TO BX
	RET
;
; INPUT A CHARACTER FROM CONSOLE
;
GETCHR:	PUSH	BX
	PUSH	DX
	PUSH	CX
	MOV	AH,CONINP
	INT	21H
	POP	CX
	POP	DX
	POP	BX
	RET
;
; DO A CR/LF
;
CRLF:	MOV	AL,CR
	CALL	PCHAR
	MOV	AL,LF
;
; PRINT A CHARCTER
;	USES	NONE
;
PCHAR:	PUSH	BX
	PUSH	DX
	PUSH	CX
	PUSH	AX
	MOV	DL,AL
	MOV	AL,Byte Ptr PRIFLG	;GET OUTPUT FUNCTION
	MOV	AH,AL			;IN C
	INT	21H
	POP	AX
	POP	CX
	POP	DX
	POP	BX
	RET
;
; TYPTX - TYPE A BLOCK OF TEXT UNTIL BIT 7 HIGH
;
;	ENTRY	(RET) = TEXT
;	EXIT	TO (RET + LENGTH)
;	USES	A,F
;
TYPTX:	MOV	BP,SP			;HL = TEXT ADDRESS
	XCHG	BX,[BP]
	CALL	TYPT1			;TYPE IT
	MOV	BP,SP
	XCHG	BX,[BP]
	RET
TYPT1:	MOV	AL,M
	AND	AL,7FH
	CALL	PCHAR
	CMP	AL,M
	LAHF
	INC	BX
	SAHF
	JZ	TYPT1			;MORE TO GO
	RET
;
;  OUTPUT A DECIMAL NUMBER
; OUTPUTS THE BINARY VALUE IN THE
; HL REG IN 5 DECIMAL DIGITS WITH
; LEADING ZEROS REPLACED BY SPACES
;  USES A,F,H,L
;
OUTDEC:	PUSH	DX
	PUSH	CX
	CALL	OUTDC
	POP	CX
	POP	DX
	RET				;RETURN TO CALLER
;
OUTDC:	MOV	CH,80H			;SET NO PRINTING FLAG
	MOV	DX,-10000
	CALL	DIGIT
	MOV	DX,-1000
	CALL	DIGIT
	MOV	DX,-100
	CALL	DIGIT
	MOV	DX,-10
	CALL	DIGIT
	MOV	CH,0			;CLEAR NO PRINTING FLAG
	MOV	DX,-1
DIGIT:	INC	CH
	ADD	BX,DX			;SUBTRACT OFF
	JB	DIGIT			;LOOP IF > ZERO
	DEC	CH			;BACKUP VALUE
	NEG	DX			;NEGATE VALUE IN DX
	ADD	BX,DX			;ADD BACK IN
	MOV	AL,CH
	CMP	AL,80H			;ANY PRINTING YET?
	JNZ	OUTDC1			;SKIP IF SO
	MOV	AL,' '			;ELSE PRINT A SPACE
	CALL	PCHAR
	RET				;IF NOT, THEN IGNORE
OUTDC1:	AND	AL,0FH			;MASK OFF LEFT HALF
	ADD	AL,30H			;ADD IN ASCII BIAS
	CALL	PCHAR			;PRINT DIGIT
	MOV	CH,0			;CLEAR NO PRINTING FLAG
	RET
;
; COMPARE WORD IN MAPBUF TO RESERVED WORD IN TABLE
;
CMPRES:	PUSH	CX
	XCHG	BX,DX			;BX TO DX
	MOV	BX,(Offset BRWRD)	;POINT TO TABLE
	MOV	AL,Byte Ptr BRCHCR	;CALCULATE OFFSET
	ADD	AL,AL
	ADD	AL,AL
	ADD	AL,AL			;ADD 8 (LENGTH OF WORD IN TABLE)
	XOR	AH,AH
	ADD	BX,AX
	PUSH	DX			;SAVE LOC'N IN MAPBUF
	MOV	CL,M			;LENGTH OF STRING2
	INC	BX			;POINT TO STRING2
	CALL	MATCH			;TRY TO MATCH STRINGS
	JZ	CMPR1			;YES, HAD A MATCH (GOT BRCH STMT)
CMPR0:	POP	DX			;NO MATCH
	POP	CX
	XCHG	BX,DX			;POINT HL TO PLACE IN MAPBUF AGAIN
	MOV	AL,1			;FLAG AS NO MATCH
	RET
CMPR1:	MOV	SI,DX			;GET CHARACTER AFTER WORD
	MOV	AL,[SI]
	CMP	AL,EOL			;END OF LINE
	JZ	CMPR0			;IF SO, IT'S NOT A BRANCH
	CMP	AL,'A'			;LESS THAN "A"?
	JNB	CMPR0			;IF NOT, IT'S NOT A BRANCH
	POP	DX
	POP	CX
	XCHG	BX,DX			;POINT HL BRANCH STATEMENT
	XOR	AL,AL			;FLAG AS MATCH
	RET
;
; TRY TO OPEN FILE, ELSE REPORT ERROR
;
OPFILE:	MOV	DX,Offset FCB
	MOV	AH,OPENF
	INT	21H
	CMP	AL,255			;CHECK IF FILE IS THERE
	JZ	OPFIL1
	RET				;FILE OPENED OK
OPFIL1:	CALL	TYPTX
	DB	CR,LF,BELL,'ERROR - NO Source File',80H
FINIS:	INT	20H			;EXIT TO Z-DOS
;
; MATCH A STRING
;	ENTRY	DE = STRING1
;		HL = STRING2
;		C  = LENGTH OF STRING2
;
MATCH:	PUSH	CX			;SAVE CX
	PUSH	DS
	POP	ES			;PUT ES HERE
	MOV	SI,DX			;SOURCE TO SI
	MOV	DI,BX			;DEST. TO DI
	XOR	CH,CH			;ZERO CH
	REPZ	CMPSB			;COMPARE STRINGS
	MOV	DX,SI			;POINT TO AFTER MATCH
	POP	CX			;RESTORE CX
	RET

;
; TABLE OF BRANCH STATEMENTS
;
BRCHNM	DB	5			;NUMBER OF ITEMS IN TABLE
BRWRD	DB	4,'THEN',0,0,0
	DB	4,'ELSE',0,0,0
	DB	5,'GOSUB',0,0
	DB	4,'GOTO',0,0,0
	DB	6,'RESUME',0
;
; RAM LOCATIONS
;
CTYPE	DB	1			;COMPUTER TYPE
INITFG	DB	1 DUP (?)
MEMPTR	DB	2 DUP (?)
BEGPTR	DB	2 DUP (?)
NXTPTR	DB	2 DUP (?)
MAXMEM	DB	2 DUP (?)
ALLBLK	DB	1 DUP (?)
WORK	DB	2 DUP (?)		;CURRENT BASIC SOURCE LINE NUMBER
CURLIN	DB	2 DUP (?)		;START OF CURRENT LINE (AFTER LINE #)
BRCHWD	DB	1 DUP (?)		;REMAINDER OF TABLE ITEMS TO SCAN YET
BRCHCR	DB	1 DUP (?)		;BRANCH STMT CURRENTLY BEING SCANNED
BRFLG	DB	1 DUP (?)		;<>0 = MULTIPLE BRANCH STMT IN LINE
MAPPTR	DB	2 DUP (?)		;CURRENT PLACE IN MAPBUF
LINES	DB	2 DUP (?)		;TEMPORARY COUNTER OF LINES
TERM	DB	2 DUP (?)		;CURRENT LINE NUMBER OF SOURCE LINE
NUMCNT	DB	1 DUP (?)		;NUMBER OF LINE NUMBERS/PRINT LINE
PRIFLG	DB	1 DUP (?)		;0=CRT, <>0=PRINTER
PAGNUM	DB	2 DUP (?)		;PAGE NUMBER
LINCNT	DB	1 DUP (?)		;LINES/PAGE
;
HEADER	DB	'BRNCHREF - BASIC Branch Statements '
	DB	'Cross Reference Utility  V '
	DB	VERSN+30H,'.',MODIF+30H+EOL
;
STACK	EQU	(Offset $)+100H		;STACK SPACE
MAPBUF	EQU	Offset STACK		;TEMP BUFFER FOR SOURCE LINE
BUFFER	EQU	(Offset MAPBUF)+255	;START OF BUFFER AREA
BRN	ENDS
	END	START
                                                                                                                              