	TITLE PRISM Printer Mode Setup
	PAGE	,132
;
;	PRISM Printer Mode Setup Program
;
;	Author: R. A. Metz		Date: 1/6/83
;
;
;	This program is invoked by: 'PRISM <string>'
;	Where <string> is a list of one-character commands
;	from the following set:
;
;	B  -  Select black ribbon
;	Y  -  Select yellow ribbon
;	R  -  Select red ribbon
;	C  -  Select cyan ribbon
;	A  -  Automatic ribbon advance (black ribbons)
;	N  -  Normal character printing
;	E  -  Enhanced character printing (double width)
;	F  -  Fixed character spacing
;	P  -  Proportional character spacing
;	D  -  Draft mode (200 cps)
;	Q  -  Quality print mode (100 cps)
;	J  -  Justify mode (No carriage control allowed)
;	U  -  Unjustify mode
;	S  -  Small characters (16.8 cpi horizontal)
;	M  -  Medium characters (12 cpi horizontal)
;	L  -  Large characters (10 cpi horizontal)
;	6  -  6 lpi
;	8  -  8 lpi
;
;	For information on use of this program, execute it with
;	no parameters and an explaination will be displayed on
;	the CRT.
;
	PAGE
PGMSEG	SEGMENT
	ASSUME 	CS:PGMSEG,DS:PGMSEG,SS:PGMSEG,ES:NOTHING
	ORG	80H
COUNT	DB	0
BUFFER	DB	127 DUP (?)
;
START:
	JMP	BEGIN
;
CR	EQU	0DH
LF	EQU	0AH
;
MENU	DB	CR,LF
	DB	'This program is invoked by: "PRISM <string>"'
	DB	CR,LF
	DB	'Where <string> is a list of one-character commands'
	DB	CR,LF
	DB	'from the following set:'
	DB	CR,LF,LF
	DB	'  B - Select black ribbon'
	DB	CR,LF
	DB	'  Y - Select yellow ribbon'
	DB	CR,LF
	DB	'  R - SElect red ribbon'
	DB	CR,LF
	DB	'  C - Select cyan ribbon'
	DB	CR,LF
	DB	'  A - Automatic ribbon advance (black ribbons)'
	DB	CR,LF
	DB	'  N - Normal character printing'
	DB	CR,LF
	DB	'  E - Enhanced (double width) character printing'
	DB	CR,LF
	DB	'  F - Fixed character spacing'
	DB	CR,LF
	DB	'  P - Proportional character spacing'
	DB	CR,LF
	DB	'  D - Draft mode (200 cps)'
	DB	CR,LF
	DB	'  Q - Quality mode (100 cps)'
	DB	CR,LF
	DB	'  J - Justify on'
	DB	CR,LF
	DB	'  U - Justify off'
	DB	CR,LF
	DB	'  S - Small characters (16.5 cpi)'
	DB	CR,LF
	DB	'  M - Medium characters (12 cpi)'
	DB	CR,LF
	DB	'  L - Large characters (10 cpi)'
	DB	CR,LF
	DB	'  6 - 6 lpi'
	DB	CR,LF
	DB	'  8 - 8 lpi'
	DB	CR,LF,'$'
;
BEGIN:
	MOV	CL,BYTE PTR COUNT	;# Characters in cmd line
	CMP	CL,0
	JNE	DO_MOD
	MOV	DX,OFFSET MENU		; Display instructions
	MOV	AH,9			; if no parms entered
	INT	21H
	INT	20H
DO_MOD:
	MOV	CH,0
	MOV	BX,OFFSET BUFFER	;Address of cmd line buffer
CLOOP:
	MOV	AL,[BX]			;Get a character
	INC	BX
	CMP	AL,40H			;Alpha?
	JLE	DO_IT			; No - no upper-case mask
	AND	AL,5FH			;Ensure upper case
DO_IT:
	CALL	PROCESS			;Process it
	LOOP	CLOOP
RTN:
	INT	20H			;Return to Z-DOS
;
PROCESS	PROC	NEAR
	PUSH	CX
	PUSH	BX
	MOV	BX,OFFSET CTBL		;Command table
CHECKIT:
	CMP	AL,[BX]
	JE	DOIT			;Search table for match
NXTC:
	ADD	BX,3			;Next entry
	CMP	BX,OFFSET ENDTBL
	JNE	CHECKIT
PROC_RET:
	POP	BX			;Return after processing or
	POP	CX			; if no match (ignore cmd)
	RET
;
DOIT:
	MOV	SI,1[BX]		;Address of command string
PRTLP:
	MOV	DL,[SI]
	INC	SI
	CMP	DL,0FFH			;Check for end of string
	JE	PROC_RET		;Return at end 
	MOV	AH,5			;Print character from string
	INT	21H
	JMP	PRTLP
;
CTBL:					;Command table:
	DB	'B'
	DW	SELB			;Select black ribbon
	DB	'Y'
	DW	SELY			;Select yellow ribbon
	DB	'R'
	DW	SELR			;Select red ribbon
	DB	'C'
	DW	SELC			;Select cyan ribbon
	DB	'A'	
	DW	AUTO			;Auto ribbon advance
	DB	'N'
	DW	NORMAL			;Normal print
	DB	'E'
	DW	ENHANCE			;Enhanced print
	DB	'F'
	DW	FIXED			;Fixed spacing
	DB	'P'
	DW	PROPORT			;Proportional spacing
	DB	'D'
	DW	DRAFT			;200 cps
	DB	'Q'
	DW	QUALITY			;100 cps
	DB	'J'
	DW	JUSTIFY			;Justify mode on
	DB	'U'
	DW	UNJUSTIFY		;Justify mode off
	DB	'S'
	DW	SMALL			;16.8 cpi
	DB	'M'
	DW	MED			;12 cpi
	DB	'L'	
	DW	LARGE			;10 cpi
	DB	'6'
	DW	LPI6			;6 lpi
	DB	'8'
	DW	LPI8			;8 lpi
ENDTBL:
;
SELB:
	DB	1BH,'Q,4,$',0FFH
SELY:
	DB	1BH,'Q,1,$',0FFH
SELR:
	DB	1BH,'Q,2,$',0FFH
SELC:
	DB	1BH,'Q,3,$',0FFH
AUTO:
	DB	1BH,'Q,5,$',0FFH
NORMAL:
	DB	02H,0FFH
ENHANCE:
	DB	01H,0FFH
FIXED:
	DB	06H,0FFH
PROPORT:
	DB	10H,0FFH
DRAFT:
	DB	1BH,'R,2,$',0FFH
QUALITY:
	DB	1BH,'R,1,$',0FFH
JUSTIFY:
	DB	04H,0FFH
UNJUSTIFY:
	DB	05H,0FFH
SMALL:
	DB	1FH,0FFH
MED:
	DB	1EH,0FFH
LARGE:
	DB	1DH,0FFH
LPI6:
	DB	1BH,'B,6,$',0FFH
LPI8:
	DB	1BH,'B,8,$',0FFH
;
PROCESS	ENDP
PGMSEG	ENDS
	END	START
