;	ONECOPY UTILITY FOR CP/M

;	TO USE THIS UTILITY, ENTER
;		ONECOPY FILENAME.TYP

        ORG	100H

START:
	JMP	ONEC
;
;	MESSAGES
;
MSG1:
	DB	0DH,0AH
	DB	'		ONECOPY',0DH,0AH
	DB	'	      VERSION 2.0',0DH,0AH,'$'
MSG2:
	DB	0DH,0AH,0DH,0AH
	DB	'Replace System Disk and Hit RETURN.$'
MSG3:
	DB	0DH,0AH,0DH,0AH,'ERROR -- No File Name Specified.'
	DB	0DH,0AH,0DH,0AH
	DB	'The Correct Syntax is "ONECOPY FILENAME.TYP".$'
MSG4:
	DB	0DH,0AH,'Insert Source Disk in Drive, Press RETURN.$'
MSG5:
	DB	0DH,0AH,'Insert Distination Disk'
	DB	' in Drive, Press RETURN.$'
MSG6:
	DB	0DH,0AH,'ERROR -- Source File Not Found.$'
MSG7:
	DB	0DH,0AH,'ERROR -- Can''t Read Source File.$'
MSG8:
	DB	0DH,0AH,'ERROR -- Can''t Write Destination File.$'
MSG9:
	DB	0DH,0AH,'Transfer Completed.'
	DB	0DH,0AH,'Replace System Disk, Hit RETURN.$'
;
;	CP/M BDOS ROUTINES
;
PRINT:
	MVI	C,009H
	JMP	BDOS
RESET:
	MVI	C,00DH
	JMP	BDOS
CONIN:
	MVI	C,001H
	CALL	BDOS
	CPI	003H
	JZ	BOOT
	RET
SELECT:
	MVI	C,00EH
	JMP	BDOS
OPEN:
	MVI	C,00FH
	JMP	BDOS
CLOSE:
	MVI	C,010H
	JMP	BDOS
DELETE:
	MVI	C,013H
	JMP	BDOS
READ:
	MVI	C,014H
	JMP	BDOS
WRITE:
	MVI	C,015H
	JMP	BDOS
MAKE:
	MVI	C,016H
	JMP	BDOS
SETDMA:
	MVI	C,01AH
	JMP	BDOS
;
;	MAIN PROGRAM
;
ONEC:
	LHLD	HIMEM
	SPHL
	LXI	D,MSG1
	CALL	PRINT		;SIGN ON
	LDA	FNAME
	CPI	020H		;SPACE
	JNZ	ONEC01
	LXI	D,MSG3
	JMP	ERROR		;NO FILE FOUND
ONEC01:
	SUB	A
	STA	RECSAV		;SET UP PARAMETERS
	STA	EXTSAV
	LHLD	HIMEM
	LXI	D,0FF00H	;-256
	DAD	D
	SHLD	TOP
	LDA	CURDRV
	STA	SYSDRV
	XRA	A
	STA	CURDSK
INSRCE:
	LXI	H,00000H  
	SHLD	RECCNT
	LXI	D,MSG4		;INSERT SOURCE DISK
	CALL	LOGIN
	CALL	OPENFL
	LDA	RECSAV
	STA	NXTREC
	LXI	D,BUFFER
RSTDMA:
	XCHG
	SHLD	DMASAV
	XCHG
	CALL	SETDMA
	LXI	D,FCB
	CALL	READ		;READ IN A RECORD
	ORA	A
	LHLD	RECCNT
	INX	H		;INCREMENT RECORD COUNT
	SHLD	RECCNT
	JZ	UPDDMA
	CPI	001H		;EOF?
	JNZ	READERR
	LHLD	RECCNT
	DCX	H
	SHLD	RECCNT
	JMP	SWPDSK
READERR:
	LXI	D,MSG7		;READ ERROR
	JMP	ERROR
SWPDSK:
	LDA	CURDSK
	ANI	0FEH 
	STA	CURDSK
	JMP	INDEST
UPDDMA:
	LHLD	DMASAV
	LXI	D,00080H
	DAD	D		;UPDATE DMA
	XCHG
	LHLD	TOP
	SUB	A
	MOV	A,L
	SUB	E		;SEE IF WE HAVE ENOUGH MEMEORY
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A
	JNC	RSTDMA		;THERE'S ROOM, RESET DMA
	LDA	CURDSK		;OTHERWISE, SWAP DISKS
	ORI	001H 
	STA	CURDSK
INDEST:
	LXI	D,MSG5		;INSERT DEST. DISK
	CALL	LOGIN
	LDA	CURDSK
	ANI	002H		;FIRST TIME THROUGH? 
	JNZ	OPENWR
	LXI	D,FCB
	SUB	A
	STA	EXTENT
	CALL	DELETE
	LXI	D,FCB
	CALL	MAKE
	INR	A
	JNZ	OPENWR
	LXI	D,MSG8		;COULDN'T OPEN OUTPUT
	JMP	ERROR
OPENWR:
	LDA	CURDSK
	ORI	002H 
	STA	CURDSK
	CALL	OPENFL		;OPEN DISTINATION FILE
	LDA	RECSAV
	STA	NXTREC
	LXI	D,BUFFER
WRITFL:
	XCHG
	SHLD	DMASAV
	XCHG
	CALL	SETDMA
	LXI	D,FCB
	CALL	WRITE
	ORA	A		;WRITE OK?
	JZ	GDWRIT
	LXI	D,MSG8
	JMP	ERROR
GDWRIT:
	LHLD	RECCNT
	DCX	H
	SHLD	RECCNT		;DECREMENT RECORD COUNT
	MOV	A,L
	ORA	H		;ALL RECORDS WRITTEN?
	JZ	CLSOUT
	LHLD	DMASAV
	LXI	D,00080H
	DAD	D		;UPDATE DMA ADDRESS
	XCHG
	JMP	WRITFL
CLSOUT:
	LXI	D,FCB
	CALL	CLOSE		;CLOSE OUTPUT FILE
	INR	A
	ORA	A
	JNZ	CHDONE
	LXI	D,MSG8
	JMP	ERROR
CHDONE:
	LDA	CURDSK
	ANI	001H		;DONE COPYING FILE? 
	JNZ	NXTBLK		;GET ANOTHER RAMFULL
	LXI	D,MSG9		;SAY WE'RE DONE
	CALL	LOGIN
	JMP	BOOT
NXTBLK:
	LDA	NXTREC
	STA	RECSAV
	LDA	EXTENT
	STA	EXTSAV
	JMP	INSRCE
LOGIN:
	CALL	PRINT		;SAY "INSERT DISK"
	CALL	CONIN		;WAIT FOR A KEYSTROKE
	CALL	RESET
	LDA	SYSDRV		;GET SYSTEM DRIVE NO.
	MOV	E,A
	JMP	SELECT
OPENFL:
	LDA	EXTSAV
	STA	EXTENT
	LXI	D,FCB
	CALL	OPEN		;OPEN THE FILE WE'RE WORKING ON
	INR	A
	RNZ
	LXI	D,MSG6
ERROR:
	CALL	PRINT
	LXI	D,MSG2
	CALL	LOGIN
	JMP	BOOT
RECSAV:
	DB	0	
EXTSAV:
	DB	0	
CURDSK:
	DB	0	
TOP:
	DW	0
RECCNT:
	DW	0
DMASAV:
	DW	0
SYSDRV:
	DB	0	

BUFFER	EQU	$		;BUFFER STARTS HERE

BOOT	EQU	00000H
CURDRV	EQU	00004H
BDOS	EQU	00005H
HIMEM	EQU	00006H
FCB	EQU	0005CH
FNAME	EQU	0005DH
EXTENT	EQU	00068H
NXTREC	EQU	0007CH

        END

H
BDOS	EQU	00005H
HIMEM	EQU	00006H
FCB	EQU	0