;
;
YES	EQU	0FFH
NO	EQU	0
;
;
;-----------------------------------------------------------------------
;
ESC	EQU	'['-40H	; ^[ = Escape
BELL	EQU	'G'-40H	; ^G = Bell character
LF	EQU	'J'-40H	; ^J = Linefeed
NEXTRY	EQU	'K'-40H	; ^K = Try next phone number, abort this try
CR	EQU	'M'-40H	; ^M = Carriage return
CLEARSC	EQU	'Z'-40H	; ^Z = Clear screen, command mode only
EOFCHAR	EQU	'Z'-40H	; ^Z = End of file
;
;
;====================== CUSTOMIZATION EQUATES ==========================
;
;
SLOT	EQU	2		; Slot of serial interface
SLOTOFF	EQU	16*SLOT		; Serial card slot offset
;
;
; CP/M adapter cards for Apple ][
;
ALSCARD	   EQU	NO		; YES if using ALS CP/M card
APPLICARD  EQU	YES		; YES if using PCPI Applicard CP/M card
MICROSOFT  EQU	NO		; YES if Microsoft Sofcard CP/M card
;
;
; Serial I/O cards for Apple ][
;
ALSDSP	EQU	NO		; YES for ALS Dispatcher
CCS	EQU	NO      	; YES for CCS 7710
COMCARD	EQU	NO		; YES for Apple Comcard
CPS	EQU	NO		; YES for CPS card
SSC	EQU	NO		; YES for Super Serial Card
SSM	EQU	NO		; YES for SSM serial card
VERSA	EQU	NO		; YES for Prometheus Versacard
SABA	EQU	YES		; YES FOR SABA'S *RAY KLIEN SIO CARD*
;
;
CPSPRT	EQU	NO		; YES if using CPS parallel printer port
;
;
;=======================================================================
;
;
	 IF	ALSCARD	OR APPLICARD
MAPOFF	EQU	0		; No memory remapping for either
	 ENDIF			; ALSCARD
;
	 IF	MICROSOFT
MAPOFF	EQU	2000H		; Microsoft strikes again
	 ENDIF			; MICROSOFT
;
;-----------------------------------------------------------------------
;
	IF SABA
CPORT		EQU	80H		;Aplicard CTC baud rate port
					; USE 80H FOR PRIMARY SERIAL PORT
					; USE 81H FOR SECONDARY SERIAL PORT
PORT:		EQU	0FCH		;Aplicard serial output port
					; USE FCH FOR PRIMARY SERIAL PORT
					; USE FEH FOR SECONDARY SERIAL PORT
MODCTL1:	EQU	PORT+1		;Modem control port
MODDATP:	EQU	PORT		;Modem data port
MODCTL2:	EQU	PORT+1		;Modem control port
MODRCVB:	EQU	01H		;Your bit to test for receive
MODRCVR:	EQU	01H		;Your value when receive ready
MODSNDB:	EQU	04H		;Your bit to test for send
MODSNDR:	EQU	04H		;Your value when send ready	

MDDATP	EQU	PORT		; SABA data port
MDCTL1	EQU	PORT+1		; SABA status port
MDRCV	EQU	01H		; Bit to test for received data
MDSND	EQU	04H		; Bit to test for ready to send
MDTXE	EQU	04H		; Modem send buffer empty
	ENDIF 				;SABA 

	 IF	CPS
MDCPST	EQU	0C0F9H+SLOT*100H+MAPOFF	; Printer status port
MDDATP	EQU	0C0FAH+SLOT*100H+MAPOFF	; Data port of CPS card
MDCTL1	EQU	0C0FBH+SLOT*100H+MAPOFF	; Status port of CPS card
MDCTL2	EQU	0C0FCH+SLOT*100H+MAPOFF	; Second CPS status port
MDCPRT	EQU	0C0FDH+SLOT*100H+MAPOFF	; Printer data port
MDCR	EQU	0C0FEH+SLOT*100H+MAPOFF	; Control port of CPS card
MDRCV	EQU	2			; Bit to test for receive
MDSND	EQU	1			; Bit to test for send
MDTXE	EQU	5			; Modem send buffer empty
	 ENDIF				; CPS
;
	 IF	SSC
MDDATP	EQU	0C088H+SLOTOFF+MAPOFF ; SSC data port
MDCTL1	EQU	0C089H+SLOTOFF+MAPOFF ; SSC status port
MDCTL2	EQU	0C08AH+SLOTOFF+MAPOFF ; SSC mode port
MDCTL3	EQU	0C08BH+SLOTOFF+MAPOFF ; SSC control port
MDRCV	EQU	08H		; Bit to test for received data
MDSND	EQU	10H		; Bit to test for ready to send
MDTXE	EQU	10H		; Modem send buffer empty
	 ENDIF			; SSC
;
	 IF	CCS
MDDATP	EQU	0C081H+SLOTOFF+MAPOFF ; Data port of CCS 7710
MDCTL1	EQU	0C080H+SLOTOFF+MAPOFF ; Status port of CCS 7710
	 ENDIF			; CCS OR ALSDSP
;
	 IF	SSM
MDDATP	EQU	0C085H+SLOTOFF+MAPOFF ; Data port of SSM
MDCTL1	EQU	0C084H+SLOTOFF+MAPOFF ; Status port of SSM
	 ENDIF			; SSM
;
	 IF	COMCARD	OR VERSA OR ALSDSP
MDDATP	EQU	0C08FH+SLOTOFF+MAPOFF ; Data port of Comcard
MDCTL1	EQU	0C08EH+SLOTOFF+MAPOFF ; Status port of Comcard
	 ENDIF			; COMCARD OR VERSA OR ALSDSP
;
	 IF	NOT SSC	AND NOT	CPS AND NOT SABA
MDRCV	EQU	1		; Bit to test for receive
MDSND	EQU	2		; Bit to test for send
MDTXE	EQU	2		; Modem send buffer empty
	 ENDIF			; NOT SSC AND NOT CPS AND NOT SABA
;
	 IF	VERSA
AN3SET	EQU	0C05FH+MAPOFF	; Set annunciator #3
AN3CLR	EQU	0C05EH+MAPOFF	; Clear   "	  #3
	 ENDIF			; VERSA
;
;
; We have software control over the CCS, CPS, SSC and Versacard (if the
; hardware mod is made.)
;
;=======================================================================
;
;
ORG	0100H
;
;
	DS	3	; Skip the data area below
;
;
; These routines and equates are at the beginning of the program so
; they can be patched by a monitor or overlay file without re-assembling
; the program.
;
MSPEED:	 DB	5	; 0=110 1=300 2=450 3=600 4=710 5=1200		103H
			; 6=2400 7=4800 8=9600 9=19200 default
 IF SABA
IMSPEED	 EQU	5	; Set default baud rate.  This can be set to a
 ENDIF ;SABA		; value of '10' for 38400 bps even though MSPEED
			; will still only be 9.

HS2400:	 DB	NO	; Yes=2400 bps highest speed			104H
HS1200:	 DB	YES	; Yes=1200 bps highest speed			105H
RACAL:	 DB	NO	; Yes=Racal-Vadic 1200V or 2400V or 2400PA	106H
PROMODM: DB	NO	; Yes=Prometheus ProModem 1200 bps		107H
RESVD1:	 DB	NO	; Reserved for special modems			108H
RESVD2:	 DB	NO	; Reserved for special modems			109H
;
;
CLEAR:	 DB	'*'	; Clear screen character (ESC not needed)	10AH
;
;
	  IF	APPLICARD
CLOCK:	 DB	60	; Clock speed in MHz, 25.5 MHz max.		10BH
			; NOTE:  MUST MULTIPLY BY 10 FOR APPLICARD
	  ENDIF		; APPLICARD
;
	  IF	NOT APPLICARD
CLOCK:	 DB	20	; Clock speed in MHz x10, 25.5 MHz max. 	10BH
	  ENDIF		; NOT APPLICARD
;
;
			; 20=2 MHh, 37=3.68 MHz, 40=4 MHz, etc.
BYTDLY:	 DB	2	; 0=0 delay  1=10ms  5=50 ms - 9=90 ms		10CH
			;   default time to send character in ter-
			;   minal mode file transfer for slow BBS
CRDLY:	 DB	2	; 0=0 delay 1=100 ms 5=500 ms - 9=900 ms	10DH
			;   default time for extra wait after CRLF
			;   in terminal mode file transfer
NOFCOL:	 DB	5	; Number of directory columns shown		10EH
TCHPUL:	 DB	'T'	; T=tone, P=Pulse (Hayes 2400 modems)		10FH
;.....
;
;
ADDLFD:	 DB	NO	; Yes=add LF after CR to send file in terminal	110H
			;   mode (normally added by remote echo)
CONVRUB: DB	YES	; Yes=convert rub to backspace			111H
CRCDFLT: DB	YES	; Yes=default to CRC checking			112H
IGNRCTL: DB	NO	; Yes=CTL-chars above ^M not displayed		113H
;.....
;
;
EXTCHR:	 DB	'['-40H	; ESC = preceeds local control character	114H
EXITCHR: DB	'E'	; Exit character				115H
FILESND: DB	'F'	; Send file when in terminal mode		116H
NOCONCT: DB	'N'	; Disconnect from phone line			117H
LOGCHR:	 DB	'L'	; Send logon					118H
LSTCHR:	 DB	'P'	; Toggle printer				119H
UNSAVCH: DB	'R'	; Close input text buffer			11AH
SAVECHR: DB	'Y'	; Open input text buffer			11BH
CLEARS:	 DB	'Z'	; Clears screen, terminal mode			11CH
SPARE1:	 DB	0	; For future development			11DH
SPARE2:	 DB	0	; For future development			11EH
;.....
;
;
; Handles in/out ports for data and status
;
I$MDCTL1: JMP	RCVCTL1		; In modem control port 		11FH
	  DB	0,0,0,0,0,0,0	; Spares if needed			122H
;
I$MDTXE:  JMP	RCVCTL1		;					129H
	  DB	0,0,0,0,0,0,0	;					12CH
;
I$MDDATP: JMP	RCVDATP		;in modem data port			133H
	  DB	0,0,0,0,0,0,0	;					146H
;
O$MDDATP: JMP	SNDDATP		; Out modem data port			13DH
	  DB	0,0,0,0,0,0,0	; Spares if needed			140H
;.....
;
;
A$MDRCV:  ANI	MDRCV		;					147H
	  RET			;					149H
;
C$MDRCV:  CPI	MDRCV		;					14AH
	  RET			;					14CH
;
A$MDSND:  ANI	MDSND		;					14DH
	  RET			;					14FH
;
C$MDSND:  CPI	MDSND		;					150H
	  RET			;					152H
;
A$MDTXE:  ANI	MDTXE		;					153H
	  RET			;					155H
;
C$MDTXE:  CPI	MDTXE		;					156H
	  RET			;					158H
;.....
;
;
; Special exit vector, used by some computers to reset interrupt vectors
;
J$EXITVEC:RET			;					159H
	  DB	0,0		;					15AH
;.....
;
;
; Jump vectors needed by each overlay
;
J$GOODBYE:JMP	GOODBYE		; Disconnects modem by dropping DTR	15CH
J$INITMOD:JMP	INITMOD		; Initializes modem, autosets baudrate	15FH
J$STUPR:  JMP	STUPR		; SET routine to change baudrate	162H
J$SYSVR:  JMP	SYSVR		; Signon message			165H
;.....
;
;
; "AT" command strings, can be replaced in individual overlay if needed
;
J$STRNGA: DS	3		; 1200 bps "AT" string			168H
J$STRNG1: DS	3		; 2400 bps "AT" string			16B:IMP
;
;
; Next fourteen lines should not be changed by user overlay as these go
; to specific locations in the main program, not in the overlay.
;
;
J$CMDSPL: DS	3		; Allows entry of baudrate on CMD line	16EH
J$CRLF:	  DS	3		; Turns up one new line on display	171H
J$DIAL:	  DS	3		; Start of dialing routine		174H
J$DSCONT: DS	3		; Terminates modem use			177H
J$GOLST:  DS	3		; Printer routine, needed by Apple //e	17AH
J$ILPRT:  DS	3		; Prints an inline string, 0 to end	17DH
J$INBUF:  DS	3		; Stores a keybd string for comparison	180H
J$INLNCP: DS	3		; Inline "compare strings" routine	183H
J$INMDM:  DS	3		; Max .1 sec wait for modem character	186H
J$RCVRSP: DS	3		; For 3801 I/O use (TV-803)		189H
J$SNDCHR: DS	3		; Sends a character to the modem	18CH
J$SNDSTR: DS	3		; Sends a string to the modem, $ to end 18FH
J$TIMER:  DS	3		; .1 second timer (amount in 'B' reg.)	192H
J$NEW1:	  DB	0,0,0		; For future needs			195H
J$NEW2:	  DB	0,0,0		; For future needs			198H
;.....
;
;
; For 2400 bps auto-stepdown units
;
MANUAL:	  DB	0		; For manual selection flag		19BH
J$300:	  JMP	OK300		; Sets baudrate to 300 baud		19CH
J$1200:	  JMP	OK1200		; Sets baudrate to 1200 bps		19FH
J$2400:	  JMP	OK2400		; Sets baudrate to 2400 bps		1A2H
;.....
;
;
LOGPTR:	  DW	LOGON		; Pointer to display LOGON message	1A5H
;
SYSVR:	  CALL	J$ILPRT		; Display the following line		1A7H
	  DB	'Apple ][ and '	;					1AAH
;
	 IF MICROSOFT
	DB	'CP/M 2.2 Card'
	 ENDIF
;
	 IF APPLICARD
	DB	'Applicard'
	 ENDIF
;
	 IF ALSCARD
	DB	'ALS CP/M Card'
	 ENDIF
;
	DB	CR,LF
;
	 IF SABA
	DB	'Port 1 1200 SIO CARD*'
	 ENDIF

	 IF VERSA
	DB	'Versacard'
	 ENDIF
;
	 IF SSC
	DB	'Super Serial Card'
	 ENDIF
;
	 IF COMCARD
	DB	'Comcard'
	 ENDIF
;
	 IF CPS
	DB	'CPS card - serial function'
	 ENDIF
;
	 IF CCS
	DB	'CCS 7710 Card'
	 ENDIF
;
	 IF ALSDSP
	DB	'ALS Dispatcher'
	 ENDIF
;
	 IF SSM
	DB	'SSM Serial Interface'
	 ENDIF
;
	DB	' in slot ',SLOT+30H,CR,LF
	DB	0
	RET
;.....
;
;
;-----------------------------------------------------------------------
;
; NOTE:  You can change the SYSVER message to be longer or shorter.  The
;	 end of your last routine should terminate by 0400H (601 bytes
;	 available after start of SYSVER).
;
;-----------------------------------------------------------------------
;
; You can put in a message at this location which can be called up with
; (special character-L).  You can put in several lines.  End with a 0.
;
LOGON:	DB	'Hello there from an Apple user',CR,0
;
;-----------------------------------------------------------------------
;
; This routine sets DTR low for 1 second to disconnect the phone
;
GOODBYE	EQU	$
;
	 IF	NOT CPS	AND NOT	SSC AND NOT SABA
	CALL	J$ILPRT
	DB	CR,LF,'++ DOES NOT DROP DTR, USE "BYE" ++'BELL,CR,LF,0
	RET
	 ENDIF			; NOT CPS AND NOT SSC AND NOT SABA
;
	MVI	A,'S'-40H	; X-off to stop host if needed
	CALL	J$SNDCHR
	MVI	B,1		; Wait a moment to let it react
	CALL	J$TIMER

	 IF SABA
; This routine sends a 300 ms. break tone and sets DTR low for the 
; same length of time to disconnect some modems such as the Bell 212A, etc.
;
          MVI	A,15H
	  OUT	MDCTL1		;SEND TO THE STATUS PORT
	  MVI	A,68H		;TURN OFF DTR
;
GOODBYE1: OUT	MDCTL1
	  MVI	B,3		;DELAY 300 MS.
	  CALL	J$TIMER
	  MVI	A,15H
	  OUT	MDCTL1
	  MVI	A,0E8H		;RESTORE TO NORMAL, 8 BITS, DTR ON, ETC.
	  OUT	MDCTL1
	  RET
	ENDIF ;SABA
;
	 IF	SSC
	MVI	A,0AH		; Turn off DTR
	CALL	SNDCTL2
	MVI	B,10		; Delay 1 second to hang up phone
	CALL	J$TIMER
	MVI	A,0BH		; Set DTR, Rx, Irq
	CALL	SNDCTL2
	XTHL			; Short delay to complete command
	XTHL
	RET
	 ENDIF			; SSC
;
	 IF	CPS
	MVI	A,80H		; Open command
	CALL	SNDMDCR
	MVI	A,1DH		; RTS, DTR off, send break
	CALL	SNDCTL1
	MVI	B,10		; WAIT 1 SECOND
	CALL	J$TIMER
	MVI	A,37H		; RTS, ERR reset errors, Rx, DTR, Tx
	CALL	SNDCTL1
	MVI	A,0		; Close command
	CALL	SNDMDCR
	MVI	B,5		; Short delay to complete command
	CALL	J$TIMER
	RET
	 ENDIF			; CPS
;.....
;
;
;=========================== INITMOD ===================================
;
;
INITMOD	EQU	$
;
	 IF	ALSCARD
	LHLD	1		; Initialize our local jumps to the BIOS
	LXI	D,60H
	DAD	D
	SHLD	APREAD+1
	INX	H
	INX	H
	INX	H
	SHLD	APWRITE+1
	RET
	 ENDIF			; ALSCARD
;.....
;
;
	 IF 	SABA
; Aplicard initialization -- sets CTC timer 00H for send and receive
; baudrate.
;
INITMOD:  
	  MVI	A,10H		;SELECT REG.
	  OUT	MDCTL1
	  MVI	A,18H		;THROW OUT OF MODE
	  OUT	MDCTL1
	  MVI	A,14H		;SELECT REG.
	  OUT	MDCTL1
	  MVI	A,44H		;SET ASCII PARAMETERS X16 CLOCK
	  OUT	MDCTL1
	  MVI	A,13H		;SELECT REG.
	  OUT	MDCTL1
	  MVI	A,0C1H		;ENABLE RECEIVE
	  OUT	MDCTL1
	  MVI	A,15H		;SELECT REG.
	  OUT	MDCTL1
	  MVI	A,0EAH		;ENABLE SEND, DTR, RTS
	  OUT	MDCTL1
;
        MVI	A,IMSPEED
	CPI	1		; 300 bps
	JZ	OK300
	CPI	5		; 1200 bps
	JZ	OK1200
	CPI	6		; 2400 bps
	JZ	OK2400
	CPI	8		; 9600 bps
	JZ	OK9600
	CPI	9  		;19200 bps
	JZ	OK19200
	CPI	10		;38400 bps (only IMSPEED can be 10)
	JZ	OK38400
	JMP	STUPR1		; Else ask what is wanted
	 ENDIF ;SABA


	 IF	CCS
	LDA	MSPEED		; Get the selected value
	CPI	1		; 300 bps
	JZ	OK300
	CPI	5		; 1200 bps
	JZ	OK1200
	CPI	6		; 2400 bps
	JZ	OK2400
	CPI	8		; 9600 bps
	JZ	OK9600
	JMP	STUPR1		; Else ask what is wanted
;
INITMOD1:
	MOV	A,B		; Get the baudrate back, 8 bits 1 stop
	CALL	SNDCTL1		; CCS ACIA control register
	XTHL			; Short delay to complete command
	XTHL
	RET
	 ENDIF			; CCS
;.....
;
;
; The following may be used to initialize the Mountain Hardware CPS
; Multifunction Card.
;
	 IF	CPS
	CALL	CPSPRINT	; Install special CPS printer routine
	LDA	MSPEED		; Get the selected value
	CPI	1		; 300 bps
	JZ	OK300
	CPI	5		; 1200 bps
	JZ	OK1200
	CPI	6		; 2400 bps
	JZ	OK2400
	CPI	8		; 9600 bps
	JZ	OK9600
	JMP	STUPR1		; Else ask what is wanted
;
INITMOD1:
	MVI	A,80H		; Open command
	CALL	SNDMDCR
	MVI	A,4EH		; 1 stop, 8 bits, 16x
	CALL	SNDDATP
	MOV	A,B		; Get the baudrate back
	CALL	SNDDATP
	MVI	A,37H		; RTS, ERR reset errors, Rx, DTR, Tx
	CALL	SNDCTL1
	XRA	A		; Close command
	CALL	SNDMDCR
	MVI	B,5		; 1/2 second delay for CPS board
	CALL	J$TIMER
	RET
	 ENDIF			; CPS
;.....
;
;
	 IF SSC
	MVI	A,0BH		; Set DTR, Rx, Irq
	CALL	SNDCTL2
	XTHL			; Short delay to complete command
	XTHL
;
	LDA	MSPEED		; Get the selected value
	CPI	1		; 300 bps
	JZ	OK300
	CPI	5		; 1200 bps
	JZ	OK1200
	CPI	6		; 2400 bps
	JZ	OK2400
	CPI	8		; 9600 bps
	JZ	OK9600
	JMP	STUPR1		; Else ask what is wanted
;
INITMOD1:
	MOV	A,B		; Get the baudrate back
	JMP	SNDCTL3		; Store default baudrate
	XTHL			; Short delay to complete command
	XTHL
	RET
	 ENDIF			; SSC
;.....
;
;
; The following routine initializes the Versacard to the default baud
; rate which is set at MSPEED above.  If MSPEED is set to something
; other than 300 or 1200 this routine does not alter the annunciator
; settings.
;
	 IF	VERSA
INITMOD1:
	LDA	MSPEED		; Set annunciators to known state
	CPI	1		; Is it 300 ?
	JZ	OK300
	CPI	5		; Is it 1200 ?
	JZ	OK1200
	RET
	 ENDIF			; VERSA
;.....
;
;
; If none of the above cards
;
	RET			; From CALL INITMOD
;.....
;
;
; The routine that checks to see if the printer is ready does not work
; with the CPS card.  This routine changes it.	It overwrites the area
; in the main program that normally checks printer status from a BDOS
; call with our own status checks.
;
CPSPRINT:
	 IF	CPS AND	CPSPRT	; If printer uses CPS printer port
	CALL	J$GOLST		; Get GOLIST+1 in 'HL'
	LXI	B,PRCHECK	; Put routine at GOLIST+1
	MOV	M,C
	INX	H
	MOV	M,D
	XCHG			; Now get GOLIST+15 into 'HL' from 'DE'
	LXI	B,PRINTCHAR	; Put routine at GOLIST+15
	MOV	M,C
	INX	H
	MOV	M,D
	RET
;.....
;
;
; Substitute routines for status checks and printing:
;
PRCHECK:CALL	RCVCPST		; Read the status port
	ANI	40H		; Mask off unused bits
	RET
;.....
;
;
PRINTCHAR:
	MOV	A,C		; Move character to 'A' register
	JMP	SNDCPRT		; Send it to the printer
	 ENDIF			; CPS AND CPSPRT
;
	RET			; In case CPSPRT was set to 'NO'
;.....
;
;
;========================== APPLE I/O ==================================
;
	 IF	MICROSOFT
SNDCTL1:STA	MDCTL1
	RET
;
SNDDATP:STA	MDDATP
	RET
;
RCVCTL1:LDA	MDCTL1
	RET
;
RCVDATP:LDA	MDDATP
	RET
	 ENDIF			; CPMCARD
;.....
;
;
	  IF	MICROSOFT AND CPS
SNDCPRT: STA	MDCPRT
	 RET
;
SNDMDCR: STA	MDCR
	 RET
;
RCVCPST: LDA	MDCPST
	 RET
	  ENDIF			; MICROSOFT AND CPS
;.....
;
;
	  IF	MICROSOFT AND SSC
RCVCTL2: LDA	MDCTL2
	 RET
;
RCVCTL3: LDA	MDCTL3
	 RET
;
SNDCTL2: STA	MDCTL2
	 RET
;
SNDCTL3: STA	MDCTL3
	 RET
	  ENDIF			; MICROSOFT AND SSC
;.....
;
;
	  IF	MICROSOFT AND VERSA
RCVAN3C: LDA	AN3CLR
	 RET
;
RCVAN3S: LDA	AN3SET
	 RET
	 ENDIF			; MICROSOFT AND VERSA
;.....
;
;
	  IF	ALSCARD	AND SSC
SNDCTL2: PUSH	H
	 LXI	H,MDCTL2
	 JMP	POKE
;
SNDCTL3: PUSH	H
	 LXI	H,MDCTL3
	 JMP	POKE
	  ENDIF			; ALSCARD AND SSC
;.....
;
;
	  IF	ALSCARD
SNDCTL1: PUSH	H
	 LXI	H,MDCTL1
	 JMP	POKE
;
SNDDATP: PUSH	H
	 LXI	H,MDDATP
;
POKE:	 PUSH	D
	 PUSH	B
	 CALL	APWRITE
	 POP	B
	 POP	D
	 POP	H
	 RET
	  ENDIF			; ALSCARD
;.....
;
;
	  IF	ALSCARD	AND SSC
RCVCTL3:  PUSH	H
	 LXI	H,MDCTL3
	 JMP	PEEK
	  ENDIF			; ALSCARD AND SSC
;.....
;
;
	  IF	ALSCARD
RCVCTL1: PUSH	H
	 LXI	H,MDCTL1
	 JMP	PEEK
;
RCVDATP: PUSH	H
	 LXI	H,MDDATP
;
PEEK:	 PUSH	D
	 PUSH	B
	 CALL	APREAD
	 POP	B
	 POP	D
	 POP	H
	 RET
;.....
;
;
; These are the jump locations to the ALS BIOS
;
APREAD:	 JMP	$-$
APWRITE: JMP	$-$
	  ENDIF			; ALSCARD
;.....
;
;
	  IF	ALSCARD	AND CPS
SNDCPRT: PUSH	H
	 LXI	H,MDCPRT
	 JMP	POKE
;
SNDMDCR: PUSH	H
	 LXI	H,MDCR
	 JMP	POKE
;
RCVCPST: PUSH	H
	 LXI	H,MDCPST
	 JMP	PEEK
	  ENDIF			; ALSCARD AND CPS
;.....
;
;
	  IF	ALSCARD	AND SSC
RCVCTL3: PUSH	H
	 LXI	H,MDCTL3
	 JMP	PEEK
;
SNDCTL2: PUSH	H
	 LXI	H,MDCTL2
	 JMP	POKE
;
SNDCTL3: PUSH	H
	 LXI	H,MDCTL3
	 JMP	POKE
	  ENDIF			; ALSCARD AND SSC
;.....
;
;
	  IF	ALSCARD	AND VERSA
RCVAN3C: PUSH	H
	 LXI	H,AN3CLR
	 JMP	PEEK
;
RCVAN3S: PUSH	H
	 LXI	H,AN3SET
	 JMP	PEEK
	  ENDIF			; ALSCARD AND VERSA
;.....
;
;
	  IF SABA
RCVCTL1: IN  MDCTL1
	 RET
;
RCVDATP: IN  MDDATP
	 RET
;
SNDCTL1: OUT MDCTL1 
	 RET
;
SNDDATP: OUT MDDATP
	 RET
	  ENDIF 		;SABA


	  IF	APPLICARD AND NOT SABA 
RDBYTE	 EQU	0FFE0H		; Read 1 byte frin Aooke (A = byte)
WRBYTE	 EQU	0FFE3H		; Write 1 byte to Apple (C = byte)
RDWORD	 EQU	0FFE6H		; Read 2 bytes from Apple (DE = word)
WRWORD	 EQU	0FFE9H		; Write 2 bytes to Apple (DE = word)
PEEK1	 EQU	6		; Command
POKE1	 EQU	7		; Command
;
SNDCTL1: PUSH	D
	 LXI	D,MDCTL1
	 JMP	POKE
;
SNDDATP: PUSH	D
	 LXI	D,MDDATP
;
POKE:	 PUSH	B
	 MOV	B,A
	 MVI	C,POKE1
	 CALL	WRBYTE
	 CALL	WRWORD
	 MOV	C,B
	 CALL	WRBYTE
	 POP	B
	 POP	D
	 RET
;...
;
;
RCVCTL1: PUSH	D
	 LXI	D,MDCTL1
	 JMP	PEEK
;
RCVDATP: PUSH	D
	 LXI	D,MDDATP
;
PEEK:	 PUSH	B
	 MVI	C,PEEK1
	 CALL	WRBYTE
	 CALL	WRWORD
	 CALL	RDBYTE
	 POP	B
	 POP	D
	 RET
	  ENDIF			; APPLICARD AND NOT SABA
;.....
;
;
	  IF	APPLICARD AND CPS
SNDCPRT: PUSH	D
	 LXI	D,MDCPRT
	 JMP	POKE
;
SNDMDCR: PUSH	D
	 LXI	D,MDCR
	 JMP	POKE
;
RCVCPST: PUSH	D
	 LXI	D,MDCPST
	 JMP	PEEK
	  ENDIF			; APPLICARD AND CPS
;.....
;
;
	  IF	APPLICARD AND SSC
RCVCTL3: PUSH	D
	 LXI	D,MDCTL3
	 JMP	PEEK
;
SNDCTL2: PUSH	D
	 LXI	D,MDCTL2
	 JMP	POKE
;
SNDCTL3: PUSH	D
	 LXI	D,MDCTL3
	 JMP	POKE
	  ENDIF			; APPLICARD AND SSC
;.....
;
;
	  IF	APPLICARD AND VERSA
RCVAN3C: PUSH	D
	 LXI	H,AN3CLR
	 JMP	PEEK
;
RCVAN3S: PUSH	D
	 LXI	H,AN3SET
	 JMP	PEEK
	  ENDIF			; APPLICARD AND VERSA
;.....
;
;
;-----------------------------------------------------------------------
;
;
; Use the 'SET' command to select a desired baud rate
;
STUPR	EQU	$
;
	 IF	ALSDSP OR COMCARD OR SSM
	RET
	 ENDIF			; ALSDSP OR COMCARD OR SSM
;
;
	 IF	NOT ALSDSP OR NOT COMCARD OR NOT SSM 
	CALL	J$CMDSPL	; Gives us CMDBUF+6
	JNC	STUPR2
;
STUPR1:	CALL	J$ILPRT
	DB	'Input Baud Rate '

IF SABA
	DB	'(300, 1200, 2400, 9600, 19200, 38400): ',0
ENDIF ;SABA

IF NOT SABA
	DB	'(300, 1200, 2400, 9600): ',0
ENDIF ;NOT SABA


	LXI	D,BAUDBUF	; Point to new input buffer
	CALL	J$INBUF
	CALL	J$CRLF
	LXI	D,BAUDBUF+2
;
STUPR2:	CALL	J$INLNCP	; Compare BAUDBUF+2 with chars. below
	DB	'300',0
	JNC	OK300		; Go if got match
	CALL	J$INLNCP
	DB	'1200',0
	JNC	OK1200
	CALL	J$INLNCP
	DB	'2400',0
	JNC	OK2400
	CALL	J$INLNCP
	DB	'9600',0
	JNC	OK9600
	CALL	J$INLNCP
	DB	'19200',0
	JNC	OK19200
	CALL	J$INLNCP
	DB	'38400',0
	JNC	OK38400
	CALL	J$ILPRT		; All matches failed, tell operator
	DB	'++ Incorrect entry ++',CR,LF,BELL,CR,LF,0
	JMP	STUPR1		; Try again
;
;
	 IF	NOT VERSA AND NOT SABA
OK300:	MVI	A,1		; MSPEED 300 baud value
	MVI	B,BD300		; Get 300 baud value for 2651 in 'B'
	JMP	LOADBD		; Go load everything
;
OK1200:	MVI	A,5
	MVI	B,BD1200
	JMP	LOADBD
;
OK2400:	XRA	A
	STA	MANUAL
	MVI	A,6
	MVI	B,BD2400
	JMP	LOADBD
;
OK9600:	MVI	A,8
	MVI	B,BD9600
;
LOADBD:	STA	MSPEED		; Change time-to-send to match baudrate
	JMP	INITMOD1	; Reset to new baudrate
	 ENDIF			; NOT VERSA AND NOT SABA
;.....
;
;
	 IF	VERSA 
OK300:	CALL	RCVAN3C		; Clear Annunciator #3 for 300 baud
	MVI	A,1		; Set MSPEED for 300 baud
	STA	MSPEED		; For 300 baud
	RET
;
OK1200:	CALL	RCVAN3S		; Set Annunciator #3 for 1200 baud
	MVI	A,5		; Set MSPEED for 1200 bps
	STA	MSPEED		; For 1200 baud
	RET
	 ENDIF			; VERSACARD 
;.....
;
	 IF SABA
;
OK300:	  MVI	A,7
	  OUT	CPORT
	  MVI	A,78
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MDCTL1
	  MVI	A,044H		; SET X16 CLOCK
	  OUT	MDCTL1
	  MVI	A,1
	  STA	MSPEED
	  RET
;
OK1200:	  MVI	A,47H
	  OUT	CPORT
	  MVI	A,96
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MDCTL1
	  MVI	A,044H		; SET X16 CLOCK
	  OUT	MDCTL1
	  MVI	A,5
	  STA   MSPEED
	  RET
;
OK2400:	  MVI	A,47H
	  OUT	CPORT
	  MVI	A,48
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MDCTL1
	  MVI	A,044H		; SET X16 CLOCK
	  OUT	MDCTL1
	  MVI	A,6
	  STA   MSPEED
	  RET
;
OK9600:	  MVI	A,47H
	  OUT	CPORT
	  MVI	A,12		; off by 2.34%
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MDCTL1
	  MVI	A,44H		; SET X16 CLOCK 
	  OUT	MDCTL1
	  MVI	A,8
	  STA   MSPEED
	  RET
;
OK19200:  MVI	A,47H
	  OUT	CPORT
	  MVI	A,6		; off by 2.4%
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MDCTL1
	  MVI	A,44H		; SET X16 CLOCK
	  OUT	MDCTL1
	  MVI	A,9
	  STA   MSPEED
	  RET
;
OK38400:  MVI	A,47H
	  OUT	CPORT
	  MVI	A,3		; off by 2.4% but it works fine on mine!
	  OUT   CPORT
	  MVI	A,14H
	  OUT   MDCTL1
	  MVI	A,44H		; SET X16 CLOCK
	  OUT	MDCTL1
	  MVI	A,9
	  STA   MSPEED
	  RET
	 ENDIF ;SABA

;.....
;
; Table of baud rate parameters
;
	 IF	CCS
BD300	EQU	16H
BD1200	EQU	15H
	 ENDIF			; CCS
;
	 IF	CPS
BD300	EQU	35H
BD600	EQU	36H
BD1200	EQU	37H
BD2400	EQU	3AH
BD9600	EQU	3EH
	 ENDIF			; CPS
;
	 IF	SSC
BD300	EQU	16H
BD1200	EQU	18H
BD2400	EQU	1AH
BD9600	EQU	1EH
	 ENDIF			; SSC

;
BAUDBUF:DB	10,0,0,0,0,0
	DB	0,0,0,0,0,0
;
	 ENDIF			; NOT ALSDSP, COMCARD, SSM
;
;-----------------------------------------------------------------------
;
; NOTE: Must terminate prior to 0400H
;
	END
