#ifndef _PMLUSER_H
#define _PMLUSER_H

/************************************************************************
 *									*
 *				N O T I C E				*
 *									*
 *			Copyright Abandoned, 1987, Fred Fish		*
 *									*
 *	This previously copyrighted work has been placed into the	*
 *	public domain by the author (Fred Fish) and may be freely used	*
 *	for any purpose, private or commercial.  I would appreciate	*
 *	it, as a courtesy, if this notice is left in all copies and	*
 *	derivative works.  Thank you, and enjoy...			*
 *									*
 *	The author makes no warranty of any kind with respect to this	*
 *	product and explicitly disclaims any implied warranties of	*
 *	merchantability or fitness for any particular purpose.		*
 *									*
 ************************************************************************
 */


/*
 *  FILE
 *
 *	pmluser.h    include file for users of portable math library
 *
 *  SYNOPSIS
 *
 *	#include <pmluser.h>
 *
 *  DESCRIPTION
 *
 *	This file should be included in any user compilation module
 *	which accesses routines from the Portable Math Library (PML).
 *
 */


/*
 *	Create the type "COMPLEX".  This is an obvious extension that I
 *	hope becomes a part of standard C someday.
 *
 */

typedef struct cmplx {			/* Complex structure */
    double real;			/* Real part */
    double imag;			/* Imaginary part */
} COMPLEX;

/* exceptions ++jrb */
typedef enum  { DOMAIN, OVERFLOW, UNDERFLOW, PLOSS, SING } exception_type;

struct exception {
	exception_type	type;	/* exception type */
	char		*name;	/* function in which it occured */
	double		arg1;	/* an arg */
	double		retval; /* val to return */
};

static unsigned long __huge[2] = { 0x7ff00000L, 0L }; /* ieee infinity */
#define HUGE  (*((double *)&__huge[0]))

/* #ifndef atarist
   #include <std.h>
   #endif
*/

#if ((defined(__STDC__)) && (!defined(__NO_PROTO__)))
double acos(double);
double acosh(double);
double asin(double);
double asinh(double);
double atan(double);
double atan2(double, double);
double atanh(double);
double cabs(COMPLEX);
double cos(double);
double cosh(double);
double dabs(double);
double fabs(double);
double exp(double);
double log(double);
double log10(double);
int matherr(struct exception *);
double max(double, double);
double min(double, double);
double mod(double, double);
int pmlcfs(int, int);
int pmlcnt(void);
int pmlerr(int);
int pmllim(int);
int pmlsfs(int, int);
double poly(int, double *, double);
double sign(double, double);
double sin(double);
double sinh(double);
double sqrt(double);
double tan(double);
double tanh(double);
double floor(double);
double ceil(double);
double pow(double, double);
double rint(double);
double modf(double, double *);
double ldexp(double, int);
#ifdef __MSHORT__
double frexp(double, short *);
#else
double frexp(double, int *);
#endif

#else

extern double acos(/* double */);
extern double acosh(/* double */);
extern double asin(/* double */);
extern double asinh(/* double */);
extern double atan(/* double */);
extern double atan2(/* double, double */);
extern double atanh(/* double */);
extern double cabs(/* COMPLEX */);
extern double cos(/* double */);
extern double cosh(/* double */);
extern double dabs(/* double */);
extern double fabs(/* double */);
extern double exp(/* double */);
extern double log(/* double */);
extern double log10(/* double */);
extern int matherr(/* struct exception * */);
extern double max(/* double, double */);
extern double min(/* double, double */);
extern double mod(/* double, double */);
extern int pmlcfs(/* int, int */);
extern int pmlcnt(/*  */);
extern int pmlerr(/* int */);
extern int pmllim(/* int */);
extern int pmlsfs(/* int, int */);
extern double poly(/* int, double *, double */);
extern double sign(/* double, double */);
extern double sin(/* double */);
extern double sinh(/* double */);
extern double sqrt(/* double */);
extern double tan(/* double */);
extern double tanh(/* double */);
extern double floor(/* double */);
extern double ceil(/* double */);
extern double pow(/* double, double */);
extern double rint(/* double */);
extern double modf(/* double, double * */);
extern double ldexp(/* double, int */);
extern double frexp(/* double, int * */);

#endif /* __STDC__ */

#endif /* _PMLUSER_H */
