 ;*************************************************************************;
 ;SIMPLE.SP                                                                ;
 ;                                                                         ;
 ;The spelling rules for the `simple' system are the same as those for the ;
 ;`big' system:                                                            ;
 ;*************************************************************************;
 ;
 ;      Copyright Graeme Ritchie, Alan Black,
 ;                Steve Pulman and Graham Russell  1987
 ;
 ;         ---------------------------------------------
 ;         |    Not to be used for military purposes   |
 ;         ---------------------------------------------
 ;

SurfaceAlphabet
	{ a b c d e f g h i j k l m n o p q r s t u v w x y z - " " "'" }
SurfaceSets
	C is { b c d f g h j k l m n p q r s t v w x z}
	V is { a e i o u }
	V2 is { e i o u y }		;;  for gemination
	NLR is { n l r }
	S is { s x z }
	C2 is { b d f h j k l m n p q r s t v w x y z }
	NB is { a c d e f g h i j k l m n o p q r s t u v w x y z }
	NN is { a b c d e f g h i j k m o p q s t u v w x y z }  ;; No L,R, too 
	= is { a b c d e f g h i j k l m n o p q r s t u v w x y z - " " "'" 0 }

LexicalAlphabet
	{ a b c d e f g h i j k l m n o p q r s t u v w x y z - + " " "'" }
LexicalSets
	C is { b c d f g h j k l m n p q r s t v w x z }
	V is { a e i o u }
	NLR is { n l r }
	S is { s x z }
	C2 is { b d f h j k l m n p q r s t v w x y z }
	NC is { a b d e f g h i j k l m n o p q s t u v w x y z }  ;; no Rs too.
	NI is { a b c d e f g h j k l m n o p q r s t u v w x y z }
	NN is { a b c d e f g h i j k m o p q s t u v w x y z }  ;; No L,R, too 
	= is { a b c d e f g h i j k l m n o p q r s t u v w x y z - + " " "'" }
	Not+ is { a b c d e f g h i j k l m n o p q r s
			  t u v w x y z " " "'" }
DefaultPairs
	+:0    ;; the boundary symbol just disappears if nothing else happens
	-:0    ;; hyphens are optional, they need not be in the surface string
	" ":-  ;; surface strings can contain hyphens instead of spaces

Rules

;MorphBoundRestrict
   ;+:0 => Not+:= --- =:=

Epenthesis
 ;*************************************************************************;
 ;   Add "e" at + boundary following sibilants or a surface "i" matching   ;
 ;   a lexical "y": "horses", "churches", "dishes", "boxes", "quizzes",    ;
 ;   "tries", etc.                                                         ;
 ;*************************************************************************;
	+:e  <=>  { < s:s h:h > S:S y:i } --- s:s
	     or   < c:c h:h > --- s:s

Gemination-1
 ;*************************************************************************;
 ;  Double the final consonant of a word when the suffix begins with a     ;
 ;  vowel: "bigger", "tapped", etc.                                        ;
 ;*************************************************************************;
	+:X  <=>  < C:C V:V =:X > --- { =:V2 =:a } 
		  where X in { b d f g m p s t }
Gemination-2
 ;*************************************************************************;
 ;  As for Gemination-1, but if the suffix starts with "a", the next       ;
 ;  character can't be "n": "travelled", etc.                              ;
 ;*************************************************************************;
	+:Y  <=>  < C:C V:V =:Y > --- =:V2
	     or   < C:C V:V =:Y > --- < =:a NN:NN >
		  where Y in { n l r }
Y-to-I
 ;*************************************************************************;
 ;  Lexical "y" corresponds to surface "i": "tried", "presidential",       ;
 ;  "sunnier", "heaviness", "multiplication", etc.                         ;
 ;*************************************************************************;
	y:i  <=>  { C:C c:t } --- < +:= a:a =:NB >
	     or   { +:= C:C < q:q u:u > } --- < +:= NI:= > 
	     or   =:= --- < +:c a:a { t:t l:l } >  ;; c-insertion
		  
Elision
 ;*************************************************************************;
 ;  Lexical "e" corresponds to no surface character in a variety of        ;
 ;  contexts: "larger",                                                    ;
 ;*************************************************************************;
        e:0  <=>   =:C2 --- < +:0 =:V2 > ; changed: was ... V:= >
	     or    C2:C2 --- < +:0 a:= =:NB > 
	     or   < C:C V:V > --- < +:0 e:e >
	     or   { g:g c:c } --- < +:0 { e:e i:i } >
	     or   l:0 --- +:0
	     or   c:c --- < +:0 a:0 t:t >
	     or   =:= --- +:i

I-to-Y
 ;*************************************************************************;
 ;  Lexical "i" corresponds to surface "y" when followed by a deleted "e"  ;
 ;  and a suffix starting with "i": "tying", etc.                          ;
 ;*************************************************************************;
	i:y  <=>  =:= --- < e:0 +:0 i:i >

C-insertion
 ;*************************************************************************;
 ;  The lexical boundary symbol corresponds to surface "c": "application", ;
 ;  "meteorological", etc.                                                 ;
 ;*************************************************************************;
	+:c  <=>  < NC:= y:i >  --- < a:a { t:t l:l } >

K-insertion
 ;*************************************************************************;
 ;  A final "c" is not doubled in Gemination contexts, but followed by     ;
 ;  "k": "trafficker", "panicky" "picnicking", etc.                        ;
 ;*************************************************************************;
	+:k  <=>  < V:V c:c > --- { i:i e:e y:y }

A-deletion
 ;*************************************************************************;
 ;  Lexical "a" corresponds to no surface character when starting a        ;
 ;  suffix such as "ation": "reduction", "intervention", etc.              ;
 ;*************************************************************************;
	a:0  <=>  < u:u c:c e:0 +:0 > --- t:t
	     or	  < e:e n:n e:0 +:0 > --- t:t

E-to-I
 ;*************************************************************************;
 ;  Lexical "e" corresponds to surface "i" before "ous" and suffixes       ;
 ;  starting with "a" except "able": "bilious", "gracious", "preferential",;
 ;  etc.                                                                   ;
 ;*************************************************************************;
	e:i  <=>   c:= --- < +:0 { a:a o:o } =:NB >                  

I-insertion                                                              
 ;*************************************************************************;
 ;  The lexical boundary symbol corresponds to surface "i" before the      ;
 ;  suffixes "al" and "an": "managerial", "electrician", etc.              ;
 ;*************************************************************************;
	+:i  <=>  < { +:0 C:C } V:V NLR:NLR > --- < a:a { n:n l:l } >
             or   < { +:0 C:C } V:V c:c> --- < a:a n:n>	
	     or   < { +:0 C:C } V:V NLR:NLR e:0 > --- < a:a { n:n l:l } >

C-to-T
 ;*************************************************************************;
 ;  Lexical "c" corresponds to surface "t": "preferential",                ;
 ;  "presidential", "differentiate", etc.                                  ;
 ;*************************************************************************;
 	c:t  <=>  n:n --- < =:i +:0 a:a =:NB > 

Y-deletion
 ;*************************************************************************;
 ;  Lexical "y" corresponds to no surface character when followed by a     ;
 ;  suffix starting with "i", unless the suffix is "ing": "harmonic",      ;
 ;  "strategic", "theorist", etc.                                          ;
 ;*************************************************************************;
        y:0  <=>  { <q:= u:= > n:= g:= r:= l:= } --- < +:0 i:i =:NN >

L-deletion
 ;*************************************************************************;
 ;  Lexical "l" corresponds to no surface character when that would lead   ;
 ;  to double or triple "l"s: "possibly", "fully", etc.                    ;
 ;*************************************************************************;
	l:0  <=>  < V:V b:b > --- < e:0 +:0 l:l >
	      or  < l:l +:0 > --- =:=

L-to-I
 ;*************************************************************************;
 ;  Surface "i" corresponds to lexical "l" before surface "l"              ;
 ;  corresponding to lexical "e": "possibility", "stabilize", etc.         ;
 ;*************************************************************************; 
	l:i  <=>  < V:V b:b > --- e:l

E-to-L
 ;*************************************************************************;
 ;  Surface "l" corresponds to lexical "e": see L-to-I                     ;
 ;*************************************************************************;
	e:l  <=>  l:i --- < +:0 i:i { t:t z:z } >

