;;;
;;;   File: dpl.st
;;;
;;;   Dynamic predicate logic in astl
;;;
;;;   Alan W Black (awb@ed.ac.uk) Feb 92
;;;
;;;   The grammar is the syntax of DPL while the semantic builds up
;;;   assignments for each wff expression.
;;;


Individuals   {h, t}
Relations     (var/2 scope/2 AssignIn/2 AssignOut/2
               ind/2 wff/1
               exists/1 forall/2 man/1 walk/1)
Parameters    {S T A B C X}
Variables     {*S, *T, *G, *H, *K, *M, *Scope, *Rel,
               *Ind, *X, *AIn, *AOut, *Aintype, *Gtype,
               *Htype, *C1, *C2, *D1, *D2, *Arg}
Situations    (EmptyAssign)
GoalProp *S : [S ! S != <<sentence,S,1>>
                   S != <<AssignOut,S,*H,1>>]
Constraints
    *S : [S ! S != <<AssignOut,S,
                     *AOut :: *Aintype &
                            [T ! T != <<*Rel,*X,1>>],1>>]
    <=
       *S : [S ! S != <<terminal,S,pred,1>>
                 S != <<sem,S,*Rel,1>>
                 S != <<arg,S,*Arg,1>>
                 S != <<AssignIn,S,*AIn :: *Aintype &
                        [T ! T != <<assign,*Arg,*X,1>>],1>>].

    *S : [S ! S != <<AssignOut,S,
                     *H :: *Htype &
                     [T ! T != <<exists,*K,1>>],1>>]
    <=
       *S : [S ! S != <<term,S,exists,1>>
                 S != <<scope,S,
                        *Scope ::
                         [T ! T != <<AssignOut,*Scope,
                                     *H :: *Htype ,1>>
                              T != <<AssignIn,*Scope,
                                     *K,1>>],1>>].

    *T : [S ! S != <<AssignIn,S,*K :: *Gtype &
                     [T ! T != <<assign,*X,*Ind,1>>],
                     1>>]
    <=
      *S : [S ! S != <<term,S,exists,1>>
                S != <<AssignIn,S,*G :: *Gtype,1>>
                S != <<scope,S,*T,1>>
                S != <<ind,S,*Ind,1>>
                S != <<var,S,*X,1>>].

    *S : [S ! S != <<AssignOut,S,
                     *G :: *AIntype &
                     [T ! T != <<forall,*K,*M,1>>],1>>]
    <=
       *S : [S ! S != <<term,S,forall,1>>
                 S != <<scope,S,
                        *Scope ::
                         [T ! T != <<AssignOut,*Scope,*M,1>>
                              T != <<AssignIn,*Scope,*K,1>>],1>>
                 S != <<AssignIn,S,*G :: *AIntype,1>>].

    *T : [S ! S != <<AssignIn,S,*K :: *Gtype &
                     [T ! T != <<assign,*X,*Ind,1>>],
                     1>>]
    <=
      *S : [S ! S != <<term,S,forall,1>>
                S != <<AssignIn,S,*G :: *Gtype,1>>
                S != <<scope,S,*T,1>>
                S != <<ind,S,*Ind,1>>
                S != <<var,S,*X,1>>].

    *T : [S ! S != <<AssignIn,S,EmptyAssign,1>>]
    <=
      *S : [S ! S != <<sentence,S,1>>
                S != <<scope,S,*T,1>>].
    *T : [S ! S != <<AssignIn,S,EmptyAssign,1>>
              S != <<AssignOut,S,*H,1>>]
    <=
      *T : [S ! S != <<sentence,S,1>>
                S != <<scope,S,*Scope :: 
                       [T ! T != <<AssignOut,T,*H,1>>],1>>].
Grammar Rules
;;;
;;;  None of this natural language grammar stuff just 
;;;  old-fasionedlogical form - this is harder than it 
;;;  should be 
;;;
*S : [S ! S != <<sentence,S,1>>
          S != <<Scope,S,*T,1>>]
->
   [S ! S != <<terminal,S,period,1>>],
   *T : [S ! S != <<wff,S,1>>],
   [S ! S != <<terminal,S,period,1>>].

*S : [S ! S != <<wff,S,1>>
          S != <<term,S,conj,1>>
          S != <<conjunct,S,*C1,1>>
          S != <<conjunct,S,*C2,1>>]
->
   *C1 : [S ! S != <<wff,S,1>>],
   [S ! S != <<terminal,S,and,1>>],
   *C2 : [S ! S != <<wff,S,1>>].

*S : [S ! S != <<wff,S,1>>
          S != <<term,S,disj,1>>
          S != <<disjunct,S,*D1,1>>
          S != <<disjunct,S,*D2,1>>]
->
   *D1 : [S ! S != <<wff,S,1>>],
   [S ! S != <<terminal,S,or,1>>],
   *D2 : [S ! S != <<wff,S,1>>].

*S : [S ! S != <<wff,S,1>>
          S != <<term,S,exists,1>>
          S != <<scope,S,*Scope,1>>
          S != <<ind,S,*Ind,1>>
          S != <<var,S,*X,1>>]
->
   [S ! S != <<terminal,S,exists-quant,1>>
        S != <<ind,S,*Ind,1>>
        S != <<var,S,*X,1>>],
   *Scope : [S ! S != <<wff,S,1>>].

*S : [S ! S != <<wff,S,1>>
          S != <<term,S,forall,1>>
          S != <<scope,S,*Scope,1>>
          S != <<ind,S,*Ind,1>>
          S != <<var,S,*X,1>>]
->
   [S ! S != <<terminal,S,forall-quant,1>>
        S != <<ind,S,*Ind,1>>
        S != <<var,S,*X,1>>],
   *Scope : [S ! S != <<wff,S,1>>].

Lexical Entries

man-x - [S ! S != <<terminal,S,pred,1>>
             S != <<sem,S,man,1>>
             S != <<arg,S,X,1>>
             S != <<wff,S,1>>]
walk-x - [S ! S != <<terminal,S,pred,1>>
              S != <<sem,S,walk,1>>
              S != <<arg,S,X,1>>
              S != <<wff,S,1>>]
exists-x - [S ! S != <<terminal,S,exists-quant,1>>
                S != <<ind,S,A,1>>  ;; should be new for each use
                S != <<var,S,X,1>>]
forall-x - [S ! S != <<terminal,S,forall-quant,1>>
                S != <<ind,S,B,1>>  ;; should be new for each use
                S != <<var,S,X,1>>]
and - [S ! S != <<terminal,S,and,1>>]
or - [S ! S != <<terminal,S,or,1>>]
period - [S ! S != <<terminal,S,period,1>>]

          
