;;;
;;;  File: astl-mode.el
;;;  Emacs Lisp
;;;
;;;  Alan W Black  Dept of AI (awb@ed.ac.uk)
;;;
;;;  Provide an emacs mode for editing astl files.  This
;;;  is basically lisp mode but without treatibng [] as
;;;  super-brackets and also treating <> as brackets.
;;;
;;;  Based on Lisp mode so as a derivative work it inherits
;;;  the GNU licence
;;;
;;;--------------------------------------------------------------------
;;;               Copyright (C) Alan W Black 1991
;;; This code is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY. No author or distributor accepts
;;; responsibility to anyone for the consequences of using this code
;;; or for whether it serves any particular purpose or works at all,
;;; unless explicitly stated in a written agreement.
;;;
;;; Everyone is granted permission to copy, modify and redistribute
;;; this code, but only under the conditions described in the GNU
;;; Emacs General Public License.  A copy of this license is
;;; distrubuted with GNU Emacs and GNU Epoch so you can know your
;;; rights and responsibilities.  It should be in a file named
;;; COPYING.  Among other things, the copyright notice and this
;;; notice must be preserved on all copies.
;;;--------------------------------------------------------------------
;;;  
;;; You should add put this file in a directory that is in your
;;; emacs load-path and add the following to your .emacs
;;;
;;; (autoload 'astl-mode "astl-mode" "Mode for editing ASTL files." t)
;;; (setq auto-mode-alist 
;;;       (append '(("\\.st$" . astl-mode)) auto-mode-alist))
;;;

(defvar astl-mode-syntax-table nil "")
(defvar astl-mode-abbrev-table nil "")

(define-abbrev-table 'astl-mode-abbrev-table ())

(defun astl-mode-variables (lisp-syntax)
  (cond (lisp-syntax
	  (if (not astl-mode-syntax-table)
	      (progn (setq astl-mode-syntax-table
			   (copy-syntax-table lisp-mode-syntax-table))
		     (modify-syntax-entry ?\| "\"   "
					  astl-mode-syntax-table)
		     (modify-syntax-entry ?\< "(>   "
					  astl-mode-syntax-table)
		     (modify-syntax-entry ?\> ")<   "
					  astl-mode-syntax-table)
		     (modify-syntax-entry ?\} "){   "
					  astl-mode-syntax-table)
		     (modify-syntax-entry ?\{ "(}   "
					  astl-mode-syntax-table)
		     (modify-syntax-entry ?\[ "(]   "
					  astl-mode-syntax-table)
		     (modify-syntax-entry ?\] ")[   "
					  astl-mode-syntax-table)))
	  (set-syntax-table astl-mode-syntax-table)))
  (setq local-abbrev-table astl-mode-abbrev-table)
  (make-local-variable 'paragraph-start)
  (setq paragraph-start (concat "^$\\|" page-delimiter))
  (make-local-variable 'paragraph-separate)
  (setq paragraph-separate paragraph-start)
  (make-local-variable 'paragraph-ignore-fill-prefix)
  (setq paragraph-ignore-fill-prefix t)
  (make-local-variable 'indent-line-function)
  (setq indent-line-function 'lisp-indent-line)
  (make-local-variable 'comment-start)
  (setq comment-start ";")
  (make-local-variable 'comment-start-skip)
  (setq comment-start-skip ";+ *")
  (make-local-variable 'comment-column)
  (setq comment-column 50)
  (make-local-variable 'comment-indent-hook)
  (setq comment-indent-hook 'lisp-comment-indent))

(defun astl-mode-commands (map)
  (define-key map "\e\C-q" 'indent-sexp)
  (define-key map "\M-q" 'reindent-lisp)
  (define-key map "\177" 'backward-delete-char-untabify)
  (define-key map "\t" 'lisp-indent-line))

(defvar astl-mode-map ())
(if astl-mode-map
    ()
  (setq astl-mode-map (make-sparse-keymap))
  (define-key astl-mode-map "\e\C-x" 'lisp-send-defun)
  (define-key astl-mode-map "\C-c\C-l" 'run-lisp)
  (astl-mode-commands astl-mode-map))

(defun astl-mode ()
  "Major mode for editing ASTL code. ASTL is a programming language/
grammar formalism based on situation theory.  This mode is based
heavily on lisp-mode.
Commands:
Delete converts tabs to spaces as it moves back.
Blank lines separate paragraphs.  Semicolons start comments.
\\{astl-mode-map}
Note that `run-lisp' may be used either to start an inferior Lisp job
or to switch back to an existing one.

Entry to this mode calls the value of astl-mode-hook
if that value is non-nil."
  (interactive)
  (kill-all-local-variables)
  (use-local-map astl-mode-map)
  (setq major-mode 'astl-mode)
  (setq mode-name "ASTL")
  (astl-mode-variables t)
  (set-syntax-table astl-mode-syntax-table)
  (run-hooks 'astl-mode-hook))





