/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsaa.util.vars;

import com.ibm.wsaa.util.StringUtils;
import com.ibm.wsaa.util.vars.AbstractVar;
import com.ibm.wsaa.util.vars.VarException;
import com.ibm.wsaa.util.vars.VarTracker;
import java.util.Map;
import java.util.Set;

public class GenericMapVar
extends AbstractVar {
    protected Map map;
    protected Object defaultVal;
    protected boolean preserveUnknownVars;

    public GenericMapVar(Map map, boolean bl) {
        this.map = map;
        this.defaultVal = null;
        this.preserveUnknownVars = bl;
    }

    public GenericMapVar(Map map, Object object) {
        this.map = map;
        this.defaultVal = object;
        this.preserveUnknownVars = false;
    }

    public GenericMapVar(Map map) {
        this(map, false);
    }

    public String resolve(String string, String[] stringArray, VarTracker varTracker) throws VarException {
        if (stringArray.length < 1 || stringArray.length > 2) {
            throw new VarException(string, stringArray, "Invalid number of arguments.  Must be 1-2.");
        }
        String string2 = stringArray[0];
        Object v = this.map.get(string2);
        if (v == null) {
            if (varTracker != null) {
                varTracker.notifyVarNotFound(string2);
            }
            if (stringArray.length > 1) {
                return stringArray[1];
            }
            if (this.preserveUnknownVars) {
                return "$" + string + "{" + StringUtils.join(stringArray, ",") + "}";
            }
            if (this.defaultVal != null) {
                return this.defaultVal.toString();
            }
            return "null";
        }
        if (varTracker != null) {
            varTracker.notifyVarUsed(string2);
        }
        if (v instanceof Object[]) {
            return StringUtils.join((Object[])v, ',', true);
        }
        return v.toString();
    }

    public Set getKeys() throws Exception {
        return this.map.keySet();
    }
}

