/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.dbutil;

import com.ibm.dmh.db.DbAdmin;
import com.ibm.dmh.db.DbInfo;
import com.ibm.dmh.db.DbMetaData;
import com.ibm.dmh.dbutil.SchemaExistsVar;
import com.ibm.dmh.dbutil.tasks.ITask;
import com.ibm.dmh.dbutil.tasks.MigrateEndMessage;
import com.ibm.wsaa.util.ConfigMgr;
import com.ibm.wsaa.util.ConfigRuntimeException;
import com.ibm.wsaa.util.ExpressionSolver;
import com.ibm.wsaa.util.FileContents;
import com.ibm.wsaa.util.LocaleMgr;
import com.ibm.wsaa.util.StringUtils;
import com.ibm.wsaa.util.vars.AbstractVar;
import com.ibm.wsaa.util.vars.MathBoolVar;
import com.ibm.wsaa.util.vars.MathFloatVar;
import com.ibm.wsaa.util.vars.MathIntVar;
import com.ibm.wsaa.util.vars.VarResolver;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Main {
    private static String dbUtilHome;
    public static String[] dbLevels;
    public static String[] migrateFromLevels;
    public static String[] migrateToLevels;
    public static String[] validOSes;
    private static final String DIV1 = "======================================================================";
    private static final String DIV2 = "----------------------------------------------------------------------";
    private static PrintWriter logFileWriter;
    private static VarResolver varResolver;
    private static Map iTaskMap;

    public static void init(String configDir) {
        File f;
        dbUtilHome = System.getProperty("dbUtilHome");
        if (dbUtilHome == null || dbUtilHome.equals("") || !new File(dbUtilHome).isDirectory()) {
            System.err.println("dbUtilHome property is not set to a valid directory:  '" + dbUtilHome + "'.  Aborting...");
            System.exit(2);
        }
        try {
            ConfigMgr.load((String)configDir);
        }
        catch (ConfigRuntimeException e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
        String os = ConfigMgr.get((String)"User.Database.os");
        String tsprefix = ConfigMgr.get((String)"User.ZOS.tsprefix");
        if (os.equalsIgnoreCase("zOS") && tsprefix.length() > 5) {
            System.err.println("User.ZOS.tsprefix value must not exceed 5 characters.  User.ZOS.tsprefix=[" + tsprefix + "].  Please update User.cfg.");
            System.exit(1);
        }
        dbLevels = StringUtils.split((String)ConfigMgr.get((String)"System.dbLevels"), (char)',');
        migrateToLevels = Arrays.asList(dbLevels).subList(1, dbLevels.length).toArray(new String[dbLevels.length - 1]);
        migrateFromLevels = Arrays.asList(dbLevels).subList(0, dbLevels.length - 1).toArray(new String[dbLevels.length - 1]);
        String stagingDir = ConfigMgr.get((String)"User.Utility.stagingDir");
        File stagingDirF = new File(stagingDir);
        if (!stagingDirF.exists() && !stagingDirF.mkdirs()) {
            System.err.println("Could not create staging directory: [" + stagingDir + "].  Cannot proceed.");
            System.exit(1);
        }
        if (!stagingDirF.canRead()) {
            System.err.println("Staging directory is not readable: [" + stagingDir + "].  Cannot proceed.");
            System.exit(1);
        }
        if (!stagingDirF.canWrite()) {
            System.err.println("Staging directory is not writeable: [" + stagingDir + "].  Cannot proceed.");
            System.exit(1);
        }
        if ((f = new File(stagingDir + "/dbutil.log")).exists()) {
            File f2 = new File(stagingDir + "/dbutil.log.2");
            if (f2.exists()) {
                f2.delete();
            }
            f.renameTo(new File(stagingDir + "/dbutil.log.2"));
            f = new File(stagingDir + "/dbutil.log");
        }
        try {
            logFileWriter = new PrintWriter(new FileWriter(f));
        }
        catch (IOException e) {
            System.err.println("User does not have write authority on this directory.  Aborting...");
            System.exit(2);
        }
        Arrays.sort(validOSes);
    }

    private static void initDb(String dbUrl, String user, String pw, String dbDriver) {
        dbUrl = Main.getNotNull(dbUrl, ConfigMgr.get((String)"User.Database.url"));
        user = Main.getNotNull(user, ConfigMgr.get((String)"User.Database.user"));
        pw = Main.getNotNull(pw, ConfigMgr.get((String)"User.Database.pw"));
        dbDriver = Main.getNotNull(dbDriver, ConfigMgr.get((String)"User.Database.driver"));
        try {
            DbAdmin.init(dbUrl, user, pw, dbDriver);
        }
        catch (ClassNotFoundException e) {
            Main.logException(e);
            Main.exit(2, "Database driver not located in classpath.", false);
        }
        catch (SQLException e) {
            Main.logException(e);
            Main.exit(2, "Problem occurred while trying to access database.", false);
        }
    }

    public static void printUsageAndExit(String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println();
        System.err.println("---Usage---");
        System.err.println("---------------------------------------------------------------------------");
        System.err.println("dbutil -createMigratePlan {" + StringUtils.join((Object[])migrateToLevels, (String)"|") + "} {optional-args}");
        System.err.println("Create a database migration plan for the database defined in User.cfg.");
        System.err.println("The specified version is the targeted database version.");
        System.err.println();
        System.err.println("Optional arguments are as follows...");
        System.err.println("\t-configDir ? - The location of the /config directory.  Use if running");
        System.err.println("\t    from a read-only directory.");
        System.err.println();
        System.err.println("---------------------------------------------------------------------------");
        System.err.println("dbutil -runMigratePlan {optional-run-steps} {optional-args}");
        System.err.println("Runs a database migration plan created by the previous command against the");
        System.err.println("database defined in User.cfg.");
        System.err.println("");
        System.err.println("Examples:");
        System.err.println("Run all steps in all migration plans:");
        System.err.println("\tdbutil -runMigratePlan");
        System.err.println("Run steps v311.1 through v311.100:");
        System.err.println("\tdbutil -runMigratePlan v311.1-v311.100");
        System.err.println("Run all steps from v311.1 to v411.100:");
        System.err.println("\tdbutil -runMigratePlan v311.1-v411.100");
        System.err.println("Run all steps up to and including v311.100:");
        System.err.println("\tdbutil -runMigratePlan -v311.100");
        System.err.println("Run all steps including and after v311.100:");
        System.err.println("\tdbutil -runMigratePlan v311.100-");
        System.err.println("Run step v311.100 only:");
        System.err.println("\tdbutil -runMigratePlan v311.100");
        System.err.println();
        System.err.println("Optional arguments are as follows...");
        System.err.println("\t-configDir ? - The location of the /config directory.  Use if running");
        System.err.println("\t    from a read-only directory.");
        System.err.println();
        System.err.println("---------------------------------------------------------------------------");
        System.err.println("dbutil -verifySchema {" + StringUtils.join((Object[])dbLevels, (String)"|") + "} {optional-args}");
        System.err.println("Verifies that the database defined in User.cfg is at the specified version.");
        System.err.println("Displays a list of all differences in tables, indexes, columns, and ");
        System.err.println("\ttriggers.");
        System.err.println("Optional arguments are as follows (all default to values in User.cfg)...");
        System.err.println("\t-configDir ? - The location of the /config directory.  Use if running");
        System.err.println("\t    from a read-only directory.");
        System.err.println("\t-dbUrl ? - The database URL.");
        System.err.println("\t-user ? - The database userid.");
        System.err.println("\t-pw ? - The database password.");
        System.err.println("\t-os {" + StringUtils.join((Object[])validOSes, (String)"|") + "} - The operating system on ");
        System.err.println("\t\twhich the database resides.");
        System.err.println("\t-isDistEnabled {true|false} - Whether the database is supposed to ");
        System.err.println("\t\tcontain distributed tables.");
        System.err.println("\t-tSchema ? - The table schema name used.");
        System.err.println("\t-dbDriver ? - The database driver class name.");
        System.err.println();
        System.err.println("---------------------------------------------------------------------------");
        System.err.println("dbutil -getInfo {optional-args}");
        System.err.println("Returns the version, os, and whether dist tables are enabled on a database.");
        System.err.println("Optional arguments are as follows (all default to values in User.cfg)...");
        System.err.println("\t-configDir ? - The location of the /config directory.  Use if running");
        System.err.println("\t    from a read-only directory.");
        System.err.println("\t-dbUrl ? - The database URL.");
        System.err.println("\t-user ? - The database userid.");
        System.err.println("\t-pw ? - The database password.");
        System.err.println("\t-tSchema ? - The table schema name used.");
        System.err.println("\t-dbDriver ? - The database driver class name.");
        System.err.println();
        Main.exit(1, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void promptToExit(String msg, boolean rollBackOnExit) {
        System.out.print(msg + "  Continue" + (rollBackOnExit ? " (Rollback occurs if 'N')" : "") + "? {Y/N}  ");
        InputStreamReader isr = new InputStreamReader(System.in);
        try {
            while (true) {
                char c;
                if ((c = Character.toUpperCase((char)isr.read())) == 'N') {
                    try {
                        if (rollBackOnExit) {
                            DbAdmin.getConnection().rollback();
                        }
                    }
                    catch (Exception e) {
                        Main.logException(e);
                    }
                    Main.exit(1, null, rollBackOnExit);
                } else if (c == 'Y') {
                    while (isr.ready()) {
                        isr.read();
                    }
                    return;
                }
                continue;
                break;
            }
        }
        catch (Exception e) {
            Main.exit(2, e.getMessage(), true);
            return;
        }
        finally {
            try {
                isr.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char prompt(String msg, char[] opts) {
        Arrays.sort(opts);
        System.out.print(msg);
        InputStreamReader isr = new InputStreamReader(System.in);
        try {
            while (true) {
                char c;
                if (Arrays.binarySearch(opts, c = Character.toUpperCase((char)isr.read())) >= 0) {
                    while (true) {
                        if (!isr.ready()) {
                            char c2 = c;
                            return c2;
                        }
                        isr.read();
                    }
                }
                continue;
                break;
            }
        }
        catch (Exception e) {
            Main.exit(2, e.getMessage(), true);
            return 'x';
        }
        finally {
            try {
                isr.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String prompt(String msg, String[] optStrings) {
        Main.logln(msg);
        char[] opts = new char[optStrings.length];
        for (int i = 0; i < optStrings.length; ++i) {
            Main.logln("{" + (i + 1) + "} - " + optStrings[i]);
            opts[i] = (char)(49 + i);
        }
        InputStreamReader isr = new InputStreamReader(System.in);
        try {
            while (true) {
                char c;
                if (Arrays.binarySearch(opts, c = (char)isr.read()) >= 0) {
                    while (true) {
                        if (!isr.ready()) {
                            String string = optStrings[c - 49];
                            return string;
                        }
                        isr.read();
                    }
                }
                continue;
                break;
            }
        }
        catch (Exception e) {
            Main.exit(2, e.getMessage(), true);
            return "";
        }
        finally {
            try {
                isr.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.out.println("JVM version detected: [" + System.getProperty("java.version") + "]");
        String[] cv = Main.split(System.getProperty("java.version"), '.');
        if (Integer.parseInt(cv[1]) < 4) {
            System.err.println("This utility requires JRE 1.4 or above.");
            System.exit(1);
        }
        String configDir = "./config";
        LinkedList<String> otherArgs = new LinkedList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-configDir") && args.length > i + 1) {
                configDir = args[i + 1];
                ++i;
                continue;
            }
            otherArgs.add(args[i]);
        }
        args = otherArgs.toArray(new String[otherArgs.size()]);
        File f = new File(configDir);
        if (!f.exists()) {
            System.err.println("Could not locate config directory:  [" + configDir + "]");
            System.exit(1);
        }
        if (!f.canRead()) {
            System.err.println("Config directory is not readable:  [" + configDir + "]");
            System.exit(1);
        }
        Main.init(configDir);
        if (args.length == 0) {
            Main.printUsageAndExit("No arguments specified.");
        }
        if (args[0].equalsIgnoreCase("-createMigratePlan") && args.length == 2) {
            Main.initDb(null, null, null, null);
            String targetVersion = args[1];
            int r = Main.createMigratePlan(targetVersion);
            switch (r) {
                case 0: {
                    Main.logln("Finished without errors.");
                    break;
                }
                case 1: {
                    Main.logln("Aborted by user.");
                    break;
                }
                default: {
                    Main.logln("Errors occurred.");
                    break;
                }
            }
        } else if (args[0].equalsIgnoreCase("-runMigratePlan")) {
            Main.initDb(null, null, null, null);
            String runSteps = args.length < 2 ? "" : StringUtils.join((Object[])Arrays.asList(args).subList(1, args.length).toArray(), (String)" ");
            int r = Main.runMigratePlan(runSteps);
            switch (r) {
                case 0: {
                    Main.logln("Finished without errors.");
                    break;
                }
                case 1: {
                    Main.logln("Aborted by user.");
                    break;
                }
                default: {
                    Main.logln("Errors occurred.");
                    break;
                }
            }
        } else if (args[0].equalsIgnoreCase("-verifySchema") && args.length >= 2) {
            Map argMap = Main.getArgMap(args, 2, new String[]{"dbUrl", "user", "pw", "os", "isDistEnabled", "tSchema", "dbDriver"});
            String targetVersion = args[1];
            String dbUrl = Main.getNotNull((String)argMap.get("dbUrl"), ConfigMgr.get((String)"User.Database.url"));
            String user = Main.getNotNull((String)argMap.get("user"), ConfigMgr.get((String)"User.Database.user"));
            String pw = Main.getNotNull((String)argMap.get("pw"), ConfigMgr.get((String)"User.Database.pw"));
            String os = Main.getNotNull((String)argMap.get("os"), ConfigMgr.get((String)"User.Database.os"));
            String isDistEnabled = Main.getNotNull((String)argMap.get("isDistEnabled"), ConfigMgr.get((String)"User.Database.isDistEnabled"));
            String tSchema = Main.getNotNull((String)argMap.get("tSchema"), ConfigMgr.get((String)"User.Database.tSchema"));
            String dbDriver = Main.getNotNull((String)argMap.get("dbDriver"), ConfigMgr.get((String)"User.Database.driver"));
            if (Arrays.binarySearch(dbLevels, targetVersion) < 0) {
                Main.exit(2, "Invalid database level specified.  Run dbutil without arguments for usage.", false);
            }
            Main.logln("Verifying database with the following properties: ");
            Main.logln("\ttargetVersion = '" + targetVersion + "'");
            Main.logln("\tdbUrl = '" + dbUrl + "'");
            Main.logln("\tuser = '" + user + "'");
            Main.logln("\tpw = '" + pw + "'");
            Main.logln("\tos = '" + os + "'");
            Main.logln("\tisDistEnabled = '" + isDistEnabled + "'");
            Main.logln("\ttSchema = '" + tSchema + "'");
            Main.logln("\tdbDriver = '" + dbDriver + "'");
            if (Arrays.binarySearch(validOSes, os) < 0) {
                Main.exit(1, "Invalid OS specified:  '" + os + "'.", false);
            }
            Main.initDb(dbUrl, user, pw, dbDriver);
            int r = Main.verifySchema(targetVersion, os, tSchema, isDistEnabled.toLowerCase().startsWith("t"));
            switch (r) {
                case 0: {
                    Main.logln("Finished without errors.");
                    break;
                }
                case 1: {
                    Main.logln("Aborted by user.");
                    break;
                }
                default: {
                    Main.logln("Errors occurred.");
                    break;
                }
            }
        } else if (args[0].equalsIgnoreCase("-generateVerifyFile")) {
            Map argMap = Main.getArgMap(args, 1, new String[]{"desc", "path", "dbUrl", "user", "pw", "tSchema", "dbDriver"});
            String desc = (String)argMap.get("desc");
            String path = (String)argMap.get("path");
            String dbUrl = Main.getNotNull((String)argMap.get("dbUrl"), ConfigMgr.get((String)"User.Database.url"));
            String user = Main.getNotNull((String)argMap.get("user"), ConfigMgr.get((String)"User.Database.user"));
            String pw = Main.getNotNull((String)argMap.get("pw"), ConfigMgr.get((String)"User.Database.pw"));
            String tSchema = Main.getNotNull((String)argMap.get("tSchema"), ConfigMgr.get((String)"User.Database.tSchema"));
            String dbDriver = Main.getNotNull((String)argMap.get("dbDriver"), ConfigMgr.get((String)"User.Database.driver"));
            Main.logln("Creating verify file with the following properties: ");
            Main.logln("\tdesc = '" + desc + "'");
            Main.logln("\tpath = '" + path + "'");
            Main.logln("\tdbUrl = '" + dbUrl + "'");
            Main.logln("\tuser = '" + user + "'");
            Main.logln("\tpw = '" + pw + "'");
            Main.logln("\ttSchema = '" + tSchema + "'");
            Main.logln("\tdbDriver = '" + dbDriver + "'");
            Main.initDb(dbUrl, user, pw, dbDriver);
            int r = Main.generateVerifyFile(desc, path, tSchema);
            switch (r) {
                case 0: {
                    Main.logln("Finished without errors.");
                    break;
                }
                case 1: {
                    Main.logln("Aborted by user.");
                    break;
                }
                default: {
                    Main.logln("Errors occurred.");
                }
            }
            Main.logln(r == 0 ? "Finished without errors." : "Errors occurred");
        } else if (args[0].equalsIgnoreCase("-getInfo")) {
            Map argMap = Main.getArgMap(args, 1, new String[]{"dbUrl", "user", "pw", "tSchema", "dbDriver"});
            String dbUrl = Main.getNotNull((String)argMap.get("dbUrl"), ConfigMgr.get((String)"User.Database.url"));
            String user = Main.getNotNull((String)argMap.get("user"), ConfigMgr.get((String)"User.Database.user"));
            String pw = Main.getNotNull((String)argMap.get("pw"), ConfigMgr.get((String)"User.Database.pw"));
            String tSchema = Main.getNotNull((String)argMap.get("tSchema"), ConfigMgr.get((String)"User.Database.tSchema"));
            String dbDriver = Main.getNotNull((String)argMap.get("dbDriver"), ConfigMgr.get((String)"User.Database.driver"));
            Main.initDb(dbUrl, user, pw, dbDriver);
            Connection c = null;
            try {
                c = DbAdmin.getConnection();
                DbInfo dbi = new DbInfo(c, tSchema);
                Main.logln("Url:  " + dbUrl);
                Main.logln("Version:  " + dbi.version);
                Main.logln("OS:  " + dbi.os);
                Main.logln("Dist-enabled:  " + dbi.isDistEnabled);
            }
            catch (Exception e) {
                Main.logException(e);
            }
            finally {
                DbAdmin.close(c);
            }
        } else {
            Main.exit(2, "Command not recognized.", false);
        }
        Main.exit(0, null, false);
    }

    public static void exit(int returnCode, String msg, boolean rollbackConnection) {
        if (msg != null) {
            Main.logln(msg);
        }
        Connection c = DbAdmin.getConnection();
        try {
            if (logFileWriter != null) {
                logFileWriter.flush();
                logFileWriter.close();
            }
            if (c != null) {
                if (rollbackConnection) {
                    c.rollback();
                } else {
                    c.commit();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        DbAdmin.close(c);
        System.exit(returnCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int generateVerifyFile(String desc, String path, String tSchema) {
        Connection c = null;
        try {
            c = DbAdmin.getConnection();
            DbMetaData dmd = new DbMetaData(c, tSchema, desc);
            c.commit();
            c.close();
            File outFile = new File(path);
            dmd.saveToFile(outFile);
        }
        catch (Exception e) {
            Main.logException(e);
            int n = 2;
            return n;
        }
        finally {
            DbAdmin.close(c);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int verifySchema(String targetVersion, String os, String tSchema, boolean isDistEnabled) {
        Connection c = null;
        try {
            File compFile = new File(dbUtilHome + "/verify/" + targetVersion + "/Verify_" + (os.equalsIgnoreCase("zOS") ? "zOS" : "UDB") + "_" + (isDistEnabled ? "wDist" : "woDist") + ".xml");
            if (!compFile.exists()) {
                Main.logln("Could not locate verification file:  '" + compFile.toString() + "'");
                int n = 2;
                DbAdmin.close(c);
                return n;
            }
            c = DbAdmin.getConnection();
            DbMetaData dmd = new DbMetaData(c, tSchema, "n/a");
            c.commit();
            c.close();
            DbMetaData dmd2 = new DbMetaData(compFile, tSchema);
            String[] diffs = dmd.compareTo(dmd2);
            Main.logln("Baseline comparison showed " + diffs.length + " differences.");
            for (int i = 0; i < diffs.length; ++i) {
                Main.logln(i + 1 + ": " + diffs[i]);
            }
            DbAdmin.close(c);
        }
        catch (Exception e) {
            Main.logException(e);
            int n = 2;
            return n;
        }
        finally {
            DbAdmin.close(c);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int createMigratePlan(String targetVersion) {
        File migratePlanDir = new File(ConfigMgr.get((String)"User.Utility.stagingDir") + "/migrate_plan");
        Connection c = null;
        String startVersion = null;
        if (Arrays.binarySearch(migrateToLevels, targetVersion) < 0) {
            Main.logln("Invalid target version specified:  '" + targetVersion + "'.");
            Main.logln("Valid target versions are:  " + StringUtils.join((Object[])migrateToLevels, (String)",") + ".");
            return 2;
        }
        try {
            c = DbAdmin.getConnection();
            DbInfo dbInfo = new DbInfo(c, ConfigMgr.get((String)"User.Database.tSchema"));
            Main.logln("");
            Main.logln("Database information detected...");
            Main.logln("Version:  " + dbInfo.version);
            Main.logln("OS:  " + dbInfo.os);
            Main.logln("Dist-enabled:  " + dbInfo.isDistEnabled);
            Main.logln("");
            if (dbInfo.version < 310) {
                char ch = Main.prompt("Database appears to be at pre-v310 level.  Migration only supported for v310+.  Proceed with migration? {Y/N}", new char[]{'Y', 'N'});
                if (ch == 'Y') {
                    dbInfo.version = 0;
                } else {
                    int n = 1;
                    return n;
                }
            }
            if (dbInfo.version == 0) {
                Main.logln("\nUnable to determine the current schema version of the database.");
                startVersion = Main.prompt("Please select from the following list of possible versions...", migrateFromLevels);
            } else {
                Main.logln("Database version appears to be at level v" + dbInfo.version + ".");
                startVersion = "v" + dbInfo.version;
            }
            if (migratePlanDir.exists()) {
                int i;
                File[] oldFiles = migratePlanDir.listFiles();
                for (i = 0; i < oldFiles.length; ++i) {
                    oldFiles[i].delete();
                }
                if (!migratePlanDir.delete()) {
                    Main.logln("Could not delete the directory '" + migratePlanDir.getAbsolutePath() + "'.");
                    i = 2;
                    return i;
                }
            }
            migratePlanDir.mkdir();
            int startIndex = Arrays.binarySearch(dbLevels, startVersion);
            int targetIndex = Arrays.binarySearch(dbLevels, targetVersion);
            if (startIndex < 0 || targetIndex < 0) {
                Main.logln("Internal error occurred:  startIndex='" + startIndex + "', targetIndex='" + targetIndex + "'");
                int n = 2;
                return n;
            }
            if (targetIndex <= startIndex) {
                Main.logln("Target version '" + targetVersion + "' is less than or equal to the current database version '" + startVersion + "'.");
                Main.logln("No plan created.");
                int n = 0;
                return n;
            }
            Main.logln("\n----------------------------------------------------------------------\n Verifying current schema of database as 'v" + dbInfo.version + "'\n" + DIV2);
            int r = Main.verifyDbAtLevel("v" + dbInfo.version);
            if (r == 1) {
                Main.logln("These differences could indicate custom changes made to the database.");
                Main.logln("These differences should be investigated before proceeding with the migration plan.");
                Main.promptToExit("Proceed with migration plan?", false);
            } else if (r == 2) {
                Main.promptToExit("Proceed with migration plan?", false);
            }
            Main.logln("\n----------------------------------------------------------------------\n Creating migration plan from current version '" + startVersion + "' to target version '" + targetVersion + "'.\n" + DIV2);
            for (int i = startIndex + 1; i <= targetIndex; ++i) {
                String v = dbLevels[i];
                Main.logln("Creating migration plan for version '" + v + "'");
                int x = Main.createPlanFile(dbUtilHome + "/migrate", ConfigMgr.get((String)"User.Utility.stagingDir") + "/migrate_plan", v);
                if (x == 0) continue;
                int n = x;
                return n;
            }
        }
        catch (Exception e) {
            Main.logException(e);
            Main.exit(2, null, true);
        }
        finally {
            DbAdmin.close(c);
        }
        return 0;
    }

    private static int createPlanFile(String migrateDir, String planDir, String version) {
        String migrateFilePath = migrateDir + "/" + version + "/Migrate.xml";
        String testSuiteFilePath = migrateDir + "/" + version + "/TestSuite.xml";
        String planFilePath = planDir + File.separator + "Migrate_" + version + ".xml";
        if (!new File(migrateFilePath).exists()) {
            throw new RuntimeException("Could not locate file '" + migrateFilePath + "'");
        }
        boolean runTestSuites = ConfigMgr.getBoolean((String)"System.runTestSuites") && new File(testSuiteFilePath).exists();
        try {
            HashMap<String, String> m;
            int i;
            FileContents fc = new FileContents();
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            ArrayList taskAttrList = new ArrayList();
            ArrayList<String> taskBodyList = new ArrayList<String>();
            LinkedList tcSetupAttrList = new LinkedList();
            LinkedList<String> tcSetupBodyList = new LinkedList<String>();
            LinkedList tcTestAttrList = new LinkedList();
            LinkedList<String> tcTestBodyList = new LinkedList<String>();
            LinkedList tcCleanupAttrList = new LinkedList();
            LinkedList<String> tcCleanupBodyList = new LinkedList<String>();
            if (runTestSuites) {
                fc = Main.getResolvedXmlFileContents(testSuiteFilePath);
                Element testSuiteRoot = builder.parse(new InputSource(new StringReader(fc.getContents()))).getDocumentElement();
                NodeList testCaseList = testSuiteRoot.getElementsByTagName("TestCase");
                for (i = 0; i < testCaseList.getLength(); ++i) {
                    int j;
                    boolean ifBool;
                    Element testCaseElement = (Element)testCaseList.item(i);
                    String ifAttr = testCaseElement.getAttribute("if");
                    ifAttr = StringUtils.replace((String)ifAttr, (String)"AND", (String)"&&");
                    ifAttr = StringUtils.replace((String)ifAttr, (String)"OR", (String)"||");
                    boolean bl = ifBool = (ifAttr = varResolver.resolveString(ifAttr)).equals("") ? true : ExpressionSolver.solveBoolean((String)ifAttr);
                    if (!ifBool) continue;
                    NodeList nl = testCaseElement.getElementsByTagName("setup");
                    for (j = 0; j < nl.getLength(); ++j) {
                        m = new HashMap();
                        m.put("class", "Sql");
                        m.put("autocommit", "true");
                        m.put("desc", "TestCase Setup: " + testCaseElement.getAttribute("desc") + " [" + (j + 1) + " of " + nl.getLength() + "]");
                        tcSetupAttrList.add(m);
                        tcSetupBodyList.add(Main.getElementBody((Element)nl.item(j)));
                    }
                    nl = testCaseElement.getElementsByTagName("test");
                    for (j = 0; j < nl.getLength(); ++j) {
                        m = new HashMap();
                        m.put("class", "SqlValidate");
                        m.put("autocommit", "true");
                        m.put("desc", "TestCase Test: " + testCaseElement.getAttribute("desc") + " [" + (j + 1) + " of " + nl.getLength() + "]");
                        tcTestAttrList.add(m);
                        tcTestBodyList.add(Main.getElementBody((Element)nl.item(j)));
                    }
                    nl = testCaseElement.getElementsByTagName("cleanup");
                    for (j = 0; j < nl.getLength(); ++j) {
                        m = new HashMap();
                        m.put("class", "Sql");
                        m.put("autocommit", "true");
                        m.put("desc", "TestCase Cleanup: " + testCaseElement.getAttribute("desc") + " [" + (j + 1) + " of " + nl.getLength() + "]");
                        tcCleanupAttrList.add(m);
                        tcCleanupBodyList.add(Main.getElementBody((Element)nl.item(j)));
                    }
                }
            }
            fc = Main.getResolvedXmlFileContents(migrateFilePath);
            Element rootElement = builder.parse(new InputSource(new StringReader(fc.getContents()))).getDocumentElement();
            NodeList taskList = rootElement.getElementsByTagName("Task");
            for (i = 0; i < taskList.getLength(); ++i) {
                boolean ifBool;
                Element task = (Element)taskList.item(i);
                String taskBody = "";
                NodeList nl = task.getChildNodes();
                if (nl.getLength() > 0) {
                    taskBody = nl.item(0).getNodeValue();
                }
                String ifAttr = task.getAttribute("if");
                ifAttr = StringUtils.replace((String)ifAttr, (String)"AND", (String)"&&");
                ifAttr = StringUtils.replace((String)ifAttr, (String)"OR", (String)"||");
                boolean bl = ifBool = (ifAttr = varResolver.resolveString(ifAttr)).equals("") ? true : ExpressionSolver.solveBoolean((String)ifAttr);
                if (!ifBool) continue;
                m = new HashMap<String, String>();
                NamedNodeMap nnm = task.getAttributes();
                for (int j = 0; j < nnm.getLength(); ++j) {
                    Node n = nnm.item(j);
                    String attrName = n.getNodeName();
                    String attrVal = n.getNodeValue();
                    if (attrName.equalsIgnoreCase("if")) continue;
                    m.put(attrName, attrVal);
                }
                taskAttrList.add(m);
                ITask iTask = Main.getITask(task.getAttribute("class"));
                if (iTask == null) {
                    Main.logln("Could not locate task implementation class: '" + task.getAttribute("class") + "'");
                    continue;
                }
                taskBodyList.add(iTask.getPlanTaskBody(taskBody, task.getAttributes()));
            }
            String s = fc.getContents();
            StringBuffer sb = new StringBuffer(s.length());
            int i1 = s.indexOf("<Task ");
            sb.append(s.substring(0, i1));
            LinkedList allAttrs = new LinkedList();
            allAttrs.addAll(tcSetupAttrList);
            allAttrs.addAll(taskAttrList);
            allAttrs.addAll(tcTestAttrList);
            allAttrs.addAll(tcCleanupAttrList);
            LinkedList<String> allBodies = new LinkedList<String>();
            allBodies.addAll(tcSetupBodyList);
            allBodies.addAll(taskBodyList);
            allBodies.addAll(tcTestBodyList);
            allBodies.addAll(tcCleanupBodyList);
            Map[] taskAttrs = allAttrs.toArray(new Map[0]);
            String[] taskBodies = allBodies.toArray(new String[0]);
            for (int i2 = 0; i2 < taskAttrs.length; ++i2) {
                String className = (String)taskAttrs[i2].get("class");
                String desc = (String)taskAttrs[i2].get("desc");
                String autoCommit = (String)taskAttrs[i2].get("autocommit");
                String level = (String)taskAttrs[i2].get("level");
                String outputfile = (String)taskAttrs[i2].get("outputfile");
                String includeheader = (String)taskAttrs[i2].get("includeheader");
                sb.append("\n\n    <Task step='" + version + "." + (i2 + 1) + "' " + "class='" + className + "' " + (level == null ? "" : "level='" + level + "' ") + "desc='" + desc + "' " + (autoCommit == null ? "" : "autocommit='" + autoCommit + "' ") + (outputfile == null ? "" : "outputfile='" + outputfile + "' ") + (includeheader == null ? "" : "includeheader='" + includeheader + "' ") + ">");
                sb.append(Main.fixXML(taskBodies[i2]));
                sb.append("\n    </Task>");
            }
            sb.append("\n\n</TaskSequence>");
            fc.setContents(sb);
            fc.saveFile(planFilePath, LocaleMgr.getExternalDefaultEncoding());
        }
        catch (Exception e) {
            Main.logException(e);
            Main.logln("Error occurred while trying to create verification file for '" + planFilePath + "'");
            Main.logln(e.getMessage());
            return 2;
        }
        return 0;
    }

    private static ITask getITask(String className) {
        if (iTaskMap.get(className) == null) {
            try {
                Class<?> c = Class.forName("com.ibm.dmh.dbutil.tasks." + className);
                iTaskMap.put(className, c.newInstance());
            }
            catch (Exception e) {
                Main.logException(e);
            }
        }
        return (ITask)iTaskMap.get(className);
    }

    private static String fixXML(String s) {
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        return s;
    }

    private static int runMigratePlan(String runSteps) {
        FileContents fc = new FileContents();
        SimpleDateFormat sdf = new SimpleDateFormat("hh:mm:ss a");
        File migratePlanDir = new File(ConfigMgr.get((String)"User.Utility.stagingDir") + "/migrate_plan");
        if (!migratePlanDir.exists() || migratePlanDir.listFiles().length == 0) {
            Main.logln("ERROR:  Directory '" + ConfigMgr.get((String)"User.Utility.stagingDir") + "/migrate_plan' was not found. ");
            Main.logln("You must run 'dbUtil -createMigratePlan' before using the '-runMigratePlan' option.");
            return 2;
        }
        Object[] planFiles = migratePlanDir.listFiles();
        Arrays.sort(planFiles);
        String startStep = "";
        String endStep = "";
        if (runSteps != null && !runSteps.equals("")) {
            String[] s = StringUtils.split((String)runSteps, (char)'-');
            startStep = s[0].trim();
            endStep = (s.length > 1 ? s[1] : s[0]).trim();
            boolean isBad = false;
            Main.logln("startStep='" + startStep + "', endStep='" + endStep + "', ");
            if (!(startStep.equals("") || startStep.matches("v\\d+\\.\\d+") && new File(migratePlanDir + "/Migrate_" + startStep.substring(0, startStep.indexOf(46)) + ".xml").exists())) {
                isBad = true;
            }
            if (!(endStep.equals("") || endStep.matches("v\\d+\\.\\d+") && new File(migratePlanDir + "/Migrate_" + endStep.substring(0, endStep.indexOf(46)) + ".xml").exists())) {
                isBad = true;
            }
            if (isBad) {
                Main.logln("Invalid steps specified.  Start and stop steps must be of the format v###.#.");
                return 2;
            }
        }
        try {
            for (int i = 0; i < planFiles.length; ++i) {
                Object planFile = planFiles[i];
                fc.readFile(((File)planFile).getAbsolutePath(), LocaleMgr.getExternalDefaultEncoding());
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Element rootElement = builder.parse(new InputSource(new StringReader(fc.getContents()))).getDocumentElement();
                String version = rootElement.getAttribute("version");
                if (!Main.fileIsInRunSteps(version, startStep, endStep)) {
                    Main.logln("Skipping plan file '" + ((File)planFile).getAbsolutePath() + "'.");
                    continue;
                }
                Main.logln("\n======================================================================\n Running plan file '" + ((File)planFile).getAbsolutePath() + "'\n" + DIV1);
                String fileVersion = rootElement.getAttribute("version");
                NodeList taskList = rootElement.getElementsByTagName("Task");
                boolean lastStepWasSkipped = false;
                for (int j = 0; j < taskList.getLength(); ++j) {
                    int r;
                    String nextStepName;
                    String step;
                    Element task = (Element)taskList.item(j);
                    String taskBody = "";
                    NodeList nl = task.getChildNodes();
                    if (nl.getLength() > 0) {
                        taskBody = nl.item(0).getNodeValue();
                    }
                    if (!Main.stepIsInRunSteps(step = task.getAttribute("step"), startStep, endStep)) {
                        Main.logln("Skipping step '" + step + "'");
                        lastStepWasSkipped = true;
                        continue;
                    }
                    Main.logln("\n----------------------------------------------------------------------\n '" + step + "' - " + sdf.format(new Date()) + " \n " + task.getAttribute("desc") + "\n" + DIV2);
                    ITask iTask = Main.getITask(task.getAttribute("class"));
                    if (iTask == null) {
                        Main.logln("Could not locate task implementation class: '" + task.getAttribute("class") + "'");
                        return 2;
                    }
                    String stepName = task.getAttribute("step");
                    String string = nextStepName = taskList.getLength() == j + 1 ? null : ((Element)taskList.item(j + 1)).getAttribute("step");
                    if (nextStepName == null && i + 1 != planFiles.length) {
                        nextStepName = ((File)planFiles[i + 1]).getName().substring(8, 12) + ".1";
                    }
                    if ((r = iTask.run(taskBody, task.getAttributes(), stepName, nextStepName)) != 0) {
                        Main.promptToExit("Last task failed.", false);
                    }
                    lastStepWasSkipped = false;
                }
                if (lastStepWasSkipped) continue;
                Main.logln("\n----------------------------------------------------------------------\n Verifying current schema of database as '" + fileVersion + "'\n" + DIV2);
                int r = Main.verifyDbAtLevel(fileVersion);
                if (r == 1) {
                    Main.logln("These differences could indicate that a problem occurred.");
                    Main.logln("These differences should be investigated before proceeding with the migration.");
                    Main.promptToExit("Proceed with migration?", false);
                    continue;
                }
                if (r != 2) continue;
                Main.promptToExit("Proceed with migration?", false);
            }
        }
        catch (Exception e) {
            Main.logException(e);
            return 2;
        }
        Iterator i = MigrateEndMessage.messages.iterator();
        while (i.hasNext()) {
            Main.logln(i.next().toString());
        }
        return 0;
    }

    public static int verifyDbAtLevel(String level) {
        String os = ConfigMgr.get((String)"User.Database.os");
        boolean isDistEnabled = ConfigMgr.getBoolean((String)"User.Database.isDistEnabled");
        String tSchema = ConfigMgr.get((String)"User.Database.tSchema");
        File f = new File(dbUtilHome + "/verify/" + level + "/Verify_" + (os.equalsIgnoreCase("zOS") ? "zOS" : "UDB") + "_" + (isDistEnabled ? "wDist" : "woDist") + ".xml");
        if (!f.exists()) {
            Main.logln("WARNING:  Unable to verify current version of database.  Could not find verify file '" + f.getAbsolutePath() + "'.");
            return 2;
        }
        try {
            DbMetaData dmd = new DbMetaData(DbAdmin.getConnection(), ConfigMgr.get((String)"User.Database.tSchema"), "n/a");
            DbMetaData verifyDbMetaData = new DbMetaData(f, tSchema);
            String[] diffs = dmd.compareTo(verifyDbMetaData);
            if (diffs.length == 0) {
                Main.logln("Current database version verified.");
                return 0;
            }
            Main.logln("Comparison of current database schema with expected schema at this particular level showed " + diffs.length + " differences.");
            for (int i = 0; i < diffs.length; ++i) {
                Main.logln(i + 1 + ": " + diffs[i]);
            }
            return 1;
        }
        catch (Exception e) {
            Main.logException(e);
            return 2;
        }
    }

    private static boolean fileIsInRunSteps(String version, String startStep, String endStep) {
        int v = Integer.parseInt(version.substring(1));
        int ss = startStep.equals("") ? 0 : Integer.parseInt(startStep.substring(1, startStep.indexOf(46)));
        int es = endStep.equals("") ? 9999 : Integer.parseInt(endStep.substring(1, endStep.indexOf(46)));
        return v >= ss && v <= es;
    }

    private static boolean stepIsInRunSteps(String step, String startStep, String endStep) {
        int stepVer = Integer.parseInt(step.substring(1, step.indexOf(46)));
        int startVer = startStep.equals("") ? 0 : Integer.parseInt(startStep.substring(1, startStep.indexOf(46)));
        int endVer = endStep.equals("") ? 9999 : Integer.parseInt(endStep.substring(1, endStep.indexOf(46)));
        int stepNum = Integer.parseInt(step.substring(step.indexOf(46) + 1));
        int startNum = startStep.equals("") ? 0 : Integer.parseInt(startStep.substring(startStep.indexOf(46) + 1));
        int endNum = endStep.equals("") ? 99999 : Integer.parseInt(endStep.substring(endStep.indexOf(46) + 1));
        return (stepVer > startVer || stepVer == startVer && stepNum >= startNum) && (stepVer < endVer || stepVer == endVer && stepNum <= endNum);
    }

    private static Map getArgMap(String[] args, int startIndex, String[] validArgs) {
        String s = StringUtils.join((Object[])Arrays.asList(args).subList(startIndex, args.length).toArray(new String[0]), (String)" ");
        Arrays.sort(validArgs);
        args = StringUtils.splitQuoted((String)s, (char)' ');
        HashMap<String, String> m = new HashMap<String, String>();
        String arg = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                arg = args[i].substring(1);
                if (Arrays.binarySearch(validArgs, arg) < 0) {
                    Main.printUsageAndExit("Invalid parameter specified:  '" + arg + "'");
                }
                m.put(arg, args[++i]);
            }
        }
        catch (IndexOutOfBoundsException e) {
            Main.printUsageAndExit("Value not specified for argument '" + arg + "'");
        }
        return m;
    }

    public static int executeSql(Statement st, String sql, boolean verbose, boolean ignoreWarnings, boolean ignoreErrors) {
        try {
            if (verbose) {
                Main.logln(sql);
            }
            sql = sql.replaceAll("\n", " ");
            st.execute(sql);
            SQLWarning warning = st.getWarnings();
            if (warning != null && !ignoreWarnings && Math.abs(warning.getErrorCode()) != 513) {
                if (!verbose) {
                    Main.logln(sql);
                }
                Main.logln("STATUS:  WARNING (SQL-" + warning.getErrorCode() + ")");
                while (warning != null) {
                    Main.logln("SQL warning message:  " + warning.getLocalizedMessage());
                    warning = warning.getNextWarning();
                }
                Main.logln("");
                Main.promptToExit("Warning occurred while running the last command.", true);
                return 1;
            }
            if (verbose) {
                Main.logln("STATUS:  OK\n");
            }
            return 0;
        }
        catch (Exception e) {
            if (!ignoreErrors) {
                if (!verbose) {
                    Main.logln(sql);
                }
                Main.logln("STATUS:  ERROR");
                Main.logln(e.getMessage());
                Main.promptToExit("Exception occurred while running the last command.", true);
            }
            return 2;
        }
    }

    public static int executeSqlValidate(Statement st, String sql, String expectedResults, boolean verbose, boolean ignoreWarnings, boolean ignoreErrors) {
        ResultSet rs = null;
        try {
            if (verbose) {
                Main.logln("Test query:  " + sql);
            }
            sql = sql.replaceAll("\n", "");
            rs = st.executeQuery(sql);
            SQLWarning warning = st.getWarnings();
            if (warning != null && !ignoreWarnings) {
                if (!verbose) {
                    Main.logln(sql);
                }
                Main.logln("STATUS:  WARNING");
                while (warning != null) {
                    Main.logln(warning.getMessage());
                    warning = warning.getNextWarning();
                }
                Main.logln("");
                Main.promptToExit("Warning occurred while running the last command.", true);
                return 1;
            }
            StringBuffer sb = new StringBuffer();
            int numCols = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                for (int i = 1; i <= numCols; ++i) {
                    sb.append(rs.getString(i).trim() + (i == numCols ? "" : ","));
                }
                sb.append("\n");
            }
            String results = sb.toString().trim();
            if (!expectedResults.equals(results)) {
                Main.logln("TEST FAILED!");
                Main.logln("--- Expected results -------------------------------------------------");
                Main.logln(expectedResults.replace(' ', '~'));
                Main.logln(DIV2);
                Main.logln("--- Actual results ---------------------------------------------------");
                Main.logln(results.replace(' ', '~'));
                Main.logln(DIV2);
                Main.promptToExit("Test failed.", true);
            }
            if (verbose) {
                Main.logln("STATUS:  OK\n");
            }
            return 0;
        }
        catch (Exception e) {
            if (!ignoreErrors) {
                if (!verbose) {
                    Main.logln(sql);
                }
                Main.logln("STATUS:  ERROR");
                Main.logln(e.getMessage());
                Main.promptToExit("Exception occurred while running the last command.", true);
            }
            return 2;
        }
    }

    private static FileContents getResolvedXmlFileContents(String path) throws Exception {
        FileContents fc = new FileContents();
        fc.readFile(path, LocaleMgr.getExternalDefaultEncoding());
        ResourceBundle rb = LocaleMgr.getResourceBundle((String)path, (Locale)LocaleMgr.getLocale((String)ConfigMgr.get((String)"User.Database.locale")));
        if (rb != null) {
            fc.insertVars("L", rb, true, true);
        } else {
            fc.insertVars("L", new Hashtable(), true, true);
        }
        fc.insertVars("C", (Map)ConfigMgr.getAllValues((boolean)true), true, false);
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Element rootElement = builder.parse(new InputSource(new StringReader(fc.getContents()))).getDocumentElement();
        NodeList varsList = rootElement.getElementsByTagName("Vars");
        if (varsList.getLength() > 0) {
            Hashtable<String, String> varTable = new Hashtable<String, String>();
            Element vars = (Element)varsList.item(0);
            NodeList x = vars.getElementsByTagName("Var");
            for (int i = 0; i < x.getLength(); ++i) {
                Element var = (Element)x.item(i);
                String value = var.getAttribute("value");
                String sql = var.getAttribute("sql");
                String defaultVal = var.hasAttribute("default") ? var.getAttribute("default") : null;
                varTable.put(var.getAttribute("name"), value == null || value.equals("") ? Main.runVarSql(sql, defaultVal) : value);
            }
            fc.insertVars("", varTable, true, false);
        }
        VarResolver vr = new VarResolver();
        vr.addVar("MB", (AbstractVar)new MathBoolVar(), null);
        vr.addVar("MF", (AbstractVar)new MathFloatVar(), null);
        vr.addVar("MI", (AbstractVar)new MathIntVar(), null);
        fc.insertVars(vr);
        fc.evaluateCommands();
        return fc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String runVarSql(String sql, String defaultVal) throws Exception {
        String string;
        sql = sql.replaceAll("\\$\\{tSchema\\}", ConfigMgr.get((String)"User.Database.tSchema"));
        Statement st = null;
        ResultSet rs = null;
        try {
            st = DbAdmin.getConnection().createStatement();
            rs = st.executeQuery(sql);
            if (!rs.next()) {
                throw new Exception("Could not execute the following query: [" + sql + "]");
            }
            String s = rs.getString(1);
            if (s == null) {
                throw new Exception("The variable query [" + sql + "] returned null.  It likely needs to be modified to include a value() column function.");
            }
            string = s;
        }
        catch (Exception e) {
            String string2;
            try {
                if (defaultVal == null) {
                    Main.logln("Exception caught trying to run the following query: [" + sql + "]");
                    throw e;
                }
                string2 = defaultVal;
            }
            catch (Throwable throwable) {
                DbAdmin.close(st);
                DbAdmin.close(rs);
                throw throwable;
            }
            DbAdmin.close(st);
            DbAdmin.close(rs);
            return string2;
        }
        DbAdmin.close(st);
        DbAdmin.close(rs);
        return string;
    }

    private static String getElementBody(Element e) {
        NodeList nl = e.getChildNodes();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nl.getLength(); ++i) {
            sb.append(nl.item(i).getNodeValue());
        }
        return sb.toString();
    }

    private static String getNotNull(String arg1, String arg2) {
        return arg1 == null ? arg2 : arg1;
    }

    public static void log(String msg) {
        if (logFileWriter != null) {
            logFileWriter.print(msg);
        }
        System.out.print(msg);
    }

    public static void logln(String msg) {
        if (logFileWriter != null) {
            logFileWriter.println(msg);
            logFileWriter.flush();
        }
        System.out.println(msg);
    }

    public static void logException(Exception e) {
        if (logFileWriter != null) {
            e.printStackTrace(logFileWriter);
        }
        e.printStackTrace(System.out);
    }

    private static String[] split(String s, char c) {
        LinkedList<String> l = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(s, "" + c);
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return l.toArray(new String[l.size()]);
    }

    static {
        validOSes = new String[]{"zOS", "WINDOWS", "AIX"};
        varResolver = new VarResolver();
        varResolver.addVar("SchemaExists", (AbstractVar)new SchemaExistsVar(), null);
        iTaskMap = new HashMap();
    }
}

