/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jjson;

import com.ibm.jjson.JsonMap;
import com.ibm.jjson.JsonParseException;
import com.ibm.jjson.JsonParser;
import com.ibm.jjson.JsonSerializer;
import com.ibm.jjson.JsonUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JsonList
extends LinkedList {
    private static final long serialVersionUID = 1L;

    public JsonList(String string) throws JsonParseException {
        JsonParser.parseInto(string, this);
    }

    public JsonList() {
    }

    public JsonList(Object[] objectArray) {
        super(Arrays.asList(objectArray));
    }

    public JsonList(Collection collection) {
        super(collection);
    }

    public String getString(int n) {
        return this.get(n).toString();
    }

    public String getString(int n, String string) {
        return JsonUtils.toString(this.get(n), string);
    }

    public boolean getBoolean(int n) {
        return JsonUtils.toBoolean(this.get(n));
    }

    public boolean getBoolean(int n, boolean bl) {
        return JsonUtils.toBoolean(this.get(n), bl);
    }

    public int getInt(int n) {
        return JsonUtils.toInt(this.get(n));
    }

    public int getInt(int n, int n2) {
        return JsonUtils.toInt(this.get(n), n2);
    }

    public Map getMap(int n) {
        return (Map)this.get(n);
    }

    public List getList(int n) {
        return JsonUtils.toList((Collection)this.get(n));
    }

    public JsonMap getJsonMap(int n) {
        return JsonUtils.toJsonMap((Map)this.get(n));
    }

    public JsonList getJsonList(int n) {
        return JsonUtils.toJsonList((Collection)this.get(n));
    }

    public String[] toStringArray() {
        return JsonUtils.toStringArray(this.toArray());
    }

    public boolean[] toBooleanArray() {
        return JsonUtils.toBooleanArray(this.toArray());
    }

    public int[] toIntArray() {
        return JsonUtils.toIntArray(this.toArray());
    }

    public Map[] toMapArray() {
        return this.toArray(new JsonMap[this.size()]);
    }

    public JsonMap[] toJsonMapArray() {
        return JsonUtils.toJsonMapArray(this.toMapArray());
    }

    public List[] toListArray() {
        return this.toArray(new JsonList[this.size()]);
    }

    public JsonList[] toJsonListArray() {
        return JsonUtils.toJsonListArray(this.toListArray());
    }

    public String toString(int n, int n2) {
        return JsonSerializer.serialize(this, n, n2);
    }

    public String toString() {
        return this.toString(JsonSerializer.NOT_STRICT, JsonSerializer.FORMAT_NORMAL);
    }
}

