/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.dbutil.tasks.v600;

import com.ibm.dmh.db.DbAdmin;
import com.ibm.dmh.db.DbFlags;
import com.ibm.dmh.db.DbPreparedStatement;
import com.ibm.dmh.db.DbResultSet;
import com.ibm.dmh.dbutil.Main;
import com.ibm.dmh.dbutil.tasks.ITask;
import org.w3c.dom.NamedNodeMap;

public class DmhContainer
implements ITask {
    public String getPlanTaskBody(String taskBody, NamedNodeMap attrs) {
        return taskBody;
    }

    public int run(String taskBody, NamedNodeMap attrs, String stepName, String nextStepName) {
        DbResultSet rs = null;
        DbPreparedStatement ps = null;
        try {
            Main.logln("Running task [DmhContainer]...");
            Main.logln("Removing extraneous '/' characters from the end of paths (i.e. 'C:/')");
            ps = DbAdmin.getPreparedStatement((int)(DbFlags.LOCK | DbFlags.ABEC), (CharSequence)"update $(SCHEMA).DMH_CONTAINER set CONTAINER_NAME=? where CONTAINER_ID=?");
            for (Object[] r : DbAdmin.query((CharSequence)"select CONTAINER_ID, CONTAINER_NAME from $(SCHEMA).DMH_CONTAINER where CONTAINER_TYPE_CD='NTFS' and CONTAINER_NAME like '%/'", (Object[])new Object[0]).toRows(new String[0])) {
                String c = (String)r[1];
                Main.logln("Fixing container [" + c + "]");
                ps.addBatch(new Object[]{c.substring(0, c.length() - 1), r[0]});
            }
            ps.executeBatch(true);
            DbAdmin.close((Object[])new Object[]{ps, rs});
            Main.logln("Populating DMH_CONTAINER.SHORT_NAME and fixing DMH_CONTAINER.CONTAINER_NAME");
            ps = DbAdmin.getPreparedStatement((int)(DbFlags.LOCK | DbFlags.ABEC), (CharSequence)"update $(SCHEMA).DMH_CONTAINER set CONTAINER_NAME=?, SHORT_NAME=? where CONTAINER_ID=?");
            rs = DbAdmin.query((CharSequence)"select C.CONTAINER_ID, C.CONTAINER_NAME \tfrom $(SCHEMA).DMH_CONTAINER C, $(SCHEMA).DMH_RESOURCE_MNGR RM \twhere C.RESOURCE_MNGR_ID=RM.RESOURCE_MNGR_ID and RM.RESOURCE_TYPE='NTFS'", (Object[])new Object[0]);
            while (rs.next()) {
                int containerId = rs.getInt(1);
                String containerName = rs.getString(2).replace('\\', '/');
                int i = containerName.lastIndexOf(47);
                String shortName = i == -1 ? containerName : containerName.substring(i + 1);
                ps.addBatch(new Object[]{containerName, shortName, containerId});
            }
            ps.executeBatch(true);
            DbAdmin.close((Object[])new Object[]{ps, rs});
            Main.logln("Fixing non-root containers with PAR_CONTAINER_ID == 0");
            int rmId = DbAdmin.query((CharSequence)"select RESOURCE_MNGR_ID from $(SCHEMA).DMH_RESOURCE_MNGR where RESOURCE_TYPE='NTFS' fetch first 1 row only", (Object[])new Object[0]).toSingleInt();
            for (int siteId : DbAdmin.query((CharSequence)"select distinct SITE_ID from $(SCHEMA).DMH_CONTAINER where CONTAINER_TYPE_CD='NTFS'", (Object[])new Object[0]).toInts()) {
                rs = DbAdmin.query((CharSequence)("select C.CONTAINER_ID, C.CONTAINER_NAME \tfrom $(SCHEMA).DMH_CONTAINER C, $(SCHEMA).DMH_RESOURCE_MNGR RM \twhere C.RESOURCE_MNGR_ID=RM.RESOURCE_MNGR_ID and RM.RESOURCE_TYPE='NTFS' and C.SITE_ID=" + siteId + " and C.PAR_CONTAINER_ID=0 and C.CONTAINER_NAME like '%/%'"), (Object[])new Object[0]);
                while (rs.next()) {
                    int containerId = rs.getInt(1);
                    String containerName = rs.getString(2);
                    Main.logln("Fixing container [" + containerName + "] in site [" + siteId + "]");
                    PathToken p = new PathToken(containerName, 0);
                    while (p != null) {
                        if (p.next == null) {
                            DbAdmin.update((int)(DbFlags.REUSABLE | DbFlags.AC), (CharSequence)"update $(SCHEMA).DMH_CONTAINER set PAR_CONTAINER_ID=? where CONTAINER_ID=?", (Object[])new Object[]{p.prev.containerId, containerId});
                        } else {
                            p.containerId = DbAdmin.query((int)DbFlags.REUSABLE, (CharSequence)"select CONTAINER_ID from $(SCHEMA).DMH_CONTAINER where CONTAINER_NAME=? and SITE_ID=?", (Object[])new Object[]{p.path, siteId}).toSingleInt();
                            if (p.containerId == -1) {
                                p.containerId = DbAdmin.getPkGenerator((String)"DMH_CONTAINER", (String)"CONTAINER_ID").getKey();
                                Main.logln("Inserting container [" + p.path + "], id=[" + p.containerId + "], siteId=[" + siteId + "]");
                                DbAdmin.update((int)(DbFlags.REUSABLE | DbFlags.AC), (CharSequence)"insert into $(SCHEMA).DMH_CONTAINER values (?, ?, ?:4, ?, ?:1, ?, current timestamp, ?, substr(user, 1, 8), ?, ?, current timestamp, current timestamp, ?, ?)", (Object[])new Object[]{p.containerId, 0, p.isZip ? "ARC" : "NTFS", p.prev == null ? 0 : p.prev.containerId, "I", rmId, 1000001, siteId, 0, p.path, p.name});
                            }
                        }
                        p = p.next;
                    }
                }
            }
            DbAdmin.close((Object[])new Object[]{rs});
            Main.logln("Populating DMH_CONTAINER_TC");
            ps = DbAdmin.getPreparedStatement((int)(DbFlags.LOCK | DbFlags.ABEC), (CharSequence)"insert into $(SCHEMA).DMH_CONTAINER_TC (CONTAINER_ID, DESC_CONTAINER_ID, DEPTH) values (?, ?, ?)");
            rs = DbAdmin.query((CharSequence)"\twith DESCENDANTS(PARENT, CHILD, DEPTH) as (\t\tselect C.PAR_CONTAINER_ID, C.CONTAINER_ID, 1\t\t\tfrom $(SCHEMA).DMH_CONTAINER C, $(SCHEMA).DMH_RESOURCE_MNGR RM \t\t\twhere PAR_CONTAINER_ID<>0 and C.RESOURCE_MNGR_ID=RM.RESOURCE_MNGR_ID and RM.RESOURCE_TYPE='NTFS'\t\tunion all \t\tselect D.PARENT, C.CONTAINER_ID, D.DEPTH+1\t\t\tfrom DESCENDANTS D, $(SCHEMA).DMH_CONTAINER C\t\t\twhere D.CHILD=C.PAR_CONTAINER_ID \t\t\tand D.DEPTH<20 \t) \tselect D.PARENT, D.CHILD, D.DEPTH\t\tfrom DESCENDANTS D\t\twhere not exists \t\t\t(select 1 \t\t\t\tfrom $(SCHEMA).DMH_CONTAINER_TC TC\t\t\t\twhere D.PARENT=TC.CONTAINER_ID \t\t\t\tand D.CHILD=TC.DESC_CONTAINER_ID)", (Object[])new Object[0]);
            while (rs.next()) {
                ps.addBatch(new Object[]{rs.getInt(1), rs.getInt(2), rs.getInt(3)});
            }
            DbAdmin.close((Object[])new Object[]{rs});
            rs = DbAdmin.query((CharSequence)" select C.CONTAINER_ID  \tfrom $(SCHEMA).DMH_CONTAINER C, $(SCHEMA).DMH_RESOURCE_MNGR RM \t\twhere C.RESOURCE_MNGR_ID=RM.RESOURCE_MNGR_ID and RM.RESOURCE_TYPE='NTFS' \t\tand not exists (select 1 from $(SCHEMA).DMH_CONTAINER_TC TC2 where TC2.CONTAINER_ID=C.CONTAINER_ID and TC2.DEPTH=0)", (Object[])new Object[0]);
            while (rs.next()) {
                ps.addBatch(new Object[]{rs.getInt(1), rs.getInt(1), 0});
            }
            ps.executeBatch(true);
            DbAdmin.close((Object[])new Object[]{ps, rs});
            Main.logln("done\n");
            return 0;
        }
        catch (Exception e) {
            Main.logException(e);
            return 2;
        }
    }

    public static void main(String[] args) {
        String c = "C:/";
        System.err.println(c.substring(0, c.length() - 1));
    }

    private static class PathToken {
        String name;
        String path;
        boolean isZip;
        PathToken prev;
        PathToken next;
        int containerId;

        public PathToken(String p, int i) {
            int i2 = p.indexOf(47, i + 1);
            this.path = p.substring(0, i2 == -1 ? p.length() : i2);
            this.isZip = this.path.endsWith("!");
            this.path = this.isZip ? this.path.substring(0, this.path.length() - 1) : this.path;
            this.name = this.path.substring(this.path.lastIndexOf(47) + 1);
            if (i2 != -1) {
                this.next = new PathToken(p, i2);
                this.next.prev = this;
            }
        }
    }
}

