/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import com.ibm.dmh.db.SqlStat;
import com.ibm.dmh.log.LoggerManager;
import com.ibm.dmh.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbStats {
    private static Logger logger = LoggerManager.getMainLogger();
    private Map<String, SqlStat> sqlStats = new LinkedHashMap<String, SqlStat>();
    private Map<String, SqlStat> batchStats = new LinkedHashMap<String, SqlStat>();
    private int numCommits;
    private long totalCommitTime;
    private int debugLevel;

    public DbStats() {
        this(1);
    }

    public DbStats(int n) {
        this.debugLevel = n;
    }

    public List<SqlStat> getSqlStats() {
        ArrayList<SqlStat> arrayList = new ArrayList<SqlStat>(this.sqlStats.size() + this.batchStats.size());
        arrayList.addAll(this.sqlStats.values());
        arrayList.addAll(this.batchStats.values());
        return arrayList;
    }

    protected void addSqlStats(String string, long l, int n, Object[] objectArray) {
        if (string.indexOf(" in ") != -1 || string.indexOf(" IN ") != -1) {
            string = string.replaceAll("(?i)\\sin\\s*\\([^\\)]*\\)", " in (...)");
        }
        long l2 = System.currentTimeMillis() - l;
        if (!this.sqlStats.containsKey(string)) {
            this.sqlStats.put(string, new SqlStat(string));
        }
        SqlStat sqlStat = this.sqlStats.get(string);
        ++sqlStat.numRuns;
        sqlStat.totalExecuteTime = (int)((long)sqlStat.totalExecuteTime + l2);
        sqlStat.numRowsAffected += n;
        if (this.debugLevel >= 2) {
            String string2 = StringUtils.format((String)(string + " (time=" + StringUtils.getTimeStringShort((long)l2) + ", rows=[" + n + "]" + (objectArray == null ? "" : ", parms=[" + StringUtils.join((Object[])objectArray, (String)",") + "]") + ")"), (Object[])new Object[0]);
            logger.log(Level.INFO, string2);
        }
    }

    protected void addBatchStats(String string, long l, int n) {
        if (string.indexOf(" in ") != -1 || string.indexOf(" IN ") != -1) {
            string = string.replaceAll("(?i)\\sin\\s*\\([^\\)]*\\)", " in (...)");
        }
        long l2 = System.currentTimeMillis() - l;
        if (!this.batchStats.containsKey(string)) {
            this.batchStats.put(string, new SqlStat(string));
        }
        SqlStat sqlStat = this.batchStats.get(string);
        ++sqlStat.numRuns;
        sqlStat.totalExecuteTime = (int)((long)sqlStat.totalExecuteTime + l2);
        sqlStat.numRowsAffected += n;
        if (this.debugLevel >= 2) {
            String string2 = StringUtils.format((String)(string + " (time=" + StringUtils.getTimeStringShort((long)l2) + ", rows=[" + n + "])"), (Object[])new Object[0]);
            logger.log(Level.INFO, string2);
        }
    }

    public void addStats(DbStats dbStats) {
        if (dbStats != null) {
            SqlStat sqlStat;
            for (SqlStat sqlStat2 : dbStats.sqlStats.values()) {
                sqlStat = this.sqlStats.get(sqlStat2.sql);
                if (sqlStat == null) {
                    this.sqlStats.put(sqlStat2.sql, sqlStat2);
                    continue;
                }
                sqlStat.numRuns += sqlStat2.numRuns;
                sqlStat.totalExecuteTime += sqlStat2.totalExecuteTime;
                sqlStat.numRowsAffected += sqlStat2.numRowsAffected;
            }
            for (SqlStat sqlStat2 : dbStats.batchStats.values()) {
                sqlStat = this.batchStats.get(sqlStat2.sql);
                if (sqlStat == null) {
                    this.batchStats.put(sqlStat2.sql, sqlStat2);
                    continue;
                }
                sqlStat.numRuns += sqlStat2.numRuns;
                sqlStat.totalExecuteTime += sqlStat2.totalExecuteTime;
                sqlStat.numRowsAffected += sqlStat2.numRowsAffected;
            }
            this.numCommits += dbStats.numCommits;
            this.totalCommitTime += dbStats.totalCommitTime;
        }
    }

    public void addCommit(long l) {
        ++this.numCommits;
        this.totalCommitTime += l;
    }

    public void logStats() {
        String string;
        ArrayList<SqlStat> arrayList;
        if (this.debugLevel == 0) {
            return;
        }
        Comparator<SqlStat> comparator = new Comparator<SqlStat>(){

            @Override
            public int compare(SqlStat sqlStat, SqlStat sqlStat2) {
                return sqlStat2.totalExecuteTime - sqlStat.totalExecuteTime;
            }
        };
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (!this.sqlStats.isEmpty()) {
            logger.log(Level.INFO, "----- SQL statement statistics -----");
            arrayList = new ArrayList<SqlStat>(this.sqlStats.values());
            Collections.sort(arrayList, comparator);
            for (SqlStat sqlStat : arrayList) {
                string = sqlStat.sql.toLowerCase();
                logger.log(Level.INFO, StringUtils.format((String)"\ttime=[%12s], runs=[%5d], rows=[%6d], sql=[%s]", (Object[])new Object[]{StringUtils.getTimeStringShort((long)sqlStat.totalExecuteTime), sqlStat.numRuns, sqlStat.numRowsAffected, sqlStat.sql}));
                if (string.startsWith("insert")) {
                    n += sqlStat.numRowsAffected;
                    continue;
                }
                if (string.startsWith("delete")) {
                    n3 += sqlStat.numRowsAffected;
                    continue;
                }
                if (string.startsWith("update")) {
                    n2 += sqlStat.numRowsAffected;
                    continue;
                }
                n4 += sqlStat.numRowsAffected;
            }
        }
        if (!this.batchStats.isEmpty()) {
            logger.log(Level.INFO, "----- SQL batch statistics -----");
            arrayList = new ArrayList<SqlStat>(this.batchStats.values());
            Collections.sort(arrayList, comparator);
            for (SqlStat sqlStat : arrayList) {
                string = sqlStat.sql.toLowerCase();
                logger.log(Level.INFO, StringUtils.format((String)"\ttime=[%12s], runs=[%5d], rows=[%6d], sql=[%s]", (Object[])new Object[]{StringUtils.getTimeStringShort((long)sqlStat.totalExecuteTime), sqlStat.numRuns, sqlStat.numRowsAffected, sqlStat.sql}));
                if (string.startsWith("insert")) {
                    n += sqlStat.numRowsAffected;
                    continue;
                }
                if (string.startsWith("delete")) {
                    n3 += sqlStat.numRowsAffected;
                    continue;
                }
                if (string.startsWith("update")) {
                    n2 += sqlStat.numRowsAffected;
                    continue;
                }
                n4 += sqlStat.numRowsAffected;
            }
        }
        logger.log(Level.INFO, "\tTotal rows:  inserted=[" + n + "], updated=[" + n2 + "], deleted=[" + n3 + "], queried=[" + n4 + "], commits=[" + this.numCommits + "], totalCommitTime=[" + this.totalCommitTime + "ms]");
    }
}

