/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import com.ibm.dmh.db.DbAdmin;
import com.ibm.dmh.db.DbColumn;
import com.ibm.dmh.db.DbIndex;
import com.ibm.dmh.db.DbTable;
import com.ibm.dmh.db.DbTrigger;
import com.ibm.dmh.db.DbUtil;
import com.ibm.dmh.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbMetaData {
    private Map<String, DbTable> tables = new TreeMap<String, DbTable>();
    private String schemaName = null;
    private String schemaDesc = null;
    private String os = null;
    private int formatVersion = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbMetaData(Connection connection, String string, String string2) throws SQLException {
        this.schemaName = string = string.trim().toUpperCase();
        this.schemaDesc = string2;
        ResultSet resultSet = null;
        Statement statement = null;
        Pattern pattern = null;
        Pattern pattern2 = null;
        Pattern pattern3 = null;
        Pattern pattern4 = null;
        try {
            pattern = Pattern.compile(".*\\s+AFTER\\s+(\\S+)\\s+(?:OF \\S+\\s+)?ON\\s+.*");
            pattern2 = Pattern.compile("\\s+DELETE\\s+FROM\\s+(\\S+)\\s+");
            pattern3 = Pattern.compile("\\s+UPDATE\\s+(\\S+)\\s+");
            pattern4 = Pattern.compile("\\s+INSERT\\s+INTO\\s+([^\\s\\(]+)");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            patternSyntaxException.printStackTrace(System.err);
            DbAdmin.close(resultSet);
            DbAdmin.close(statement);
            return;
        }
        try {
            Object object;
            LinkedList<String> linkedList;
            String string3;
            Object object2;
            Object object3;
            resultSet = connection.getMetaData().getTables(null, "SYSIBM", "SYSDATABASE", null);
            this.os = resultSet.next() ? "zOS" : "UDB";
            resultSet.close();
            String string4 = null;
            statement = connection.createStatement();
            string4 = "select NAME,TYPE from SYSIBM.SYSTABLES where CREATOR='" + string + "' order by NAME";
            resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                object3 = resultSet.getString(1).trim().toUpperCase();
                object2 = resultSet.getString(2).trim().toUpperCase();
                this.tables.put((String)object3, new DbTable((String)object3, ((String)object2).charAt(0), false));
            }
            string4 = this.os.equals("zOS") ? "select TBNAME,NAME,COLTYPE,LENGTH,LENGTH2,NULLS,DEFAULT,DEFAULTVALUE from SYSIBM.SYSCOLUMNS where TBCREATOR='" + string + "' " + "order by TBNAME, COLNO" : "select TBNAME,NAME,COLTYPE,LENGTH,LONGLENGTH,NULLS,DEFAULT,'1' from SYSIBM.SYSCOLUMNS where TBCREATOR='" + string + "' " + "order by TBNAME, COLNO";
            resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                DbTable dbTable;
                object3 = resultSet.getString(1).trim().toUpperCase();
                object2 = resultSet.getString(2).trim().toUpperCase();
                int n = DbUtil.getSqlType(resultSet.getString(3).trim());
                int n2 = resultSet.getInt(4);
                int n3 = resultSet.getInt(5);
                string3 = resultSet.getString(6);
                linkedList = resultSet.getString(7);
                object = resultSet.getString(8);
                boolean bl = StringUtils.getBoolean((String)string3);
                Object object4 = null;
                if (this.os.equals("zOS")) {
                    char c = ((String)((Object)linkedList)).charAt(0);
                    switch (c) {
                        case 'A': 
                        case 'D': 
                        case 'I': 
                        case 'J': 
                        case 'N': 
                        case 'S': 
                        case 'U': {
                            break;
                        }
                        case 'B': {
                            object4 = DbUtil.getDefaultForColumnType(n);
                            break;
                        }
                        case 'Y': {
                            if (string3.equalsIgnoreCase("Y")) break;
                            object4 = DbUtil.getDefaultForColumnType(n);
                            break;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '7': {
                            object4 = object;
                        }
                    }
                    if (n3 > 0) {
                        n2 = n3;
                    }
                } else {
                    n2 = n3;
                    object4 = linkedList;
                    if (object4 != null && ((String)object4).startsWith("'")) {
                        object4 = ((String)object4).substring(1, ((String)object4).length() - 1);
                    }
                }
                if (object4 != null) {
                    object4 = ((String)object4).trim();
                }
                if ((dbTable = this.tables.get(object3)).getType() == 'V') {
                    object4 = null;
                }
                dbTable.addColumn(new DbColumn((String)object2, n, n2, (String)object4, "" + bl, false));
            }
            resultSet.close();
            resultSet = statement.executeQuery("select NAME, TBNAME from SYSIBM.SYSINDEXES where TBCREATOR='" + string + "' and CREATOR='" + string + "'");
            while (resultSet.next()) {
                object3 = resultSet.getString(2).trim().toUpperCase();
                object2 = resultSet.getString(1).trim().toUpperCase();
                DbTable dbTable = this.tables.get(object3);
                if (dbTable == null) {
                    throw new RuntimeException("Unexpected scenario encountered.  Table [" + (String)object3 + "] for index [" + (String)object2 + "] was not previously found in SYSIBM.SYSTABLES.  Contact IBM support.");
                }
                dbTable.addIndex(new DbIndex((String)object2, null, false));
            }
            resultSet.close();
            statement.close();
            string4 = this.os.equals("zOS") ? "select A.TBNAME as TABLE, A.NAME as INDEX, B.COLNAME as COLUMN, B.ORDERING as ORD from SYSIBM.SYSINDEXES A, SYSIBM.SYSKEYS B where A.TBCREATOR='" + string + "' and A.CREATOR='" + string + "' and A.NAME=B.IXNAME and B.IXCREATOR='" + string + "' " + "order by table, index, colseq" : "select A.TBNAME as TABLE, A.NAME as INDEX, B.COLNAME as COLUMN, B.COLORDER as ORD from SYSIBM.SYSINDEXES A, SYSIBM.SYSINDEXCOLUSE B where A.TBCREATOR='" + string + "' and A.CREATOR='" + string + "' and A.NAME=B.INDNAME and B.INDSCHEMA='" + string + "'" + "order by table, index, colseq";
            object3 = new HashMap();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                object2 = resultSet.getString(1).trim().toUpperCase();
                String string5 = resultSet.getString(2).trim().toUpperCase();
                String string6 = resultSet.getString(3).trim().toUpperCase();
                String string7 = resultSet.getString(4).trim().toUpperCase();
                string3 = (String)object2 + "," + string5;
                if (!object3.containsKey(string3)) {
                    object3.put(string3, new LinkedList());
                }
                linkedList = (List)object3.get(string3);
                linkedList.add(string6 + "-" + string7);
            }
            for (String string8 : object3.keySet()) {
                List list = (List)object3.get(string8);
                String[] stringArray = string8.split(",");
                this.tables.get((Object)stringArray[0]).indexes.get((Object)stringArray[1]).colTokens = DbMetaData.join(list);
            }
            resultSet.close();
            statement.close();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select NAME, TBNAME, TEXT from SYSIBM.SYSTRIGGERS where SCHEMA='" + string + "'");
            while (resultSet.next()) {
                object2 = resultSet.getString(2).trim().toUpperCase();
                String string9 = resultSet.getString(1).trim().toUpperCase();
                DbTable dbTable = this.tables.get(object2);
                if (dbTable == null) {
                    System.err.println("ERROR: Unknown table in SYSIBM.SYSTRIGGERS: table=[" + (String)object2 + "], trigger=[" + string9 + "]");
                    continue;
                }
                String string10 = resultSet.getString(3).trim().toUpperCase();
                string10 = string10.replaceAll("\n", " ");
                string3 = "Unknown";
                linkedList = new LinkedList<String>();
                object = pattern.matcher(string10);
                if (((Matcher)object).matches()) {
                    string3 = ((Matcher)object).group(1).substring(0, 1);
                }
                string10 = string10.substring(string10.indexOf("MODE"));
                object = pattern2.matcher(string10);
                while (((Matcher)object).find()) {
                    linkedList.add(DbMetaData.stripSchema(((Matcher)object).group(1)) + "-D");
                }
                object = pattern3.matcher(string10);
                while (((Matcher)object).find()) {
                    linkedList.add(DbMetaData.stripSchema(((Matcher)object).group(1)) + "-U");
                }
                object = pattern4.matcher(string10);
                while (((Matcher)object).find()) {
                    linkedList.add(DbMetaData.stripSchema(((Matcher)object).group(1)) + "-I");
                }
                if (string3.equals("Unknown")) {
                    System.err.println("ERROR: Couldn't determine trigger type on '" + string9 + "'.");
                }
                if (linkedList.size() == 0) {
                    System.err.println("ERROR: Couldn't find any targets on trigger '" + string9 + "'.");
                }
                dbTable.addTrigger(new DbTrigger(string9, string3, DbMetaData.join(linkedList), false));
            }
            resultSet.close();
            statement.close();
            statement = connection.createStatement();
            try {
                resultSet = statement.executeQuery("select TBNAME, NAME from SYSIBM.SYSCOLUMNS where TBCREATOR='" + string + "' and KEYSEQ > 0 ORDER BY TBNAME, KEYSEQ");
                while (resultSet.next()) {
                    object2 = resultSet.getString(1).trim().toUpperCase();
                    String string11 = resultSet.getString(2).trim().toUpperCase();
                    DbTable dbTable = this.tables.get(object2);
                    dbTable.pkColumns = dbTable.pkColumns + (dbTable.pkColumns.equals("") ? "" : ",") + string11;
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == -204) {
                    System.out.println("WARNING:  Database appears to be on DB2 pre-v7.  Unable to retrieve primary key information.");
                }
                throw sQLException;
            }
            resultSet.close();
            statement.close();
        }
        catch (Throwable throwable) {
            DbAdmin.close(resultSet);
            DbAdmin.close(statement);
            throw throwable;
        }
        DbAdmin.close(resultSet);
        DbAdmin.close(statement);
    }

    public DbMetaData(File file, String string) throws ParserConfigurationException, FactoryConfigurationError, FileNotFoundException, SAXException, IOException {
        this.schemaName = string;
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Element element = documentBuilder.parse(new InputSource(new FileReader(file))).getDocumentElement();
        this.schemaDesc = element.getAttribute("desc");
        this.formatVersion = Integer.parseInt(StringUtils.getString((String)element.getAttribute("formatVersion"), (String)"1"));
        NodeList nodeList = element.getElementsByTagName("Table");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Element element2;
            int n;
            Element element3 = (Element)nodeList.item(i);
            String string2 = element3.getAttribute("name");
            String string3 = element3.getAttribute("pk");
            String string4 = element3.getAttribute("type");
            boolean bl = StringUtils.getBoolean((String)element3.getAttribute("optional"));
            DbTable dbTable = new DbTable(string2, StringUtils.isEmpty((CharSequence)string4) ? (char)'U' : (char)string4.charAt(0), bl);
            dbTable.pkColumns = string3;
            this.tables.put(string2, dbTable);
            NodeList nodeList2 = element3.getElementsByTagName("Column");
            for (n = 0; n < nodeList2.getLength(); ++n) {
                element2 = (Element)nodeList2.item(n);
                object = this.formatVersion > 1 ? new DbColumn(element2.getAttribute("name"), element2.getAttribute("type"), element2.hasAttribute("default") ? element2.getAttribute("default") : null, element2.hasAttribute("nullable") ? element2.getAttribute("nullable") : "false", StringUtils.getBoolean((String)element2.getAttribute("optional"))) : new DbColumn(element2.getAttribute("name"), Integer.parseInt(element2.getAttribute("type")), Integer.parseInt(element2.getAttribute("size")), null, null, StringUtils.getBoolean((String)element2.getAttribute("optional")));
                dbTable.addColumn((DbColumn)object);
            }
            nodeList2 = element3.getElementsByTagName("Index");
            for (n = 0; n < nodeList2.getLength(); ++n) {
                element2 = (Element)nodeList2.item(n);
                object = new DbIndex(element2.getAttribute("name"), StringUtils.getString((String)element2.getAttribute("colTokens"), (String)""), StringUtils.getBoolean((String)element2.getAttribute("optional")));
                dbTable.addIndex((DbIndex)object);
            }
            nodeList2 = element3.getElementsByTagName("Trigger");
            for (n = 0; n < nodeList2.getLength(); ++n) {
                element2 = (Element)nodeList2.item(n);
                object = new DbTrigger(element2.getAttribute("name"), StringUtils.getString((String)element2.getAttribute("type"), (String)""), StringUtils.getString((String)element2.getAttribute("targets"), (String)""), StringUtils.getBoolean((String)element2.getAttribute("optional")));
                dbTable.addTrigger((DbTrigger)object);
            }
        }
    }

    public void saveToFile(File file) throws IOException {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        printWriter.println("<DbMetaData desc='" + this.schemaDesc + "' formatVersion='" + this.formatVersion + "'>");
        for (DbTable dbTable : this.tables.values()) {
            printWriter.println("\t<Table name='" + dbTable.getName() + "' pk='" + dbTable.pkColumns + "' type='" + dbTable.getType() + "'>");
            for (DbColumn dbColumn : dbTable.columns.values()) {
                printWriter.println("\t\t<Column name='" + dbColumn.getName() + "' type='" + DbUtil.getSqlTypeAndSizeString(dbColumn.getType(), dbColumn.getSize()) + "'" + (dbColumn.isAllowNull() ? " nullable='true'" : "") + (dbColumn.getDefaultValue() == null ? "" : " default='" + dbColumn.getDefaultValue() + "'") + "/>");
            }
            for (DbIndex dbIndex : dbTable.indexes.values()) {
                printWriter.println("\t\t<Index name='" + dbIndex.getName() + "' colTokens='" + dbIndex.getColTokens() + "'/>");
            }
            for (DbTrigger dbTrigger : dbTable.triggers.values()) {
                printWriter.println("\t\t<Trigger name='" + dbTrigger.getName() + "' type='" + dbTrigger.getType() + "' targets='" + dbTrigger.getTargets() + "'/>");
            }
            printWriter.println("\t</Table>");
        }
        printWriter.println("</DbMetaData>");
        printWriter.flush();
        printWriter.close();
    }

    private static String join(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next() + (iterator.hasNext() ? "," : ""));
        }
        return stringBuffer.toString();
    }

    public String[] compareTo(DbMetaData dbMetaData) {
        Object object;
        String string;
        DbTable dbTable;
        String string2;
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl = this.formatVersion >= 2 && dbMetaData.formatVersion >= 2;
        for (DbTable dbTable2 : dbMetaData.tables.values()) {
            string2 = dbTable2.getName();
            dbTable = this.getTable(string2);
            if (dbTable == null) {
                if (dbTable2.isOptional()) continue;
                linkedList.add("Database is missing table '" + string2 + "'.");
                continue;
            }
            if (!dbTable.pkColumns.equals(dbTable2.pkColumns)) {
                linkedList.add("Table '" + string2 + "' primary key columns should be '" + dbTable2.pkColumns + "' but is '" + dbTable.pkColumns + "'");
            }
            for (DbColumn dbColumn : dbTable2.columns.values()) {
                string = dbColumn.getName();
                object = dbTable.columns.get(string);
                if (object == null) {
                    if (dbColumn.isOptional()) continue;
                    linkedList.add("Database is missing column '" + string + "' in table '" + string2 + "'");
                    continue;
                }
                if (((DbColumn)object).getType() != dbColumn.getType() || ((DbColumn)object).getSize() != dbColumn.getSize()) {
                    linkedList.add("Column type should be '" + DbUtil.getSqlTypeAndSizeString(dbColumn.getType(), dbColumn.getSize()) + "' but is '" + DbUtil.getSqlTypeAndSizeString(((DbColumn)object).getType(), ((DbColumn)object).getSize()) + "' for column '" + string + "' in table '" + string2 + "'.");
                }
                if (!bl) continue;
                if (!DbMetaData.isEqual(((DbColumn)object).getDefaultValue(), dbColumn.getDefaultValue())) {
                    linkedList.add("Column default value should be '" + dbColumn.getDefaultValue() + "' but is '" + ((DbColumn)object).getDefaultValue() + "' for column '" + string + "' in table '" + string2 + "'.");
                }
                if (((DbColumn)object).isAllowNull() == dbColumn.isAllowNull()) continue;
                linkedList.add("Column nullable should be '" + dbColumn.isAllowNull() + "' but is '" + ((DbColumn)object).isAllowNull() + "' for column '" + string + "' in table '" + string2 + "'.");
            }
            for (DbIndex dbIndex : dbTable2.indexes.values()) {
                string = dbIndex.getName();
                object = dbTable.indexes.get(string);
                if (object == null) {
                    if (dbIndex.isOptional()) continue;
                    linkedList.add("Database is missing index '" + string + "' in table '" + string2 + "'");
                    continue;
                }
                if (!bl || ((DbIndex)object).getColTokens().equals(dbIndex.getColTokens())) continue;
                linkedList.add("Columns on index '" + string + "' are different.  Expected='" + dbIndex.getColTokens() + "', actual='" + ((DbIndex)object).getColTokens() + "'.");
            }
            for (DbTrigger dbTrigger : dbTable2.triggers.values()) {
                string = dbTrigger.getName();
                object = dbTable.triggers.get(string);
                if (object == null) {
                    if (dbTrigger.isOptional()) continue;
                    linkedList.add("Database is missing trigger '" + string + "' in table '" + string2 + "'");
                    continue;
                }
                if (bl && !((DbTrigger)object).getType().equals(dbTrigger.getType())) {
                    linkedList.add("Trigger '" + string + "' was expected to be of type '" + dbTrigger.getType() + "' but was actually of type '" + ((DbTrigger)object).getType() + "'.");
                    continue;
                }
                if (!bl || ((DbTrigger)object).getTargets().equals(dbTrigger.getTargets())) continue;
                linkedList.add("Trigger target tables on '" + string + "' was expected to be '" + dbTrigger.getTargets() + "' but was actually '" + ((DbTrigger)object).getTargets() + "'.");
            }
        }
        for (DbTable dbTable2 : this.tables.values()) {
            string2 = dbTable2.getName();
            dbTable = dbMetaData.getTable(string2);
            if (dbTable == null) {
                if (dbTable2.isOptional()) continue;
                linkedList.add("Database has extra table '" + string2 + "'.");
                continue;
            }
            for (DbColumn dbColumn : dbTable2.columns.values()) {
                string = dbColumn.getName();
                object = dbTable.columns.get(string);
                if (object != null || dbColumn.isOptional()) continue;
                linkedList.add("Database has extra column '" + string + "' in table '" + string2 + "'");
            }
            for (DbIndex dbIndex : dbTable2.indexes.values()) {
                string = dbIndex.getName();
                object = dbTable.indexes.get(string);
                if (object != null || dbIndex.isOptional()) continue;
                linkedList.add("Database has extra index '" + string + "' in table '" + string2 + "'");
            }
            for (DbTrigger dbTrigger : dbTable2.triggers.values()) {
                string = dbTrigger.getName();
                object = dbTable.triggers.get(string);
                if (object != null || dbTrigger.isOptional()) continue;
                linkedList.add("Database has extra trigger '" + string + "' in table '" + string2 + "'");
            }
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public Collection<DbTable> getTables() {
        return this.tables.values();
    }

    public Collection<String> getTableNames() {
        return this.tables.keySet();
    }

    public DbTable getTable(String string) {
        if ((string = string.toUpperCase()).startsWith(this.schemaName + ".")) {
            string = string.substring(string.indexOf(46) + 1);
        }
        return this.tables.get(string.toUpperCase());
    }

    public DbColumn getColumn(String string, String string2) {
        DbTable dbTable = this.getTable(string);
        if (dbTable == null) {
            return null;
        }
        return dbTable.columns.get(string2.toUpperCase());
    }

    public DbIndex getIndex(String string, String string2) {
        DbTable dbTable = this.getTable(string);
        if (dbTable == null) {
            return null;
        }
        return dbTable.indexes.get(string2.toUpperCase());
    }

    public DbTrigger getTrigger(String string, String string2) {
        DbTable dbTable = this.getTable(string);
        if (dbTable == null) {
            return null;
        }
        return dbTable.triggers.get(string2.toUpperCase());
    }

    public static String stripSchema(String string) {
        int n = string.indexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    public static boolean isEqual(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == null && object2 == null;
        }
        return object.equals(object2);
    }

    public static String getTypeString(DbColumn dbColumn) {
        switch (dbColumn.getType()) {
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY(" + dbColumn.getSize() + ")";
            }
            case 2004: {
                return "BLOB(" + dbColumn.getSize() + ")";
            }
            case 1: {
                return "CHAR(" + dbColumn.getSize() + ")";
            }
            case 2005: {
                return "CLOB(" + dbColumn.getSize() + ")";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "LONGVARBINARY(" + dbColumn.getSize() + ")";
            }
            case -1: {
                return "LONGVARCHAR(" + dbColumn.getSize() + ")";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY(" + dbColumn.getSize() + ")";
            }
            case 12: {
                return "VARCHAR(" + dbColumn.getSize() + ")";
            }
        }
        return "UNKNOWN(" + dbColumn.getSize() + ")";
    }
}

