/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.log;

import com.ibm.dmh.util.LocaleMgr;
import com.ibm.dmh.util.StringUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggerManager {
    private static Level logLevel;
    private static Level consoleLogLevel;
    private static String logDir;
    private static boolean isInitialized;
    private static int numberOfLogsToKeep;
    private static int maxLogFileSize;
    private static boolean doAppend;
    private static Formatter formatter;
    private static Logger mainLogger;
    private static Map<String, Logger> loggers;

    public static void init(String string, String string2, String string3, boolean bl) {
        if (isInitialized) {
            return;
        }
        if (string == null) {
            string = StringUtils.getString(System.getProperty("LOGLEVEL"), "INFO");
        }
        if (string2 == null) {
            string2 = StringUtils.getString(System.getProperty("LOGDIR"), "%t");
        }
        if (!string2.equals("%t")) {
            new File(string2).mkdirs();
        }
        consoleLogLevel = logLevel = Level.parse(string);
        logDir = string2;
        System.err.println("logLevel=[" + logLevel + "], logDir=[" + new File(string2).getAbsolutePath() + "], mainLoggerName=[" + string3 + "], useGlobalLogger=[" + bl + "]");
        isInitialized = true;
        if (bl) {
            Logger logger = Logger.getLogger("");
            LoggerManager.initLogger(logger, string3);
            mainLogger = Logger.getLogger(string3);
            loggers.put(string3, mainLogger);
        } else {
            mainLogger = LoggerManager.getLogger(StringUtils.getString(string3, ""));
            Logger.getLogger("").setLevel(Level.OFF);
            for (Handler handler : Logger.getLogger("").getHandlers()) {
                handler.setLevel(Level.OFF);
            }
        }
    }

    public static Logger getLogger(String string) {
        return LoggerManager.getLogger(string, string);
    }

    public static Logger getLogger(String string, String string2) {
        if (!isInitialized) {
            return Logger.global;
        }
        if (!loggers.containsKey(string)) {
            Logger logger = Logger.getLogger(string);
            LoggerManager.initLogger(logger, string);
            loggers.put(string, logger);
        }
        return loggers.get(string);
    }

    private static void initLogger(Logger logger, String string) {
        for (Handler handler : logger.getHandlers()) {
            handler.setLevel(Level.OFF);
        }
        try {
            boolean bl = false;
            int n = 0;
            if (n == 0) {
                FileHandler fileHandler = new FileHandler(logDir + "/" + string + ".%g.%u.log", maxLogFileSize, numberOfLogsToKeep, doAppend);
                fileHandler.setLevel(logLevel);
                fileHandler.setFormatter(formatter);
                ((Handler)fileHandler).setEncoding(LocaleMgr.getExternalDefaultEncoding());
                logger.addHandler(fileHandler);
            }
            if (!bl && consoleLogLevel.intValue() < Level.OFF.intValue()) {
                ConsoleHandler consoleHandler = new ConsoleHandler();
                consoleHandler.setLevel(consoleLogLevel);
                consoleHandler.setFormatter(formatter);
                logger.addHandler(consoleHandler);
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Exception caught trying to instantiate logger.", exception);
        }
        logger.setLevel(logLevel);
    }

    public static Logger getMainLogger() {
        return mainLogger == null ? Logger.global : mainLogger;
    }

    public static File getLogDir() {
        String string = logDir;
        if (string.indexOf("%t") != -1) {
            string = logDir.replaceAll("\\%t", StringUtils.coalesce(System.getProperty("java.io.tmpdir"), System.getProperty("user.home")).replace('\\', '/'));
        }
        return new File(string);
    }

    public static void shutdown() {
        if (!isInitialized) {
            return;
        }
        for (Handler handler : mainLogger.getHandlers()) {
            handler.close();
        }
        for (Logger logger : loggers.values()) {
            for (Handler handler : logger.getHandlers()) {
                handler.close();
            }
        }
        isInitialized = false;
    }

    static {
        numberOfLogsToKeep = 3;
        maxLogFileSize = 10000000;
        doAppend = false;
        formatter = new Formatter(){
            DateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");

            public String format(LogRecord logRecord) {
                String string = StringUtils.chop(logRecord.getLoggerName(), 10, true, true);
                String string2 = "[" + this.df.format(logRecord.getMillis()) + "] " + string + " " + logRecord.getLevel() + ": " + logRecord.getMessage() + "\r\n";
                if (logRecord.getThrown() != null) {
                    try {
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(stringWriter);
                        logRecord.getThrown().printStackTrace(printWriter);
                        printWriter.close();
                        string2 = string2 + stringWriter.toString() + "\r\n";
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                    }
                }
                return string2;
            }
        };
        loggers = new HashMap<String, Logger>();
    }
}

