/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.util;

import com.ibm.dmh.cfgmgr.vars.ConfigVar;
import com.ibm.dmh.cfgmgr.vars.ResourceBundleVar;
import com.ibm.dmh.cfgmgr.vars.VarResolver;
import com.ibm.dmh.cfgmgr.vars.VarTracker;
import com.ibm.dmh.util.FileContents;
import com.ibm.dmh.util.LocaleMgr;
import com.ibm.dmh.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.StringReader;
import java.net.URL;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class XmlLoader {
    public Document doc;

    public XmlLoader(String string, String[] stringArray, String string2, VarResolver varResolver) throws Exception {
        this(string, stringArray, string2, varResolver, true);
    }

    public XmlLoader(String string, String[] stringArray, String string2, VarResolver varResolver, boolean bl) throws Exception {
        String string3;
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            string3 = stringArray[n] + '/' + string;
            if (!new File(string3).exists()) continue;
            this.init(string3, string2, varResolver, bl);
            return;
        }
        for (n = 0; n < stringArray.length; ++n) {
            string3 = stringArray[n] + '/' + string;
            URL uRL = ClassLoader.getSystemResource(string3);
            if (uRL == null) continue;
            boolean bl2 = uRL.toURI().toString().indexOf("file:") == 0;
            this.init(string3, bl2 ? LocaleMgr.getExternalDefaultEncoding() : "UTF-8", varResolver, bl);
            return;
        }
        throw new FileNotFoundException("XmlLoader could not find file [" + string + "] in search path [" + StringUtils.join(stringArray, ",") + "] or CLASSPATH");
    }

    public XmlLoader(String string, String string2, VarResolver varResolver) throws Exception {
        this.init(string, string2, varResolver, false);
    }

    private void init(String string, String string2, VarResolver varResolver, boolean bl) throws Exception {
        FileContents fileContents = new FileContents();
        fileContents.readFile(string, string2 == null ? LocaleMgr.getExternalDefaultEncoding() : string2);
        ResourceBundle resourceBundle = LocaleMgr.getBundleForFile(string);
        if (varResolver == null) {
            varResolver = new VarResolver();
        }
        if (resourceBundle != null) {
            varResolver.addVar("L", new ResourceBundleVar(resourceBundle), new VarTracker(bl, true));
        }
        varResolver.addVar("C", new ConfigVar(), new VarTracker(false, true));
        fileContents.insertVars(varResolver);
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(fileContents.getContents()));
        inputSource.setSystemId(new File(".").toURL().toString());
        this.doc = documentBuilder.parse(inputSource);
    }

    public Element getRootElement() {
        return this.doc.getDocumentElement();
    }

    public Document getDocument() {
        return this.doc;
    }
}

