/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import com.ibm.dmh.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NoInitialContextException;
import javax.naming.NotContextException;
import javax.sql.DataSource;

public class DataSourceAdmin {
    private static DataSource dataSource = null;
    private static boolean isInitialized = false;

    public static void init(String string) throws Exception {
        if (isInitialized) {
            return;
        }
        try {
            InitialContext initialContext = new InitialContext();
            try {
                dataSource = (DataSource)initialContext.lookup(string);
            }
            catch (NameNotFoundException nameNotFoundException) {
            }
            catch (NotContextException notContextException) {
                // empty catch block
            }
            if (dataSource == null && !string.startsWith("java:comp/env/")) {
                try {
                    dataSource = (DataSource)initialContext.lookup("java:comp/env/" + string);
                }
                catch (NameNotFoundException nameNotFoundException) {}
            }
        }
        catch (NoInitialContextException noInitialContextException) {
            throw new Exception("Non-J2EE environment detected.");
        }
        if (dataSource == null) {
            throw new Exception("DataSource with name [" + string + "] could not be located in JNDI registry.");
        }
        isInitialized = true;
    }

    public static Connection getConnection(String string, String string2) throws SQLException {
        for (int i = 1; i <= 2; ++i) {
            try {
                if (StringUtils.isEmpty((CharSequence)string) || StringUtils.isEmpty((CharSequence)string2) || string.equalsIgnoreCase("*default*")) {
                    return dataSource.getConnection();
                }
                return dataSource.getConnection(string, string2);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Attempt #[" + i + " of 2] on getConnection() failed: " + runtimeException.getClass() + ", " + runtimeException.getLocalizedMessage());
                if (i != 2) continue;
                throw runtimeException;
            }
            catch (SQLException sQLException) {
                int n = sQLException.getErrorCode();
                if (n == -922 || n == -1403 || n == -30082) {
                    throw sQLException;
                }
                System.err.println("Attempt #[" + i + " of 2] on getConnection() failed: " + sQLException.getClass() + ", " + sQLException.getLocalizedMessage());
                if (i != 2) continue;
                throw sQLException;
            }
        }
        return null;
    }
}

