/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.cdz.core;

import com.ibm.cdz.common.TraceUtil;
import com.ibm.cdz.common.util.RemoteEditableUtil;
import com.ibm.cdz.remote.core.editor.RemoteCEditor;
import com.ibm.cdz.remote.core.extensionpoints.api.IActionHandler;
import com.ibm.cdz.remote.core.extensionpoints.api.IEditorContext;
import com.ibm.cdz.remote.core.extensionpoints.api.IHelpResolver;
import com.ibm.cdz.remote.core.extensionpoints.api.IIncludeHandler;
import com.ibm.cdz.remote.core.extensionpoints.api.IInfoProvider;
import com.ibm.cdz.remote.core.extensionpoints.api.IRemoteEditor;
import com.ibm.cdz.remote.core.extensionpoints.api.IResourceResolver;
import com.ibm.cdz.remote.core.extensionpoints.api.IVariableResolver;
import com.ibm.ftt.cdz.core.MVSResourceResolver;
import com.ibm.ftt.cdz.core.Messages;
import com.ibm.ftt.cdz.core.ResourceUtil;
import com.ibm.ftt.cdz.core.editor.actions.MVSRemoteSyntaxCheck;
import com.ibm.ftt.core.impl.utils.CodepageValidator;
import com.ibm.ftt.core.impl.utils.LocalResourcePropertyUtils;
import com.ibm.ftt.lpex.mvs.MvsLpexResources;
import com.ibm.ftt.projects.core.impl.logical.LogicalPropertyManager;
import com.ibm.ftt.projects.core.logical.ILogicalResource;
import com.ibm.ftt.projects.zos.zoslogical.LZOSResource;
import com.ibm.ftt.resource.utils.PBResourceUtils;
import com.ibm.ftt.resources.core.impl.PhysicalPropertyManager;
import com.ibm.ftt.resources.core.physical.IPhysicalResource;
import com.ibm.ftt.resources.zos.PBSystemIFileProperties;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import com.ibm.ftt.resources.zos.util.ILockingConstants;
import com.ibm.ftt.resources.zos.util.LockException;
import com.ibm.ftt.resources.zos.util.LockManager;
import com.ibm.ftt.resources.zos.util.MVSSystemEditableRemoteFile;
import com.ibm.ftt.resources.zos.zosfactory.ZOSPhysicalResourceFinder;
import com.ibm.ftt.resources.zos.zosphysical.RecordFormat;
import com.ibm.ftt.resources.zos.zosphysical.ZOSDataSet;
import com.ibm.ftt.resources.zos.zosphysical.ZOSDataSetMember;
import com.ibm.ftt.resources.zos.zosphysical.ZOSPartitionedDataSet;
import com.ibm.ftt.resources.zos.zosphysical.ZOSResource;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSDataSetMemberImpl;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSResourceImpl;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSSequentialDataSetImpl;
import com.ibm.ftt.rse.mvs.client.subsystems.MVSFileSubSystem;
import com.ibm.ftt.ui.rse.utils.RSESaveAsSelectionObject;
import com.ibm.ftt.ui.rse.utils.RSEUtil;
import com.ibm.ftt.ui.views.navigator.NavigatorResources;
import com.ibm.tpf.lpex.common.F1HelpUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.services.files.RemoteFileException;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.FileEditorInput;

public class WDzInfoProvider
implements IInfoProvider {
    public void fileOpened(IFile file, IRemoteEditor editor) {
        Object res = ResourceUtil.getResource(file);
        if (res != null && (res instanceof ILogicalResource || res instanceof IPhysicalResource || this.isWDzIResource((IResource)res))) {
            editor.setEditorContext((IEditorContext)new WDzContext(file, res));
            ZOSDataSet ds = this.getDataSet(res);
            this.lock(file, editor);
            if (ds != null) {
                RecordFormat format = ds.getCharacteristics().getRecordFormat();
                int lrecl = ds.getCharacteristics().getRecordLength();
                if (!format.getName().startsWith("F")) {
                    lrecl -= 4;
                }
                editor.setColumnLimit(lrecl);
            }
            editor.initComplete(true);
            return;
        }
        editor.initComplete(false);
    }

    private boolean isWDzIResource(IResource resource) {
        IProject proj = resource.getProject();
        try {
            if (proj.hasNature("com.ibm.ftt.projects.core.offlinesubproject")) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public String getSourceCp(IFile file) {
        String cp = null;
        if (file != null) {
            String mappedCp;
            boolean isBinary;
            IProject project;
            String sosiEncoding;
            String useSOSI = LocalResourcePropertyUtils.getPropertyOrOverride((String)"DBCS.USESOSI", (IResource)file);
            if (useSOSI != null && useSOSI.equals("TRUE") && (sosiEncoding = LocalResourcePropertyUtils.getPropertyOrOverride((String)"DBCS.SOSIENCODING", (IResource)file)) != null) {
                cp = sosiEncoding;
            }
            if (cp == null && PBResourceUtils.isRemoteMVS((IResource)file) && (project = file.getProject()) != null && !(isBinary = ((ZOSResourceImpl)PBResourceUtils.getRemotePhysicalResource((IResource)file)).getMvsResource().isBinary())) {
                cp = ((ZOSResourceImpl)PBResourceUtils.getRemotePhysicalResource((IResource)file)).getMvsResource().getHostCp();
            }
            if (cp != null && (mappedCp = CodepageValidator.getCodepage(cp)) != null) {
                cp = mappedCp;
            }
        }
        return cp;
    }

    public boolean hasBadHex(IFile file) {
        ZOSResource ds = (ZOSResource)ZOSPhysicalResourceFinder.eINSTANCE.findPhysicalResource((IResource)file);
        boolean badHex = false;
        if (ds instanceof ZOSDataSetMemberImpl) {
            badHex = ((ZOSDataSetMemberImpl)ds).getFileCharacteristics().hasBadHex();
        } else if (ds instanceof ZOSSequentialDataSetImpl) {
            badHex = ((ZOSSequentialDataSetImpl)ds).getFileCharacteristics().hasBadHex();
        }
        return badHex;
    }

    private boolean lock(IFile file, IRemoteEditor editor) {
        boolean success = true;
        if (file != null) {
            try {
                int rc = LockManager.INSTANCE.lock((Object)editor, file);
                success = rc == 1 || rc == 2;
            }
            catch (LockException e) {
                TraceUtil.getInstance().write(this.getClass().getName(), "lock refused:" + e.getMessage());
                success = false;
                MessageDialog.openInformation((Shell)editor.getSite().getShell(), (String)NavigatorResources.PBResourceNavigator_editFileIsLockedTitle, (String)NavigatorResources.PBResourceNavigator_editSessionInReadOnlyMode);
            }
            if (!success) {
                editor.setReadOnly(true);
                TraceUtil.getInstance().write(this.getClass().getName(), "failed to acquire lock");
                MessageDialog.openInformation((Shell)editor.getSite().getShell(), (String)NavigatorResources.PBResourceNavigator_editFileIsLockedTitle, (String)NavigatorResources.PBResourceNavigator_fileLockError);
            }
        }
        return success;
    }

    private ZOSDataSet getDataSet(Object res) {
        IPhysicalResource physicalRes = null;
        if (res instanceof ILogicalResource) {
            physicalRes = ((ILogicalResource)res).getPhysicalResource();
        } else if (res instanceof IPhysicalResource) {
            physicalRes = (IPhysicalResource)res;
        }
        if (physicalRes instanceof ZOSDataSetMember) {
            ZOSPartitionedDataSet ds = ((ZOSDataSetMember)physicalRes).getDataset();
            return ds;
        }
        return null;
    }

    public void fileClosed(IFile file, IRemoteEditor editor) {
        Object res = ResourceUtil.getResource(file);
        if (res != null && (res instanceof ILogicalResource || res instanceof IPhysicalResource || this.isWDzIResource((IResource)res))) {
            this.unlock(file, editor);
        }
    }

    private void unlock(IFile file, IRemoteEditor editor) {
        editor.unsetReadOnly();
        if (file != null) {
            LockManager.INSTANCE.unlock((Object)editor, file);
            TraceUtil.getInstance().write(this.getClass().getName(), "unlocked file:" + file.getFullPath().toOSString());
        }
    }

    public void editorContextMenuAboutToShow(IMenuManager menu, IFile file, IRemoteEditor editor) {
        menu.add((IContributionItem)new Separator());
        MVSRemoteSyntaxCheck action = new MVSRemoteSyntaxCheck(file, editor);
        if (action.isEnabled()) {
            menu.add((IAction)action);
        }
    }

    private static final class TextEditorMessages {
        private static ResourceBundle _bundle;

        private TextEditorMessages() {
        }

        public static String getString(String key) {
            try {
                if (TextEditorMessages.getResourceBundle() != null) {
                    return _bundle.getString(key);
                }
            }
            catch (MissingResourceException missingResourceException) {}
            return "!" + key + "!";
        }

        public static ResourceBundle getResourceBundle() {
            if (_bundle == null) {
                _bundle = ResourceBundle.getBundle("org.eclipse.ui.editors.text.TextEditorMessages");
            }
            return _bundle;
        }
    }

    private class WDzActionHandler
    implements IActionHandler,
    ILockingConstants {
        private WDzActionHandler() {
        }

        public boolean saveAs(IRemoteEditor editor, IProgressMonitor progressMonitor) {
            IFile initialFile = null;
            IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                initialFile = ((IFileEditorInput)input).getFile();
            }
            return this.performSaveAs(progressMonitor, initialFile, editor);
        }

        private boolean performSaveAs(IProgressMonitor progressMonitor, IFile original, final IRemoteEditor editor) {
            boolean success;
            block35: {
                int n;
                Shell shell = editor.getSite().getShell();
                Object remoteObject = null;
                RSESaveAsSelectionObject object = RSEUtil.saveAsLocalAndRemote((boolean)true, (boolean)true, (boolean)true, (boolean)false, (Shell)shell);
                if (object == null) {
                    return true;
                }
                IFile file = null;
                if (object.getLocalOrRemoteObject() instanceof IContainer) {
                    IContainer c = (IContainer)object.getLocalOrRemoteObject();
                    file = c.getFile((IPath)new Path(object.getTargetFileName()));
                } else if (object.getLocalOrRemoteObject() instanceof IPhysicalResource) {
                    block33: {
                        IPhysicalResource pRes = (IPhysicalResource)object.getLocalOrRemoteObject();
                        String targetName = object.getTargetFileName().toUpperCase();
                        int lockResult = 0;
                        try {
                            lockResult = LockManager.INSTANCE.lock((Object)this, pRes, targetName);
                            if (lockResult == 1 || lockResult == 2) break block33;
                            String message = NLS.bind((String)MvsLpexResources.Err_SaveAs_NewLockFailed, (Object)targetName);
                            String title = MvsLpexResources.Err_SaveAs_Title;
                            MessageDialog.openWarning((Shell)shell, (String)title, (String)message);
                            return true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (lockResult == 1) {
                                lockResult = LockManager.INSTANCE.unlock((Object)this, pRes, targetName);
                            }
                            return true;
                        }
                    }
                    remoteObject = RSEUtil.createRemoteObject((Object)object.getLocalOrRemoteObject(), (String)object.getTargetFileName(), (InputStream)new ByteArrayInputStream(new byte[0]), null);
                    file = ((ZOSDataSetMemberImpl)remoteObject).getMvsResource().getFile(progressMonitor);
                    MVSFileSubSystem ss = (MVSFileSubSystem)RemoteEditableUtil.getRemoteSubSystem((IFile)original);
                    String containerPath = object.getContainerPath();
                    int colonIndex = containerPath.indexOf(58);
                    containerPath = containerPath.substring(colonIndex + 1);
                    String folderOrFileName = String.valueOf(containerPath) + "/" + object.getTargetFileName().toUpperCase();
                    MVSFileResource fileResource = null;
                    try {
                        fileResource = ss.getRemoteFileObject(folderOrFileName);
                        MVSSystemEditableRemoteFile editableFile = new MVSSystemEditableRemoteFile(fileResource);
                        if (editableFile != null) {
                            PBSystemIFileProperties properties = new PBSystemIFileProperties((IResource)file);
                            properties.setRemoteEditObject(remoteObject);
                            editableFile.setLocalResourceProperties();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                FileEditorInput newInput = new FileEditorInput(file);
                WorkspaceModifyOperation op = new WorkspaceModifyOperation((IEditorInput)newInput){
                    private final /* synthetic */ IEditorInput val$newInput;
                    {
                        this.val$newInput = iEditorInput;
                    }

                    public void execute(IProgressMonitor monitor) throws CoreException {
                        editor.getDocumentProvider().saveDocument(monitor, (Object)this.val$newInput, editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()), true);
                    }
                };
                success = false;
                try {
                    editor.getDocumentProvider().aboutToChange((Object)newInput);
                    new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)op);
                    success = true;
                }
                catch (InterruptedException interruptedException) {
                    editor.getDocumentProvider().changed((Object)newInput);
                    if (!success) break block35;
                    IFile oldFile = this.getIFile(editor);
                    editor.setInput((IEditorInput)newInput);
                    RemoteCEditor ceditor = (RemoteCEditor)editor;
                    ceditor.removeEditorContexts();
                    try {
                        ceditor.setEditorInput((IEditorInput)newInput);
                    }
                    catch (Exception exception) {}
                    ceditor.getEditorContext().setPrimarySource(file);
                    n = LockManager.INSTANCE.unlock((Object)this, oldFile);
                    break block35;
                }
                catch (InvocationTargetException x) {
                    block36: {
                        try {
                            Throwable targetException = x.getTargetException();
                            String title = TextEditorMessages.getString("Editor.error.save.title");
                            String msg = MessageFormat.format(TextEditorMessages.getString("Editor.error.save.message"), targetException.getMessage());
                            if (!(targetException instanceof CoreException)) break block36;
                            CoreException coreException = (CoreException)targetException;
                            IStatus status = coreException.getStatus();
                            if (status != null) {
                                switch (status.getSeverity()) {
                                    case 1: {
                                        MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                                        break;
                                    }
                                    case 2: {
                                        MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                                        break;
                                    }
                                    default: {
                                        MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                                        break;
                                    }
                                }
                                break block36;
                            }
                            MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                        }
                        catch (Throwable throwable) {
                            editor.getDocumentProvider().changed((Object)newInput);
                            if (success) {
                                IFile oldFile = this.getIFile(editor);
                                editor.setInput((IEditorInput)newInput);
                                RemoteCEditor ceditor = (RemoteCEditor)editor;
                                ceditor.removeEditorContexts();
                                try {
                                    ceditor.setEditorInput((IEditorInput)newInput);
                                }
                                catch (Exception exception) {}
                                ceditor.getEditorContext().setPrimarySource(file);
                                n = LockManager.INSTANCE.unlock((Object)this, oldFile);
                            }
                            throw throwable;
                        }
                    }
                    editor.getDocumentProvider().changed((Object)newInput);
                    if (!success) break block35;
                    IFile oldFile = this.getIFile(editor);
                    editor.setInput((IEditorInput)newInput);
                    RemoteCEditor ceditor = (RemoteCEditor)editor;
                    ceditor.removeEditorContexts();
                    try {
                        ceditor.setEditorInput((IEditorInput)newInput);
                    }
                    catch (Exception exception) {}
                    ceditor.getEditorContext().setPrimarySource(file);
                    n = LockManager.INSTANCE.unlock((Object)this, oldFile);
                    break block35;
                }
                editor.getDocumentProvider().changed((Object)newInput);
                if (success) {
                    IFile oldFile = this.getIFile(editor);
                    editor.setInput((IEditorInput)newInput);
                    RemoteCEditor ceditor = (RemoteCEditor)editor;
                    ceditor.removeEditorContexts();
                    try {
                        ceditor.setEditorInput((IEditorInput)newInput);
                    }
                    catch (Exception exception) {}
                    ceditor.getEditorContext().setPrimarySource(file);
                    n = LockManager.INSTANCE.unlock((Object)this, oldFile);
                }
            }
            if (progressMonitor != null) {
                progressMonitor.setCanceled(!success);
            }
            return true;
        }

        private IFile getIFile(IRemoteEditor editor) {
            IFile file = null;
            IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                file = ((IFileEditorInput)input).getFile();
            }
            return file;
        }

        public String getFileActionInput(IRemoteEditor editor) {
            Shell shell = RSEUIPlugin.getActiveWorkbenchShell();
            Object selectedObject = RSEUtil.browseLocalAndRemoteFiles((boolean)true, (boolean)true, (boolean)true, (boolean)false, (Shell)shell);
            if (selectedObject == null) {
                return null;
            }
            IFile file = null;
            try {
                if (selectedObject instanceof IFile) {
                    file = (IFile)selectedObject;
                } else if (selectedObject instanceof LZOSResource) {
                    LZOSResource selectedMember = (LZOSResource)selectedObject;
                    file = ((ZOSResourceImpl)selectedMember.getPhysicalResource()).getMvsResource().getFile((IProgressMonitor)new NullProgressMonitor());
                } else if (selectedObject instanceof MVSFileResource) {
                    MVSFileResource selectedMVSResource = (MVSFileResource)selectedObject;
                    file = ((ZOSResourceImpl)selectedMVSResource.getZOSResource()).getMvsResource().getFile((IProgressMonitor)new NullProgressMonitor());
                }
                return file.getLocation().toOSString();
            }
            catch (RemoteFileException e) {
                SystemMessageDialog dialog = new SystemMessageDialog(shell, e.getSystemMessage());
                dialog.open();
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private class WDzContext
    implements IEditorContext {
        private Object res;
        private WDzActionHandler actionHandler;
        private WDzIncludeHandler includeHandler;
        private MVSResourceResolver resourceResolver;
        private WDzHelpResolver helpResolver;
        private IFile _primarySource;

        public WDzContext(IFile file, Object res) {
            this.res = res;
            this.actionHandler = new WDzActionHandler();
            this.includeHandler = new WDzIncludeHandler();
            this.resourceResolver = new MVSResourceResolver();
            this.helpResolver = new WDzHelpResolver();
            this._primarySource = file;
        }

        public IActionHandler getActionHandler() {
            return this.actionHandler;
        }

        public IHelpResolver getHelpResolver() {
            return this.helpResolver;
        }

        public IIncludeHandler getIncludeHandler() {
            return this.includeHandler;
        }

        public String getName() {
            if (this.res instanceof ILogicalResource) {
                ILogicalResource resource = (ILogicalResource)this.res;
                return Messages.getReplacedMessage(Messages.WDzInfoProvider_1, new Object[]{resource.getFullPath().toString()});
            }
            if (this.res instanceof IPhysicalResource) {
                IPhysicalResource resource = (IPhysicalResource)this.res;
                StringBuffer buffer = new StringBuffer();
                buffer.append(String.valueOf(resource.getSystem().getName()) + "/");
                buffer.append(resource.getFullPath().toString());
                return Messages.getReplacedMessage(Messages.WDzInfoProvider_2, new Object[]{buffer.toString()});
            }
            if (this.res instanceof IResource) {
                return Messages.WDzInfoProvider_3;
            }
            return Messages.WDzInfoProvider_4;
        }

        public IVariableResolver getVariableResolver() {
            return null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WDzContext) {
                return true;
            }
            return super.equals(obj);
        }

        public String getContextType() {
            return "mvs";
        }

        public IResourceResolver getResourceResolver() {
            return this.resourceResolver;
        }

        public IFile getPrimarySource() {
            return this._primarySource;
        }

        public void setPrimarySource(IFile primary) {
            this._primarySource = primary;
        }
    }

    private class WDzHelpResolver
    implements IHelpResolver {
        private WDzHelpResolver() {
        }

        public boolean getHelp(IFile file, String token) {
            if (token != null) {
                boolean success = this.getInternalHelp(file, token);
                if (!success) {
                    success = this.getInternalHelp(file, String.valueOf(token) + "_help");
                }
                return success;
            }
            return this.getInternalHelp(file, "default_help");
        }

        private boolean getInternalHelp(IFile file, String token) {
            IWorkbenchHelpSystem system = PlatformUI.getWorkbench().getHelpSystem();
            String value = null;
            Properties prop = F1HelpUtil.getProperties();
            if (prop != null && (value = (String)prop.get(token)) != null) {
                system.displayHelpResource(value);
                return true;
            }
            prop = F1HelpUtil.getLibProperties();
            if (prop != null && (value = (String)prop.get(token)) != null) {
                system.displayHelpResource(value);
                return true;
            }
            return false;
        }
    }

    private class WDzIncludeHandler
    implements IIncludeHandler {
        private WDzIncludeHandler() {
        }

        public IScannerInfo getIncludeInformation(IFile file) {
            Object res = ResourceUtil.getResource(file);
            if (res != null) {
                if (res instanceof ILogicalResource) {
                    return this.logicalScannerInfo(res);
                }
                if (res instanceof IPhysicalResource) {
                    return this.physicalScannerInfo((IPhysicalResource)res);
                }
                return this.logicalScannerInfo(res);
            }
            return new ScannerInfo();
        }

        public IScannerInfo getMacrosOnly(IFile file) {
            return this.getIncludeInformation(file);
        }

        private IExtendedScannerInfo physicalScannerInfo(final IPhysicalResource resource) {
            String useC = PhysicalPropertyManager.getManager().getPropertyOrOverride(resource, "CPP.COMPILE.USEC");
            final boolean isUsingC = this.isUsingC(useC);
            return new IExtendedScannerInfo(){

                public String[] getMacroFiles() {
                    return null;
                }

                public String[] getIncludeFiles() {
                    return null;
                }

                public String[] getLocalIncludePath() {
                    String incString;
                    String string = incString = !isUsingC ? PhysicalPropertyManager.getManager().getPropertyOrOverride(resource, "CPP.COMPILE.USERLIB") : PhysicalPropertyManager.getManager().getPropertyOrOverride(resource, "CPP.COMPILE.CUSERLIB");
                    if (incString != null) {
                        String[] incPaths = incString.split(" ");
                        incPaths = this.prependWithHost(incPaths);
                        return incPaths;
                    }
                    return new String[0];
                }

                public Map getDefinedSymbols() {
                    String[] symbols;
                    String symString;
                    String string = symString = !isUsingC ? PhysicalPropertyManager.getManager().getPropertyOrOverride(resource, "CPP.COMPILE.MACROS") : PhysicalPropertyManager.getManager().getPropertyOrOverride(resource, "CPP.COMPILE.CMACROS");
                    if (symString == null || symString.length() == 0) {
                        symString = "errno=(*__errno()),__TARGET_LIB__=0x20000000".replace(',', ' ');
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    if (symString != null && (symbols = symString.split(" ")) != null) {
                        int i = 0;
                        while (i < symbols.length) {
                            String symbol = symbols[i];
                            String[] keyval = symbol.split("=");
                            if (keyval != null && keyval[0].length() > 0) {
                                map.put(keyval[0], keyval.length == 2 ? keyval[1] : "");
                            }
                            ++i;
                        }
                    }
                    return map;
                }

                public String[] getIncludePaths() {
                    String syslib;
                    String options = !isUsingC ? PhysicalPropertyManager.getManager().getPropertyOrOverride(resource, "CPP.COMPILE.OPTIONS") : PhysicalPropertyManager.getManager().getPropertyOrOverride(resource, "CPP.COMPILE.COPTIONS");
                    StringBuffer incString = this.extractSearchString(options);
                    String string = syslib = !isUsingC ? PhysicalPropertyManager.getManager().getPropertyOrOverride(resource, "CPP.COMPILE.SYSLIB") : PhysicalPropertyManager.getManager().getPropertyOrOverride(resource, "CPP.COMPILE.CSYSLIB");
                    if (syslib != null) {
                        incString.append(" " + syslib);
                    }
                    if (incString != null) {
                        String[] incPaths = incString.toString().split(" ");
                        incPaths = this.prependWithHost(incPaths);
                        return incPaths;
                    }
                    return new String[0];
                }

                private StringBuffer extractSearchString(String options) {
                    StringBuffer result = new StringBuffer();
                    if (options != null) {
                        try {
                            String substring;
                            int endIndex;
                            int index = options.lastIndexOf("SEARCH(");
                            if (index != -1 && (endIndex = (substring = options.substring(index + "SEARCH(".length())).indexOf(")")) != -1) {
                                String optionsList = substring.substring(0, endIndex);
                                result.append(optionsList.replaceAll(",", " "));
                            }
                        }
                        catch (Exception exception) {}
                    }
                    return result;
                }

                private String[] prependWithHost(String[] incPaths) {
                    if (incPaths != null) {
                        int i = 0;
                        while (i < incPaths.length) {
                            incPaths[i] = "\\\\" + resource.getSystem().getName() + "\\" + incPaths[i];
                            ++i;
                        }
                    }
                    return incPaths;
                }
            };
        }

        private boolean isUsingC(String useC) {
            if (useC != null) {
                return useC.equalsIgnoreCase("TRUE");
            }
            return false;
        }

        private IExtendedScannerInfo logicalScannerInfo(final Object resource) {
            String useC = LogicalPropertyManager.getManager().getPropertyOrOverride(resource, "CPP.COMPILE.USEC");
            final boolean isUsingC = this.isUsingC(useC);
            return new IExtendedScannerInfo(){

                public String[] getMacroFiles() {
                    return null;
                }

                public String[] getIncludeFiles() {
                    return null;
                }

                public String[] getLocalIncludePath() {
                    String incString;
                    String string = incString = !isUsingC ? LogicalPropertyManager.getManager().getPropertyOrOverride(resource, "CPP.COMPILE.USERLIB") : LogicalPropertyManager.getManager().getPropertyOrOverride(resource, "CPP.COMPILE.CUSERLIB");
                    if (incString != null && incString.length() > 0) {
                        String[] incPaths = incString.split(" ");
                        incPaths = this.prependWithHost(incPaths);
                        return incPaths;
                    }
                    return new String[0];
                }

                public Map getDefinedSymbols() {
                    String[] symbols;
                    String symString = !isUsingC ? LogicalPropertyManager.getManager().getPropertyOrOverride(resource, "CPP.COMPILE.MACROS") : LogicalPropertyManager.getManager().getPropertyOrOverride(resource, "CPP.COMPILE.CMACROS");
                    HashMap<String, String> map = new HashMap<String, String>();
                    if (symString != null && symString.length() > 0 && (symbols = symString.split(" ")) != null) {
                        int i = 0;
                        while (i < symbols.length) {
                            String symbol = symbols[i];
                            String[] keyval = symbol.split("=");
                            if (keyval != null) {
                                map.put(keyval[0], keyval.length == 2 ? keyval[1] : "");
                            }
                            ++i;
                        }
                    }
                    return map;
                }

                public String[] getIncludePaths() {
                    String incString;
                    String string = incString = !isUsingC ? LogicalPropertyManager.getManager().getPropertyOrOverride(resource, "CPP.COMPILE.SYSLIB") : LogicalPropertyManager.getManager().getPropertyOrOverride(resource, "CPP.COMPILE.CSYSLIB");
                    if (incString != null && incString.length() > 0) {
                        String[] incPaths = incString.split(" ");
                        incPaths = this.prependWithHost(incPaths);
                        return incPaths;
                    }
                    return new String[0];
                }

                private String[] prependWithHost(String[] incPaths) {
                    if (incPaths != null) {
                        int i = 0;
                        while (i < incPaths.length) {
                            if (resource instanceof ILogicalResource) {
                                incPaths[i] = "\\\\" + ((ILogicalResource)resource).getPhysicalResource().getSystem().getName() + "\\" + incPaths[i];
                            } else if (resource instanceof IResource) {
                                IPhysicalResource res = PBResourceUtils.getRemotePhysicalResource((IResource)((IResource)resource));
                                incPaths[i] = "\\\\" + res.getSystem().getName() + "\\" + incPaths[i];
                            }
                            ++i;
                        }
                    }
                    return incPaths;
                }
            };
        }
    }
}

