##################################################################
#
#  Makefile for creating fttfdbkw.lib and fttfdbkw.dll for Windows
#
##################################################################

#-----------------------------------------------------------------
#  Set normal options for c compiler
#-----------------------------------------------------------------
CFLAGS = /Q+ /Ge- /Se /C+

#-----------------------------------------------------------------
#  Set the debugger flags as requested.
#-----------------------------------------------------------------
!ifdef DEBUG
DFLAGS = /Ti+
LFLAGS = /DEBUG
!else
DFLAGS = /Ti-
LFLAGS = /NODEBUG
!endif

#-----------------------------------------------------------------
#  Set the flags for optimization as requested.
#-----------------------------------------------------------------
!ifdef OPTIMIZE
OFLAGS = /Gf+ /Gi+ /Oi300 /Om- /O+
!else
OFLAGS =
!endif

#-----------------------------------------------------------------
#  Set the path to the source and object files for this level
#-----------------------------------------------------------------
!ifndef BASEDRIVE
BASEDRIVE = F
!endif
OBJPATH = $(BASEDRIVE):\cobrtew\obj
!ifndef SOURCEPATH
SOURCEPATH = $(BASEDRIVE):\cobrtew\source
!endif

#-----------------------------------------------------------------
#  All object files required for the library
#-----------------------------------------------------------------
OBJS = fttfdbkw.obj

#-----------------------------------------------------------------
#  All c files required for the library
#-----------------------------------------------------------------
CFILES = fttfdbkw.c

#-----------------------------------------------------------------
#  CopyRight stub
#-----------------------------------------------------------------
CPRTSTUB = comcopyr.exe

#-----------------------------------------------------------------
#  Basic settings for makefile
#-----------------------------------------------------------------
.IGNORE:
.SUFFIXES: .dll

#-----------------------------------------------------------------
#  alpha is the set up process, no longer used by default
#-----------------------------------------------------------------
all: fttfdbkw.dll

#-----------------------------------------------------------------
#  Copy all object, header, c, and assembler files required by
#  the library
#-----------------------------------------------------------------
alpha:
        wcpyfile $(OBJPATH) $(OBJS) >nul 2>nul
        wcpyfile $(SOURCEPATH) $(CFILES) >nul 2>nul
        wcpyfile $(BASEDRIVE):\cobrtew\cmd $(CPRTSTUB) >nul 2>nul

cleanup:
        del *.obj
        del *.c

fttfdbkw.dll: $(OBJS)
        ilib /NOLOGO /GI fttfdbkw.obj
        ilink /NOLOGO /FREE /DLL $(LFLAGS) /MAP fttfdbkw.exp fttfdbkw.obj \
        /STUB:$(CPRTSTUB)
        erase fttfdbkw.exp

#-----------------------------------------------------------------
#  Dependency lists
#-----------------------------------------------------------------
fttfdbkw.obj: fttfdbkw.c
        icc $(CFLAGS) $(DFLAGS) $(OFLAGS) $*.c

#-----------------------------------------------------------------
#  Dependency lists for header files, any header file dependant
#  on other header files is 'touched' to bring it into date
#  compliance
#-----------------------------------------------------------------
