/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.shadowline;

import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.FMIResourceIterator;
import com.ibm.fmi.model.IRecordHeaderContainer;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.RecordHeader;
import com.ibm.fmi.model.RecordLayout;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.shadowline.ShadowLine;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlaceholderHiddenSet
extends ShadowLine
implements IRecordHeaderContainer {
    private int numRecords = -1;
    private RecordHeader header = null;
    private byte[] data = null;

    @Override
    public RecordHeader getHeader() {
        return this.header;
    }

    public RecordHeader copyHeader() {
        return this.header.copy();
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setHeader(RecordHeader header) {
        this.header = header;
    }

    public void setHeader(byte[] header) {
        this.header = new RecordHeader(header);
    }

    @Override
    public int getNumRecords() {
        return this.numRecords;
    }

    public void setNumRecords(int numRecords) {
        this.numRecords = numRecords;
    }

    @Override
    public DisplayLine copy() throws FMIModelException {
        throw new FMIModelException("Cannot copy this line");
    }

    @Override
    public boolean mergeBeginning(DisplayLine toMerge) {
        return false;
    }

    @Override
    public boolean mergeEnd(DisplayLine toMerge) {
        return false;
    }

    @Override
    public abstract String getMessage(int var1);

    @Override
    public boolean storesRecordData() {
        return false;
    }

    @Override
    public boolean canSplit() {
        return false;
    }

    @Override
    public DisplayLine splitOffBeginning() {
        return null;
    }

    @Override
    public DisplayLine splitOffEnd() {
        return null;
    }

    @Override
    public DisplayLine splitOffBeginning(int numUpper) {
        return null;
    }

    @Override
    public DisplayLine splitOffEnd(int numLower) {
        return null;
    }

    @Override
    public byte[] getFullEbcdic() {
        byte[] headerBytes = this.header.getBytes();
        int width = this.data != null ? this.data.length + headerBytes.length : headerBytes.length;
        byte[] ebcdic = new byte[width];
        int i = 0;
        while (i < headerBytes.length) {
            ebcdic[i] = headerBytes[i];
            ++i;
        }
        if (this.data != null) {
            int j = headerBytes.length;
            while (j < ebcdic.length) {
                ebcdic[j] = this.data[j - headerBytes.length];
                ++j;
            }
        }
        return ebcdic;
    }

    @Override
    public List<DisplayLine> changeLayout(RecordLayout layout) throws FMIModelException {
        ArrayList<DisplayLine> toReturn = new ArrayList<DisplayLine>(1);
        toReturn.add(this);
        return toReturn;
    }

    @Override
    public FMIResourceIterator<Record> getRecordIterator() {
        return new FMIResourceIterator<Record>(null);
    }

    @Override
    public boolean containsDuplicateKey() {
        return false;
    }
}

