/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.shadowline;

import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.RecordLayout;
import com.ibm.fmi.model.TemplattedData;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.shadowline.HiddenSet;
import com.ibm.fmi.model.shadowline.ShadowLine;
import com.ibm.fmi.model.shadowline.SuppressedSet;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcludedSet
extends HiddenSet {
    @Override
    public boolean isOfSet(byte[] record) {
        return false;
    }

    @Override
    public String getMessage(int numRecords) {
        return String.valueOf(numRecords) + " records excluded";
    }

    @Override
    public ShadowLine getInstance() {
        return new ExcludedSet();
    }

    @Override
    public RecordLayout getLayout() {
        if (this.records.size() > 0) {
            return ((Record)this.records.get(0)).getLayout();
        }
        return null;
    }

    @Override
    public boolean canSplit() {
        return this.records != null && this.records.size() > 1;
    }

    @Override
    public DisplayLine splitOffBeginning() throws FMIModelException {
        ExcludedSet newSet = new ExcludedSet();
        newSet.setParent(this.parent);
        newSet.addRecord((Record)this.records.remove(0));
        return newSet;
    }

    @Override
    public DisplayLine splitOffEnd() throws FMIModelException {
        ExcludedSet newSet = new ExcludedSet();
        newSet.setParent(this.parent);
        newSet.addRecord((Record)this.records.remove(this.records.size() - 1));
        return newSet;
    }

    @Override
    public List<DisplayLine> changeLayout(RecordLayout newLayout) throws FMIModelException {
        ArrayList<DisplayLine> newSet = new ArrayList<DisplayLine>(1);
        if (this.layout == newLayout) {
            newSet.add(this);
        } else {
            SuppressedSet suppSet = new SuppressedSet();
            suppSet.setParent(this.parent);
            suppSet.addModelListener((TemplattedData)this.parent);
            suppSet.setLayout(this.layout);
            for (Record r : this.records) {
                suppSet.addRecord(r);
                r.setParent(suppSet);
                r.removeModelListener(this);
                r.addModelListener(suppSet);
                r.getHeader().setSuppressed();
            }
            this.records.clear();
            newSet.add(suppSet);
        }
        return newSet;
    }

    @Override
    protected boolean canMerge(HiddenSet target) {
        return target instanceof ExcludedSet;
    }
}

