/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.key;

import com.ibm.fmi.model.FMIDisplayLineRecordIterator;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.TemplattedData;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.key.KSDSKey;
import com.ibm.fmi.model.key.KSDSKeyDuplicateEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KSDSKeyIndex {
    private List<KSDSKeyDuplicateEntry> duplicateKeys;
    private TemplattedData model;

    public KSDSKeyIndex(KSDSKey key, TemplattedData model) {
        this.model = model;
        this.duplicateKeys = new ArrayList<KSDSKeyDuplicateEntry>();
    }

    public void handleKeyDeletion(Record r) throws FMIKeyException, FMIModelException {
        KSDSKeyDuplicateEntry oldEntry = new KSDSKeyDuplicateEntry(r.getKeyContent(), r, this);
        for (KSDSKeyDuplicateEntry entry : this.duplicateKeys) {
            if (!entry.equals(oldEntry)) continue;
            entry.removeRecord(r);
            if (entry.numRecords() != 0) break;
            this.duplicateKeys.remove(entry);
            break;
        }
    }

    public void handleKeyAddition(Record r) throws FMIKeyException, FMIModelException {
        byte[] newKey = r.getKeyContent();
        KSDSKeyDuplicateEntry newEntry = new KSDSKeyDuplicateEntry(r.getKeyContent(), r, this);
        for (KSDSKeyDuplicateEntry entry : this.duplicateKeys) {
            if (!entry.equals(newEntry)) continue;
            entry.addRecord(r);
            return;
        }
        FMIDisplayLineRecordIterator rIter = this.model.getDisplayLineRecordIterator();
        while (rIter.hasNext()) {
            Record rec = rIter.next();
            if (!Arrays.equals(newKey, rec.getKeyContent())) continue;
            KSDSKeyDuplicateEntry newDupeEntry = new KSDSKeyDuplicateEntry(newKey, r, this);
            newDupeEntry.addRecord(rec);
            this.duplicateKeys.add(newDupeEntry);
            break;
        }
    }

    public void handleKeyChange(Record r, byte[] oldKey) throws FMIKeyException, FMIModelException {
        byte[] newKey = r.getKeyContent();
        KSDSKeyDuplicateEntry oldEntry = new KSDSKeyDuplicateEntry(oldKey, null, this);
        KSDSKeyDuplicateEntry newEntry = new KSDSKeyDuplicateEntry(newKey, r, this);
        for (KSDSKeyDuplicateEntry entry : this.duplicateKeys) {
            if (!entry.equals(oldEntry)) continue;
            entry.removeRecord(r);
            if (entry.numRecords() != 0) break;
            this.duplicateKeys.remove(entry);
            break;
        }
        for (KSDSKeyDuplicateEntry entry : this.duplicateKeys) {
            if (!entry.equals(newEntry)) continue;
            entry.addRecord(r);
            return;
        }
        FMIDisplayLineRecordIterator rIter = this.model.getDisplayLineRecordIterator();
        while (rIter.hasNext()) {
            Record rec = rIter.next();
            if (rec == r || !Arrays.equals(newKey, rec.getKeyContent())) continue;
            KSDSKeyDuplicateEntry newDupeEntry = new KSDSKeyDuplicateEntry(newKey, r, this);
            newDupeEntry.addRecord(rec);
            this.duplicateKeys.add(newDupeEntry);
            break;
        }
    }

    public boolean containsDuplicates() {
        return this.duplicateKeys.size() > 0;
    }
}

