/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.fm;

import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.fm.CopyMemberSegment;
import com.ibm.fmi.model.fm.CriteriaSegment;
import com.ibm.fmi.model.fm.DatasetNameSegment;
import com.ibm.fmi.model.fm.DynamicTemplateExpressionSegment;
import com.ibm.fmi.model.fm.FieldMappingSegment;
import com.ibm.fmi.model.fm.MainFieldDescriptorSegment;
import com.ibm.fmi.model.fm.PrintHeadingSegment;
import com.ibm.fmi.model.fm.SaveFileSegment;
import com.ibm.fmi.model.fm.SavedElementsSegment;
import com.ibm.fmi.model.fm.Segment;
import com.ibm.fmi.model.fm.SegmentHeader;
import com.ibm.fmi.model.fm.SourceStatementSegment;
import java.nio.ByteBuffer;

public class SegmentFactory {
    private static final short DB2_COLUMNS = 3;
    private static final short COPY_MEMBER = 10;
    private static final short DATASET_NAME = 11;
    private static final short OBJECT_MEMBER_COMMENTS = 12;
    private static final short IMS_DATASET_NAME_MEMBER = 13;
    private static final short IMS_CRITERIA = 14;
    private static final short IMS_DBD = 15;
    private static final short IMS_LAST_UPDATE = 16;
    private static final short MULTIPLE_COPYBOOKS = 17;
    private static final short MAIN_FIELD_DESCRIPTOR = 20;
    private static final short SELECTION_CRITERIA = 21;
    private static final short IDENTIFICATION_CRITERIA = 22;
    private static final short DB2_SELECTION_CRITERIA = 23;
    private static final short FIELD_MAPPING = 24;
    private static final short SOURCE_STATEMENT = 25;
    private static final short DYNAMIC_TEMPLATE_EXPRESSION = 26;
    private static final short PRINT_HEADING = 30;
    private static final short SAVED_ELEMENTS = 31;
    private static final short ATTRIBUTE_INFORMATION = 40;
    private static final short DB2_ISQ_HEADER = 41;
    private static final short SAVE_FILE_CONTROL = 99;

    public static Segment buildSegment(SegmentHeader header, ByteBuffer buf) throws FMIParseException {
        switch (header.getType()) {
            case 3: {
                throw new FMIParseException("DB2 Templates are not supported");
            }
            case 10: {
                return new CopyMemberSegment(buf);
            }
            case 11: {
                return new DatasetNameSegment(buf);
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 23: 
            case 40: 
            case 41: {
                throw new FMIParseException(String.valueOf(header.getType()) + ": unsupported type specified in template");
            }
            case 26: {
                return new DynamicTemplateExpressionSegment(buf);
            }
            case 20: {
                return new MainFieldDescriptorSegment(buf);
            }
            case 21: 
            case 22: {
                return new CriteriaSegment(buf);
            }
            case 24: {
                return new FieldMappingSegment(buf);
            }
            case 25: {
                return new SourceStatementSegment(buf);
            }
            case 30: {
                return new PrintHeadingSegment(buf);
            }
            case 31: {
                return new SavedElementsSegment(buf);
            }
            case 99: {
                return new SaveFileSegment(buf);
            }
        }
        return null;
    }
}

