/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.fm;

import com.ibm.fmi.model.ByteUtilities;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.fm.Symbol;
import java.nio.ByteBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RelocationTable {
    private final int FREE_AREA_LENGTH = 8;
    private final int DATE_LENGTH = 8;
    private final int TIME_LENGTH = 8;
    private final int FLAG_LENGTH = 2;
    private final byte DYNAMIC_BIT = (byte)8;
    private final byte IMSEXTENDED_BIT = (byte)7;
    private final byte SEGMENTED_BIT = (byte)6;
    public static final int TYPE_STANDARD = 0;
    public static final int TYPE_LANGUAGE_TMPL = 0;
    private static final int BASE_TYPE = 0;
    private static final int IMS_TYPE = 1;
    private static final int DB2_TYPE = 2;
    private static final int IMS_VIEW_TYPE = 3;
    private static final int IMS_CRITERIA_TYPE = 4;
    private static final int DYNAMIC_TYPE = 5;
    private static final int COBOL_LANGUAGE = 0;
    private static final int PL1_LANGUAGE = 1;
    private int blockLen;
    private int symbolCount;
    private int rexxOffset;
    private int rexxLen;
    private String date;
    private String time;
    private DatasetType type;
    private TemplateLanguage lang;
    private boolean dynamicTemplate;
    private boolean imsExtended;
    private boolean segmented;
    private int imsRexxOffset;
    private int imsRexxLen;
    private int db2ColumnsOffset;
    private int expressionOffset;
    private int expressionLen;
    private ArrayList<Symbol> symbols;

    public RelocationTable(ByteBuffer byteBuf) throws FMIParseException {
        this.fillHeader(byteBuf);
        this.fillSymbolTable(byteBuf);
    }

    private void fillHeader(ByteBuffer byteBuf) throws FMIParseException {
        this.blockLen = byteBuf.getInt();
        this.symbolCount = byteBuf.getInt();
        this.rexxOffset = byteBuf.getInt();
        this.rexxLen = byteBuf.getInt();
        try {
            this.date = ByteUtilities.getString(byteBuf, 8);
            this.time = ByteUtilities.getString(byteBuf, 8);
        }
        catch (FMIConversionException fMIConversionException) {
            throw new FMIParseException();
        }
        this.getType(byteBuf);
        this.getLanguage(byteBuf);
        byte[] flags = ByteUtilities.getBytes(byteBuf, 2);
        this.dynamicTemplate = ByteUtilities.testBit(flags[0], 8);
        this.imsExtended = ByteUtilities.testBit(flags[0], 7);
        this.segmented = ByteUtilities.testBit(flags[0], 6);
        this.imsRexxOffset = byteBuf.getInt();
        this.imsRexxLen = byteBuf.getInt();
        this.db2ColumnsOffset = byteBuf.getInt();
        this.expressionOffset = byteBuf.getInt();
        this.expressionLen = byteBuf.getInt();
        byteBuf.position(byteBuf.position() + 8);
    }

    private void getType(ByteBuffer buf) throws FMIParseException {
        byte typeByte = buf.get();
        switch (typeByte) {
            case 0: {
                this.type = DatasetType.BASE;
                return;
            }
            case 1: 
            case 3: 
            case 4: {
                throw new FMIParseException("IMS not supported");
            }
            case 2: {
                throw new FMIParseException("DB2 not supported");
            }
            case 5: {
                throw new FMIParseException("Parse error - template not dynamic");
            }
        }
        throw new FMIParseException("Unknown dataset type");
    }

    private void getLanguage(ByteBuffer buf) throws FMIParseException {
        byte typeByte = buf.get();
        switch (typeByte) {
            case 0: {
                this.lang = TemplateLanguage.COBOL;
                return;
            }
            case 1: {
                this.lang = TemplateLanguage.PL1;
                return;
            }
        }
        throw new FMIParseException("Unknown template langauge");
    }

    private void fillSymbolTable(ByteBuffer byteBuf) {
        this.symbols = new ArrayList(this.symbolCount);
        int i = 0;
        while (i < this.symbolCount) {
            Symbol s = new Symbol(byteBuf);
            this.symbols.add(s);
            ++i;
        }
    }

    public int getBlockLen() {
        return this.blockLen;
    }

    public String getDate() {
        return this.date;
    }

    public int getDb2ColumnsOffset() {
        return this.db2ColumnsOffset;
    }

    public boolean isDynamicTemplate() {
        return this.dynamicTemplate;
    }

    public int getExpressionLen() {
        return this.expressionLen;
    }

    public int getExpressionOffset() {
        return this.expressionOffset;
    }

    public boolean isImsExtended() {
        return this.imsExtended;
    }

    public int getImsRexxLen() {
        return this.imsRexxLen;
    }

    public int getImsRexxOffset() {
        return this.imsRexxOffset;
    }

    public TemplateLanguage getLang() {
        return this.lang;
    }

    public int getRexxLen() {
        return this.rexxLen;
    }

    public int getRexxOffset() {
        return this.rexxOffset;
    }

    public boolean isSegmented() {
        return this.segmented;
    }

    public int getSymbolCount() {
        return this.symbolCount;
    }

    public ArrayList<Symbol> getSymbols() {
        return this.symbols;
    }

    public String getTime() {
        return this.time;
    }

    public DatasetType getType() {
        return this.type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DatasetType {
        BASE,
        IMS,
        DB2,
        IMS_VIEW,
        IMS_CRITERIA,
        DYNAMIC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TemplateLanguage {
        COBOL,
        PL1;

    }
}

