/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.fm;

import com.ibm.fmi.model.ByteUtilities;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.fm.Segment;
import java.nio.ByteBuffer;

class PrintHeadingSegment
extends Segment {
    private short headingLen;
    private String heading;

    PrintHeadingSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
    }

    protected void parse(ByteBuffer buf) throws FMIParseException {
        this.headingLen = buf.getShort();
        try {
            if (this.headingLen > 0) {
                this.heading = ByteUtilities.getString(buf, this.headingLen);
            }
        }
        catch (FMIConversionException fMIConversionException) {
            throw new FMIParseException();
        }
    }

    public String getHeading() {
        return this.heading;
    }
}

