/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.fm;

import com.ibm.fmi.model.ByteUtilities;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.fm.Segment;
import java.nio.ByteBuffer;

public class DatasetNameSegment
extends Segment {
    private short nameLen;
    private String name;

    DatasetNameSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
    }

    public void parse(ByteBuffer buf) throws FMIParseException {
        this.nameLen = buf.getShort();
        try {
            this.name = ByteUtilities.getString(buf, this.nameLen);
        }
        catch (FMIConversionException fMIConversionException) {
            throw new FMIParseException("Invalid dataset name in template");
        }
    }

    public String getName() {
        return this.name;
    }
}

