/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.datatypeconverters;

import com.ibm.fmi.model.ByteUtilities;
import com.ibm.fmi.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.fmi.model.exception.FMIConversionException;

public class FMIPackedDecimalDataTypeConverter
implements IFMIDataTypeConverter {
    private final String MSG_UNEXPECTED_DATA_SIZE = "Could not convert binary data to String.  Unexpected data size.";
    private final String INVALID_PACKED_DECIMAL = "This field is not valid packed decimal";
    private final String INVALID_PD_EXTRA_PARAMETER_ARR = "Invalid parameters provided for Packed Decimal converter.  Expected { Integer impliedDecimalOffset }";
    private final String INVALID_IMPLIED_DECIMAL_OFFSET = "Invalid implied decimal offset.  Out of bounds.";
    private final String MULTIPLE_DECIMAL_PLACES = "Multiple decimal places in value";
    private final String EXCEEDS_NUM_DECIMAL_PLACES = "Exceeds maximum number of decimal places";
    private final int NO_IMPLIED_DECIMAL = -1;

    public byte[] ASCIIstrToEBCDIC(String asciiString, byte[] oldEBCDIC, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        asciiString = this.correctASCIIStringFormat(asciiString, tgtWidth, extraParams);
        int impliedDecimal = this.getImpliedDecimalOffset(extraParams);
        if (impliedDecimal != -1) {
            int decimalLocation = asciiString.indexOf(46);
            if (decimalLocation == -1) {
                throw new FMIConversionException("Internal Error: FMIPackedDecimalDataTypeConverter#ASCIIstrToEBCDIC");
            }
            asciiString = String.valueOf(asciiString.substring(0, decimalLocation)) + asciiString.substring(decimalLocation + 1, asciiString.length());
        }
        boolean negative = false;
        byte[] ebcdicBytes = new byte[tgtWidth];
        int ebcdicIndex = ebcdicBytes.length - 1;
        int i = 0;
        while (i < ebcdicBytes.length - 1) {
            ebcdicBytes[i] = 0;
            ++i;
        }
        if (asciiString == null || asciiString.equals("")) {
            ebcdicBytes[ebcdicBytes.length - 1] = 12;
            return ebcdicBytes;
        }
        if (asciiString.charAt(0) == '-') {
            negative = true;
        }
        if (negative && asciiString.length() > tgtWidth * 2 || !negative && asciiString.length() > tgtWidth * 2 - 1) {
            throw new FMIConversionException("Field data exceeds maximum display width");
        }
        byte[] asciiBytes = asciiString.getBytes();
        int asciiIndex = asciiBytes.length - 1;
        int lastAsciiIndex = negative ? 1 : 0;
        ebcdicBytes[ebcdicIndex] = negative ? -3 : -4;
        asciiBytes[asciiIndex] = (byte)(asciiBytes[asciiIndex] << 4);
        asciiBytes[asciiIndex] = (byte)(asciiBytes[asciiIndex] | 0xF);
        ebcdicBytes[ebcdicIndex] = (byte)(asciiBytes[asciiIndex] & ebcdicBytes[ebcdicIndex]);
        --asciiIndex;
        --ebcdicIndex;
        while (asciiIndex > lastAsciiIndex) {
            asciiBytes[asciiIndex - 1] = (byte)(asciiBytes[asciiIndex - 1] << 4);
            asciiBytes[asciiIndex] = (byte)(asciiBytes[asciiIndex] & 0xF);
            ebcdicBytes[ebcdicIndex--] = (byte)(asciiBytes[asciiIndex - 1] | asciiBytes[asciiIndex]);
            asciiIndex -= 2;
        }
        if (asciiIndex == lastAsciiIndex) {
            ebcdicBytes[ebcdicIndex] = (byte)(asciiBytes[asciiIndex] & 0xF);
        }
        return ebcdicBytes;
    }

    public String correctASCIIStringFormat(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        int impliedDecimal = this.getImpliedDecimalOffset(extraParams);
        StringBuffer buf = null;
        int aIndex = 0;
        if (asciiString == null || asciiString.equals("")) {
            buf = new StringBuffer("0");
        } else {
            buf = new StringBuffer(asciiString);
            aIndex = buf.charAt(0) == '-' ? 1 : 0;
            while (aIndex < buf.length() && buf.charAt(aIndex) == '0') {
                buf.deleteCharAt(aIndex);
            }
            if (buf.length() == 0 || buf.charAt(0) == '.') {
                buf.insert(0, '0');
            }
        }
        if (impliedDecimal != -1) {
            int i;
            int decimalIndex;
            int indexDifference;
            if (buf.indexOf(".") == -1) {
                buf.append(".");
            }
            if ((indexDifference = (decimalIndex = buf.length() - (buf.indexOf(".") + 1)) - impliedDecimal) > 0) {
                i = 0;
                while (i < indexDifference) {
                    if (buf.charAt(buf.length() - 1) != '0') {
                        throw new FMIConversionException("Too many values after the decimal point");
                    }
                    buf.deleteCharAt(buf.length() - 1);
                    ++i;
                }
            } else if (indexDifference < 0) {
                i = 0;
                while (i < -indexDifference) {
                    buf.append('0');
                    ++i;
                }
            }
            if (buf.charAt(aIndex) == '.') {
                buf.insert(aIndex, '0');
            }
        }
        boolean foundPoint = false;
        int i = aIndex;
        while (i < buf.length()) {
            if (!Character.isDigit(buf.charAt(i))) {
                if (buf.charAt(i) == '.' && !foundPoint) {
                    foundPoint = true;
                } else {
                    throw new FMIConversionException("Invalid character in field");
                }
            }
            ++i;
        }
        return buf.toString();
    }

    /*
     * Unable to fully structure code
     */
    public String EBCDICtoASCIIstr(byte[] EBCDICval, int maxWidth, Object[] extraParams) throws FMIConversionException {
        impliedDecimalOffset = this.getImpliedDecimalOffset(extraParams);
        strVal = null;
        negative = false;
        asciiLength = EBCDICval.length * 2 - 1;
        curIndex = 0;
        startLow = false;
        if (EBCDICval != null && EBCDICval.length != 0) ** GOTO lbl10
        throw new FMIConversionException("This field is not valid packed decimal");
lbl-1000:
        // 1 sources

        {
            asciiLength -= 2;
lbl10:
            // 2 sources

            ** while (EBCDICval[curIndex] == 0 && curIndex++ < EBCDICval.length)
        }
lbl11:
        // 1 sources

        if (curIndex >= EBCDICval.length) {
            throw new FMIConversionException("This field is not valid packed decimal");
        }
        if ((EBCDICval[curIndex] & 15) == EBCDICval[curIndex]) {
            --asciiLength;
            startLow = true;
        }
        if (ByteUtilities.isNegative(EBCDICval[EBCDICval.length - 1], false, "This field is not valid packed decimal")) {
            ++asciiLength;
            negative = true;
        }
        if (asciiLength == 0) {
            return "0";
        }
        if (asciiLength == 1 && negative) {
            return "-0";
        }
        asciiBytes = new byte[asciiLength];
        v0 = asciiIndex = negative != false ? 1 : 0;
        if (negative) {
            asciiBytes[0] = 45;
        }
        if (startLow) {
            asciiBytes[asciiIndex++] = (byte)(EBCDICval[curIndex++] | 48);
        }
        while (curIndex < EBCDICval.length - 1) {
            asciiBytes[asciiIndex++] = (byte)(48 | (EBCDICval[curIndex] & 255) >> 4);
            asciiBytes[asciiIndex++] = (byte)(EBCDICval[curIndex] & 15 | 48);
            ++curIndex;
        }
        asciiBytes[asciiIndex] = (byte)(48 | (EBCDICval[curIndex] & 255) >> 4);
        strVal = new String(asciiBytes);
        if (strVal == null) {
            throw new FMIConversionException("Could not convert binary data to String.  Unexpected data size.");
        }
        if (strVal.length() > maxWidth || strVal.length() == maxWidth && !negative) {
            throw new FMIConversionException("Field data exceeds maximum display width");
        }
        if (impliedDecimalOffset != -1) {
            buf = new StringBuffer(strVal);
            offset = buf.length() > impliedDecimalOffset ? buf.length() - impliedDecimalOffset : 0;
            buf.insert(offset, '.');
            strVal = buf.toString();
        }
        return this.correctASCIIStringFormat(strVal, EBCDICval.length, extraParams);
    }

    public boolean validateASCII(String ascii, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        int impliedDecimal = this.getImpliedDecimalOffset(extraParams);
        if (ascii.length() > tgtWidth * 2 && impliedDecimal == -1 || ascii.length() > tgtWidth * 2 + 1 && impliedDecimal != -1) {
            throw new FMIConversionException("Too many characters in field");
        }
        String str = this.correctASCIIStringFormat(ascii, tgtWidth, extraParams);
        int maxDigits = tgtWidth * 2 - 1;
        int numDigits = str.length();
        if (str.charAt(0) == '-') {
            --numDigits;
        }
        if (impliedDecimal != -1 && str.indexOf(".") != -1) {
            --numDigits;
        }
        if (numDigits > maxDigits) {
            throw new FMIConversionException("Value too large for field");
        }
        return true;
    }

    public int getMaxASCIIWidth(int ebcdicWidth, Object[] extraParams) throws FMIConversionException {
        int impliedDecimalOffset = this.getImpliedDecimalOffset(extraParams);
        int maxWidth = -1;
        if (ebcdicWidth > 0) {
            maxWidth = ebcdicWidth * 2;
        } else if (ebcdicWidth == 0) {
            maxWidth = 0;
        } else {
            throw new FMIConversionException("Error determining maximum ASCII field length");
        }
        if (impliedDecimalOffset > maxWidth) {
            throw new FMIConversionException("Invalid implied decimal offset.  Out of bounds.");
        }
        if (impliedDecimalOffset != -1) {
            ++maxWidth;
        }
        return maxWidth;
    }

    private int getImpliedDecimalOffset(Object[] extraParams) throws FMIConversionException {
        if (extraParams == null || extraParams.length == 0) {
            return -1;
        }
        if (extraParams != null && (extraParams.length != 1 || extraParams[0].getClass() != Integer.class)) {
            throw new FMIConversionException("Invalid parameters provided for Packed Decimal converter.  Expected { Integer impliedDecimalOffset }");
        }
        int offset = (Integer)extraParams[0];
        if (offset < 0) {
            throw new FMIConversionException("Invalid implied decimal offset.  Out of bounds.");
        }
        return offset;
    }

    public boolean isNumeric() {
        return true;
    }

    public String getSymbol() {
        return "PD";
    }

    public byte[] getDefaultValue(int length, Object[] extraParams) {
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < bytes.length - 1) {
            bytes[i] = 0;
            ++i;
        }
        bytes[bytes.length - 1] = 12;
        return bytes;
    }

    public boolean requiresFullWordBoundary(int length) {
        return false;
    }

    public boolean requiresHalfWordBoundary(int length) {
        return false;
    }
}

