/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.datatypeconverters;

import com.ibm.fmi.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.fmi.model.exception.FMIConversionException;

public class FMIAlphabeticDataTypeConverter
implements IFMIDataTypeConverter {
    private final String INVALID_CHAR_IN_STR = "Invalid character in alphabetic field";

    public byte[] ASCIIstrToEBCDIC(String asciiString, byte[] oldEBCDIC, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        this.validateASCII(asciiString, this.getMaxASCIIWidth(tgtWidth, extraParams), extraParams);
        if (asciiString == null) {
            asciiString = new String("");
        }
        try {
            if (asciiString.length() < tgtWidth) {
                StringBuffer buffer = new StringBuffer(asciiString);
                int i = buffer.length();
                while (i < tgtWidth) {
                    buffer.append(" ");
                    ++i;
                }
                asciiString = buffer.toString();
            }
            return asciiString.getBytes("Cp1047");
        }
        catch (Exception e) {
            throw new FMIConversionException("Conversion from ASCII to EBCDIC failed: " + e.getClass().getName());
        }
    }

    public String correctASCIIStringFormat(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        return asciiString;
    }

    public String EBCDICtoASCIIstr(byte[] EBCDICval, int maxStrLength, Object[] extraParams) throws FMIConversionException {
        String ascii = null;
        try {
            ascii = new String(EBCDICval, "Cp1047");
        }
        catch (Exception uee) {
            throw new FMIConversionException("Conversion from EBCDIC to ASCII failed: " + uee.getClass().getName());
        }
        if (ascii.length() > maxStrLength) {
            throw new FMIConversionException("Field data exceeds maximum display width: " + maxStrLength);
        }
        this.validateASCII(ascii, maxStrLength, extraParams);
        return ascii;
    }

    public boolean validateASCII(String ascii, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        if (tgtWidth < ascii.length()) {
            throw new FMIConversionException("Field data exceeds maximum display width");
        }
        char[] chars = ascii.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!Character.isLetter(chars[i]) && chars[i] != ' ') {
                throw new FMIConversionException("Invalid character in alphabetic field");
            }
            ++i;
        }
        return true;
    }

    public int getMaxASCIIWidth(int ebcdicWidth, Object[] extraParams) throws FMIConversionException {
        return ebcdicWidth;
    }

    public boolean isNumeric() {
        return false;
    }

    public String getSymbol() {
        return "AN";
    }

    public byte[] getDefaultValue(int length, Object[] extraParams) {
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = 64;
            ++i;
        }
        return bytes;
    }

    public boolean requiresFullWordBoundary(int length) {
        return false;
    }

    public boolean requiresHalfWordBoundary(int length) {
        return false;
    }
}

