/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model;

import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.FieldGroup;
import java.util.Iterator;
import java.util.Stack;

public class FieldIterator
implements Iterator {
    protected FieldGroup topLevelDataItem;
    protected FieldGroup curItem;
    protected Stack<Integer> curPosition;
    private boolean topLevelIsField;

    public FieldIterator(FieldGroup topLevelDataItem) {
        this.topLevelIsField = topLevelDataItem instanceof Field;
        this.topLevelDataItem = topLevelDataItem;
        this.reset();
    }

    private void findNextFieldContainer() {
        if (this.curItem.numChildren() == 0) {
            this.curItem = null;
            return;
        }
        while (true) {
            FieldGroup curFG = this.curItem.getChild(0);
            this.curPosition.push(0);
            if (curFG instanceof Field) break;
            this.curItem = curFG;
        }
    }

    private void moveToNextItem() {
        if (!this.curPosition.isEmpty()) {
            int curChild = this.curPosition.pop() + 1;
            if (curChild >= this.curItem.numChildren()) {
                this.curItem = this.curItem.getParent();
                this.moveToNextItem();
            } else {
                this.curPosition.push(curChild);
                FieldGroup child = this.curItem.getChild(curChild);
                if (child instanceof Field) {
                    return;
                }
                this.curItem = child;
                this.findNextFieldContainer();
                return;
            }
        }
    }

    private Field getNext() {
        int position = this.curPosition.peek();
        FieldGroup fg = this.curItem.getChild(position);
        if (!(fg instanceof Field)) {
            return null;
        }
        return (Field)fg;
    }

    public boolean hasNext() {
        if (this.topLevelIsField) {
            return this.curItem != null;
        }
        return this.curItem != null && !this.curPosition.isEmpty();
    }

    public Field next() {
        if (this.topLevelIsField && this.curItem != null) {
            this.curItem = null;
            return (Field)this.topLevelDataItem;
        }
        if (this.topLevelIsField) {
            return null;
        }
        Field nextField = this.curItem == null ? null : this.getNext();
        this.moveToNextItem();
        return nextField;
    }

    public void reset() {
        this.curItem = this.topLevelDataItem;
        if (this.topLevelIsField) {
            return;
        }
        this.curPosition = new Stack();
        this.findNextFieldContainer();
    }

    public void remove() {
    }
}

