/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model;

import com.ibm.fmi.model.DefiningObject;
import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.FieldGroup;
import com.ibm.fmi.model.FieldGroupArray;
import com.ibm.fmi.model.event.IFMIModelListener;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;

public class FieldGroupVarArray
extends FieldGroupArray
implements IFMIModelListener {
    public final int UNDEFINED = -1;
    public final int LIMIT = 50;
    private boolean fieldsSet = false;
    private int maxSize;
    private int minSize;
    private int curSize;
    private DefiningObject dependsOn;
    private int defaultNumChildren;

    public FieldGroupVarArray(FieldGroup template, int curSize, int level, int recordOffset, int length, int minSize, int maxSize, int defaultNumChildren, DefiningObject dependsOn) throws FMIModelException {
        super(template, level, recordOffset, length, maxSize);
        dependsOn.setTgtArray(this);
        this.defaultNumChildren = defaultNumChildren;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.curSize = curSize;
        int i = curSize;
        while (i < this.children.length) {
            this.children[i].setEditable(false);
            this.children[i].setEmpty(true);
            ++i;
        }
        this.numSlackBytes = template.numSlackBytes * curSize;
        this.ebcdicWidth = template.ebcdicWidth * curSize;
        this.dependsOn = dependsOn;
        this.empty = false;
        this.editable = false;
        this.hasContent = false;
    }

    public Field getDependsOn() {
        return this.dependsOn;
    }

    public FieldGroupVarArray copy() throws FMIModelException {
        FieldGroup[] copyChildren = new FieldGroup[this.children.length];
        int i = 0;
        while (i < copyChildren.length) {
            copyChildren[i] = this.children[i].copy();
            ++i;
        }
        FieldGroupVarArray copy = new FieldGroupVarArray(this.template, this.curSize, this.level, this.recordOffset, this.ebcdicWidth, this.minSize, this.maxSize, this.defaultNumChildren, this.dependsOn);
        copy.numSlackBytes = this.numSlackBytes;
        copy.hasRedefine = this.hasRedefine;
        copy.setParentResource(this.parentResource);
        FieldGroup[] fieldGroupArray = this.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup child = fieldGroupArray[n];
            child.setParent(copy);
            ++n;
        }
        copy.setStartLayoutIndex(this.startLayoutIndex);
        return copy;
    }

    public int setEbcdic(byte[] ebcdic, int decrement, boolean initializing, boolean forceVal, boolean fireEvent) throws FMIConversionException, FMIKeyException, FMIModelException {
        if (decrement != 0) {
            this.recordOffset -= decrement;
        }
        if (this.children == null) {
            throw new FMIModelException("Array out of bounds");
        }
        int curDecrement = 0;
        if (this.dependsOn != null) {
            curDecrement = this.setSize(this.dependsOn.getNumericValue());
        }
        decrement = this.setChildrenEbcdic(ebcdic, decrement, initializing, forceVal, fireEvent);
        this.initialized = true;
        return curDecrement + decrement;
    }

    public void setDependsOn(DefiningObject dependsOn) throws FMIModelException {
        if (this.fieldsSet) {
            throw new FMIModelException("Cannot change defining object");
        }
        this.dependsOn = dependsOn;
    }

    int setSize(int size) {
        if (size == this.curSize) {
            return 0;
        }
        int i = size;
        while (i < this.children.length) {
            this.children[i].setEditable(false);
            this.children[i].setEmpty(true);
            ++i;
        }
        int decrement = (this.curSize - size) * this.template.ebcdicWidth;
        this.curSize = size;
        this.numSlackBytes = this.template.numSlackBytes * this.curSize;
        this.ebcdicWidth = this.template.ebcdicWidth * this.curSize;
        this.parent.decrementWidth(decrement);
        return decrement;
    }

    protected int setChildrenEbcdic(byte[] ebcdic, int decrement, boolean initializing, boolean forceVal, boolean fireEvent) throws FMIConversionException, FMIKeyException, FMIModelException {
        this.actualWidth = 0;
        FieldGroup[] fieldGroupArray = this.children;
        int n = 0;
        int n2 = fieldGroupArray.length;
        while (n < n2) {
            FieldGroup f = fieldGroupArray[n];
            if (!f.isEmpty()) {
                decrement = f.setEbcdic(ebcdic, decrement, initializing, forceVal, fireEvent);
            }
            ++n;
        }
        this.actualWidth = this.ebcdicWidth;
        return decrement;
    }
}

