/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model;

import com.ibm.fmi.model.FieldGroup;
import java.util.Iterator;
import java.util.Stack;

public class FieldGroupIterator
implements Iterator {
    FieldGroup topLevel;
    FieldGroup curItem;
    Stack<Integer> nextPosition;

    public FieldGroupIterator(FieldGroup topLevelItem) {
        this.topLevel = topLevelItem;
        this.reset();
    }

    private void moveToNext() {
        int position = this.nextPosition.peek();
        if (position >= this.curItem.numChildren()) {
            this.nextPosition.pop();
            if (this.nextPosition.isEmpty()) {
                this.curItem = null;
                return;
            }
            this.curItem = this.curItem.getParent();
            this.nextPosition.push(this.nextPosition.pop() + 1);
            this.moveToNext();
        } else {
            this.curItem = this.curItem.getChild(position);
            this.nextPosition.push(0);
        }
    }

    public boolean hasNext() {
        return this.curItem != null;
    }

    public FieldGroup next() {
        FieldGroup toReturn = this.curItem;
        this.moveToNext();
        return toReturn;
    }

    public void remove() {
    }

    public void reset() {
        this.curItem = this.topLevel;
        this.nextPosition = new Stack();
        this.nextPosition.push(0);
    }

    public static FieldGroup findFieldGroup(FieldGroup topLevelItem, int modelIndex) {
        return FieldGroupIterator.findFieldGroupHelper(topLevelItem, modelIndex);
    }

    public static FieldGroup findFieldGroupHelper(FieldGroup curGroup, int modelIndex) {
        if (curGroup.numChildren() == 0) {
            return null;
        }
        if (curGroup.getModelIndex() == modelIndex) {
            return curGroup;
        }
        int i = 0;
        while (curGroup.numChildren() > i && curGroup.getChild(i).getModelIndex() < modelIndex) {
            ++i;
        }
        if (curGroup.getChild(i).getModelIndex() == modelIndex) {
            return curGroup.getChild(i);
        }
        return FieldGroupIterator.findFieldGroupHelper(curGroup.getChild(i - 1), modelIndex);
    }
}

