/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model;

import com.ibm.fmi.model.ByteUtilities;
import com.ibm.fmi.model.DefaultRecordLayout;
import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.RecordHeader;
import com.ibm.fmi.model.RecordLayout;
import com.ibm.fmi.model.TemplattedData;
import com.ibm.fmi.model.event.FMIResource;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.shadowline.HiddenSet;
import com.ibm.fmi.model.shadowline.PlaceholderHiddenSet;
import com.ibm.fmi.model.shadowline.ShadowLine;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FMRecordParser {
    private static final int HEADER_SIZE = 32;
    private static final int NUMREC_BYTE_INDEX = 24;
    private static final int LENGTH_BYTE_INDEX = 28;
    private static final String AT_INDEX = "at index";
    private static final String INCORRECT_LENGTH = "Incorrect record length provided: ";

    public static TemplattedData parseRecords(TemplattedData topLevel, byte[] contents, ShadowLine[] shadowLines, List<RecordLayout> layouts) throws FMIConversionException, FMIParseException, FMIKeyException, FMIModelException {
        int index = 0;
        int recNum = 1;
        ArrayList<DisplayLine> displayLines = null;
        if (contents == null) {
            return null;
        }
        int widestRecordLength = 0;
        while (index < contents.length) {
            int length = ByteUtilities.byteArrayToInt(contents, index + 28);
            if (length > widestRecordLength) {
                widestRecordLength = length;
            }
            if (length + index > contents.length) {
                throw new FMIParseException(INCORRECT_LENGTH, recNum, 0);
            }
            long numRecords = ByteUtilities.byteArrayToUnsignedInt(contents, index + 24);
            byte[] header = new byte[32];
            byte[] curRecordBytes = new byte[length];
            int i = 0;
            while (i < header.length) {
                header[i] = contents[index + i];
                ++i;
            }
            i = header.length;
            while (i < curRecordBytes.length + header.length) {
                curRecordBytes[i - header.length] = contents[index + i];
                ++i;
            }
            try {
                displayLines = FMRecordParser.addRecordToModel(curRecordBytes, header, shadowLines, layouts, displayLines, (int)numRecords, topLevel);
            }
            catch (FMIConversionException fe) {
                throw (FMIConversionException)FMRecordParser.addMessageToFMIException(fe, recNum);
            }
            catch (FMIParseException pe) {
                pe.setRecord(recNum);
                throw pe;
            }
            index += curRecordBytes.length + header.length;
            ++recNum;
        }
        RecordLayout layout = topLevel.getLayouts().get(0);
        if (layout instanceof DefaultRecordLayout) {
            ((DefaultRecordLayout)layout).setMaximumWidth(widestRecordLength);
        }
        topLevel.addDisplayLines(displayLines, true);
        return topLevel;
    }

    private static ArrayList<DisplayLine> addRecordToModel(byte[] recordData, byte[] headerBytes, ShadowLine[] shadowLines, List<RecordLayout> layouts, ArrayList<DisplayLine> displayLines, int numRecords, TemplattedData topLevel) throws FMIConversionException, FMIParseException, FMIKeyException, FMIModelException {
        RecordHeader header = new RecordHeader(headerBytes);
        RecordLayout layout = null;
        for (RecordLayout curLayout : layouts) {
            if (curLayout.getSymbol() != header.getLayoutNumber()) continue;
            layout = curLayout;
            break;
        }
        boolean isShadow = false;
        if (displayLines == null) {
            displayLines = new ArrayList();
        }
        if (shadowLines != null) {
            int i = 0;
            while (i < shadowLines.length) {
                if (shadowLines[i].isOfSet(headerBytes)) {
                    isShadow = true;
                    ShadowLine newShadowLine = shadowLines[i].getInstance();
                    boolean merged = false;
                    if (newShadowLine instanceof PlaceholderHiddenSet) {
                        PlaceholderHiddenSet placeholder = (PlaceholderHiddenSet)newShadowLine;
                        placeholder.setHeader(header);
                        if (numRecords == 0) {
                            numRecords = 1;
                        }
                        placeholder.setNumRecords(numRecords);
                        placeholder.setData(recordData);
                        placeholder.setParent(topLevel);
                    } else if (newShadowLine instanceof HiddenSet) {
                        HiddenSet hS = (HiddenSet)newShadowLine;
                        hS.setLayout(layout);
                        hS.addRecord(FMRecordParser.buildRecord(hS, header, layout, recordData, topLevel));
                        if (displayLines.size() > 0) {
                            DisplayLine lastLine = displayLines.get(displayLines.size() - 1);
                            merged = lastLine.mergeEnd(hS);
                        }
                    }
                    if (merged) break;
                    displayLines.add(newShadowLine);
                    break;
                }
                ++i;
            }
        }
        if (!isShadow) {
            Record newRec = FMRecordParser.buildRecord(topLevel, header, layout, recordData, topLevel);
            displayLines.add(newRec);
        }
        return displayLines;
    }

    private static Record buildRecord(FMIResource parent, RecordHeader header, RecordLayout layout, byte[] data, TemplattedData topLevel) throws FMIParseException, FMIConversionException, FMIKeyException, FMIModelException {
        Record theRecord = new Record(layout, topLevel);
        theRecord.setParent(parent);
        theRecord.setHeader(header);
        theRecord.setEbcdic(data, true, true, false);
        return theRecord;
    }

    private static FMIException addMessageToFMIException(FMIException fe, int index) {
        fe.addToMessage(" at index: " + index);
        return fe;
    }
}

