/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model;

import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.FMIResourceIterator;
import com.ibm.fmi.model.IRecordHeaderContainer;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.shadowline.HiddenSet;
import com.ibm.fmi.model.shadowline.PlaceholderHiddenSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FMIRecordHeaderIterator
implements Iterator<IRecordHeaderContainer> {
    public ListIterator<DisplayLine> displayLineIterator;
    public FMIResourceIterator<Record> recordIterator;

    public FMIRecordHeaderIterator(List<DisplayLine> displayLines) throws FMIModelException {
        this.displayLineIterator = displayLines.listIterator();
        this.recordIterator = null;
        this.findFirstRecord(displayLines);
    }

    public FMIRecordHeaderIterator(Record r, List<DisplayLine> displayLines) throws FMIModelException {
        this.displayLineIterator = displayLines.listIterator();
        this.recordIterator = null;
        this.findRecord(r, displayLines);
    }

    public FMIRecordHeaderIterator(int offset, List<DisplayLine> displayLines) {
        this.displayLineIterator = displayLines.listIterator();
        this.recordIterator = null;
        this.findRecord(offset, displayLines);
    }

    private void findRecord(int offset, List<DisplayLine> displayLines) {
        int curIndex = 0;
        while (this.displayLineIterator.hasNext() && curIndex < offset) {
            this.displayLineIterator.next();
            ++curIndex;
        }
    }

    private void findFirstRecord(List<DisplayLine> displayLines) throws FMIModelException {
        boolean lineFound = false;
        while (this.displayLineIterator.hasNext()) {
            DisplayLine cur = this.displayLineIterator.next();
            if (cur instanceof Record || cur instanceof PlaceholderHiddenSet) {
                lineFound = true;
                break;
            }
            if (!(cur instanceof HiddenSet)) continue;
            this.recordIterator = ((HiddenSet)cur).getRecordIterator();
            lineFound = true;
            break;
        }
        if (!lineFound) {
            throw new FMIModelException("Could not find record in model");
        }
        if (this.recordIterator == null) {
            if (this.displayLineIterator.hasPrevious()) {
                this.displayLineIterator.previous();
            } else {
                this.displayLineIterator = displayLines.listIterator();
            }
        }
    }

    private void findRecord(Record r, List<DisplayLine> displayLines) throws FMIModelException {
        boolean lineFound = false;
        while (this.displayLineIterator.hasNext()) {
            DisplayLine cur = this.displayLineIterator.next();
            if ((!(cur instanceof Record) || cur != r) && (!(cur instanceof HiddenSet) || !this.findRecordInHiddenSet(r, (HiddenSet)cur))) continue;
            lineFound = true;
            break;
        }
        if (!lineFound) {
            throw new FMIModelException("Could not find record in model");
        }
        if (this.recordIterator == null) {
            if (this.displayLineIterator.hasPrevious()) {
                this.displayLineIterator.previous();
            } else {
                this.displayLineIterator = displayLines.listIterator();
            }
        }
    }

    private boolean findRecordInHiddenSet(Record r, HiddenSet h) {
        this.recordIterator = h.getRecordIterator();
        while (this.recordIterator.hasNext()) {
            Record curRecord = (Record)this.recordIterator.next();
            if (curRecord != r) continue;
            if (this.recordIterator.hasPrevious()) {
                this.recordIterator.previous();
            } else {
                this.recordIterator = h.getRecordIterator();
            }
            return true;
        }
        this.recordIterator = null;
        return false;
    }

    public boolean hasPrevious() {
        return this.recordIterator != null && this.recordIterator.hasPrevious() || this.displayLineIterator != null && this.displayLineIterator.hasPrevious();
    }

    @Override
    public boolean hasNext() {
        return this.recordIterator != null && this.recordIterator.hasNext() || this.displayLineIterator != null && this.displayLineIterator.hasNext();
    }

    public IRecordHeaderContainer previous() {
        IRecordHeaderContainer previous = null;
        if (this.recordIterator != null && !this.recordIterator.hasPrevious()) {
            this.recordIterator = null;
        }
        if (this.recordIterator != null && this.recordIterator.hasPrevious()) {
            previous = this.recordIterator.previous();
        } else if (this.displayLineIterator != null && this.displayLineIterator.hasPrevious()) {
            DisplayLine prevDL = this.displayLineIterator.previous();
            if (prevDL instanceof Record || prevDL instanceof PlaceholderHiddenSet) {
                previous = (IRecordHeaderContainer)((Object)prevDL);
            } else if (prevDL instanceof HiddenSet) {
                this.recordIterator = ((HiddenSet)prevDL).getRecordIterator();
                while (this.recordIterator.hasNext()) {
                    this.recordIterator.next();
                }
                previous = this.recordIterator.previous();
            }
        }
        return previous;
    }

    @Override
    public IRecordHeaderContainer next() {
        IRecordHeaderContainer next = null;
        if (this.recordIterator != null && !this.recordIterator.hasNext()) {
            this.recordIterator = null;
        }
        if (this.recordIterator != null && this.recordIterator.hasNext()) {
            next = (IRecordHeaderContainer)this.recordIterator.next();
        } else if (this.displayLineIterator != null && this.displayLineIterator.hasNext()) {
            DisplayLine nextDL = this.displayLineIterator.next();
            if (nextDL instanceof Record || nextDL instanceof PlaceholderHiddenSet) {
                next = (IRecordHeaderContainer)((Object)nextDL);
            } else if (nextDL instanceof HiddenSet) {
                this.recordIterator = ((HiddenSet)nextDL).getRecordIterator();
                next = (IRecordHeaderContainer)this.recordIterator.next();
            }
        }
        return next;
    }

    @Override
    public void remove() {
    }
}

