/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.client.operation;

import com.ibm.etools.systems.dstore.core.model.DataElement;
import com.ibm.etools.systems.subsystems.RemoteFileException;
import com.ibm.fmi.client.FMIClientUtilities;
import com.ibm.ftt.resources.zos.filesystem.MVSObject;
import com.ibm.ftt.resources.zos.filesystem.MVSResource;
import com.ibm.ftt.resources.zos.util.RSEClient;
import com.ibm.ftt.rse.mvs.util.FFSResponse;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class FMIRefreshOperation
extends WorkspaceModifyOperation {
    private MVSResource tgtResource;
    private Object editObject;
    private String templateName;
    private IFile file;
    private Integer layout;

    public FMIRefreshOperation(MVSResource rsc, Object editObject, String templateName, Integer layout) {
        this.tgtResource = rsc;
        this.editObject = editObject;
        this.templateName = templateName;
        this.file = null;
        this.layout = layout;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            DataElement[] args;
            monitor.beginTask("FMIDownload", 100);
            if (this.layout != null) {
                args = new DataElement[]{RSEClient.argument((MVSObject)this.tgtResource, (String)FMIClientUtilities.getRemoteDataset(this.tgtResource)), RSEClient.argument((MVSObject)this.tgtResource, (String)FMIClientUtilities.getRemoteMember(this.tgtResource)), RSEClient.argument((MVSObject)this.tgtResource, (String)this.templateName), RSEClient.argument((MVSObject)this.tgtResource, (String)Integer.toString(this.layout))};
                FFSResponse ffsResponse = RSEClient.command((MVSObject)this.tgtResource, (String)"C_FMI_LAYOUT_CHANGE", (DataElement[])args, (int)0, (IProgressMonitor)monitor);
                if (!ffsResponse.isSuccess()) {
                    String errorMessage = ffsResponse.getMessage();
                    monitor.setCanceled(true);
                    throw new RemoteFileException(errorMessage);
                }
            }
            monitor.worked(25);
            args = new DataElement[6];
            String workstationPath = FMIClientUtilities.getLocalPath(this.tgtResource);
            args[0] = RSEClient.argument((MVSObject)this.tgtResource, (String)FMIClientUtilities.getRemoteDataset(this.tgtResource));
            args[1] = RSEClient.argument((MVSObject)this.tgtResource, (String)FMIClientUtilities.getRemoteMember(this.tgtResource));
            args[2] = RSEClient.argument((MVSObject)this.tgtResource, (String)workstationPath);
            args[3] = RSEClient.argument((MVSObject)this.tgtResource, (String)this.templateName);
            args[4] = RSEClient.argument((MVSObject)this.tgtResource, (String)FMIClientUtilities.getLocalTemplateName(workstationPath));
            args[5] = RSEClient.argument((MVSObject)this.tgtResource, (String)this.tgtResource.getTransfer(), (String)this.tgtResource.getHostCp(), (String)this.tgtResource.getLocalCp());
            FFSResponse ffsResponse = RSEClient.command((MVSObject)this.tgtResource, (String)"C_FMI_UPDATE_DATASET", (DataElement[])args, (int)0, (IProgressMonitor)monitor);
            if (!ffsResponse.isSuccess()) {
                String errorMessage = ffsResponse.getMessage();
                monitor.setCanceled(true);
                throw new RemoteFileException(errorMessage);
            }
            monitor.worked(100);
        }
        catch (RemoteFileException re) {
            throw new InterruptedException(re.getMessage());
        }
    }

    public IFile getFile() {
        return this.file;
    }
}

