/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.client;

import com.ibm.etools.systems.core.SystemPlugin;
import com.ibm.etools.systems.dstore.core.model.DataElement;
import com.ibm.fmi.client.FMIEditSessionProperties;
import com.ibm.fmi.client.operation.FMIEndEditSessionOperation;
import com.ibm.fmi.client.operation.FMIRefreshOperation;
import com.ibm.fmi.client.operation.FMISaveOperation;
import com.ibm.ftt.resources.core.PhysicalPropertyManager;
import com.ibm.ftt.resources.core.physical.IPhysicalResource;
import com.ibm.ftt.resources.zos.filesystem.MVSResource;
import com.ibm.ftt.resources.zos.filesystem.impl.MemberImpl;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSResourceImpl;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class FMIClientUtilities {
    private static final String TEMPLATE_PROP_STR = "FM Template";

    public static String getLocalTemplateName(String localDataset) {
        int extPoint = localDataset.lastIndexOf(46);
        if (extPoint == -1) {
            return null;
        }
        String extension = localDataset.substring(extPoint);
        String dataSetWithoutExtension = localDataset.substring(0, extPoint);
        return String.valueOf(dataSetWithoutExtension) + "_TMPL" + extension;
    }

    public static void cleanUpDatasets(String localDataset) {
        File templateFile;
        File datasetFile = new File(localDataset);
        if (datasetFile.exists()) {
            datasetFile.delete();
        }
        if ((templateFile = new File(FMIClientUtilities.getLocalTemplateName(localDataset))).exists()) {
            templateFile.delete();
        }
    }

    public static String getRemoteDataset(MVSResource dataset) {
        IFile file = dataset.getLocalResource();
        if (dataset instanceof MemberImpl) {
            String localParentPath = file.getParent().getLocation().makeAbsolute().toOSString();
            String parentPath = localParentPath.substring(localParentPath.lastIndexOf(92) + 1, localParentPath.length());
            return parentPath;
        }
        return dataset.getName();
    }

    public static String getRemoteMember(MVSResource dataset) {
        return dataset instanceof MemberImpl ? dataset.getName() : null;
    }

    public static String getLocalPath(MVSResource dataset) {
        String localParentPath = dataset.getLocalResource().getParent().getLocation().makeAbsolute().toOSString();
        return String.valueOf(localParentPath) + "/" + FMIClientUtilities.getFileNameWithExtension(dataset);
    }

    public static String getFileNameWithExtension(MVSResource dataset) {
        String fileName = dataset.getName();
        if (dataset.getExtension() != null && dataset.getExtension().length() > 0) {
            fileName = String.valueOf(fileName) + "." + dataset.getExtension();
        }
        return fileName;
    }

    public static String getLocalPathWithoutExtension(MVSResource dataset) {
        String fullName = FMIClientUtilities.getLocalPath(dataset);
        return fullName.substring(0, fullName.lastIndexOf(46));
    }

    public static String getTemplateName(IPhysicalResource dataset) {
        PhysicalPropertyManager physicalManager = (PhysicalPropertyManager)PhysicalPropertyManager.getManager();
        return physicalManager.getPersistentProperty(dataset, TEMPLATE_PROP_STR);
    }

    public static boolean saveToFM(IProgressMonitor monitor, Object zosResourceImpl, byte[] changedRecords, Integer newLayoutSymbol) {
        ZOSResourceImpl rsc = (ZOSResourceImpl)zosResourceImpl;
        FMISaveOperation saveOp = new FMISaveOperation(rsc, changedRecords);
        boolean failed = false;
        try {
            saveOp.run(monitor);
        }
        catch (Exception e) {
            ErrorDialog.openError((Shell)SystemPlugin.getActiveWorkbenchShell(), (String)"Errors in save data", (String)"Save Error: ", (IStatus)new Status(4, "FMIEditor", 0, e.getMessage(), null));
            failed = true;
        }
        try {
            String templateName = FMIClientUtilities.getTemplateName((IPhysicalResource)rsc);
            FMIRefreshOperation downloadOperation = new FMIRefreshOperation(rsc.getMvsResource(), zosResourceImpl, templateName, newLayoutSymbol);
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(SystemPlugin.getActiveWorkbenchShell());
            progressDialog.run(false, false, (IRunnableWithProgress)downloadOperation);
        }
        catch (Exception ie) {
            ErrorDialog.openError((Shell)SystemPlugin.getActiveWorkbenchShell(), (String)"Error downloading file", (String)"Error downloading file", (IStatus)new Status(4, "FMIEditor", 0, ie.getMessage(), null));
            failed = true;
        }
        return !failed;
    }

    public static void closeEditorSession(Object datasetResource, Shell activeShell) {
        ZOSResourceImpl rsc = (ZOSResourceImpl)datasetResource;
        MVSResource mvsResource = rsc.getMvsResource();
        FMIEndEditSessionOperation endEditSessionOperation = new FMIEndEditSessionOperation(mvsResource, FMIClientUtilities.getLocalPathWithoutExtension(mvsResource), FMIClientUtilities.getTemplateName((IPhysicalResource)rsc));
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(activeShell);
        try {
            progressDialog.run(false, false, (IRunnableWithProgress)endEditSessionOperation);
        }
        catch (Exception e) {
            ErrorDialog.openError((Shell)SystemPlugin.getActiveWorkbenchShell(), (String)"Exception while closing edit session", (String)"Dataset close error:", (IStatus)new Status(4, "FMIEditor", 0, e.getMessage(), null));
        }
    }

    public static FMIEditSessionProperties getDatasetProperties(MVSResource rsc) {
        FMIEditSessionProperties props = new FMIEditSessionProperties();
        DataElement resourceElement = rsc.getDataElement();
        ArrayList elements = resourceElement.getNestedData();
        for (DataElement de : elements) {
            String key = FMIClientUtilities.getAttributeKey(de);
            String value = FMIClientUtilities.getAttributeValue(de);
            if (key.equals("fmi.isKSDS")) {
                props.setKSDS(FMIClientUtilities.convertStringToBoolean(value));
                continue;
            }
            if (key.equals("fmi.keyLen")) {
                props.setKeyLen(Integer.parseInt(value));
                continue;
            }
            if (key.equals("fmi.keyOffset")) {
                props.setKeyOffset(Integer.parseInt(value));
                continue;
            }
            if (key.equals("fmi.maxRECL")) {
                props.setMaxRECL(Integer.parseInt(value));
                continue;
            }
            if (key.equals("fmi.minRECL")) {
                props.setMinRECL(Integer.parseInt(value));
                continue;
            }
            if (key.equals("fmi.numRec")) {
                props.setNumRecords(Integer.parseInt(value));
                continue;
            }
            if (key.equals("fmi.noAppend")) {
                props.setNoAppend(FMIClientUtilities.convertStringToBoolean(value));
                continue;
            }
            if (key.equals("fmi.fixedLen")) {
                props.setFixedLen(FMIClientUtilities.convertStringToBoolean(value));
                continue;
            }
            if (key.equals("fmi.noMove")) {
                props.setNoMove(FMIClientUtilities.convertStringToBoolean(value));
                continue;
            }
            if (key.equals("fmi.noRecLenChange")) {
                props.setNoRecLenChange(FMIClientUtilities.convertStringToBoolean(value));
                continue;
            }
            if (key.equals("fmi.noUpdates")) {
                props.setNoUpdate(FMIClientUtilities.convertStringToBoolean(value));
                continue;
            }
            if (key.equals("fmi.insertDelete")) {
                props.setNoInsertDelete(FMIClientUtilities.convertStringToBoolean(value));
                continue;
            }
            if (key.equals("fmi.isQSAM")) {
                props.setQSAM(FMIClientUtilities.convertStringToBoolean(value));
                continue;
            }
            if (!key.equals("fmi.isRRDS")) continue;
            props.setRRDS(FMIClientUtilities.convertStringToBoolean(value));
        }
        return props;
    }

    public static String getAttributeKey(DataElement de) {
        return de.getAttribute(0);
    }

    public static String getAttributeValue(DataElement de) {
        return de.getAttribute(2);
    }

    public static boolean convertStringToBoolean(String val) {
        return val.equals("Y");
    }
}

