/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.util;

import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.FMIResourceIterator;
import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.FieldGroupArray;
import com.ibm.fmi.model.IFieldGroupContainer;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.TemplattedData;
import com.ibm.fmi.model.event.FMIResource;
import com.ibm.fmi.model.shadowline.ExcludedSet;
import com.ibm.fmi.model.shadowline.ShadowLine;

public class FMIModelIndex
implements Comparable {
    private int displayLineIndex;
    private int recordIndex;
    private int fieldIndex;
    private int fieldOffset;

    public FMIModelIndex(int displayLineIndex, int fieldIndex, int fieldOffset) {
        this.displayLineIndex = displayLineIndex;
        this.fieldIndex = fieldIndex;
        this.fieldOffset = fieldOffset;
        this.recordIndex = -1;
    }

    public FMIModelIndex(int displayLineIndex, int recordIndex, int fieldIndex, int fieldOffset) {
        this.displayLineIndex = displayLineIndex;
        this.recordIndex = recordIndex;
        this.fieldIndex = fieldIndex;
        this.fieldOffset = fieldOffset;
    }

    public FMIModelIndex(FMIModelIndex idx) {
        this.displayLineIndex = idx.displayLineIndex;
        this.recordIndex = idx.recordIndex;
        this.fieldIndex = idx.fieldIndex;
        this.fieldOffset = idx.fieldOffset;
    }

    public int getDisplayLineIndex() {
        return this.displayLineIndex;
    }

    public void setDisplayLineIndex(int displayLineIndex) {
        this.displayLineIndex = displayLineIndex;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    public void setFieldIndex(int fieldIndex) {
        this.fieldIndex = fieldIndex;
    }

    public int getFieldOffset() {
        return this.fieldOffset;
    }

    public void setFieldOffset(int fieldOffset) {
        this.fieldOffset = fieldOffset;
    }

    public Field getField(TemplattedData td) {
        FMIResourceIterator dlIterator = td.getDisplayLineIterator();
        DisplayLine dl = (DisplayLine)dlIterator.getResource(this.displayLineIndex);
        if (dl instanceof ExcludedSet && this.recordIndex != -1) {
            return ((Record)((ExcludedSet)dl).getRecordIterator().getResource(this.recordIndex)).getDisplayField(this.fieldIndex);
        }
        if (dl instanceof ShadowLine) {
            return null;
        }
        Record rec = (Record)dl;
        return rec.getDisplayField(this.fieldIndex);
    }

    public String getFieldStringWithOffset(TemplattedData td) {
        String str = this.getField(td).getAsciiStr();
        if (str.length() > this.fieldOffset) {
            return str.substring(this.fieldOffset);
        }
        return null;
    }

    public FMIModelIndex getNextField(TemplattedData td, boolean includeVisible, boolean includeExcluded) {
        assert (includeVisible || includeExcluded);
        FMIResourceIterator dlit = td.getDisplayLineIterator();
        if (this.fieldIndex < ((DisplayLine)dlit.getResource(this.displayLineIndex)).getLayout().numDisplayFields() - 1) {
            return new FMIModelIndex(this.displayLineIndex, this.recordIndex, this.fieldIndex + 1, 0);
        }
        if (includeExcluded && this.recordIndex < ((ExcludedSet)dlit.getResource(this.displayLineIndex)).getNumRecords() - 1) {
            return new FMIModelIndex(this.displayLineIndex, this.recordIndex + 1, 0, 0);
        }
        int temp = this.displayLineIndex + 1;
        while (!(temp >= td.numDisplayLines() || dlit.getResource(temp) instanceof ExcludedSet && includeExcluded || dlit.getResource(temp) instanceof Record && includeVisible)) {
            ++temp;
        }
        if (temp == td.numDisplayLines()) {
            return null;
        }
        if (includeExcluded && dlit.getResource(temp) instanceof ExcludedSet) {
            return new FMIModelIndex(temp, 0, 0, 0);
        }
        return new FMIModelIndex(temp, 0, 0);
    }

    public FMIModelIndex getNextField(TemplattedData td) {
        return this.getNextField(td, true, false);
    }

    public FMIModelIndex getPreviousField(TemplattedData td, boolean includeVisible, boolean includeExcluded) {
        assert (includeVisible || includeExcluded);
        if (this.fieldIndex > 0) {
            return new FMIModelIndex(this.displayLineIndex, this.recordIndex, this.fieldIndex - 1, 0);
        }
        if (includeExcluded && this.recordIndex > 0) {
            return new FMIModelIndex(this.displayLineIndex, this.recordIndex - 1, ((DisplayLine)td.getDisplayLineIterator().getResource(this.recordIndex - 1)).getLayout().numDisplayFields() - 1, 0);
        }
        FMIResourceIterator dlit = td.getDisplayLineIterator();
        int temp = this.displayLineIndex - 1;
        while (!(temp < 0 || dlit.getResource(temp) instanceof ExcludedSet && includeExcluded || dlit.getResource(temp) instanceof Record && includeVisible)) {
            --temp;
        }
        if (temp < 0) {
            return null;
        }
        if (includeExcluded && dlit.getResource(temp) instanceof ExcludedSet) {
            return new FMIModelIndex(temp, ((ExcludedSet)dlit.getResource(temp)).getNumRecords() - 1, ((DisplayLine)dlit.getResource(temp)).getLayout().numDisplayFields() - 1, 0);
        }
        return new FMIModelIndex(temp, ((DisplayLine)dlit.getResource(temp)).getLayout().numDisplayFields() - 1, 0);
    }

    public FMIModelIndex getPreviousField(TemplattedData td) {
        return this.getPreviousField(td, true, false);
    }

    public static FMIModelIndex getModelIndex(Field field) {
        IFieldGroupContainer obj = field.getParentResource();
        if (obj instanceof FieldGroupArray) {
            obj = ((FieldGroupArray)obj).getParentResource();
        }
        if (obj instanceof Record) {
            Record rec = (Record)obj;
            FMIResourceIterator dlIterator = ((TemplattedData)rec.getParent()).getDisplayLineIterator();
            return new FMIModelIndex(dlIterator.indexOf((FMIResource)rec), rec.indexOf(field), 0);
        }
        return null;
    }

    public int compareTo(Object o) {
        FMIModelIndex index = (FMIModelIndex)o;
        if (index.getDisplayLineIndex() == this.getDisplayLineIndex()) {
            if (index.getRecordIndex() == this.getRecordIndex()) {
                if (index.getFieldIndex() == this.getFieldIndex()) {
                    return this.getFieldOffset() - index.getFieldOffset();
                }
                return this.getFieldIndex() - index.getFieldIndex();
            }
            return this.getRecordIndex() - index.getRecordIndex();
        }
        return this.getDisplayLineIndex() - index.getDisplayLineIndex();
    }

    public int getRecordIndex() {
        return this.recordIndex;
    }

    public void setRecordIndex(int recordIndex) {
        this.recordIndex = recordIndex;
    }
}

