/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.providers;

import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.FMIResourceIterator;
import com.ibm.fmi.model.FieldGroupArray;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.TemplattedData;
import com.ibm.fmi.model.event.FMIModelDisplayLineChangeEvent;
import com.ibm.fmi.model.event.FMIModelFieldChangeEvent;
import com.ibm.fmi.model.event.FMIModelMultiDisplayLineChangeEvent;
import com.ibm.fmi.model.event.FMIResource;
import com.ibm.fmi.model.event.IFMIModelListener;
import com.ibm.fmi.ui.UiPlugin;
import com.ibm.fmi.ui.providers.HexRecordWrapper;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class FMITableModeContentProvider
implements ILazyContentProvider,
IFMIModelListener {
    TableViewer viewer = null;
    TemplattedData input = null;
    private List<Record> nonShadowRecords;
    private boolean isHex;
    private boolean isShadow;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TableViewer)viewer;
        if (oldInput != newInput) {
            this.nonShadowRecords = null;
            if (this.input != null) {
                this.input.removeModelListener((IFMIModelListener)this);
            }
            this.input = (TemplattedData)newInput;
            if (this.input != null) {
                this.input.addModelListener((IFMIModelListener)this);
            }
        }
        this.updateTableSize(this.getTableSize(this.input));
    }

    public void updateTableSize(int size) {
        if (this.viewer != null) {
            this.viewer.setItemCount(size);
        }
    }

    public int getTableSize(TemplattedData input) {
        if (input == null) {
            return 0;
        }
        FMIResourceIterator dlIter = input.getDisplayLineIterator();
        if (this.nonShadowRecords == null) {
            this.nonShadowRecords = new Vector<Record>();
            int i = 0;
            while (i < input.numDisplayLines()) {
                if (dlIter.getResource(i) instanceof Record) {
                    this.nonShadowRecords.add((Record)dlIter.getResource(i));
                }
                ++i;
            }
        }
        if (!this.isHex && this.isShadow) {
            return input.numDisplayLines();
        }
        if (this.isHex && this.isShadow) {
            return input.numDisplayLines() + this.nonShadowRecords.size() * 2;
        }
        if (this.isHex && !this.isShadow) {
            return this.nonShadowRecords.size() * 3;
        }
        if (!this.isHex && !this.isShadow) {
            return this.nonShadowRecords.size();
        }
        return 0;
    }

    protected int getNonShadowIndex(DisplayLine dl) {
        FMIResourceIterator dlIter = this.input.getDisplayLineIterator();
        if (!(dl instanceof Record)) {
            int index = dlIter.indexOf((FMIResource)dl);
            while (++index < dlIter.countResources() && !(dl instanceof Record)) {
                dl = (DisplayLine)dlIter.getResource(index);
            }
            if (!(dl instanceof Record)) {
                return this.nonShadowRecords.size();
            }
        }
        return this.nonShadowRecords.indexOf(dl);
    }

    public int getIndexOf(Object dl) {
        FMIResourceIterator dlIter = this.input.getDisplayLineIterator();
        if (!this.isHex && this.isShadow && dl instanceof DisplayLine) {
            return dlIter.indexOf((FMIResource)((DisplayLine)dl));
        }
        if (!this.isHex && !this.isShadow && dl instanceof Record) {
            return this.nonShadowRecords.indexOf(dl);
        }
        if (this.isHex && this.isShadow) {
            int hex = 0;
            if (dl instanceof HexRecordWrapper) {
                hex = ((HexRecordWrapper)dl).isFirstDigit() ? 1 : 2;
                dl = ((HexRecordWrapper)dl).getRecord();
            }
            int index = dlIter.indexOf((FMIResource)((DisplayLine)dl));
            return 3 * index - 2 * (index - this.getNonShadowIndex((DisplayLine)dl)) + hex;
        }
        if (this.isHex && !this.isShadow) {
            int hex = 0;
            if (dl instanceof HexRecordWrapper) {
                hex = ((HexRecordWrapper)dl).isFirstDigit() ? 1 : 2;
                dl = ((HexRecordWrapper)dl).getRecord();
            }
            return this.nonShadowRecords.indexOf(dl) * 3 + hex;
        }
        return -1;
    }

    public void updateElement(int index) {
        UiPlugin.trace(3, this, "updating element at index " + index + " hex: " + this.isHex + " shadow: " + this.isShadow, null);
        try {
            FMIResourceIterator dlIter = this.input.getDisplayLineIterator();
            if (dlIter.countResources() == 0 || index < 0) {
                return;
            }
            if (!this.isHex && this.isShadow && dlIter.countResources() > index) {
                this.viewer.replace((Object)dlIter.getResource(index), index);
            } else if (this.isHex && this.isShadow) {
                int recIndex = index / 3;
                DisplayLine dl = (DisplayLine)dlIter.getResource(recIndex);
                int hexShadowIndex = index - (2 * (recIndex - this.getNonShadowIndex(dl)) + index % 3);
                while (recIndex < dlIter.countResources()) {
                    if (index == hexShadowIndex) {
                        this.viewer.replace((Object)dlIter.getResource(recIndex), index);
                        return;
                    }
                    if (dlIter.getResource(recIndex) instanceof Record) {
                        if (index <= hexShadowIndex + 2) {
                            int hex = index - hexShadowIndex;
                            this.viewer.replace((Object)new HexRecordWrapper((Record)dlIter.getResource(recIndex), hex == 1), index);
                            return;
                        }
                        hexShadowIndex += 2;
                    }
                    ++recIndex;
                    ++hexShadowIndex;
                }
            } else if (this.isHex && !this.isShadow) {
                int recIndex = index / 3;
                int pos = index % 3;
                if (pos == 0) {
                    this.viewer.replace((Object)this.nonShadowRecords.get(recIndex), index);
                } else {
                    this.viewer.replace((Object)new HexRecordWrapper(this.nonShadowRecords.get(recIndex), pos == 1), index);
                }
            } else if (!this.isHex && !this.isShadow && this.nonShadowRecords.size() > index) {
                this.viewer.replace((Object)this.nonShadowRecords.get(index), index);
            }
        }
        catch (IndexOutOfBoundsException e) {
            UiPlugin.trace(1, this, "updating index: " + index + " isHex: " + this.isHex + " isShadow: " + this.isShadow, e);
        }
    }

    public void dispose() {
        if (this.input != null) {
            this.input.removeModelListener((IFMIModelListener)this);
        }
        this.input = null;
        this.nonShadowRecords = null;
    }

    protected void doAdd(final DisplayLine dispLine) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                FMIResourceIterator dlIter = FMITableModeContentProvider.this.input.getDisplayLineIterator();
                if (dispLine instanceof Record) {
                    int index = dlIter.indexOf((FMIResource)dispLine);
                    if (index == -1) {
                        UiPlugin.trace(0, this, "Cannot find added dispLine" + dispLine + "in input!", null);
                    } else if (index + 1 >= dlIter.countResources()) {
                        FMITableModeContentProvider.this.nonShadowRecords.add((Record)dispLine);
                    } else {
                        DisplayLine tempDL = null;
                        int addIndex = 0;
                        while ((addIndex = FMITableModeContentProvider.this.getNonShadowIndex(tempDL = (DisplayLine)dlIter.getResource(++index))) == -1 && index < dlIter.countResources() - 1) {
                        }
                        FMITableModeContentProvider.this.nonShadowRecords.add(addIndex, (Record)dispLine);
                    }
                }
                FMITableModeContentProvider.this.updateTableSize(FMITableModeContentProvider.this.getTableSize(FMITableModeContentProvider.this.input));
                if (FMITableModeContentProvider.this.viewer != null && FMITableModeContentProvider.this.viewer.getTable() != null) {
                    FMITableModeContentProvider.this.viewer.refresh();
                }
            }
        });
    }

    protected void doSplit(DisplayLine oldSet, DisplayLine[] newSets) {
        FMIResourceIterator dlIter = this.input.getDisplayLineIterator();
        if (dlIter.indexOf((FMIResource)oldSet) == -1) {
            this.doRemove(oldSet);
        } else {
            this.doChange(oldSet);
        }
        this.doAddMany(newSets);
    }

    protected void doAddMany(final DisplayLine[] recSets) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                FMIResourceIterator dlIter = FMITableModeContentProvider.this.input.getDisplayLineIterator();
                DisplayLine[] displayLineArray = recSets;
                int n = 0;
                int n2 = displayLineArray.length;
                while (n < n2) {
                    DisplayLine dispLine = displayLineArray[n];
                    if (dispLine instanceof Record) {
                        try {
                            DisplayLine tempDL = (DisplayLine)dlIter.getResource(dlIter.indexOf((FMIResource)dispLine) + 1);
                            FMITableModeContentProvider.this.nonShadowRecords.add(FMITableModeContentProvider.this.getNonShadowIndex(tempDL), (Record)dispLine);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            FMITableModeContentProvider.this.nonShadowRecords.add((Record)dispLine);
                        }
                    }
                    ++n;
                }
                FMITableModeContentProvider.this.updateTableSize(FMITableModeContentProvider.this.getTableSize(FMITableModeContentProvider.this.input));
                if (FMITableModeContentProvider.this.viewer != null && FMITableModeContentProvider.this.viewer.getTable() != null) {
                    FMITableModeContentProvider.this.viewer.refresh();
                }
            }
        });
    }

    protected void doChange(final DisplayLine dispLine) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (FMITableModeContentProvider.this.viewer != null && FMITableModeContentProvider.this.viewer.getTable() != null) {
                    int index = FMITableModeContentProvider.this.getIndexOf(dispLine);
                    FMITableModeContentProvider.this.viewer.replace((Object)dispLine, index);
                    if (FMITableModeContentProvider.this.isHex() && dispLine instanceof Record) {
                        FMITableModeContentProvider.this.viewer.replace((Object)new HexRecordWrapper((Record)dispLine, true), index + 1);
                        FMITableModeContentProvider.this.viewer.replace((Object)new HexRecordWrapper((Record)dispLine, false), index + 2);
                    }
                }
            }
        });
    }

    protected void doRemove(final DisplayLine dispLine) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (dispLine instanceof Record) {
                    FMITableModeContentProvider.this.nonShadowRecords.remove(dispLine);
                }
                FMITableModeContentProvider.this.updateTableSize(FMITableModeContentProvider.this.getTableSize(FMITableModeContentProvider.this.input));
                if (FMITableModeContentProvider.this.viewer != null && FMITableModeContentProvider.this.viewer.getTable() != null) {
                    FMITableModeContentProvider.this.viewer.refresh();
                    FMITableModeContentProvider.this.viewer.setSelection((ISelection)new StructuredSelection());
                }
            }
        });
    }

    protected void doRemoveMany(final DisplayLine[] recSets) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                DisplayLine[] displayLineArray = recSets;
                int n = 0;
                int n2 = displayLineArray.length;
                while (n < n2) {
                    DisplayLine dl = displayLineArray[n];
                    if (dl instanceof Record) {
                        FMITableModeContentProvider.this.nonShadowRecords.remove((Record)dl);
                    }
                    ++n;
                }
                FMITableModeContentProvider.this.updateTableSize(FMITableModeContentProvider.this.getTableSize(FMITableModeContentProvider.this.input));
                if (FMITableModeContentProvider.this.viewer != null && FMITableModeContentProvider.this.viewer.getTable() != null) {
                    FMITableModeContentProvider.this.viewer.refresh();
                    FMITableModeContentProvider.this.viewer.setSelection((ISelection)new StructuredSelection());
                }
            }
        });
    }

    protected void doMove(DisplayLine[] movedSets) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (FMITableModeContentProvider.this.viewer != null && FMITableModeContentProvider.this.viewer.getTable() != null) {
                    FMITableModeContentProvider.this.viewer.refresh();
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleFieldChangeEvent(FMIModelFieldChangeEvent event) {
        UiPlugin.trace(3, this, "handling Model Field Event " + event, null);
        FMIResource parent = event.getParent();
        if (!FMIModelFieldChangeEvent.FMIFieldOperation.CHANGE.equals((Object)event.getFieldOperation())) {
            UiPlugin.trace(1, this, event + " not of recognized type", null);
            return;
        }
        if (parent instanceof DisplayLine) {
            this.doChange((DisplayLine)parent);
            return;
        }
        if (parent instanceof FieldGroupArray && ((FieldGroupArray)parent).getParentResource() instanceof DisplayLine) {
            this.doChange((DisplayLine)((FieldGroupArray)parent).getParentResource());
            return;
        }
        UiPlugin.trace(1, this, "CHANGE EVENT: " + event + " not of recognized type", null);
    }

    public void handleDisplayLineChangeEvent(FMIModelDisplayLineChangeEvent event) {
        UiPlugin.trace(3, this, "handling Model display line Event " + event, null);
        FMIResource parent = event.getParent();
        if (!(parent instanceof TemplattedData)) {
            return;
        }
        DisplayLine target = event.getChangedLine();
        if (FMIModelDisplayLineChangeEvent.FMIDisplayLineOperation.ADD.equals((Object)event.getDisplayLineOperation())) {
            this.doAdd(target);
        } else if (FMIModelDisplayLineChangeEvent.FMIDisplayLineOperation.CHANGE.equals((Object)event.getDisplayLineOperation())) {
            this.doChange(target);
        } else if (FMIModelDisplayLineChangeEvent.FMIDisplayLineOperation.REMOVE.equals((Object)event.getDisplayLineOperation()) || FMIModelDisplayLineChangeEvent.FMIDisplayLineOperation.REMOVE_FROM_VIEW.equals((Object)event.getDisplayLineOperation())) {
            if (this.viewer != null && this.viewer.getTable() != null) {
                this.doRemove(target);
            }
        } else {
            UiPlugin.trace(1, this, event + " not of recognized type", null);
        }
    }

    public void handleMultiDisplayLineChangeEvent(FMIModelMultiDisplayLineChangeEvent event) {
        UiPlugin.trace(3, this, "handling Model display line multi Event " + event, null);
        FMIResource parent = event.getParent();
        if (!(parent instanceof TemplattedData)) {
            return;
        }
        if (event.getNewlyVisible() != null) {
            this.doAddMany(event.getNewlyVisible());
        } else if (event.getRemovedFromView() != null) {
            this.doRemoveMany(event.getRemovedFromView());
        } else if (event.getChangedRecords() != null) {
            DisplayLine[] displayLineArray = event.getChangedRecords();
            int n = 0;
            int n2 = displayLineArray.length;
            while (n < n2) {
                DisplayLine dL = displayLineArray[n];
                this.doChange(dL);
                ++n;
            }
        } else if (event.getMoved() != null) {
            this.doMove(event.getMoved());
        }
    }

    public boolean isHex() {
        return this.isHex;
    }

    public void setHex(boolean isHex) {
        if (this.isHex != isHex) {
            this.isHex = isHex;
            this.updateTableSize(this.getTableSize(this.input));
            if (this.viewer != null && this.viewer.getTable() != null) {
                this.viewer.refresh();
            }
        }
    }

    public boolean isShadow() {
        return this.isShadow;
    }

    public void setShadow(boolean isShadow) {
        if (this.isShadow != isShadow) {
            this.isShadow = isShadow;
            this.updateTableSize(this.getTableSize(this.input));
            if (this.viewer != null && this.viewer.getTable() != null) {
                this.viewer.refresh();
            }
        }
    }
}

