/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.providers;

import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.RecordLayout;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.shadowline.ShadowLine;
import com.ibm.fmi.ui.UiPlugin;
import com.ibm.fmi.ui.providers.HexFieldWrapper;
import com.ibm.fmi.ui.providers.HexRecordWrapper;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Item;

public class FMITableModeCellModifier
implements ICellModifier {
    public boolean canModify(Object element, String property) {
        if (property == null || property.equals("-1") || element instanceof ShadowLine) {
            return false;
        }
        int index = Integer.parseInt(property);
        if (element instanceof Record) {
            Record rec = (Record)element;
            Field field = rec.getDisplayField(index);
            return field.isEditable();
        }
        return true;
    }

    public Object getValue(Object element, String property) {
        int index = Integer.parseInt(property);
        if (element instanceof HexRecordWrapper) {
            HexRecordWrapper hrsw = (HexRecordWrapper)element;
            return hrsw.getHexString(index);
        }
        if (element instanceof Record) {
            Record rec = (Record)element;
            return rec.getDisplayField(index).getAsciiStr();
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        if (element instanceof Item) {
            element = ((Item)element).getData();
        }
        if (value == null) {
            UiPlugin.trace(1, this, "property " + property + " on element " + element + " was set to be null.  Returning", null);
            return;
        }
        int index = Integer.parseInt(property);
        if (element instanceof Record) {
            Record record = (Record)element;
            Field field = record.getDisplayField(index);
            try {
                field.setASCIIStr((String)value, true);
            }
            catch (FMIConversionException e) {
                UiPlugin.trace(0, this, "property " + property + " on element " + element + " is invalid.", e);
            }
            catch (FMIKeyException e) {
                UiPlugin.trace(0, this, "property " + property + " on element " + element + " is invalid.", e);
            }
            catch (FMIModelException e) {
                UiPlugin.trace(0, this, "property " + property + " on element " + element + " is invalid.", e);
            }
        } else if (element instanceof HexRecordWrapper) {
            try {
                ((HexRecordWrapper)element).setHexString((String)value, index);
            }
            catch (FMIConversionException e) {
                UiPlugin.trace(0, this, "property " + property + " on element " + element + " is invalid.", e);
            }
            catch (FMIKeyException e) {
                UiPlugin.trace(0, this, "property " + property + " on element " + element + " is invalid.", e);
            }
            catch (FMIModelException e) {
                UiPlugin.trace(0, this, "property " + property + " on element " + element + " is invalid.", e);
            }
        }
    }

    protected RecordLayout getLayout(Object element) {
        RecordLayout layout = null;
        if (element instanceof DisplayLine) {
            layout = ((DisplayLine)element).getLayout();
        } else if (element instanceof Field && ((Field)element).getParentResource() instanceof Record) {
            layout = ((Record)((Field)element).getParentResource()).getLayout();
        } else if (element instanceof HexRecordWrapper) {
            layout = ((HexRecordWrapper)element).getRecord().getLayout();
        } else if (element instanceof HexFieldWrapper && ((HexFieldWrapper)element).getField().getParentResource() instanceof Record) {
            layout = ((Record)((HexFieldWrapper)element).getField().getParentResource()).getLayout();
        }
        return layout;
    }
}

