/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.providers;

import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.event.FMIModelDisplayLineChangeEvent;
import com.ibm.fmi.model.event.FMIModelFieldChangeEvent;
import com.ibm.fmi.model.event.FMIModelMultiDisplayLineChangeEvent;
import com.ibm.fmi.model.event.IFMIModelListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class FMISingleModeContentProvider
implements IStructuredContentProvider,
IFMIModelListener {
    private DisplayLine input = null;
    private TableViewer viewer = null;

    public Object[] getElements(Object inputElement) {
        Record rec = null;
        if (!(inputElement instanceof Record)) {
            return new Object[0];
        }
        rec = (Record)inputElement;
        if (rec == null || rec.getLayout().numDisplayFields() == 0) {
            return new Object[0];
        }
        return rec.getModelFields();
    }

    public void dispose() {
        if (this.input != null) {
            this.input.removeModelListener((IFMIModelListener)this);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TableViewer) {
            this.viewer = (TableViewer)viewer;
        }
        if (this.input != null) {
            this.input.removeModelListener((IFMIModelListener)this);
        }
        if (newInput != null && newInput instanceof DisplayLine) {
            this.input = (DisplayLine)newInput;
            this.input.addModelListener((IFMIModelListener)this);
        }
    }

    public void handleFieldChangeEvent(FMIModelFieldChangeEvent event) {
        if (!event.getFieldOperation().equals((Object)FMIModelFieldChangeEvent.FMIFieldOperation.VALIDATE)) {
            this.viewer.refresh();
        }
    }

    public void handleDisplayLineChangeEvent(FMIModelDisplayLineChangeEvent event) {
        this.viewer.refresh();
    }

    public void handleMultiDisplayLineChangeEvent(FMIModelMultiDisplayLineChangeEvent event) {
        this.viewer.refresh();
    }
}

