/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.editors;

import com.ibm.etools.systems.subsystems.CommunicationsEvent;
import com.ibm.etools.systems.subsystems.ICommunicationsListener;
import com.ibm.etools.systems.subsystems.ISystem;
import com.ibm.fmi.client.FMIClientUtilities;
import com.ibm.fmi.client.FMIEditSessionProperties;
import com.ibm.fmi.client.FMIEditorInput;
import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.FMIResourceIterator;
import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.FieldGroupArray;
import com.ibm.fmi.model.IFieldGroupContainer;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.RecordLayout;
import com.ibm.fmi.model.TemplattedData;
import com.ibm.fmi.model.TemplattedDataBuilder;
import com.ibm.fmi.model.event.FMIModelDisplayLineChangeEvent;
import com.ibm.fmi.model.event.FMIModelFieldChangeEvent;
import com.ibm.fmi.model.event.FMIModelMultiDisplayLineChangeEvent;
import com.ibm.fmi.model.event.FMIResource;
import com.ibm.fmi.model.event.IFMIModelListener;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.shadowline.ExcludedSet;
import com.ibm.fmi.model.shadowline.ShadowLine;
import com.ibm.fmi.model.shadowline.SuppressedSet;
import com.ibm.fmi.model.shadowline.UnselectedSet;
import com.ibm.fmi.ui.UiPlugin;
import com.ibm.fmi.ui.action.AddRowActions;
import com.ibm.fmi.ui.action.CopyActions;
import com.ibm.fmi.ui.action.EditorAction;
import com.ibm.fmi.ui.action.ExcludeAction;
import com.ibm.fmi.ui.action.FMIFindReplaceAction;
import com.ibm.fmi.ui.action.HiddenActions;
import com.ibm.fmi.ui.action.IncludeAction;
import com.ibm.fmi.ui.action.PasteActions;
import com.ibm.fmi.ui.action.RemoveRowActions;
import com.ibm.fmi.ui.action.ShadowLinesActions;
import com.ibm.fmi.ui.action.SuppressedActions;
import com.ibm.fmi.ui.action.ToggleOverwriteAction;
import com.ibm.fmi.ui.editors.FMICharTableViewer;
import com.ibm.fmi.ui.editors.FieldCellEditor;
import com.ibm.fmi.ui.editors.FieldEditorValidator;
import com.ibm.fmi.ui.event.FMIEditorFocusEvent;
import com.ibm.fmi.ui.event.FMIEditorFocusEventListener;
import com.ibm.fmi.ui.event.FMIEditorMessageEvent;
import com.ibm.fmi.ui.event.FMIEditorMessageEventListener;
import com.ibm.fmi.ui.providers.FMIHexSingleModeContentProvider;
import com.ibm.fmi.ui.providers.FMISingleModeCellModifier;
import com.ibm.fmi.ui.providers.FMISingleModeContentProvider;
import com.ibm.fmi.ui.providers.FMISingleModeLabelProvider;
import com.ibm.fmi.ui.providers.FMITableModeCellModifier;
import com.ibm.fmi.ui.providers.FMITableModeContentProvider;
import com.ibm.fmi.ui.providers.FMITableModeLabelProvider;
import com.ibm.fmi.ui.providers.HexRecordWrapper;
import com.ibm.fmi.ui.util.FMIModelIndex;
import com.ibm.fmi.ui.util.FMIModelRegion;
import com.ibm.fmi.ui.util.FMISelectionIndex;
import com.ibm.ftt.resources.core.physical.IPhysicalResource;
import com.ibm.ftt.resources.zos.zosphysical.ZOSResource;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class FileManagerIntegrationEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
IFMIModelListener,
ICommunicationsListener,
IWorkbenchListener {
    private static FMIEditorFocusEventListener listener = null;
    private static FMIEditorMessageEventListener messagelistener = null;
    private FileManagerIntegrationEditor alias;
    protected TemplattedData tData;
    private Composite fmiComposite;
    private Composite charComposite;
    private SashForm SFTop;
    private String remoteTemplateName;
    private CLabel tableStatusLabel;
    private IPreferenceStore prefStore;
    private TableViewer upperTableViewer;
    private TableViewer singleTableViewer;
    private CellEditor[] upperCellEditors;
    protected static final String[] SINGLEMODE_COLUMNS = new String[]{UiPlugin.getString("FIELD_TITLE"), UiPlugin.getString("DATA_TITLE")};
    FMICharTableViewer charTableViewer;
    private Object zOSResource;
    private Label templateName;
    private Label templateName2;
    protected ISystem system = null;
    private FMIEditSessionProperties sessionProperties;
    private ToggleOverwriteAction toggleOverwriteAction;
    private static final String STRING_NO_FIT = UiPlugin.getString("Editor.Error.large");
    private static final String STRING_CONVERSION_FAILED = UiPlugin.getString("Editor.Error.conversion");
    private HashMap<String, IAction> actionMap = new HashMap();
    private KeyPressListener keyListener = new KeyPressListener();
    public static final int PROP_HEX = 2049;
    public static final int PROP_OVERWRITE = 2050;
    public static final int PROP_SHADOW = 2051;
    public static final int PROP_INPLACE = 2052;
    boolean hexMode;
    boolean overwriteMode;
    boolean shadowMode;
    boolean dirtyFlag;

    public void setTableStatus(IStatus status) {
        if (status.matches(4)) {
            this.tableStatusLabel.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
            this.tableStatusLabel.setText(status.getMessage());
        } else if (status.matches(2)) {
            this.tableStatusLabel.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
            this.tableStatusLabel.setText(status.getMessage());
        } else if (status.matches(1)) {
            this.tableStatusLabel.setImage(JFaceResources.getImage((String)"dialog_messasge_info_image"));
            this.tableStatusLabel.setText(status.getMessage());
        } else {
            this.tableStatusLabel.setImage(null);
            this.tableStatusLabel.setText("");
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof FMIEditorInput)) {
            throw new PartInitException(UiPlugin.getString("Editor.error.init"));
        }
        FMIEditorInput fmiInput = (FMIEditorInput)editorInput;
        FileEditorInput fileInput = new FileEditorInput(fmiInput.getFile());
        this.setSite((IWorkbenchPartSite)site);
        this.setInput((IEditorInput)fileInput);
        this.setPartName(fmiInput.getName());
        this.setZosResource(fmiInput.getResource());
        this.setSessionProperties(fmiInput.getEditSessionProperties());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        ShadowLine[] sets = this.getShadowLines();
        try {
            String dataset = fmiInput.getFile().getLocation().toOSString();
            this.tData = TemplattedDataBuilder.buildModel((String)dataset, (ShadowLine[])sets, (FMIEditSessionProperties)this.sessionProperties, (Object)this.zOSResource);
        }
        catch (FMIConversionException e) {
            UiPlugin.trace(0, (Object)this, UiPlugin.getString("Editor.Trace.Error.open"), e);
            throw new PartInitException(String.valueOf(UiPlugin.getString("Editor.error.file.msg")) + ": " + e.getMessage());
        }
        catch (FMIParseException e) {
            UiPlugin.trace(0, (Object)this, UiPlugin.getString("Editor.error.open"), e);
            throw new PartInitException(String.valueOf(UiPlugin.getString("Editor.error.file.msg")) + ": " + e.getMessage());
        }
        catch (FMIKeyException e) {
            UiPlugin.trace(0, (Object)this, UiPlugin.getString("Editor.error.open"), e);
            throw new PartInitException(String.valueOf(UiPlugin.getString("Editor.error.file.msg")) + ": " + e.getMessage());
        }
        catch (FMIModelException e) {
            UiPlugin.trace(0, (Object)this, UiPlugin.getString("Editor.error.open"), e);
            throw new PartInitException(String.valueOf(UiPlugin.getString("Editor.error.file.msg")) + ": " + e.getMessage());
        }
        this.tData.addModelListener((IFMIModelListener)this);
        site.getWorkbenchWindow().getWorkbench().addWorkbenchListener((IWorkbenchListener)this);
        this.prefStore = UiPlugin.getDefault().getPreferenceStore();
        this.hexMode = this.prefStore.getBoolean(Integer.toString(2049));
        this.shadowMode = this.prefStore.getBoolean(Integer.toString(2051));
        this.overwriteMode = this.prefStore.getBoolean(Integer.toString(2050));
        super.init(site, (IEditorInput)fileInput);
    }

    private ShadowLine[] getShadowLines() {
        ShadowLine[] sets = new ShadowLine[]{new UnselectedSet(), new ExcludedSet(), new SuppressedSet()};
        return sets;
    }

    protected void createPages() {
        this.createActions();
        this.createPage0(this.tData);
        this.createPage1();
    }

    public void createPage0(TemplattedData tData) {
        Object[] objectArray;
        this.fmiComposite = new Composite(this.getContainer(), 0);
        GridLayout gLayout = new GridLayout();
        gLayout.numColumns = 4;
        this.fmiComposite.setLayout((Layout)gLayout);
        this.templateName = new Label(this.fmiComposite, 0);
        if (this.remoteTemplateName == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = "None";
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = this.remoteTemplateName;
        }
        Object[] objectArr = objectArray;
        this.templateName.setText(UiPlugin.getString("Editor.msg.template", objectArr));
        this.templateName.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.tableStatusLabel = new CLabel(this.fmiComposite, 0);
        this.tableStatusLabel.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Button expansion = new Button(this.fmiComposite, 0);
        expansion.setImage(UiPlugin.getDefault().getImageRegistry().get("icons/tgl_obj.gif"));
        expansion.setToolTipText(UiPlugin.getString("Editor.Button..singleMode"));
        expansion.setLayoutData((Object)new GridData(3));
        expansion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FileManagerIntegrationEditor.this.SFTop != null) {
                    if (FileManagerIntegrationEditor.this.SFTop.getMaximizedControl() != FileManagerIntegrationEditor.this.upperTableViewer.getTable()) {
                        FileManagerIntegrationEditor.this.SFTop.setMaximizedControl((Control)FileManagerIntegrationEditor.this.upperTableViewer.getTable());
                    } else {
                        FileManagerIntegrationEditor.this.SFTop.setMaximizedControl(null);
                    }
                }
            }
        });
        this.SFTop = new SashForm(this.fmiComposite, 2560);
        GridData SFTopData = new GridData();
        SFTopData.horizontalSpan = 4;
        SFTopData.horizontalAlignment = 4;
        SFTopData.verticalAlignment = 4;
        SFTopData.verticalSpan = 4;
        SFTopData.grabExcessVerticalSpace = true;
        SFTopData.grabExcessHorizontalSpace = true;
        this.SFTop.setLayoutData((Object)SFTopData);
        RecordLayout layout = tData.getCurLayout();
        String[] tableColNames = new String[layout.numDisplayFields() + 1];
        int[] widthArray = new int[layout.numDisplayFields() + 1];
        int numNames = 0;
        while (numNames < layout.numDisplayFields()) {
            tableColNames[numNames + 1] = layout.getDisplayField(numNames).getName();
            widthArray[numNames + 1] = layout.getDisplayField(numNames).getMaxEbcdicWidth();
            ++numNames;
        }
        tableColNames[0] = "";
        widthArray[0] = 0;
        Table table = this.createUpperTable((Composite)this.SFTop, tData, tableColNames, widthArray);
        this.createUpperTableViewer(tableColNames, table);
        Table tableS = this.createSingleTable((Composite)this.SFTop, tData, tableColNames, widthArray);
        this.createTableViewerSingle(tableS);
        table.setMenu(this.createPopupMenu());
        this.alias = this;
        this.upperTableViewer.getTable().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent fe) {
                super.focusGained(fe);
                if (fe.getSource() == FileManagerIntegrationEditor.this.upperTableViewer.getTable()) {
                    FileManagerIntegrationEditor.this.fireFMIEditorFocusEvent(FileManagerIntegrationEditor.this.alias);
                }
            }
        });
        Listener tableListener = this.getTableListener();
        table.addListener(5, tableListener);
        CellEditor[] editors = this.upperTableViewer.getCellEditors();
        int i = 0;
        while (editors != null && i < editors.length) {
            editors[i].addListener((ICellEditorListener)new ColumnCellEditorListener(editors[i]));
            ((FieldCellEditor)editors[i]).getText().addKeyListener((KeyListener)this.keyListener);
            ++i;
        }
        int index = this.addPage((Control)this.fmiComposite);
        this.setPageText(index, UiPlugin.getString("Editor.title.page0"));
        table.addKeyListener((KeyListener)this.keyListener);
    }

    private void fireFMIEditorFocusEvent(FileManagerIntegrationEditor fmie) {
        if (listener != null) {
            FMIEditorFocusEvent FMIefe = new FMIEditorFocusEvent(fmie);
            listener.handleEditorFocusEvent(FMIefe);
        }
    }

    private void fireFMIEditorMessageEvent(String editorMessage) {
        if (messagelistener != null) {
            FMIEditorMessageEvent FMIeme = new FMIEditorMessageEvent(editorMessage);
            messagelistener.handleEditorMessageEvent(FMIeme);
        }
    }

    public void addFMIEditorFocusEventListener(FMIEditorFocusEventListener listener) {
        if (FileManagerIntegrationEditor.listener == null) {
            FileManagerIntegrationEditor.listener = listener;
        }
    }

    public void addFMIEditorMessageEventListener(FMIEditorMessageEventListener mel) {
        if (messagelistener == null) {
            messagelistener = mel;
        }
    }

    public void removeFMIEditorFocusEventListener() {
        listener = null;
    }

    public void removeFMIEditorMessageEventListener() {
        messagelistener = null;
    }

    public boolean readOnly() {
        return this.sessionProperties.noUpdate();
    }

    private void createUpperTableViewer(String[] tableColNames, Table table) {
        this.upperTableViewer = new TableViewer(table);
        if (!this.readOnly()) {
            this.upperCellEditors = new CellEditor[tableColNames.length];
            String[] properties = new String[tableColNames.length];
            int numCells = 0;
            while (numCells < tableColNames.length) {
                FieldCellEditor tce;
                properties[numCells] = "" + (numCells - 1);
                if (numCells > 0 && numCells <= this.tData.getCurLayout().numDisplayFields()) {
                    Field field = this.tData.getCurLayout().getDisplayField(numCells - 1);
                    tce = field.isNumeric() ? new FieldCellEditor(this.upperTableViewer, 131072, numCells) : new FieldCellEditor(this.upperTableViewer, 16384, numCells);
                    tce.getText().setTextLimit(field.getMaxAsciiWidth());
                    tce.setValidator(new FieldEditorValidator(numCells - 1));
                } else {
                    tce = new FieldCellEditor(this.upperTableViewer, 16384, numCells);
                }
                this.addPropertyListener(tce);
                tce.setOverwriteMode(this.isOverwriteMode());
                this.upperCellEditors[numCells] = tce;
                ++numCells;
            }
            this.upperTableViewer.setCellEditors(this.upperCellEditors);
            this.upperTableViewer.setCellModifier((ICellModifier)new FMITableModeCellModifier());
            this.upperTableViewer.setColumnProperties(properties);
        }
        FMITableModeContentProvider cp = new FMITableModeContentProvider();
        cp.setHex(this.isHexMode());
        cp.setShadow(this.isShadowMode());
        this.upperTableViewer.setContentProvider((IContentProvider)cp);
        this.upperTableViewer.setLabelProvider((IBaseLabelProvider)new FMITableModeLabelProvider(this.tData));
        this.upperTableViewer.setInput((Object)this.tData);
        this.upperTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                FileManagerIntegrationEditor.this.updateSingleMode(sel.getFirstElement());
            }
        });
    }

    public Table createUpperTable(Composite parent, TemplattedData input, String[] tableColNames, int[] widthArray) {
        Table table = new Table(parent, 268501762);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        Font font = JFaceResources.getTextFont();
        table.setFont(font);
        GC gc = new GC((Drawable)table);
        gc.setFont(font);
        FontMetrics metrics = gc.getFontMetrics();
        gc.dispose();
        int n = 1;
        TableColumn tableColumn0 = new TableColumn(table, 0);
        tableColumn0.setWidth(40);
        tableColumn0.setResizable(false);
        int t = 1;
        while (t < tableColNames.length) {
            Field field = input.getCurLayout().getDisplayField(t - 1);
            TableColumn tableColumn = field.isNumeric() ? new TableColumn(table, 131072) : new TableColumn(table, 16384);
            tableColumn.setText(tableColNames[t]);
            tableColumn.setWidth(field.getMaxAsciiWidth() * metrics.getAverageCharWidth() + 12);
            tableColumn.setToolTipText("#" + field.getSymbol() + "\n " + field.getConverterSymbol() + " " + (field.getRecordOffset() + 1) + ":" + field.getMaxEbcdicWidth());
            n += widthArray[t];
            ++t;
        }
        return table;
    }

    public Table createSingleTable(Composite parent, TemplattedData input, String[] tableColNames, int[] widthArray) {
        Group singleModeGroup = new Group(parent, 0);
        singleModeGroup.setText(UiPlugin.getString("Editor.Title.SingleMode"));
        GridLayout singleModeGroupLayout = new GridLayout(2, false);
        singleModeGroup.setLayout((Layout)singleModeGroupLayout);
        Label recordLabel = new Label((Composite)singleModeGroup, 0);
        recordLabel.setText(" ");
        recordLabel.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Table table = new Table((Composite)singleModeGroup, 67588);
        Font font = JFaceResources.getTextFont();
        table.setFont(font);
        GC gc = new GC((Drawable)table);
        gc.setFont(font);
        FontMetrics metrics = gc.getFontMetrics();
        gc.dispose();
        table.setLinesVisible(false);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        RecordLayout layout = input.getCurLayout();
        int nameWidth = 0;
        int dataWidth = 0;
        int i = 0;
        while (i < layout.numDisplayFields()) {
            nameWidth = Math.max(nameWidth, layout.getDisplayField(i).getName().length());
            dataWidth = Math.max(dataWidth, layout.getDisplayField(i).getMaxAsciiWidth());
            ++i;
        }
        TableColumn col1 = new TableColumn(table, 0);
        col1.setWidth(metrics.getAverageCharWidth() * nameWidth + 12);
        col1.setText(SINGLEMODE_COLUMNS[0]);
        TableColumn col2 = new TableColumn(table, 16384);
        col2.setWidth(metrics.getAverageCharWidth() * dataWidth + 12);
        col2.setText(SINGLEMODE_COLUMNS[1]);
        Group SBG = new Group((Composite)singleModeGroup, 0);
        SBG.setLayoutData((Object)new GridData(2, 2, false, true, 1, 1));
        RowLayout rl = new RowLayout(512);
        SBG.setLayout((Layout)rl);
        Button prevButton = new Button((Composite)SBG, 4);
        Button nextButton = new Button((Composite)SBG, 4);
        prevButton.setAlignment(128);
        prevButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Table upperTable = FileManagerIntegrationEditor.this.upperTableViewer.getTable();
                int index = upperTable.getSelectionIndex();
                while (--index >= 0) {
                    if (!(upperTable.getItem(index).getData() instanceof DisplayLine)) continue;
                    upperTable.setSelection(index);
                    FileManagerIntegrationEditor.this.updateSingleMode(upperTable.getItem(index));
                    return;
                }
            }
        });
        nextButton.setAlignment(1024);
        nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Table upperTable = FileManagerIntegrationEditor.this.upperTableViewer.getTable();
                int index = upperTable.getSelectionIndex();
                while (++index < upperTable.getItemCount()) {
                    if (!(upperTable.getItem(index).getData() instanceof DisplayLine)) continue;
                    upperTable.setSelection(index);
                    FileManagerIntegrationEditor.this.updateSingleMode(upperTable.getItem(index));
                    return;
                }
            }
        });
        return table;
    }

    private void createTableViewerSingle(Table table) {
        this.singleTableViewer = new TableViewer(table);
        if (!this.readOnly()) {
            CellEditor[] singleCellEditors = new CellEditor[SINGLEMODE_COLUMNS.length];
            FieldCellEditor textEditor = new FieldCellEditor(this.singleTableViewer, 16384, 1);
            this.addPropertyListener(textEditor);
            textEditor.setOverwriteMode(this.isOverwriteMode());
            textEditor.getText().addKeyListener((KeyListener)this.keyListener);
            textEditor.addListener(new ColumnCellEditorListener(textEditor));
            textEditor.getText().setTextLimit(60);
            textEditor.setValidator(new FieldEditorValidator(-1));
            singleCellEditors[0] = textEditor;
            singleCellEditors[1] = textEditor;
            this.singleTableViewer.setCellModifier((ICellModifier)new FMISingleModeCellModifier());
            this.singleTableViewer.setColumnProperties(SINGLEMODE_COLUMNS);
            this.singleTableViewer.setCellEditors(singleCellEditors);
        }
        if (this.isHexMode()) {
            this.singleTableViewer.setContentProvider((IContentProvider)new FMIHexSingleModeContentProvider());
        } else {
            this.singleTableViewer.setContentProvider((IContentProvider)new FMISingleModeContentProvider());
        }
        this.singleTableViewer.setLabelProvider((IBaseLabelProvider)new FMISingleModeLabelProvider());
    }

    public void updateSingleMode(Object obj) {
        if (this.singleTableViewer != null) {
            if (obj instanceof TableItem) {
                obj = ((TableItem)obj).getData();
            }
            if (obj instanceof HexRecordWrapper) {
                obj = ((HexRecordWrapper)obj).getRecord();
            }
            this.singleTableViewer.setInput(obj);
        }
    }

    public void createPage1() {
        this.charComposite = new Composite(this.getContainer(), 0);
        this.charComposite.setLayout((Layout)new GridLayout(1, false));
        this.templateName2 = new Label(this.charComposite, 0);
        this.templateName2.setText(this.templateName.getText());
        this.charTableViewer = new FMICharTableViewer(this.charComposite, this.tData, this.isHexMode(), this.isShadowMode(), this);
        Listener tableListener = this.charTableViewer.getTableListener();
        this.charTableViewer.getTable().addListener(5, tableListener);
        this.addPropertyListener(this.charTableViewer);
        this.charTableViewer.getTable().setMenu(this.createPopupMenu());
        int index = this.addPage((Control)this.charComposite);
        this.setPageText(index, UiPlugin.getString("Editor.title.page1"));
    }

    public void doSave(IProgressMonitor arg0) {
        if (this.readOnly()) {
            return;
        }
        try {
            boolean saveResult = this.tData.saveToFM(arg0);
            if (saveResult) {
                this.dirtyFlag = false;
                this.firePropertyChange(257);
            }
            String dataset = ((IFileEditorInput)this.getEditorInput()).getFile().getLocation().toOSString();
            try {
                TemplattedData tDataNew = TemplattedDataBuilder.buildModel((String)dataset, (ShadowLine[])this.getShadowLines(), (FMIEditSessionProperties)this.sessionProperties, (Object)this.zOSResource);
                this.upperTableViewer.setInput((Object)tDataNew);
                this.charTableViewer.getTableViewerC().setInput((Object)tDataNew);
                this.tData.removeModelListener((IFMIModelListener)this);
                this.tData = tDataNew;
                this.tData.addModelListener((IFMIModelListener)this);
            }
            catch (Exception exception) {}
            this.upperTableViewer.refresh();
            this.charTableViewer.getTableViewerC().refresh();
            this.singleTableViewer.refresh();
        }
        catch (FMIModelException fMIModelException) {
            this.dirtyFlag = false;
            this.firePropertyChange(257);
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return this.tableStatusLabel.getText() == null || this.tableStatusLabel.getText().equals("");
    }

    public boolean isHexMode() {
        return this.hexMode;
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = FileManagerIntegrationEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((IFileEditorInput)FileManagerIntegrationEditor.this.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(FileManagerIntegrationEditor.this.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    private void setZosResource(Object mvsResource) {
        this.zOSResource = mvsResource;
        ZOSResource res = (ZOSResource)mvsResource;
        this.remoteTemplateName = FMIClientUtilities.getTemplateName((IPhysicalResource)res);
        if (this.remoteTemplateName != null && this.remoteTemplateName.equals("")) {
            this.remoteTemplateName = null;
        }
    }

    public void deselectAll() {
        if (this.getActivePage() == 0) {
            this.upperTableViewer.setSelection((ISelection)new StructuredSelection());
        } else {
            this.charTableViewer.getTableViewerC().setSelection((ISelection)new StructuredSelection());
        }
    }

    public IStructuredSelection getStructuredSelection() {
        if (this.getActivePage() == 0) {
            return (IStructuredSelection)this.upperTableViewer.getSelection();
        }
        return (IStructuredSelection)this.charTableViewer.getTableViewerC().getSelection();
    }

    public TemplattedData getActiveModel() {
        return this.tData;
    }

    public void setHexMode(boolean isHexMode) {
        if (isHexMode != this.hexMode) {
            this.hexMode = isHexMode;
            this.prefStore.setValue(Integer.toString(2049), isHexMode);
            if (this.prefStore instanceof IPersistentPreferenceStore) {
                try {
                    ((IPersistentPreferenceStore)this.prefStore).save();
                }
                catch (IOException e) {
                    UiPlugin.trace(1, this.prefStore, UiPlugin.getString("Editor.Warning.saveFailed"), e);
                }
            }
            this.firePropertyChange(2049);
            FMITableModeContentProvider cp = (FMITableModeContentProvider)this.upperTableViewer.getContentProvider();
            cp.setHex(isHexMode);
            Object obj = ((IStructuredSelection)this.upperTableViewer.getSelection()).getFirstElement();
            if (obj instanceof HexRecordWrapper) {
                obj = ((HexRecordWrapper)obj).getRecord();
            }
            if (this.isHexMode()) {
                this.singleTableViewer.setContentProvider((IContentProvider)new FMIHexSingleModeContentProvider());
            } else {
                this.singleTableViewer.setContentProvider((IContentProvider)new FMISingleModeContentProvider());
            }
            if (obj != null) {
                StructuredSelection selection = new StructuredSelection(obj);
                this.upperTableViewer.getTable().setSelection(cp.getIndexOf((DisplayLine)obj));
                this.updateSingleMode(selection);
            }
        }
    }

    public boolean isOverwriteMode() {
        return this.overwriteMode;
    }

    public boolean isShadowMode() {
        return this.shadowMode;
    }

    public boolean isInPlace() {
        return this.sessionProperties.isNoAppend() || this.sessionProperties.noInsertDelete();
    }

    public void setShadowLines(boolean isShadowMode) {
        if (isShadowMode != this.shadowMode) {
            this.shadowMode = isShadowMode;
            this.prefStore.setValue(Integer.toString(2051), isShadowMode);
            if (this.prefStore instanceof IPersistentPreferenceStore) {
                try {
                    ((IPersistentPreferenceStore)this.prefStore).save();
                }
                catch (IOException e) {
                    UiPlugin.trace(1, this.prefStore, UiPlugin.getString("Editor.Warning.saveFailed"), e);
                }
            }
            this.firePropertyChange(2051);
            FMITableModeContentProvider cp = (FMITableModeContentProvider)this.upperTableViewer.getContentProvider();
            cp.setShadow(isShadowMode);
        }
    }

    public FMIModelIndex getSelectionPoint() {
        FMIResourceIterator dlIterator = this.tData.getDisplayLineIterator();
        if (this.getActivePage() == 0 && !this.isHexMode()) {
            Iterator it = ((StructuredSelection)this.upperTableViewer.getSelection()).iterator();
            int index = 0;
            while (it.hasNext()) {
                DisplayLine dl = (DisplayLine)it.next();
                index = Math.max(index, dlIterator.indexOf((FMIResource)dl));
            }
            if (this.tData.getDisplayLineIterator().getResource(index) instanceof ExcludedSet) {
                return new FMIModelIndex(index, 0, 0, 0);
            }
            int fieldIndex = 0;
            int fieldOffset = 0;
            if (this.upperTableViewer.isCellEditorActive()) {
                int i = 0;
                while (i < this.upperCellEditors.length) {
                    if (this.upperCellEditors[i].isActivated()) {
                        fieldIndex = i - 1;
                        fieldOffset = ((FieldCellEditor)this.upperCellEditors[i]).getText().getSelection().y;
                        break;
                    }
                    ++i;
                }
            }
            return new FMIModelIndex(index, fieldIndex, fieldOffset);
        }
        return null;
    }

    public FMIModelRegion getSelectedRegion() {
        if (this.getActivePage() == 0) {
            int[] sels = this.upperTableViewer.getTable().getSelectionIndices();
            int min = Integer.MAX_VALUE;
            int max = 0;
            int i = 0;
            while (i < sels.length) {
                min = Math.min(min, sels[i]);
                max = Math.max(max, sels[i]);
                ++i;
            }
            return new FMIModelRegion(min, max);
        }
        return null;
    }

    public int getAsciiWidth(Field field) {
        return field.getMaxAsciiWidth() != -22 ? field.getMaxAsciiWidth() : field.getAsciiStr().length();
    }

    public FMIModelIndex findAndSelect(FMIModelIndex modelIndex, String findString, boolean searchForward, boolean caseSensitive, boolean regEx, Set fields, FMIModelRegion region, boolean visible, boolean excluded) {
        assert (visible || excluded);
        if (modelIndex == null) {
            return null;
        }
        if (this.getActivePage() == 0 && !this.isHexMode()) {
            Field field = modelIndex.getField(this.tData);
            int asciiWidth = this.getAsciiWidth(field);
            String fieldName = field.getName();
            while (true) {
                if (region != null && !region.contains(modelIndex)) {
                    return null;
                }
                if (!fields.contains(fieldName) || field.isEmpty() || searchForward && asciiWidth - modelIndex.getFieldOffset() < findString.length() || !searchForward && modelIndex.getFieldOffset() < 0) {
                    modelIndex = searchForward ? modelIndex.getNextField(this.tData, visible, excluded) : modelIndex.getPreviousField(this.tData, visible, excluded);
                    if (modelIndex == null) {
                        return null;
                    }
                    field = modelIndex.getField(this.tData);
                    asciiWidth = this.getAsciiWidth(field);
                    fieldName = field.getName();
                    if (searchForward) continue;
                    modelIndex.setFieldOffset(asciiWidth - findString.length());
                    continue;
                }
                if (!regEx && field.getAsciiStr().regionMatches(!caseSensitive, modelIndex.getFieldOffset(), findString, 0, findString.length()) || regEx && modelIndex.getFieldStringWithOffset(this.tData).matches(findString)) break;
                if (searchForward) {
                    modelIndex.setFieldOffset(modelIndex.getFieldOffset() + 1);
                    continue;
                }
                modelIndex.setFieldOffset(modelIndex.getFieldOffset() - 1);
            }
            this.showFieldColumn(field);
            this.setSelection(field, modelIndex.getFieldOffset(), findString.length());
            return new FMIModelIndex(modelIndex.getDisplayLineIndex(), modelIndex.getFieldIndex(), modelIndex.getFieldOffset());
        }
        this.getActivePage();
        return null;
    }

    private TableColumn getFieldColumn(Field field) {
        Table t = this.upperTableViewer.getTable();
        int columnCount = t.getColumnCount();
        int showColumnNumber = this.getFieldColumnNumber(field);
        TableColumn tc = null;
        tc = showColumnNumber == columnCount ? t.getColumn(showColumnNumber) : t.getColumn(showColumnNumber + 1);
        return tc;
    }

    private int getFieldColumnNumber(Field field) {
        return field.getDisplayIndex();
    }

    private void showFieldColumn(Field fieldToShow) {
        TableColumn tc = this.getFieldColumn(fieldToShow);
        this.upperTableViewer.getTable().showColumn(tc);
    }

    protected void setSelection(Field field, int fieldOffset, int length) {
        if (!(field.getParentResource() instanceof Record)) {
            return;
        }
        Record rec = (Record)field.getParentResource();
        UiPlugin.trace(2, (Object)this, "Selecting " + field + " at position " + fieldOffset + " for " + length + " characters.", null);
        if (rec.getParent() instanceof ExcludedSet) {
            try {
                this.tData.makeRecordVisible(rec);
            }
            catch (FMIKeyException e) {
                UiPlugin.trace(1, (Object)this, UiPlugin.getString("Editor.Error.setSelection"), e);
            }
            catch (FMIModelException e) {
                UiPlugin.trace(1, (Object)this, UiPlugin.getString("Editor.Error.setSelection"), e);
            }
        }
        if (this.readOnly()) {
            return;
        }
        if (this.getActivePage() == 0 && !this.isHexMode()) {
            int fieldIndex = rec.indexOf(field);
            this.upperTableViewer.editElement((Object)rec, fieldIndex + 1);
            ((FieldCellEditor)this.upperTableViewer.getCellEditors()[fieldIndex + 1]).getText().setSelection(fieldOffset, fieldOffset + length);
        } else if (this.getActivePage() == 1 && !this.isHexMode()) {
            int fieldIndex = rec.indexOf(field);
            int offset = fieldOffset;
            int i = 0;
            while (i < fieldIndex) {
                offset += rec.getDisplayField(i).getActualEbcdicWidth();
                ++i;
            }
            this.charTableViewer.getTableViewerC().editElement((Object)rec, 1);
            ((FieldCellEditor)this.charTableViewer.getTableViewerC().getCellEditors()[1]).getText().setSelection(offset, offset + length);
        }
    }

    public boolean replaceSelection(FMISelectionIndex si, String replaceText) {
        if (si != null && replaceText != null) {
            Field target = si.getField(this.tData);
            String original = target.getAsciiStr();
            original = this.trimTrailing(original);
            String updated = this.substitute(original, si.getFieldOffset(), si.getFieldOffset() + si.getSelectionLength(), replaceText);
            try {
                target.validateASCIIchange(updated);
                target.setASCIIStr(updated, true);
            }
            catch (FMIKeyException e1) {
                e1.printStackTrace();
                return false;
            }
            catch (FMIConversionException fMIConversionException) {
                this.fireFMIEditorMessageEvent(STRING_NO_FIT);
                return false;
            }
            catch (FMIModelException fMIModelException) {
                this.fireFMIEditorMessageEvent(STRING_NO_FIT);
                return false;
            }
            return true;
        }
        return false;
    }

    private String substitute(String target, int startNdx, int endNdx, String sub) {
        String firstHalf = target.substring(0, startNdx);
        String secondHalf = target.substring(endNdx, target.length());
        return String.valueOf(firstHalf) + sub + secondHalf;
    }

    private String trimTrailing(String src) {
        int i = src.length() - 1;
        while (i >= 0) {
            if (src.charAt(i) != ' ') break;
            --i;
        }
        if (i == src.length() - 1) {
            return src;
        }
        return src.substring(0, i + 1);
    }

    public boolean replaceSelection(String text) {
        if (this.getActivePage() == 0 && this.upperTableViewer.isCellEditorActive()) {
            CellEditor[] cellEditors = this.upperCellEditors;
            int i = 0;
            while (i < cellEditors.length) {
                if (cellEditors[i].isActivated()) {
                    return ((FieldCellEditor)cellEditors[i]).insert(text);
                }
                ++i;
            }
        }
        return false;
    }

    public void replaceAll(String findString, boolean caseSensitive, boolean regEx, Set fields, String newText, FMIModelRegion region, boolean visible, boolean excluded) {
        assert (visible || excluded);
        Pattern pattern = Pattern.compile(findString);
        FMIModelIndex modelIndex = new FMIModelIndex(0, 0, 0, 0);
        if (region != null) {
            modelIndex = region.getFirstIndex();
        }
        if (this.getActivePage() == 0 && !this.isHexMode()) {
            boolean keepGoing = true;
            while (modelIndex != null && keepGoing) {
                Field field = modelIndex.getField(this.tData);
                int asciiWidth = this.getAsciiWidth(field);
                String fieldName = field.getName();
                IFieldGroupContainer p = field.getParentResource();
                if (p instanceof FieldGroupArray) {
                    p = ((FieldGroupArray)p).getParentResource();
                }
                if (p instanceof Record) {
                    Record cfr_ignored_0 = (Record)p;
                }
                if (!fields.contains(fieldName) || field.isEmpty() || asciiWidth - modelIndex.getFieldOffset() < findString.length()) {
                    modelIndex = modelIndex.getNextField(this.tData, visible, excluded);
                } else if (!regEx && field.getAsciiStr().regionMatches(!caseSensitive, modelIndex.getFieldOffset(), findString, 0, findString.length()) || regEx && modelIndex.getFieldStringWithOffset(this.tData).matches(findString)) {
                    do {
                        String string = field.getAsciiStr();
                        string = this.trimTrailing(string);
                        if (!regEx) {
                            try {
                                field.setASCIIStr(string.substring(0, modelIndex.getFieldOffset()).concat(newText).concat(string.substring(modelIndex.getFieldOffset() + findString.length())), true);
                                modelIndex.setFieldOffset(modelIndex.getFieldOffset() + newText.length());
                            }
                            catch (FMIKeyException e) {
                                UiPlugin.trace(2, (Object)this, "Replace  all of '" + findString + "' to '" + newText + "' failed on Field " + field, e);
                                this.fireFMIEditorMessageEvent(STRING_NO_FIT);
                                keepGoing = false;
                            }
                            catch (FMIConversionException e) {
                                UiPlugin.trace(2, (Object)this, "Replace  all of '" + findString + "' to '" + newText + "' failed on Field " + field, e);
                                this.fireFMIEditorMessageEvent(STRING_NO_FIT);
                                keepGoing = false;
                            }
                            catch (FMIModelException e) {
                                UiPlugin.trace(2, (Object)this, "Replace  all of '" + findString + "' to '" + newText + "' failed on Field " + field, e);
                                this.fireFMIEditorMessageEvent(STRING_NO_FIT);
                                keepGoing = false;
                            }
                            continue;
                        }
                        Matcher matcher = pattern.matcher(string);
                        if (!matcher.find() || matcher.start() != 0) continue;
                        try {
                            field.setASCIIStr(String.valueOf(string.substring(0, modelIndex.getFieldOffset())) + newText + string.substring(matcher.end()), true);
                        }
                        catch (FMIKeyException e) {
                            UiPlugin.trace(2, (Object)this, "RegEx replace  all of '" + findString + "' to '" + newText + "' failed on Field " + field, e);
                            this.fireFMIEditorMessageEvent(STRING_NO_FIT);
                            keepGoing = false;
                        }
                        catch (FMIConversionException e) {
                            UiPlugin.trace(2, (Object)this, "RegEx replace  all of '" + findString + "' to '" + newText + "' failed on Field " + field, e);
                            this.fireFMIEditorMessageEvent(STRING_NO_FIT);
                            keepGoing = false;
                        }
                        catch (FMIModelException e) {
                            UiPlugin.trace(2, (Object)this, "RegEx replace  all of '" + findString + "' to '" + newText + "' failed on Field " + field, e);
                            this.fireFMIEditorMessageEvent(STRING_NO_FIT);
                            keepGoing = false;
                        }
                    } while ((!regEx && field.getAsciiStr().regionMatches(!caseSensitive, modelIndex.getFieldOffset(), findString, 0, findString.length()) || regEx && modelIndex.getFieldStringWithOffset(this.tData).matches(findString)) && keepGoing);
                    modelIndex = modelIndex.getNextField(this.tData, visible, excluded);
                } else {
                    modelIndex.setFieldOffset(modelIndex.getFieldOffset() + 1);
                }
                if (modelIndex == null || region == null || !region.contains(modelIndex)) continue;
                modelIndex = null;
            }
        } else {
            this.getActivePage();
        }
    }

    public void selectMatchingRecords(String findString, boolean caseSensitive, boolean regEx, Set fields, FMIModelRegion region, boolean visible, boolean excluded) {
        assert (visible || excluded);
        FMIModelIndex modelIndex = new FMIModelIndex(0, 0, 0, 0);
        if (region != null) {
            modelIndex = region.getFirstIndex();
        }
        HashSet<Record> toSelect = new HashSet<Record>();
        if (this.getActivePage() == 0 && !this.isHexMode()) {
            while (modelIndex != null) {
                Field field = modelIndex.getField(this.tData);
                Record parentRecord = null;
                IFieldGroupContainer p = field.getParentResource();
                if (p instanceof FieldGroupArray) {
                    p = ((FieldGroupArray)p).getParentResource();
                }
                if (p instanceof Record) {
                    parentRecord = (Record)p;
                }
                if (!fields.contains(parentRecord.getLayout().getDisplayField(field.getStartLayoutIndex()).getName()) || field.isEmpty() || field.getMaxAsciiWidth() - modelIndex.getFieldOffset() <= findString.length()) {
                    modelIndex = modelIndex.getNextField(this.tData, visible, excluded);
                } else if (!regEx && field.getAsciiStr().regionMatches(!caseSensitive, modelIndex.getFieldOffset(), findString, 0, findString.length()) || regEx && modelIndex.getFieldStringWithOffset(this.tData).matches(findString)) {
                    toSelect.add(parentRecord);
                    modelIndex = modelIndex.getNextField(this.tData, visible, excluded);
                } else {
                    modelIndex.setFieldOffset(modelIndex.getFieldOffset() + 1);
                }
                if (modelIndex == null || region == null || !region.contains(modelIndex)) continue;
                modelIndex = null;
            }
            for (Record select : toSelect) {
                if (!(select.getParent() instanceof ExcludedSet)) continue;
                try {
                    this.tData.makeRecordVisible(select);
                }
                catch (FMIKeyException e) {
                    UiPlugin.trace(1, (Object)this, UiPlugin.getString("Editor.Warning.selectAll"), e);
                }
                catch (FMIModelException e) {
                    UiPlugin.trace(1, (Object)this, UiPlugin.getString("Editor.Warning.selectAll"), e);
                }
            }
            StructuredSelection sel = new StructuredSelection(toSelect.toArray());
            this.upperTableViewer.setSelection((ISelection)sel);
        } else {
            this.getActivePage();
        }
    }

    protected void createActions() {
        this.toggleOverwriteAction = new ToggleOverwriteAction();
        this.toggleOverwriteAction.setEditor((IEditorPart)this);
        this.actionMap.put("ADD_RECORD_BEFORE", (IAction)new AddRowActions(UiPlugin.getString("ADD_RECORD_BEFORE")));
        this.actionMap.put("ADD_RECORD_AFTER", (IAction)new AddRowActions(UiPlugin.getString("ADD_RECORD_AFTER")));
        this.actionMap.put(ActionFactory.CUT.getId(), (IAction)new CopyActions(UiPlugin.getString("CUT"), false));
        this.actionMap.put(ActionFactory.COPY.getId(), (IAction)new CopyActions(UiPlugin.getString("COPY"), true));
        this.actionMap.put(ActionFactory.PASTE.getId(), (IAction)new PasteActions(UiPlugin.getString("PASTE")));
        this.actionMap.put(ActionFactory.DELETE.getId(), (IAction)new RemoveRowActions(UiPlugin.getString("REMOVE_RECORD")));
        this.actionMap.put("EXCLUDE", (IAction)new ExcludeAction(UiPlugin.getString("EXCLUDE"), this));
        this.actionMap.put("INCLUDE", (IAction)new IncludeAction(UiPlugin.getString("INCLUDE"), this));
        this.actionMap.put("SHADOWLINES", (IAction)new ShadowLinesActions(this, UiPlugin.getString("SHADOWLINES")));
        this.actionMap.put("SUPPRESSED", (IAction)new SuppressedActions(this, UiPlugin.getString("SUPPRESSED_RECORDS")));
        this.actionMap.put("UNSELECTED", (IAction)new HiddenActions(UiPlugin.getString("UNSELECTED_RECORDS")));
        this.actionMap.put(ActionFactory.FIND.getId(), (IAction)new FMIFindReplaceAction("Find/Replace", this));
    }

    public IAction getAction(String key) {
        return this.actionMap.get(key);
    }

    protected Menu createPopupMenu() {
        MenuManager manager = new MenuManager();
        manager.add((IContributionItem)new Separator("group.undo"));
        manager.add((IContributionItem)new Separator("group.add"));
        manager.add((IContributionItem)new Separator("group.copy"));
        manager.add((IContributionItem)new Separator("group.print"));
        manager.add((IContributionItem)new GroupMarker("group.save"));
        manager.add((IContributionItem)new Separator("group.edit"));
        manager.add((IContributionItem)new Separator("group.find"));
        manager.add((IContributionItem)new Separator("group.rest"));
        manager.add((IContributionItem)new Separator("additions"));
        this.addAction((IMenuManager)manager, "group.add", this.actionMap.get("ADD_RECORD_BEFORE"));
        this.addAction((IMenuManager)manager, "group.add", this.actionMap.get("ADD_RECORD_AFTER"));
        this.addAction((IMenuManager)manager, "group.copy", this.actionMap.get(ActionFactory.CUT.getId()));
        this.addAction((IMenuManager)manager, "group.copy", this.actionMap.get(ActionFactory.COPY.getId()));
        this.addAction((IMenuManager)manager, "group.copy", this.actionMap.get(ActionFactory.PASTE.getId()));
        this.addAction((IMenuManager)manager, "group.copy", this.actionMap.get(ActionFactory.DELETE.getId()));
        this.addAction((IMenuManager)manager, "group.edit", this.actionMap.get("EXCLUDE"));
        this.addAction((IMenuManager)manager, "group.edit", this.actionMap.get("INCLUDE"));
        this.addAction((IMenuManager)manager, "group.edit", this.actionMap.get("SHADOWLINES"));
        this.addAction((IMenuManager)manager, "group.edit", this.actionMap.get("SUPPRESSED"));
        this.addAction((IMenuManager)manager, "group.edit", this.actionMap.get("UNSELECTED"));
        this.addAction((IMenuManager)manager, "group.find", this.actionMap.get(ActionFactory.FIND.getId()));
        if (this.isInPlace() || this.readOnly()) {
            ((EditorAction)this.actionMap.get("ADD_RECORD_BEFORE")).setGlobalEnabled(false);
            ((EditorAction)this.actionMap.get("ADD_RECORD_AFTER")).setGlobalEnabled(false);
            ((EditorAction)this.actionMap.get(ActionFactory.COPY.getId())).setGlobalEnabled(false);
            ((EditorAction)this.actionMap.get(ActionFactory.CUT.getId())).setGlobalEnabled(false);
            ((EditorAction)this.actionMap.get(ActionFactory.PASTE.getId())).setGlobalEnabled(false);
            ((EditorAction)this.actionMap.get(ActionFactory.DELETE.getId())).setGlobalEnabled(false);
        }
        if (this.readOnly()) {
            this.actionMap.get(ActionFactory.FIND.getId()).setEnabled(false);
        }
        return manager.createContextMenu((Control)this.fmiComposite);
    }

    protected void addAction(IMenuManager menuManager, String groupName, IAction action) {
        IMenuManager subMenu = menuManager.findMenuUsingPath(groupName);
        if (subMenu == null) {
            menuManager.appendToGroup(groupName, action);
        } else {
            subMenu.add(action);
        }
    }

    public void setEditorAsDirty() {
        if (!this.dirtyFlag) {
            this.dirtyFlag = true;
            this.firePropertyChange(257);
        }
    }

    public int getActivePage() {
        return super.getActivePage();
    }

    public void setActivePage(int num) {
        super.setActivePage(num);
    }

    public void setOverwriteMode(boolean isOverwriteMode) {
        if (isOverwriteMode != this.overwriteMode) {
            this.overwriteMode = isOverwriteMode;
            this.prefStore.setValue(Integer.toString(2050), isOverwriteMode);
            if (this.prefStore instanceof IPersistentPreferenceStore) {
                try {
                    ((IPersistentPreferenceStore)this.prefStore).save();
                }
                catch (IOException e) {
                    UiPlugin.trace(1, this.prefStore, UiPlugin.getString("Editor.Warning.saveFailed"), e);
                }
            }
            this.firePropertyChange(2050);
        }
    }

    public void handleFieldChangeEvent(FMIModelFieldChangeEvent event) {
        if (!event.getFieldOperation().equals((Object)FMIModelFieldChangeEvent.FMIFieldOperation.VALIDATE)) {
            this.setEditorAsDirty();
        }
    }

    public void handleDisplayLineChangeEvent(FMIModelDisplayLineChangeEvent event) {
        this.setEditorAsDirty();
    }

    public void handleMultiDisplayLineChangeEvent(FMIModelMultiDisplayLineChangeEvent event) {
        this.setEditorAsDirty();
    }

    protected void switchSelectionListeners() {
        int page = this.getActivePage();
        Iterator<String> it = this.actionMap.keySet().iterator();
        while (it.hasNext()) {
            IAction action = this.actionMap.get(it.next());
            if (!(action instanceof ISelectionChangedListener)) continue;
            ISelectionChangedListener listener = (ISelectionChangedListener)action;
            if (page == 0) {
                this.charTableViewer.getTableViewerC().removeSelectionChangedListener(listener);
                this.upperTableViewer.addSelectionChangedListener(listener);
                continue;
            }
            this.upperTableViewer.removeSelectionChangedListener(listener);
            this.charTableViewer.getTableViewerC().addSelectionChangedListener(listener);
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.switchSelectionListeners();
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    public void dispose() {
        this.tData.cleanUp(this.getSite().getShell());
        if (this.system != null) {
            this.system.removeCommunicationsListener((ICommunicationsListener)this);
        }
        this.getSite().getWorkbenchWindow().getWorkbench().removeWorkbenchListener((IWorkbenchListener)this);
        super.dispose();
    }

    Listener getTableListener() {
        return new Listener(){
            protected TableItem oldItem = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 5: {
                        TableItem item = FileManagerIntegrationEditor.this.upperTableViewer.getTable().getItem(new Point(event.x, event.y));
                        if (item == this.oldItem) break;
                        this.oldItem = item;
                        if (item != null && item.getImage() != null) {
                            Object isel = item.getData();
                            FileManagerIntegrationEditor.this.upperTableViewer.getTable().setToolTipText(this.getLabelFor(isel, item));
                            break;
                        }
                        FileManagerIntegrationEditor.this.upperTableViewer.getTable().setToolTipText(null);
                    }
                }
            }

            private String getLabelFor(Object isel, TableItem item) {
                String label = null;
                if (isel instanceof ShadowLine) {
                    String type = ((ShadowLine)isel).getMessage(((ShadowLine)isel).getNumRecords());
                    label = UiPlugin.getString("Editor.hidden", new Object[]{type});
                } else if (item.getImage() != null) {
                    label = "Duplicate Keys found!";
                }
                return label;
            }
        };
    }

    private void setSessionProperties(FMIEditSessionProperties properties) {
        this.sessionProperties = properties;
    }

    public void listenToSystem(ISystem system) {
        if (this.system != null) {
            this.system.removeCommunicationsListener((ICommunicationsListener)this);
        }
        this.system = system;
        this.system.addCommunicationsListener((ICommunicationsListener)this);
    }

    public void communicationsStateChange(CommunicationsEvent e) {
    }

    public boolean isPassiveCommunicationsListener() {
        return false;
    }

    public boolean preShutdown(IWorkbench arg0, boolean arg1) {
        return this.getSite().getPage().closeEditor((IEditorPart)this, true);
    }

    public void postShutdown(IWorkbench arg0) {
        this.getSite().getPage().closeEditor((IEditorPart)this, false);
    }

    public class KeyPressListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent event) {
            if (event.keyCode == 0x1000009 && event.stateMask == 0) {
                FileManagerIntegrationEditor.this.toggleOverwriteAction.run();
                event.doit = false;
            }
        }
    }

    public class ColumnCellEditorListener
    implements ICellEditorListener {
        private CellEditor ce;

        ColumnCellEditorListener(CellEditor ce) {
            this.ce = ce;
        }

        public void applyEditorValue() {
        }

        public void cancelEditor() {
            FileManagerIntegrationEditor.this.setTableStatus(Status.OK_STATUS);
        }

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            Object status = null;
            status = newValidState ? Status.OK_STATUS : new Status(4, "com.ibm.fmi.ui", 0, this.ce.getErrorMessage(), null);
            FileManagerIntegrationEditor.this.setTableStatus((IStatus)status);
        }
    }
}

